<?php
/*
 * member/member/Status.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-08-16
 */
require_once( dirname(dirname(__FILE__))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php');
/**
 * spider : 会員状態変更実行用アクションモジュールクラス
 * 
 * @package member 会員管理パッケージ
 * @version 1.0.00
 * @author  <m_nakashima@users.sourceforge.jp>
 * @since PHP 4.0
 */
class member_member_Status extends system_login_ModuleBase {
	function member_member_Status(){
		array_push($this->require_module_array,'database2.Connect');
	}
	function execute( & $request ) {
		$dbo				= $request->getAttribute( 'dbo' );
		$memberId			= mb_convert_kana(trim(stripslashes($_POST['member_id'])),'a');
		$statusFlag			= mb_convert_kana(trim(stripslashes($_POST['status_flag'])),'a');
		$loginUserObject	= $this->getLoginUserObject( $request );
		$memberObject		= null;
		if( strlen($memberId) == 0 ) {
			$request->addLocaledError('member.error.common.selectmember',SPIDER_LOG_LEVEL_FATAL,array(''));
		} else {
			$memberObject	= spider_Controller::createObject('member_DaoMember');
			// IDが指定されているなら編集のため読み込み
			if( $dbo->loadById($memberObject,$memberId) ){
				if( preg_match('/^[0-9]{1,3}$/',$statusFlag) == 0 ) {
					$request->addLocaledError('member.error.common.invalidstatus',SPIDER_LOG_LEVEL_FATAL,array(''));
				} else if( !array_key_exists($statusFlag,$GLOBALS['MEMBER_STATUS_HASH']) ) {
					$request->addLocaledError('member.error.common.invalidstatus',SPIDER_LOG_LEVEL_FATAL,array(''));
				}
			} else {
				$request->addLocaledError('member.error.common.membernotfound',SPIDER_LOG_LEVEL_FATAL,array(''));
			}
		}

		if( !$request->isError() ) {
			// エラーがないなら更新処理
			$memberObject->status_flag	= $statusFlag;
			$memberObject->modifier_id	= $loginUserObject->getUniqueId();
			// 削除にするならログインIDは同一メールアドレスのユーザーが登録できないことを避けるため会員IDを入れておく
			if( $statusFlag >= 200 ) {
				$memberObject->login_id		= $memberObject->member_id;
			}
			$memberObject->updated_date	= date('Y-m-d H:i:s');
			if( $dbo->update($memberObject,true) ) {
				// パッケージコネクタの追加更新処理をおこなう
				if( is_array($GLOBALS['member.existsConnectorHash'] ) ) {
					foreach( $GLOBALS['member.existsConnectorHash'] as $packageId => $connectorObject ) {
						$connectorObject->additionalPostUpdateProcess( $request, $memberObject );
					}
				}
			} else {
				$request->addLocaledError('database2.error.update',SPIDER_LOG_LEVEL_FATAL,array(''));
			}
		}
		$request->setAttribute('member.member.memberObject',$memberObject);
	}
}
?>