<?php
/*
 * member/member/LoadList.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once( dirname(dirname(__FILE__))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php');
require_once( dirname(dirname(__FILE__))
.DIRECTORY_SEPARATOR.'Connector.class.php' );
/**
 * spider : 会員テーブル操作 一覧取得用アクションモジュールクラス
 * 
 * @package member 会員管理パッケージ
 * @subpackage member 会員テーブル操作パッケージ
 * @version 1.0.0
 * @author  <m_nakashima@users.sourceforge.jp>
 * @since PHP 4.0
 */
class member_member_LoadList extends system_login_ModuleBase {
	function member_member_LoadList() {
		array_push($this->require_module_array,'database2.Connect');
	}
	function execute( & $request ) {
		$dbo				= $request->getAttribute( 'dbo' );
		$page_rows			= $request->getParam('pr','get');
		$page_number		= $request->getParam('pn','get');
		$queryWord			= $request->getParam('q','get');
		$sortItem			= $request->getParam('si','get');
		$sortOrder			= $request->getParam('so','get');
		$memberClass		= $request->getParam('mmc','get');
		$statusFlag			= $request->getParam('mmstf','get');

		// 都道府県条件
		$prefectureNumbers	= $request->getParam('pref','get','array');
		$prefectureNumberArray	= array();
		foreach( $prefectureNumbers as $num ) {
			if( preg_match('/[0-9]{1,2}/',trim($num)) > 0 ) {
				array_push( $prefectureNumberArray, trim($num));
			}
		}
		
		// 所有 
		$owner				= $request->getParam('owner','get');
		$loginUserObject	= $this->getLoginUserObject( $request );
		// 要対応
		$correspond			= $request->getParam('correspond','get');
		// メールエラー戻り条件
		$mailReturnPc		= $request->getParam('mretpc','get');
		$mailReturnMobile	= $request->getParam('mretmb','get');
		// メール一斉配信履歴条件
		$mailSendCondition	= $request->getParam('mlhc','get');
		$mailSendMonth		= $request->getParam('mlhm','get');
		// 性別
		$sex				= $request->getParam('msex','get');

		if ( !is_numeric( $page_number ) || $page_number < 1 ) {
			$page_number	= 1;
		}
		if ( !is_numeric( $page_rows ) || $page_rows < 1 ) {
			$page_rows		= 20;
		} else if ( $page_rows > 100 ) {
			$page_rows		= 20;
		}
		if( 'asc' != $sortOrder ) {
			$sortOrder	= 'desc';
		}
		$order_condition	= '';
		if( 'id' == $sortItem ) {
			$order_condition	= ' ORDER BY '.TABLE_NAME_MEMBER.'.member_id '.$sortOrder;
		} else 	if( 'handle' == $sortItem ) {
			$order_condition	= ' ORDER BY '.TABLE_NAME_MEMBER.'.view_name '.$sortOrder;
		} else {
			$sortItem			= 'reg';
			$order_condition	= ' ORDER BY '.TABLE_NAME_MEMBER.'.registered_date '.$sortOrder;
		}
		
		$condition_array	= array();
		if( preg_match('/^[0-9]{1,3}$/',$statusFlag) > 0 ) {
			array_push( $condition_array, TABLE_NAME_MEMBER.'.status_flag='.$statusFlag );
		} else {
			$statusFlag	= '';
			array_push( $condition_array, TABLE_NAME_MEMBER.'.status_flag<200' );
		}
		if( strlen($memberClass) > 0 && preg_match('/^[0-9]{1,3}$/',$memberClass) > 0 ) {
			array_push( $condition_array, TABLE_NAME_MEMBER.'.member_class='.$memberClass );
		} else {
			$memberClass	= '';
		}
		// 検索フリーワード
		if ( strlen( $queryWord ) > 0 ) {
			$queryWord	= str_replace('　',' ',$queryWord);
			while( false !== strpos($queryWord,'  ') ) {
				$queryWord	= str_replace('  ',' ',$queryWord);
			}
			$wordArray	= explode(' ',$queryWord);
			foreach( $wordArray as $word ) {
				$str	= '( '.TABLE_NAME_MEMBER.'.member_id LIKE '.$dbo->quote( '%'.$word.'%' )
					.' OR '
					.TABLE_NAME_MEMBER.'.pc_mail LIKE '.$dbo->quote( '%'.$word.'%' )
					.' OR '
					.TABLE_NAME_MEMBER.'.mb_mail LIKE '.$dbo->quote( '%'.$word.'%' )
					.' OR '
					.TABLE_NAME_MEMBER.'.view_name LIKE '.$dbo->quote( '%'.$word.'%' )
					.' OR '
					.TABLE_NAME_MEMBER.'.first_name LIKE '.$dbo->quote( '%'.$word.'%' )
					.' OR '
					.TABLE_NAME_MEMBER.'.family_name LIKE '.$dbo->quote( '%'.$word.'%' )
					.' OR '
					.TABLE_NAME_MEMBER.'.first_kana LIKE '.$dbo->quote( '%'.$word.'%' )
					.' OR '
					.TABLE_NAME_MEMBER.'.family_kana LIKE '.$dbo->quote( '%'.$word.'%' )
					.' OR '
					.TABLE_NAME_MEMBER.'.telephone_number LIKE '.$dbo->quote( '%'.$word.'%' )
					.' OR '
					.TABLE_NAME_MEMBER.'.faximili_number LIKE '.$dbo->quote( '%'.$word.'%' )
					.' OR '
					.TABLE_NAME_MEMBER.'.mobile_number LIKE '.$dbo->quote( '%'.$word.'%' )
					.' OR '
					.TABLE_NAME_MEMBER.'.telephone_number2 LIKE '.$dbo->quote( '%'.$word.'%' )
					.' OR '
					.TABLE_NAME_MEMBER.'.faximili_number2 LIKE '.$dbo->quote( '%'.$word.'%' )
					.' OR '
					.TABLE_NAME_MEMBER.'.company_name LIKE '.$dbo->quote( '%'.$word.'%' )
										.' OR '
					.TABLE_NAME_MEMBER.'.section_name LIKE '.$dbo->quote( '%'.$word.'%' )
					.' )'
				;
				array_push( $condition_array, $str );
			}
		}
		// 登録日条件
		if( strlen( $str = $this->_getRegisteredDateCondition( $request ) ) > 0 ) {
			array_push( $condition_array, $str );
		}
		
		// ログイン日時条件
		if( strlen( $str = $this->_getLoginDateCondition( $request ) ) > 0 ) {
			array_push( $condition_array, $str );
		}
		
		// 都道府県条件
		if( count($prefectureNumberArray) > 0 && count($prefectureNumberArray) < count($GLOBALS['PREFECTURE_HASH']) ) {
			$str	= TABLE_NAME_MEMBER.'.prefecture_number IN ('.implode(',',$prefectureNumberArray).')';
			array_push( $condition_array, $str );
		}
		
		// 自分がオーナー
		if( strlen($owner) > 0 ) {
			$str	= TABLE_NAME_MEMBER.'.owner_id='.$dbo->quote( $loginUserObject->getUniqueId() );
			array_push( $condition_array, $str );
		}
		// 要対応
		if( strlen($correspond) > 0 ) {
			$str	= 'CRPD.status_flag<100';
			array_push( $condition_array, $str );
		}
		// メールエラー戻り回数条件
		if( strlen($mailReturnPc) > 0 ) {
			if( preg_match('/^[0-9]+$/',$mailReturnPc) ) {
				// 未満条件
				$str	= TABLE_NAME_MEMBER.'.member_id IN ('
					.' SELECT DISTINCT member_id FROM '.TABLE_NAME_MEMBER_ERROR_COUNT
					.' WHERE '.TABLE_NAME_MEMBER_ERROR_COUNT.'.pc_mail_error_count<'.$mailReturnPc
					.')'
				;
				array_push( $condition_array, $str );
			} else if( preg_match('/^u[0-9]+$/',$mailReturnPc) ) {
				// 以上条件
				$num	= str_replace('u','',$mailReturnPc);
				$str	= TABLE_NAME_MEMBER.'.member_id IN ('
					.' SELECT DISTINCT member_id FROM '.TABLE_NAME_MEMBER_ERROR_COUNT
					.' WHERE '.TABLE_NAME_MEMBER_ERROR_COUNT.'.pc_mail_error_count>='.$num
					.')'
				;
			} else {
				$mailReturnPc	= '';
			}
		}
		if( strlen($mailReturnMobile) > 0 ) {
			if( preg_match('/^[0-9]+$/',$mailReturnMobile) ) {
				// 未満条件
				$str	= TABLE_NAME_MEMBER.'.member_id IN ('
					.' SELECT DISTINCT member_id FROM '.TABLE_NAME_MEMBER_ERROR_COUNT
					.' WHERE '.TABLE_NAME_MEMBER_ERROR_COUNT.'.pc_mail_error_count<'.$mailReturnMobile
					.')'
				;
				array_push( $condition_array, $str );
			} else if( preg_match('/^u[0-9]+$/',$mailReturnMobile) ) {
				// 以上条件
				$num	= str_replace('u','',$mailReturnMobile);
				$str	= TABLE_NAME_MEMBER.'.member_id IN ('
					.' SELECT DISTINCT member_id FROM '.TABLE_NAME_MEMBER_ERROR_COUNT
					.' WHERE '.TABLE_NAME_MEMBER_ERROR_COUNT.'.mb_mail_error_count>='.$num
					.')'
				;
			} else {
				$mailReturnMobile	= '';
			}
		}

		// メール一斉配信履歴条件
		if( 'sent' == $mailSendCondition ) {
			// 配信した条件
			if( preg_match('/^[0-9]{1,2}$/',$mailSendMonth) == 0 ) {
				$mailSendMonth	= 6;
			}
			$str	= TABLE_NAME_MEMBER.'.member_id IN ('
				.' SELECT DISTINCT member_id FROM '.TABLE_NAME_MEMBER_MAIL_LOG
				.' LEFT OUTER JOIN '.TABLE_NAME_MEMBER_MAIL
				.' ON '.TABLE_NAME_MEMBER_MAIL.'.mail_id='.TABLE_NAME_MEMBER_MAIL_LOG.'.mail_id'
				.' WHERE '.TABLE_NAME_MEMBER_MAIL_LOG.'.delivery_date>'.$dbo->quote(date('Y-m-d H:i:s',strtotime('-'.$mailSendMonth.' month')))
				.' AND '.TABLE_NAME_MEMBER_MAIL.'.select_type<>'.$dbo->quote('m')
				.')'
			;
			array_push( $condition_array, $str );
		} else if( 'nosent' == $mailSendCondition ) {
			// 配信してない条件
			if( preg_match('/^[0-9]{1,2}$/',$mailSendMonth) == 0 ) {
				$mailSendMonth	= 6;
			}
			$str	= TABLE_NAME_MEMBER.'.member_id NOT IN ('
				.' SELECT DISTINCT member_id FROM '.TABLE_NAME_MEMBER_MAIL_LOG
				.' LEFT OUTER JOIN '.TABLE_NAME_MEMBER_MAIL
				.' ON '.TABLE_NAME_MEMBER_MAIL.'.mail_id='.TABLE_NAME_MEMBER_MAIL_LOG.'.mail_id'
				.' WHERE '.TABLE_NAME_MEMBER_MAIL_LOG.'.delivery_date>'.$dbo->quote(date('Y-m-d H:i:s',strtotime('-'.$mailSendMonth.' month')))
				.' AND '.TABLE_NAME_MEMBER_MAIL.'.select_type<>'.$dbo->quote('m')
				.')'
			;
			array_push( $condition_array, $str );
		}
		
		// 性別
		if( strlen($sex) > 0 && preg_match('/^[012]$/',$sex) > 0 ) {
			$str	= TABLE_NAME_MEMBER.'.sex='.$sex;
			array_push( $condition_array, $str );
		}
		// 生年月日
		if( strlen( $str = $this->_getBirthDateCondition( $request ) ) > 0 ) {
			array_push( $condition_array, $str );
		}

		// 他パッケージの追加条件を取得
		$extraConditionObjectArray	= array();
		$extraConditionFormHash		= array();
		$connectorObjectHash		= member_Connector::getExistsConnecterHash( $request );
		foreach( $connectorObjectHash as $packageId => $connectorObject ) {
			// 追加検索条件を取得
			$str	= trim($connectorObject->getWhereConditionStrings( $request ));
			if( strlen($str) > 0 ) {
				array_push( $condition_array, $str );
			}
			// 追加検索条件入力フォームを取得
			$extraConditionFormHash[$packageId]	= $connectorObject->getSearchFormStrings( $request );
		}

		// 条件の結合		
		$condition_string	= '';
		if ( count( $condition_array ) > 0 ) {
			$condition_string	= ' WHERE '.implode( ' AND ', $condition_array );
		}
		
		// トータル件数を取得
		$sql	= 'SELECT COUNT(DISTINCT('
			.TABLE_NAME_MEMBER.'.member_id)) '
			.' FROM '.TABLE_NAME_MEMBER
			.' LEFT OUTER JOIN '.TABLE_NAME_MEMBER_CORRESPOND.' AS CRPD '
				.' ON CRPD.member_id='.TABLE_NAME_MEMBER.'.member_id '
				.' AND CRPD.status_flag<100 '
			.$condition_string
		;
		if( strlen($correspond) > 0 ) {
			$sql	.= ' AND CRPD.status_flag<100';
		}
		$request->setSession( MEMBER_SESSION_NAME_LOADCOUNT_QUERY, $sql, SPIDER_SESSION_SCOPE_GLOBAL );
		$total_count	= 0;
		$result			= $dbo->queryOne( $sql );
		if ( false === $result ) {
			$request->addLocaledError('database2.error.common',SPIDER_LOG_LEVEL_FATAL,array($sql));
		} else {
			$total_count	= $result;
		}
		$total_page			= ceil( $total_count / $page_rows );
		if ( $page_number > $total_page ) {
			$page_number	= $total_page;
		}
		
		// ページ分取得
		$sql	= 'SELECT DISTINCT '.TABLE_NAME_MEMBER.'.* '
			.',MAX(CRPD.correspond_date) AS last_correspond_date'
			.',SUM( CASE WHEN CRPD.status_flag >= 100 AND CRPD.status_flag < 200 THEN 1 ELSE 0 END ) AS complete_correspond'
			.',SUM( CASE WHEN CRPD.status_flag < 100 THEN 1 ELSE 0 END ) AS remain_correspond'
			.' FROM '.TABLE_NAME_MEMBER
			.' LEFT OUTER JOIN '.TABLE_NAME_MEMBER_CORRESPOND.' AS CRPD '
				.' ON CRPD.member_id='.TABLE_NAME_MEMBER.'.member_id '
				.' AND CRPD.status_flag<200 '
			.$condition_string
			.' GROUP BY '.TABLE_NAME_MEMBER.'.member_id '
			.$order_condition
		;
		$dbo->setLimit( $page_rows, ( $page_number - 1 ) * $page_rows );
		$obj		= spider_Controller::createObject('member_DaoMember');
		$result		= $dbo->queryAll( $sql,$obj,true );
		if ( false === $result ) {
			$request->addLocaledError('database2.error.common',SPIDER_LOG_LEVEL_FATAL,array($sql));
		} else {
			$request->setAttribute( 'member.data_array', $result );
			$request->setAttribute( 'member.total_count', $total_count );
			$request->setAttribute( 'member.total_page', $total_page );
			$request->setAttribute( 'member.page_number', $page_number );
			$request->setAttribute( 'member.page_rows', $page_rows );
			$request->setAttribute( 'member.query', $queryWord );
			$request->setAttribute( 'member.sort_item', $sortItem );
			$request->setAttribute( 'member.sort_order', $sortOrder );
			$request->setAttribute( 'member.memberClass', $memberClass );
			$request->setAttribute( 'member.statusFlag', $statusFlag );
			// 都道府県
			$request->setAttribute( 'member.member.prefectureNumberArray',	$prefectureNumberArray);
			
			$request->setAttribute( 'member.owner',			$owner );
			$request->setAttribute( 'member.correspond',		$correspond );
			// メールエラー戻り回数
			$request->setAttribute( 'member.mailReturnPc',			$mailReturnPc );
			$request->setAttribute( 'member.mailReturnMobile',		$mailReturnMobile );

			$request->setAttribute( 'member.mailSendCondition',	$mailSendCondition );
			$request->setAttribute( 'member.mailSendMonth',		$mailSendMonth );
			// 性別
			$request->setAttribute( 'member.sex',	$sex);
			// 他パッケージ追加条件
			$request->setAttribute( 'member.connectorObjectHash', $connectorObjectHash );
			$request->setAttribute( 'member.extraConditionFormHash', $extraConditionFormHash );

			$has_next_page	= false;
			if( $page_number < $total_page ) {
				$has_next_page	= true;
			}
			$request->setAttribute( 'member.has_next_page', $has_next_page );
			$has_prev_page	= false;
			if( $page_number > 1 ) {
				$has_prev_page	= true;
			}
			$request->setAttribute( 'member.has_prev_page', $has_prev_page );
			$request->setSession(MEMBER_SESSION_NAME_LOADLIST_QUERY, $sql, SPIDER_SESSION_SCOPE_GLOBAL);
		}
		$request->setSession( MEMBER_SESSION_NAME_LAST_SEARCH_LIST_URI, SPIDER_URI_REQUEST, SPIDER_SESSION_SCOPE_GLOBAL );
	}
	/**
	 * 登録日条件文字列を取得
	 */
	function _getRegisteredDateCondition( & $request ) {
		$dbo				= $request->getAttribute( 'dbo' );
		// 登録日付
		$regStartYear		= $request->getParam('mrsy','get');
		$regStartMonth		= $request->getParam('mrsm','get');
		$regStartDay		= $request->getParam('mrsd','get');
		$regEndYear			= $request->getParam('mrey','get');
		$regEndMonth		= $request->getParam('mrem','get');
		$regEndDay			= $request->getParam('mred','get');
		// 登録日 範囲条件
		if( preg_match('/^[0-9]{4}/',$regStartYear) > 0
			&& preg_match('/^[0-9]{1,2}/',$regStartMonth) > 0
			&& preg_match('/^[0-9]{4}/',$regEndYear) > 0
			&& preg_match('/^[0-9]{1,2}/',$regEndMonth) > 0
		) {
			// 範囲両端が入力されている場合
			if( intval(sprintf('%04d',$regStartYear).sprintf('%02d',$regStartMonth)) > intval(sprintf('%04d',$regEndYear).sprintf('%02d',$regEndMonth)) ) {
				// 最初の年月の方が大きかったら値を入れ替え
				$tmpYear		= $regStartYear;
				$tmpMonth		= $regStartMonth;
				$tmpDay			= $regStartDay;
				$regStartYear	= $regEndYear;
				$regStartMonth	= $regEndMonth;
				$regStartDay	= $regEndDay;
				$regEndYear		= $tmpYear;
				$regEndMonth	= $tmpMonth;
				$regEndDay		= $tmpDay;
			}
		}
		// 日の設定
		if ( strlen(trim($regStartDay)) == 0
			|| !is_numeric($regStartDay)
			|| $regStartDay < 1
			|| $regStartDay > 31
		) {
			// 日が正しく指定されていない場合、1日を設定
			$regStartDay = 1;
		}
		if ( strlen(trim($regEndDay)) == 0
			|| !is_numeric($regEndDay)
			|| $regEndDay < 1
			|| $regEndDay > 31
		) {
			// 日が正しく指定されていない場合、月末を設定
			$end_time	= strtotime($regEndYear.'-'.$regEndMonth);
			$regEndDay	= date('t',$end_time);
		}
		$regStartDate	= '';
		$regEndDate		= '';
		spider_Controller::loadClassDefinition('util_ValidateFunctions');
		if( !util_ValidateFunctions::isAvailableDate( $regStartYear, $regStartMonth, $regStartDay ) ) {
			// 日付の指定が正しくない場合、条件をクリア
			$regStartYear	= '';
			$regStartMonth	= '';
			$regStartDay		= '';
		} else {
			$regStartDate = $regStartYear.'-'.$regStartMonth.'-'.$regStartDay;
		}
		if( !util_ValidateFunctions::isAvailableDate( $regEndYear, $regEndMonth, $regEndDay ) ) {
			// 日付の指定が正しくない場合、条件をクリア
			$regEndYear	= '';
			$regEndMonth	= '';
			$regEndDay	= '';
		} else {
			$regEndDate = $regEndYear.'-'.$regEndMonth.'-'.$regEndDay;
		}
		$regConditionArray	= array();
		if ( strlen(trim($regStartDate)) > 0 ) {
			$regStartDate .= ' 00:00:00';
			$str	= TABLE_NAME_MEMBER.'.registered_date >=' . $dbo->quote( $regStartDate );
			array_push( $regConditionArray, $str );
		}
		if ( strlen(trim($regEndDate)) > 0 ) {
			$regEndDate .= ' 23:59:59';
			$str	= TABLE_NAME_MEMBER.'.registered_date <=' . $dbo->quote( $regEndDate );
			array_push( $regConditionArray, $str );
		}
		// 登録日付の属性登録
		$request->setAttribute( 'member.start_year',	$regStartYear );
		$request->setAttribute( 'member.start_month',	$regStartMonth );
		$request->setAttribute( 'member.start_day',		$regStartDay );
		$request->setAttribute( 'member.end_year',		$regEndYear );
		$request->setAttribute( 'member.end_month',		$regEndMonth );
		$request->setAttribute( 'member.end_day',		$regEndDay );
		$regConditionString	= '';
		if( count($regConditionArray) > 0 ) {
			$regConditionString	= implode(' AND ', $regConditionArray);
		}
		return $regConditionString;
	}
	/**
	 * ログイン日付条件文字列を取得
	 */
	function _getLoginDateCondition( & $request ) {
		$dbo				= $request->getAttribute( 'dbo' );
		// ログイン日付
		$loginStartYear		= $request->getParam('mlsy','get');
		$loginStartMonth	= $request->getParam('mlsm','get');
		$loginStartDay		= $request->getParam('mlsd','get');
		$loginEndYear		= $request->getParam('mley','get');
		$loginEndMonth		= $request->getParam('mlem','get');
		$loginEndDay		= $request->getParam('mled','get');
		// 登録日 範囲条件
		if( preg_match('/^[0-9]{4}/',$loginStartYear) > 0
			&& preg_match('/^[0-9]{1,2}/',$loginStartMonth) > 0
			&& preg_match('/^[0-9]{4}/',$loginEndYear) > 0
			&& preg_match('/^[0-9]{1,2}/',$loginEndMonth) > 0
		) {
			// 範囲両端が入力されている場合
			if( intval(sprintf('%04d',$loginStartYear).sprintf('%02d',$loginStartMonth)) > intval(sprintf('%04d',$loginEndYear).sprintf('%02d',$loginEndMonth)) ) {
				// 最初の年月の方が大きかったら値を入れ替え
				$tmpYear			= $loginStartYear;
				$tmpMonth			= $loginStartMonth;
				$tmpDay				= $loginStartDay;
				$loginStartYear		= $loginEndYear;
				$loginStartMonth	= $loginEndMonth;
				$loginStartDay		= $loginEndDay;
				$loginEndYear		= $tmpYear;
				$loginEndMonth		= $tmpMonth;
				$loginEndDay		= $tmpDay;
			}
			// 日の設定
			if ( strlen(trim($loginStartDay)) == 0
				|| !is_numeric($loginStartDay)
				|| $loginStartDay < 1
				|| $loginStartDay > 31
			) {
				// 日が正しく指定されていない場合、1日を設定
				$loginStartDay = 1;
			}
			if ( strlen(trim($loginEndDay)) == 0
				|| !is_numeric($loginEndDay)
				|| $loginEndDay < 1
				|| $loginEndDay > 31
			) {
				// 日が正しく指定されていない場合、月末を設定
				$loginEndTime	= strtotime($loginEndYear.'-'.$loginEndMonth);
				$loginEndDay	= date('t',$loginEndTime);
			}
		}
		$loginStartDate	= '';
		$loginEndDate		= '';
		spider_Controller::loadClassDefinition('util_ValidateFunctions');
		if( !util_ValidateFunctions::isAvailableDate( $loginStartYear, $loginStartMonth, $loginStartDay ) ) {
			// 日付の指定が正しくない場合、条件をクリア
			$loginStartYear	= '';
			$loginStartMonth	= '';
			$loginStartDay		= '';
		} else {
			$loginStartDate = $loginStartYear.'-'.$loginStartMonth.'-'.$loginStartDay;
		}
		if( !util_ValidateFunctions::isAvailableDate( $loginEndYear, $loginEndMonth, $loginEndDay ) ) {
			// 日付の指定が正しくない場合、条件をクリア
			$loginEndYear	= '';
			$loginEndMonth	= '';
			$loginEndDay	= '';
		} else {
			$loginEndDate = $loginEndYear.'-'.$loginEndMonth.'-'.$loginEndDay;
		}
		$retConditionArray	= array();
		if ( strlen(trim($loginStartDate)) > 0 ) {
			$loginStartDate .= ' 00:00:00';
			$str	= TABLE_NAME_MEMBER_LOGIN_HISTORY.'.login_date >=' . $dbo->quote( $loginStartDate );
			array_push( $retConditionArray, $str );
		}
		if ( strlen(trim($loginEndDate)) > 0 ) {
			$loginEndDate .= ' 23:59:59';
			$str	= TABLE_NAME_MEMBER_LOGIN_HISTORY.'.login_date <=' . $dbo->quote( $loginEndDate );
			array_push( $retConditionArray, $str );
		}
		$request->setAttribute( 'member.loginStartYear',	$loginStartYear );
		$request->setAttribute( 'member.loginStartMonth',	$loginStartMonth );
		$request->setAttribute( 'member.loginStartDay',		$loginStartDay );
		$request->setAttribute( 'member.loginEndYear',		$loginEndYear );
		$request->setAttribute( 'member.loginEndMonth',		$loginEndMonth );
		$request->setAttribute( 'member.loginEndDay',		$loginEndDay );
		$conditionString	= '';
		if( count($retConditionArray) > 0 ) {
			$conditionString	= TABLE_NAME_MEMBER.'.member_id IN ( SELECT DISTINCT member_id FROM '.TABLE_NAME_MEMBER_LOGIN_HISTORY
				.' WHERE '.implode(' AND ', $retConditionArray).' )';
		}
		return $conditionString;
	}
	/**
	 * 生年月日条件文字列作成
	 */
	function _getBirthDateCondition( & $request ) {
		$dbo				= $request->getAttribute( 'dbo' );
		// 生年日付
		$birthStartYear		= $request->getParam('mbsy','get');
		$birthStartMonth	= $request->getParam('mbsm','get');
		$birthStartDay		= $request->getParam('mbsd','get');
		$birthEndYear		= $request->getParam('mbey','get');
		$birthEndMonth		= $request->getParam('mbem','get');
		$birthEndDay		= $request->getParam('mbed','get');
		
		// 条件配列
		$conditionArray		= array();
		// 開始年月日の条件
		$conditionString	= '';
		if( preg_match('/^(19[0-9]{2}|2[0-9]{3})$/',$birthStartYear) > 0
			&& preg_match('/^([1-9]|1[0-2])$/',$birthStartMonth) > 0
			&& preg_match('/^((0|)[1-9]|[12][0-9]|3[01])$/',$birthStartDay) > 0
		){
			// 年月日全て正しい入力がある場合
			$conditionString	= '( '.TABLE_NAME_MEMBER.'.birth_year>'.$birthStartYear
				.' OR '
				.'('.TABLE_NAME_MEMBER.'.birth_year='.$birthStartYear.' AND '.TABLE_NAME_MEMBER.'.birth_month>'.$birthStartMonth.' )'
				.' OR '
				.'('.TABLE_NAME_MEMBER.'.birth_year='.$birthStartYear.' AND '.TABLE_NAME_MEMBER.'.birth_month='.$birthStartMonth.' AND '.TABLE_NAME_MEMBER.'.birth_day>='.$birthStartDay.' )'
				.' )';
		} else if( preg_match('/^(19[0-9]{2}|2[0-9]{3})$/',$birthStartYear) > 0
			&& preg_match('/^([1-9]|1[0-2])$/',$birthStartMonth) > 0
			&& preg_match('/^((0|)[1-9]|[12][0-9]|3[01])$/',$birthStartDay) == 0
		){
			// 年月のみ入力されている場合
			$conditionString	= '( '.TABLE_NAME_MEMBER.'.birth_year>'.$birthStartYear
				.' OR '
				.'('.TABLE_NAME_MEMBER.'.birth_year='.$birthStartYear.' AND '.TABLE_NAME_MEMBER.'.birth_month>='.$birthStartMonth.' )'
				.' )';
		} else if( preg_match('/^(19[0-9]{2}|2[0-9]{3})$/',$birthStartYear) > 0
			&& preg_match('/^([1-9]|1[0-2])$/',$birthStartMonth) == 0
			&& preg_match('/^((0|)[1-9]|[12][0-9]|3[01])$/',$birthStartDay) == 0
		){
			// 年のみ入力されている場合
			$conditionString	= '( '.TABLE_NAME_MEMBER.'.birth_year>='.$birthStartYear.' )';
		} else if( preg_match('/^(19[0-9]{2}|2[0-9]{3})$/',$birthStartYear) == 0
			&& preg_match('/^([1-9]|1[0-2])$/',$birthStartMonth) > 0
			&& preg_match('/^((0|)[1-9]|[12][0-9]|3[01])$/',$birthStartDay) > 0
		){
			// 月日のみ入力されている場合
			$conditionString	= '( '
				.'('.TABLE_NAME_MEMBER.'.birth_month>'.$birthStartMonth.' )'
				.' OR '
				.'('.TABLE_NAME_MEMBER.'.birth_month='.$birthStartMonth.' AND '.TABLE_NAME_MEMBER.'.birth_day>='.$birthStartDay.' )'
				.' )';
		} else if( preg_match('/^(19[0-9]{2}|2[0-9]{3})$/',$birthStartYear) == 0
			&& preg_match('/^([1-9]|1[0-2])$/',$birthStartMonth) > 0
			&& preg_match('/^((0|)[1-9]|[12][0-9]|3[01])$/',$birthStartDay) == 0
		){
			// 月のみ入力されている場合
			$conditionString	= '('.TABLE_NAME_MEMBER.'.birth_month>='.$birthStartMonth.' )';
		} else if( preg_match('/^(19[0-9]{2}|2[0-9]{3})$/',$birthStartYear) == 0
			&& preg_match('/^([1-9]|1[0-2])$/',$birthStartMonth) == 0
			&& preg_match('/^((0|)[1-9]|[12][0-9]|3[01])$/',$birthStartDay) > 0
		){
			// 日のみ入力されている場合
			$conditionString	= '('.TABLE_NAME_MEMBER.'.birth_day>='.$birthStartDay.' )';
		} else if( preg_match('/^(19[0-9]{2}|2[0-9]{3})$/',$birthStartYear) > 0
			&& preg_match('/^([1-9]|1[0-2])$/',$birthStartMonth) == 0
			&& preg_match('/^((0|)[1-9]|[12][0-9]|3[01])$/',$birthStartDay) > 0
		){
			// 年と日が入力されている場合
			$conditionString	= '( '.TABLE_NAME_MEMBER.'.birth_year>='.$birthStartYear
				.' AND '
				.'('.TABLE_NAME_MEMBER.'.birth_day>='.$birthStartDay.' )'
				.' )';
		}
		if( strlen($conditionString) > 0 ) {
			array_push($conditionArray,$conditionString);
		}
		
		// 終了年月日の条件
		$conditionString	= '';
		if( preg_match('/^(19[0-9]{2}|2[0-9]{3})$/',$birthEndYear) > 0
			&& preg_match('/^([1-9]|1[0-2])$/',$birthEndMonth) > 0
			&& preg_match('/^((0|)[1-9]|[12][0-9]|3[01])$/',$birthEndDay) > 0
		){
			// 年月日全て正しい入力がある場合
			$conditionString	= '( '.TABLE_NAME_MEMBER.'.birth_year<'.$birthEndYear
				.' OR '
				.'('.TABLE_NAME_MEMBER.'.birth_year='.$birthEndYear.' AND '.TABLE_NAME_MEMBER.'.birth_month<'.$birthEndMonth.' )'
				.' OR '
				.'('.TABLE_NAME_MEMBER.'.birth_year='.$birthEndYear.' AND '.TABLE_NAME_MEMBER.'.birth_month='.$birthEndMonth.' AND '.TABLE_NAME_MEMBER.'.birth_day<='.$birthEndDay.' )'
				.' )';
		} else if( preg_match('/^(19[0-9]{2}|2[0-9]{3})$/',$birthEndYear) > 0
			&& preg_match('/^([1-9]|1[0-2])$/',$birthEndMonth) > 0
			&& preg_match('/^((0|)[1-9]|[12][0-9]|3[01])$/',$birthEndDay) == 0
		){
			// 年月のみ入力されている場合
			$conditionString	= '( '.TABLE_NAME_MEMBER.'.birth_year<'.$birthEndYear
				.' OR '
				.'('.TABLE_NAME_MEMBER.'.birth_year='.$birthEndYear.' AND '.TABLE_NAME_MEMBER.'.birth_month<='.$birthEndMonth.' )'
				.' )';
		} else if( preg_match('/^(19[0-9]{2}|2[0-9]{3})$/',$birthEndYear) > 0
			&& preg_match('/^([1-9]|1[0-2])$/',$birthEndMonth) == 0
			&& preg_match('/^((0|)[1-9]|[12][0-9]|3[01])$/',$birthEndDay) == 0
		){
			// 年のみ入力されている場合
			$conditionString	= '( '.TABLE_NAME_MEMBER.'.birth_year<='.$birthEndYear.' )';
		} else if( preg_match('/^(19[0-9]{2}|2[0-9]{3})$/',$birthEndYear) == 0
			&& preg_match('/^([1-9]|1[0-2])$/',$birthEndMonth) > 0
			&& preg_match('/^((0|)[1-9]|[12][0-9]|3[01])$/',$birthEndDay) > 0
		){
			// 月日のみ入力されている場合
			$conditionString	= '( '
				.'('.TABLE_NAME_MEMBER.'.birth_month<'.$birthEndMonth.' )'
				.' OR '
				.'('.TABLE_NAME_MEMBER.'.birth_month='.$birthEndMonth.' AND '.TABLE_NAME_MEMBER.'.birth_day<='.$birthEndDay.' )'
				.' )';
		} else if( preg_match('/^(19[0-9]{2}|2[0-9]{3})$/',$birthEndYear) == 0
			&& preg_match('/^([1-9]|1[0-2])$/',$birthEndMonth) > 0
			&& preg_match('/^((0|)[1-9]|[12][0-9]|3[01])$/',$birthEndDay) == 0
		){
			// 月のみ入力されている場合
			$conditionString	= '('.TABLE_NAME_MEMBER.'.birth_month<='.$birthEndMonth.' )';
		} else if( preg_match('/^(19[0-9]{2}|2[0-9]{3})$/',$birthEndYear) == 0
			&& preg_match('/^([1-9]|1[0-2])$/',$birthEndMonth) == 0
			&& preg_match('/^((0|)[1-9]|[12][0-9]|3[01])$/',$birthEndDay) > 0
		){
			// 日のみ入力されている場合
			$conditionString	= '('.TABLE_NAME_MEMBER.'.birth_day<='.$birthEndDay.' )';
		} else if( preg_match('/^(19[0-9]{2}|2[0-9]{3})$/',$birthEndYear) > 0
			&& preg_match('/^([1-9]|1[0-2])$/',$birthEndMonth) == 0
			&& preg_match('/^((0|)[1-9]|[12][0-9]|3[01])$/',$birthEndDay) > 0
		){
			// 年と日が入力されている場合
			$conditionString	= '( '.TABLE_NAME_MEMBER.'.birth_year<='.$birthEndYear
				.' AND '
				.'('.TABLE_NAME_MEMBER.'.birth_day<='.$birthEndDay.' )'
				.' )';
		}
		if( strlen($conditionString) > 0 ) {
			array_push($conditionArray,$conditionString);
		}
		
		$request->setAttribute( 'member.birthStartYear',	$birthStartYear );
		$request->setAttribute( 'member.birthStartMonth',	$birthStartMonth );
		$request->setAttribute( 'member.birthStartDay',		$birthStartDay );
		$request->setAttribute( 'member.birthEndYear',		$birthEndYear );
		$request->setAttribute( 'member.birthEndMonth',		$birthEndMonth );
		$request->setAttribute( 'member.birthEndDay',		$birthEndDay );
		if( count($conditionArray) > 0 ) {
			return implode(' AND ',$conditionArray);
		} else {
			return '';
		}
	}
}
?>