<?php
/*
 * member/member/Load.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once( dirname(dirname(__FILE__))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php');
/**
 * spider : 会員テーブル操作 情報読み込み用アクションモジュールクラス
 * 
 * @package member 会員管理パッケージ
 * @subpackage member 会員テーブル操作パッケージ
 * @version 1.0.0
 * @author  <m_nakashima@users.sourceforge.jp>
 * @since PHP 4.0
 */
class member_member_Load extends system_login_ModuleBase {
	function member_member_Load() {
		array_push($this->require_module_array,'database2.Connect');
	}
	function execute( & $request ) {
		// 入力取得
		$dbo			= $request->getAttribute( 'dbo' );
		$memberId		= $request->getParam('mi','get');
		$memberNumber	= $request->getParam('mn','get');
		$memberObject	= spider_Controller::createObject('member_DaoMember');
		// ログイン状態制御
		$loginUserObject	= $this->getLoginUserObject( $request );
		if( strlen(trim($memberId)) > 0 ) {
			// 会員IDが指定されているなら編集の為読み込み
			if( $dbo->loadById( $memberObject, $memberId ) ) {
				// ログイン状態制御
				if( $memberObject->canViewData( $request, $loginUserObject ) ) {
				} else {
					$request->addLocaledError('system.error.login.user.noauthexec',SPIDER_LOG_LEVEL_FATAL,array(''));
				}
			} else {
				$request->addLocaledError('member.error.common.membernotfound',SPIDER_LOG_LEVEL_FATAL,array(''));
			}
		} else if( strlen(trim($memberNumber)) > 0 ) {
			// 会員番号が指定されているなら編集の為読み込み
			if( $dbo->loadByNumber( $memberObject, $memberNumber ) ) {
				// ログイン状態制御
				if( $memberObject->canViewData( $request, $loginUserObject ) ) {
				} else {
					$request->addLocaledError('system.error.login.user.noauthexec',SPIDER_LOG_LEVEL_FATAL,array(''));
				}
			} else {
				$request->addLocaledError('member.error.common.membernotfound',SPIDER_LOG_LEVEL_FATAL,array(''));
			}
		} else {
			$request->addLocaledError('member.error.common.selectmember',SPIDER_LOG_LEVEL_FATAL,array(''));
		}
		$request->setAttribute('member.member.memberObject',$memberObject);
	}
}
?>