<?php
/*
 * member/mail/reject/Form.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once(dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php');
/**
 * spider : メンバーメール 配信メールマガジン種別作成入力フォーム用アクションモジュールクラス
 * 
 * @package member メンバー管理パッケージ
 * @subpackage mail メールパッケージ
 * @subpackage reject メールマガジン種別パッケージ
 * @version 1.0.0
 * @author  <m_nakashima@users.sourceforge.jp>
 * @since PHP 4.0
 */
class member_mail_reject_Form extends system_login_ModuleBase {
	function member_mail_reject_Form(){
		array_push($this->require_module_array,'database2.Connect');
	}
	function execute( & $request ) {
		
		$dbo						= $request->getAttribute( 'dbo' );

		$list_id					= stripslashes( $_GET['rli'] );
		$sessionObjectName		= 'member.mail.reject.modify.object.'.$list_id;
		$sessionConfirmName		= 'member.mail.reject.modify.confirm.'.$list_id;
		$compare_reject_list	= spider_Controller::createObject('member_DaoMemberMailReject');
		$rejectListObject			= $request->getSession($sessionObjectName);
		$loginUserObject			= $this->getLoginUserObject( $request );
		$request->removeSession($sessionConfirmName);

		if( get_class($compare_reject_list) == get_class($rejectListObject) ){
			// セッションに登録済みならそのまま利用する
		} else {
			// セッションにないなら作成する
			$rejectListObject			= new member_DaoMemberMailReject();
			if( strlen(trim($list_id)) > 0 ) {
				// IDが指定されているなら編集のため読み込み
				if( $dbo->loadById( $rejectListObject, $list_id ) ){
					$this->lockData( $request, $rejectListObject );
				} else {
					$request->addLocaledError('system.error.common.data.invalidselect',SPIDER_LOG_LEVEL_FATAL,array(''));
				}
			} else {
				// IDが指定されていないなら新規作成
			}
		}
		
		$request->setAttribute('member.mail.reject.reject_list_object',$rejectListObject);

	}
}
?>