<?php
/*
 * member/mail/reject/AddMember.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once(dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php');
/**
 * spider : メンバーメール 配信メールマガジン種別メンバー追加用アクションモジュールクラス
 * 
 * @package member メンバー管理パッケージ
 * @subpackage mail メールパッケージ
 * @subpackage reject メールマガジン種別パッケージ
 * @version 1.0.0
 * @author  <m_nakashima@users.sourceforge.jp>
 * @since PHP 4.0
 */
class member_mail_reject_AddMember extends system_login_ModuleBase {
	function member_mail_reject_AddMember(){
		array_push($this->require_module_array,'database2.Connect');
	}
	function execute( & $request ) {
		
		$dbo						= $request->getAttribute( 'dbo' );

		$list_id					= stripslashes( $_POST['list_id'] );
		$memberId					= stripslashes( $_POST['member_id'] );
		$loginUserObject			= $this->getLoginUserObject( $request );

		if( strlen($list_id) == 0 ) {
			$request->addLocaledError('member.error.dao.magazine.selectmagazinetype',SPIDER_LOG_LEVEL_FATAL,array());
		}
		if( strlen($memberId) == 0 ) {
			$request->addLocaledError('member.error.common.selectmember',SPIDER_LOG_LEVEL_FATAL,array());
		}
		$rejectListObject	= spider_Controller::createObject('member_DaoMemberMailReject');
		$memberObject		= spider_Controller::createObject('member_DaoMember');
		if( !$request->isError() ) {
			if( !$dbo->loadById( $rejectListObject, $list_id ) ) {
				$request->addLocaledError('system.error.common.data.invalidselect',SPIDER_LOG_LEVEL_FATAL,array());
			}
			if( !$dbo->loadById( $memberObject, $memberId ) ) {
				$request->addLocaledError('system.error.common.data.invalidselect',SPIDER_LOG_LEVEL_FATAL,array());
			}
		}
		if( !$request->isError() ) {
			// エラーがないなら
			if( $rejectListObject->isBelongTo( $dbo, $memberId ) ) {
				// 既に所属しているなら何もしない
			} else {
				// 読み込みできなかったら挿入
				array_push( $memberObject->rejectListIdArray,$list_id );
				$memberObject->modifier_id	= $loginUserObject->getUniqueId();
				$memberObject->updated_date	= date('Y-m-d H:i:s');
				if( $dbo->update( $memberObject, true ) ) {
				} else {
					$request->addLocaledError('database2.error.update',SPIDER_LOG_LEVEL_FATAL,array(""));
				}
			}
		}

		$request->setAttribute('member.mail.reject.reject_list_object',$rejectListObject);

	}
}
?>