<?php
/*
 * member/mail/LoadList.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once( dirname(dirname(__FILE__))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php');
class member_mail_LoadList extends system_login_ModuleBase {
	function member_mail_LoadList() {
		array_push($this->require_module_array,'database2.Connect');
	}
	function execute( & $request ) {
		$dbo				= $request->getAttribute( 'dbo' );
		$page_rows			= stripslashes( $_GET['pr'] );
		$page_number		= stripslashes( $_GET['pn'] );
		$statusFlag			= stripslashes( $_GET['mmst'] );
		$query_word			= stripslashes( $_GET['q'] );
		$pastReserved		= stripslashes( $_GET['mpstrsv'] );
		$sortItem			= trim( stripslashes( $_GET['msi'] ) );
		$sortOrder			= trim( stripslashes( $_GET['mso'] ) );
		$targetMemberId		= trim(stripslashes( $_GET['mi'] ));
		$target_start_year	= trim(stripslashes( $_GET['tsy'] ));
		$target_start_month	= trim(stripslashes( $_GET['tsm'] ));
		$target_start_day	= trim(stripslashes( $_GET['tsd'] ));
		$target_end_year	= trim(stripslashes( $_GET['tey'] ));
		$target_end_month	= trim(stripslashes( $_GET['tem'] ));
		$target_end_day		= trim(stripslashes( $_GET['ted'] ));
		if( preg_match('/^(1|2)[0-9]{3}$/',$target_start_year) == 0 ) {
			$target_start_year	= date('Y');
		}
		if( preg_match('/^(1|2)[0-9]{3}$/',$target_end_year) == 0 ) {
			$target_end_year	= date('Y');
		}
		if( preg_match('/^((|0)[1-9]|1[0-2])$/',$target_start_month) == 0 ) {
			$target_start_month	= date('m');
		}
		if( preg_match('/^((|0)[1-9]|1[0-2])$/',$target_end_month) == 0 ) {
			$target_end_month	= date('m');
		}
		if( preg_match('/^((|0)[1-9]|(1|2)[0-9]|3[01])$/',$target_start_day) == 0 ) {
			$target_start_day	= '01';
		}
		if( preg_match('/^((|0)[1-9]|(1|2)[0-9]|3[01])$/',$target_end_day) == 0 ) {
			$target_end_day	= date('t');
		}
		if( preg_match('/^[tT]|[yY]$/',$pastReserved) > 0 ) {
			$pastReserved	= true;
		} else {
			$pastReserved	= false;
		}

		if ( !is_numeric( $page_number ) || $page_number < 1 ) {
			$page_number	= 1;
		}
		if ( !is_numeric( $page_rows ) || $page_rows < 1 ) {
			$page_rows		= 50;
		} else if ( $page_rows > 1000 ) {
			$page_rows		= 1000;
		}
		if( 'asc' != $sortOrder ) {
			$sortOrder	= 'desc';
		}
		if( $sortItem == 'reg' ) {
			$order_condition	= ' ORDER BY ' .TABLE_NAME_MEMBER_MAIL.'.registered_date '.$sortOrder;
		} else if( $sortItem == 'cmp' ) {
			$order_condition	= ' ORDER BY ' .TABLE_NAME_MEMBER_MAIL.'.completed_date '.$sortOrder;
		} else {
			$sortItem			= 'rsv';
			$order_condition	= ' ORDER BY ' .TABLE_NAME_MEMBER_MAIL.'.reserve_date '.$sortOrder;
		}
		
		$condition_array	= array();
		if( preg_match('/^[0-9]{1,3}$/',$statusFlag) > 0 ) {
			array_push( $condition_array, TABLE_NAME_MEMBER_MAIL.'.status_flag='.$statusFlag );
		} else {
			array_push( $condition_array, TABLE_NAME_MEMBER_MAIL.'.status_flag<200' );
		}
		if ( strlen( $query_word ) > 0 ) {
			$str	= '( '.TABLE_NAME_MEMBER_MAIL.'.mail_id LIKE ' . $dbo->quote( '%'.$query_word.'%' )
				. ' OR '
				. TABLE_NAME_MEMBER_MAIL.'.subject LIKE ' . $dbo->quote( '%'.$query_word.'%' )
				. ' OR '
				. TABLE_NAME_MEMBER_MAIL.'.body LIKE ' . $dbo->quote( '%'.$query_word.'%' )
				. ' )'
			;
			array_push( $condition_array, $str );
		}
		// 日付範囲
		$start_date	= $target_start_year.'-'.$target_start_month.'-'.$target_start_day. ' 00:00:00';
		$str		= TABLE_NAME_MEMBER_MAIL.'.reserve_date>='.$dbo->quote($start_date);
		array_push( $condition_array, $str );
		$end_date	= $target_end_year.'-'.$target_end_month.'-'.$target_end_day. ' 23:59:59';
		$str		= TABLE_NAME_MEMBER_MAIL.'.reserve_date<='.$dbo->quote($end_date);
		array_push( $condition_array, $str );
		// ターゲットメンバー
		if( strlen($targetMemberId) > 0 ) {
			$str		= TABLE_NAME_MEMBER_MAIL_LOG.'.member_id='.$dbo->quote($targetMemberId);
			array_push( $condition_array, $str );
		}
		// 配信予定日を過ぎている
		if( $pastReserved ) {
			$str		= TABLE_NAME_MEMBER_MAIL.'.reserve_date<NOW()';
			array_push( $condition_array, $str );
		}
		$condition_string	= '';
		if ( count( $condition_array ) > 0 ) {
			$condition_string	= ' WHERE ' . implode( ' AND ', $condition_array );
		}
		
		// トータル件数を取得
		$sql	= 'SELECT COUNT(DISTINCT('.TABLE_NAME_MEMBER_MAIL
			. '.mail_id)) '
			. ' FROM ' . TABLE_NAME_MEMBER_MAIL
			. ' LEFT OUTER JOIN '.TABLE_NAME_MEMBER_MAIL_LOG
			. ' ON '.TABLE_NAME_MEMBER_MAIL_LOG.'.mail_id='.TABLE_NAME_MEMBER_MAIL.'.mail_id'
			. $condition_string
		;
		$total_count	= 0;
		$result			= $dbo->queryOne( $sql );
		if ( $result === false ) {
			$request->addLocaledError('database2.error.common',SPIDER_LOG_LEVEL_FATAL,array($sql));
		} else {
			$total_count	= $result;
		}
		$total_page			= ceil( $total_count / $page_rows );
		if ( $page_number > $total_page ) {
			$page_number	= $total_page;
		}
		
		// IDをページ分取得
		$sql	= 'SELECT DISTINCT('.TABLE_NAME_MEMBER_MAIL . '.mail_id) as mail_id '
			. ', '.TABLE_NAME_MEMBER_MAIL.'.reserve_date '
			. ' FROM ' . TABLE_NAME_MEMBER_MAIL
			. ' LEFT OUTER JOIN '.TABLE_NAME_MEMBER_MAIL_LOG
			. ' ON '.TABLE_NAME_MEMBER_MAIL_LOG.'.mail_id='.TABLE_NAME_MEMBER_MAIL.'.mail_id'
			. $condition_string
			. $order_condition
		;
		
		$dbo->setLimit( $page_rows, ( $page_number - 1 ) * $page_rows );
		$result			= $dbo->queryAll( $sql,null,MDB2_FETCHMODE_ASSOC );
		if ( $result === false ) {
			$request->addLocaledError('database2.error.common',SPIDER_LOG_LEVEL_FATAL,array($sql));
		} else {
			$mail_object_array	= array();
			foreach ( $result as $row ) {
				$mail_object	= spider_Controller::createObject('member_DaoMemberMail');
				if( $dbo->loadById( $mail_object, $row['mail_id'], true ) ) {
					// 処理済みと未処理の件数を作成
					$mail_object->mail_count_reserved	= 0;
					$mail_object->mail_count_delivered	= 0;
					$mail_object->mail_count_error		= 0;
					foreach( $mail_object->delivery_status_hash as $status => $cnt ) {
						if( $status == 0 ) {
							$mail_object->mail_count_reserved	+= $cnt;
						} else if( $status == 1 ) {
							$mail_object->mail_count_delivered	+= $cnt;
						} else {
							$mail_object->mail_count_error	+= $cnt;
						}
					}
					array_push( $mail_object_array, $mail_object );
				}
			}
			$request->setAttribute( 'member.mail.data_array', $mail_object_array );
			$request->setAttribute( 'member.mail.total_count', $total_count );
			$request->setAttribute( 'member.mail.total_page', $total_page );
			$request->setAttribute( 'member.mail.page_number', $page_number );
			$request->setAttribute( 'member.mail.page_rows', $page_rows );
			$request->setAttribute( 'member.mail.query', $query_word );
			$request->setAttribute( 'member.mail.statusFlag', $statusFlag );
			$request->setAttribute( 'member.mail.pastReserved', $pastReserved );
			$request->setAttribute( 'member.mail.sortOrder', $sortOrder );
			$request->setAttribute( 'member.mail.sortItem', $sortItem );

			$request->setAttribute( 'member.mail.target_member_id', $targetMemberId );
			$request->setAttribute( 'member.mail.target_start_year', $target_start_year );
			$request->setAttribute( 'member.mail.target_start_month', $target_start_month );
			$request->setAttribute( 'member.mail.target_start_day', $target_start_day );
			$request->setAttribute( 'member.mail.target_end_year', $target_end_year );
			$request->setAttribute( 'member.mail.target_end_month', $target_end_month );
			$request->setAttribute( 'member.mail.target_end_day', $target_end_day );
			
			$has_next_page	= false;
			if( $page_number < $total_page ) {
				$has_next_page	= true;
			}
			$request->setAttribute( 'member.mail.has_next_page', $has_next_page );
			$has_prev_page	= false;
			if( $page_number > 1 ) {
				$has_prev_page	= true;
			}
			$request->setAttribute( 'member.mail.has_prev_page', $has_prev_page );
		}
	}
}
?>