<?php
/*
 * member/mail/Form.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once( dirname(dirname(__FILE__))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php');
require_once( dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'util'
.DIRECTORY_SEPARATOR.'LockProcess.class.php');
/**
 * spider : メンバーメール 入力フォーム用アクションモジュールクラス
 * 
 * @package member メンバー管理パッケージ
 * @subpackage mail メールパッケージ
 * @version 1.0.0
 * @author  <m_nakashima@users.sourceforge.jp>
 * @since PHP 4.0
 */
class member_mail_Form extends system_login_ModuleBase {
	function member_mail_Form(){
		array_push($this->require_module_array,'database2.Connect');
	}
	function execute( & $request ) {
		
		$dbo					= $request->getAttribute( 'dbo' );
		$member_id				= $_GET['mi'];
		$select_type			= trim(stripslashes( $_GET['stype'] ));
		if( 'q' != $select_type && 's' != $select_type ) {
			$select_type		= 'm';
		}
		$session_sufix			= '_'.$select_type.'_';
		if(is_array($member_id)) {
			$session_sufix		.= implode('.',$member_id);
		} else {
			$session_sufix		.= trim($member_id);
		}
		$sessionObjectName		= MEMBER_SESSION_NAME_MAIL_OBJECT.$session_sufix;
		$sessionConfirmName	= MEMBER_SESSION_NAME_SENDMAIL_CONFIRM_RESULT.$session_sufix;
		$confirm_mail					= spider_Controller::createObject('member_DaoMemberMail');
		$mail_object					= $request->getSession($sessionObjectName);
		$request->removeSession($sessionConfirmName);
		
		if( get_class( $confirm_mail ) != get_class( $mail_object ) ) {
			// セッションに正しいオブジェクトがないなら作成する
			$mail_object						= spider_Controller::createObject('member_DaoMemberMail');
			$default_time						= time();
			$mail_object->reserve_date_year		= date('Y',$default_time);
			$mail_object->reserve_date_month	= date('m',$default_time);
			$mail_object->reserve_date_day		= date('d',$default_time);
			$mail_object->reserve_date_hour		= date('H',$default_time);
			$mail_object->reserve_date_min		= '00';
			// 対応履歴追記
			$mail_object->add_correspond		= false;
			$mail_object->correspond_status		= '';
			$mail_object->correspond_type		= '';
			$mail_object->correspond_category	= '';
		}
		
		$mail_object->select_type				= $select_type;
		
		// 選択タイプごとの確認
		if( 'q' == $mail_object->select_type ) {
			// 検索クエリの場合
			$count_sql	= $request->getSession(MEMBER_SESSION_NAME_LOADCOUNT_QUERY);
			$list_sql	= $request->getSession(MEMBER_SESSION_NAME_LOADLIST_QUERY);
			if( strlen($count_sql) == 0 || strlen($list_sql) == 0 ) {
				$request->addLocaledError('system.error.common.session.timeout',SPIDER_LOG_LEVEL_FATAL,array(''));
			} else {
			}
		} else if( 's' == $mail_object->select_type ) {
			// セッション選択リストの場合
			$session_selected_array	= $request->getSession(MEMBER_SESSION_NAME_SELECTED_LIST);
			if( !is_array($session_selected_array) || count( $session_selected_array ) == 0 ) {
				$request->addLocaledError('member.error.common.noselectedmember',SPIDER_LOG_LEVEL_FATAL,array(''));
			} else if ( count( $session_selected_array ) > 1000 ) {
				$request->addLocaledError('member.error.mail.maxatonce',SPIDER_LOG_LEVEL_FATAL,array(''));
			} else {
				foreach( $session_selected_array as $member_id=>$member_name ) {
					$member_object			= spider_Controller::createObject('member_DaoMember');
					if( strlen(trim($member_id)) > 0 ) {
						// IDが指定されているなら編集のため読み込み
						if( $dbo->loadById( $member_object, $member_id ) ){
						} else {
							$member_object->view_name	= "存在しないか削除済み";
						}
						$mail_object->member_id_object_hash[$member_id]	= $member_object;
					}
				}
			}
		} else {
			// IDポストの場合
			$mail_object->select_type	= 'm';
			$member_id_array	= array();
			if( is_array( $member_id ) ) {
				if( count( $member_id ) == 0 ) {
					$request->addLocaledError('member.error.common.selectmember',SPIDER_LOG_LEVEL_FATAL,array(''));
				} else {
					$member_id_array	= $member_id;
				}
			} else if( strlen(trim($member_id)) > 0 ) {
				array_push( $member_id_array, $member_id );
			} else {
				$request->addLocaledError('member.error.common.selectmember',SPIDER_LOG_LEVEL_FATAL,array(''));
			}
			foreach( $member_id_array as $mid ) {
				$member_object			= spider_Controller::createObject('member_DaoMember');
				if( $dbo->loadById( $member_object, $mid ) ){
				} else {
					$member_object->view_name	= "存在しないか削除済み";
				}
				$mail_object->member_id_object_hash[$mid]	= $member_object;
			}
		}
		if( strlen(trim($mail_object->body)) == 0 ) {
			$mail_object->body	= "{member::view_name}様\n"
				. "\n"
				. "ここで本文を編集してください\n"
			;
		}

		$request->setAttribute('member.mail.mail_object',$mail_object );

	}
}
?>