<?php
/*
 * member/history/Correspond.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once(dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'system'
.DIRECTORY_SEPARATOR.'login'
.DIRECTORY_SEPARATOR.'ModuleBase.class.php');
require_once( dirname(dirname(__FILE__))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php');
require_once( dirname(dirname(__FILE__))
.DIRECTORY_SEPARATOR.'DaoMember.class.php');
require_once( dirname(dirname(__FILE__))
.DIRECTORY_SEPARATOR.'DaoMemberCorrespond.class.php');
/**
 * spider : 会員ポイント履歴 一覧取得用アクションモジュールクラス
 * 
 * @package member 会員管理パッケージ
 * @subpackage pointhistory ポイント履歴パッケージ
 * @version 1.0.0
 * @author  <m_nakashima@users.sourceforge.jp>
 * @since PHP 4.0
 */
class member_history_Correspond extends system_login_ModuleBase {
	function member_history_Correspond() {
		array_push($this->require_module_array,'database2.Connect');
	}
	function execute( & $request ) {

		$dbo			= $request->getAttribute( 'dbo' );
		$memberId		= trim( stripslashes( $_GET['mi'] ) );
		$targetYear		= trim( stripslashes( $_GET['mpty'] ) );
		$targetMonth	= trim( stripslashes( $_GET['mptm'] ) );
		
		if( strlen(trim($memberId)) == 0 ) {
			$request->addLocaledError('system.error.common.data.invalidselect',SPIDER_LOG_LEVEL_FATAL,array());
			return;
		} else {
			$memberObject	= spider_Controller::createObject('member_DaoMember');
			if( $dbo->loadById( $memberObject, $memberId, true ) ) {
				$request->setAttribute( 'member.history.correspond.memberObject', $memberObject );
			} else {
				$request->addLocaledError('system.error.common.data.invalidselect',SPIDER_LOG_LEVEL_FATAL,array());
			}
		}
		
		if( preg_match('/^[0-9]{4}$/',$targetYear) == 0 || $targetYear < 1970 || $targetYear > date('Y') ) {
			$targetYear	= date('Y');
		}
		if( preg_match('/^[0-9]{1,2}$/',$targetMonth) == 0 || $targetMonth < 1 || $targetMonth > 12 ) {
			$targetMonth	= date('m');
		}
				
		$condition_string	= '';
		$condition_array	= array();
		// 対象会員ID
		$str	= 'member_id='.$dbo->quote($memberId);
		array_push( $condition_array, $str );
		// 開始日
		$startDate	= $targetYear.'-'.$targetMonth.'-01 00:00:00';
		$str	= 'correspond_date>='.$dbo->quote($targetYear.'-'.$targetMonth.'-01 00:00:00');
		array_push( $condition_array, $str );
		// 終了日
		$endYear	= $targetYear;
		$endMonth	= $targetMonth	+ 1;
		if( $endMonth > 12 ) {
			$endMonth	= '01';
			$endYear++;
		}
		$str	= 'correspond_date<'.$dbo->quote($endYear.'-'.$endMonth.'-01 00:00:00');
		array_push( $condition_array, $str );
		// 合計ポイント増減
		$totalPointChange	= 0;
		// 条件結合		
		if ( count( $condition_array ) > 0 ) {
			$condition_string	= ' WHERE ' . implode( ' AND ', $condition_array );
		}
		// SELECT文
		$sql	= 'SELECT * FROM '.TABLE_NAME_MEMBER_CORRESPOND.$condition_string.' ORDER BY correspond_date ASC';
		$pointHistoryObject	= spider_Controller::createObject('member_DaoMemberCorrespond');
		$pointHistoryArray	= $dbo->queryAll( $sql, $pointHistoryObject );
		if ( false === $pointHistoryArray ) {
			$request->addLocaledError('database2.error.common',SPIDER_LOG_LEVEL_FATAL,array($sql));
		} else {
			foreach( $pointHistoryArray as $historyObject ) {
				$totalPointChange	+= $historyObject->action_point;
			}
		}
		$request->setAttribute( 'member.history.correspond.data_array', $pointHistoryArray );
		$request->setAttribute( 'member.history.correspond.member_id', $memberId );
		$request->setAttribute( 'member.history.correspond.targetYear', $targetYear );
		$request->setAttribute( 'member.history.correspond.targetMonth', $targetMonth );
		
	}
}
?>