<?php
/*
 * member/member/Condition.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once(dirname(__FILE__)
.DIRECTORY_SEPARATOR.'PackageConfig.class.php');
/**
 * 会員パッケージと他パッケージを連結する基底クラス
 */
class member_Connector {
	/**
	 * 会員検索条件のWHEREに追加する条件文字列を取得
	 * @param $requst spider_HttpRequstオブジェクト参照
	 */
	function getWhereConditionStrings( & $request ) {
		return "";
	}
	/**
	 * 会員検索フォームに表示する入力フォーム文字列を取得
	 * @param $requst spider_HttpRequstオブジェクト参照
	 */
	function getSearchFormStrings( & $request ) {
		return "";
	}
	/**
	 * パッケージで扱う追加会員種別があればハッシュで取得
	 * @param $requst spider_HttpRequstオブジェクト参照
	 * @return array 会員種別番号=>会員種別名称のハッシュ
	 */
	function getAdditionalMemberClassHash( & $request ) {
		return array();
	}
	/**
	 * パッケージで扱う追加会員種別のうちで会員自ら登録できる会員種別を返します
	 * @param $requst spider_HttpRequstオブジェクト参照
	 * @return array 会員種別番号=>会員種別名称のハッシュ
	 */
	function getPublicMemberClassHash( & $request ) {
		return array();
	}
	/**
	 * 会員登録した際の追加自動処理があれば記述します
	 * @param $requst spider_HttpRequstオブジェクト参照
	 * @param $memberObject member_DaoMemberオブジェクト参照
	 */
	function additionalPostInsertProcess( & $request, & $memberObject ) {
	}
	/**
	 * 会員情報更新した際の追加自動処理があれば記述します
	 * @param $requst spider_HttpRequstオブジェクト参照
	 * @param $memberObject member_DaoMemberオブジェクト参照
	 */
	function additionalPostUpdateProcess( & $request, & $memberObject ) {
	}
	/**
	 * メール送信時の本文に関連した入力チェックをおこないます
	 * @param $requst spider_HttpRequstオブジェクト参照
	 * @param $memberMailObject メールオブジェクト参照
	 */
	function mailConfirm( & $request, & $memberMailObject ) {
	}
	/**
	 * メール送信直前にメールオブジェクトに対する処理をおこないます
	 * @param $requst spider_HttpRequstオブジェクト参照
	 * @param $memberMailObject メールオブジェクト参照
	 */
	function mailPreSend( & $request, & $memberMailObject ) {
	}
	/**
	 * 個人情報一覧の個々のデータに追加するリンクを取得
	 * @param $requst spider_HttpRequstオブジェクト参照
	 * @param $memberObject member_DaoMemberオブジェクト参照
	 * @return string リンクタグ文字列の配列
	 */
	function getMemberLinkArray( & $request, & $memberObject ) {
		return array();
	}
	/**
	 * 存在するインストール済みパッケージの連結クラスオブジェクトハッシュを取得
	 * @param $requst spider_HttpRequstオブジェクト参照
	 * @return hash 'パッケージID' => connectorオブジェクト のハッシュ
	 */
	function getExistsConnecterHash( & $request ) {
		$connectorObjectHash		= array();
		$GLOBALS['MEMBER_MEMBER_REGISTABLE_CLASS_HASH']		= array();
		foreach( $GLOBALS['MEMBER_MEMBER_CLASS_HASH'] as $key => $val ){
			if( $key > 0 ){
				$GLOBALS['MEMBER_MEMBER_REGISTABLE_CLASS_HASH'][$key]	= $val;
			}
		}
		// lib以下のパッケージ内のMemberConnector.class.phpを探す
		$connectorDirHandle	= @opendir( DIR_PATH_LIB );
		if( $connectorDirHandle ) {
			while (($dirName = readdir($connectorDirHandle)) !== false) {
				if( preg_match('/^\\./',$dirName) == 0 ) {
					$extPath	= DIR_PATH_LIB.DIRECTORY_SEPARATOR.$dirName
						.DIRECTORY_SEPARATOR.'MemberConnector.class.php';
					if( file_exists($extPath) ) {
						require_once( $extPath );
						$className			= $dirName.'_MemberConnector';
						$connectorObject	= new $className;
						if( is_a($connectorObject,'member_Connector') ) {
							$connectorObjectHash[$dirName]	= $connectorObject;
							$extClassHash		= $connectorObject->getAdditionalMemberClassHash( $request );
							foreach( $extClassHash as $key => $val ) {
								$GLOBALS['MEMBER_MEMBER_CLASS_HASH'][$key]	= $val;
							}
							$extClassHash		= $connectorObject->getPublicMemberClassHash( $request );
							foreach( $extClassHash as $key => $val ) {
								$GLOBALS['MEMBER_MEMBER_REGISTABLE_CLASS_HASH'][$key]	= $val;
							}
						}
					}
				}
			}
			@closedir($connectorDirHandle);
		}
		// 追加の会員クラスが定義されていれば追加
		if( isset($GLOBALS['MEMBER_ADDITINAL_MEMBER_REGISTABLE_CLASS_HASH'])
		&& is_array($GLOBALS['MEMBER_ADDITINAL_MEMBER_REGISTABLE_CLASS_HASH']) ) {
			foreach( $GLOBALS['MEMBER_ADDITINAL_MEMBER_REGISTABLE_CLASS_HASH'] as $key => $val ) {
				$GLOBALS['MEMBER_MEMBER_REGISTABLE_CLASS_HASH'][$key]	= $val;
			}
		}
		if( isset($GLOBALS['MEMBER_ADDITINAL_MEMBER_CLASS_HASH'])
		&& is_array($GLOBALS['MEMBER_ADDITINAL_MEMBER_CLASS_HASH']) ) {
			foreach( $GLOBALS['MEMBER_ADDITINAL_MEMBER_CLASS_HASH'] as $key => $val ) {
				$GLOBALS['MEMBER_MEMBER_CLASS_HASH'][$key]	= $val;
			}
		}
		// 会員からの登録可能フラグの設定
		$registableByUser	= true;
		if( !defined('MEMBER_PERMIT_REGIST_BY_USER')
		|| preg_match('/^[tT](|[rR][uU][eE])$/',MEMBER_PERMIT_REGIST_BY_USER) == 0 ) {
			$registableByUser	= false;
		}
		$request->setAttribute('member.registableByUser',$registableByUser);
		return $connectorObjectHash;
	}
}
?>