<?php
/*
 * design/template/recover/Execute.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once( dirname(dirname(dirname(dirname(__FILE__))))
.DIRECTORY_SEPARATOR.'system'.DIRECTORY_SEPARATOR.'login'
.DIRECTORY_SEPARATOR.'ModuleBase.class.php');
require_once( dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'DaoTemplate.class.php');
/**
 * デザインテンプレートファイルをアップロードして妥当性検査をおこなうモジュール
 * 
 * multipart/form-data形式でPOSTアップロードされたファイルと情報に基づいてデザインテンプレートをアップロードされたファイルから復元・インストールします。
 * 
 * <b>POST入力値</b>
 * ありません
 * 
 * <b>spider_HttpRequestにセットする属性キーと値</b>
 * <ul>
 * <li><b>design.template.recover.infoHash</b><br />入力値を格納した連想配列 array('fileName'=>'','viewName'=>'','installKeyPlain'=>'','overrideContents'=>'','overridePages'=>'')</li>
 * </ul>
 * 
 * <b>セッションにセットする属性キーと値</b>
 * ありません
 * 
 * <b>セッションから削除する属性キー</b>
 * <ul>
 * <li><b>design.template.recover.infoHash</b><br />入力値を格納した連想配列 array('fileName'=>'','viewName'=>'','installKeyPlain'=>'','overrideContents'=>'','overridePages'=>'')</li>
 * <li><b>design.template.recover.confirmResult</b><br />POST入力に問題がなければ指定されたキーを格納して文字列「OK」を設定。</li>
 * </ul>
 */
class design_template_recover_Execute extends system_login_ModuleBase {
	function design_template_recover_Execute() {
	}
	function execute( & $request ) {
		$confirmResult		= $request->getSession('design.template.recover.confirmResult',SPIDER_SESSION_SCOPE_GLOBAL);
		$recoverInfoHash	= $request->getSession('design.template.recover.infoHash',SPIDER_SESSION_SCOPE_GLOBAL);
		if( is_null($recoverInfoHash) || !is_array($recoverInfoHash) || strlen($confirmResult) == 0 ) {
			$request->addLocaledError('system.error.common.session.timeout',SPIDER_LOG_LEVEL_ERROR,array());
			return;
		}
		$realFilePath	= system_DataFileWriter::getRealAbsolutePath( $request, $recoverInfoHash['tempUri'], DIR_NAME_TMP );
		if( !file_exists($realFilePath) ) {
			$request->addError('アップロードしたテンプレートファイルが何らかの原因で削除されています。操作に時間をかけすぎた場合もありますのでお手数ですが最初からやりなおしてください。');
			return;
		}
		$templateObject	= new design_DaoTemplate($recoverInfoHash['fileName']);
		$templateObject->loadInfo( $request );
		// 既に存在するテンプレートか確認
		$infoPath	= $templateObject->_getSettingSaveDir().DIRECTORY_SEPARATOR.'info.txt';
		// 失敗したらテンプレートを削除するか否か
		$isDeleteIfErr	= true;
		if( file_exists($infoPath) ) {
			$isDeleteIfErr	= false;
		}
		// アップロードに問題ないなら復元を試みる
		if( $templateObject->recover( $request, $realFilePath,
		$recoverInfoHash['viewName'], $recoverInfoHash['installKeyPlain'], $isDeleteIfErr,
		$recoverInfoHash['overrideContents'], $recoverInfoHash['overridePages'], $recoverInfoHash['overridePages'],
		basename($realFilePath) ) ) {
			// エラーがないならテンプレートをリビルド
			foreach( $GLOBALS['SPIDER_USER_AGENT_CLASS_HASH'] as $aKey => $aName ) {
				$templateObject->rebuild( $request, $aKey );
			}
		}
		// エラー有無に関わらず一時ファイルとセッションを削除
		system_DataFileWriter::delete( $request, $recoverInfoHash['tempUri'], DIR_NAME_TMP );
		$request->removeSession('design.template.recover.confirmResult');
		$request->removeSession('design.template.recover.infoHash');
		// 属性値を設定
		$request->setAttribute('design.template.recover.templateObject',$templateObject );
	}
}
?>