<?php
/*
 * design/template/apply/Execute.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once( dirname(dirname(dirname(dirname(__FILE__))))
	.DIRECTORY_SEPARATOR.'system'
	.DIRECTORY_SEPARATOR.'login'
	.DIRECTORY_SEPARATOR.'ModuleBase.class.php');
require_once( dirname(dirname(dirname(dirname(__FILE__))))
	.DIRECTORY_SEPARATOR.'content'
	.DIRECTORY_SEPARATOR.'DaoPage.class.php');
require_once( dirname(dirname(dirname(dirname(__FILE__))))
	.DIRECTORY_SEPARATOR.'system'
	.DIRECTORY_SEPARATOR.'DataFileWriter.class.php');
require_once( dirname(dirname(dirname(dirname(__FILE__))))
	.DIRECTORY_SEPARATOR.'util'
	.DIRECTORY_SEPARATOR.'CharUtility.class.php');
require_once( dirname(dirname(dirname(dirname(__FILE__))))
	.DIRECTORY_SEPARATOR.'util'
	.DIRECTORY_SEPARATOR.'File.class.php');
require_once( dirname(dirname(dirname(__FILE__)))
	. DIRECTORY_SEPARATOR . 'DaoTemplate.class.php' );
require_once( dirname(dirname(dirname(__FILE__)))
	. DIRECTORY_SEPARATOR . 'package_define.inc.php' );
class design_template_apply_Execute extends system_login_ModuleBase {
	
	function design_template_apply_Execute() {
	}
	function execute( & $request ) {

		$pageUri			= mb_convert_kana( trim( stripslashes( $_POST['page_uri'] ) ), 'KVas' );
		$templateFileName	= mb_convert_kana( trim( stripslashes( $_POST['template_file_name'] ) ), 'KVas' );
		$applyTemplate		= mb_convert_kana( trim( stripslashes( $_POST['apply_template'] ) ), 'KVas' );
		$applyPages			= mb_convert_kana( trim( stripslashes( $_POST['apply_pages'] ) ), 'KVas' );
		
		if( preg_match('/^[fF](|[aA][lL][sS][eE])$/',$applyTemplate) == 0 ) {
			$applyTemplate	= 'true';
		}
		
		$templateObject		= new design_DaoTemplate($templateFileName);
		if( strlen($templateFileName) == 0 ) {
			$request->addError('適用するテンプレートを指定してください。');
		} else if( !file_exists(DIR_PATH_DATA
			.DIRECTORY_SEPARATOR.'design'
			.DIRECTORY_SEPARATOR.'template'
			.DIRECTORY_SEPARATOR.$templateFileName
			.DIRECTORY_SEPARATOR.'info.txt') ) {
			$request->addError('適用するテンプレート'.$templateFileName.'が存在しないか削除されました。');
		} else {
			$templateObject->loadInfo( $request );
		}
		if( !$request->isError() ) {
			if( strlen($pageUri) == 0 ) {
				$request->addError('適用するページを指定してください。');
			} else {
				$absolutePath	= util_File::suri2path($pageUri);
				if( !file_exists($absolutePath) ) {
					$request->addError('指定された'.$pageUri.'は存在しません。');
				} else if( is_dir($absolutePath) ) {
					// フォルダだった場合
				} else {
					// ファイルならテンプレート指定文字列を置換して書き込み
					if( preg_match('/^[tT](|[rR][uU][eE])$/',$applyTemplate) > 0 ) {
						$strings	= file_get_contents($absolutePath);
						$strings	= preg_replace(
							'/'.util_CharUtility::escapeRegxStr('{template:').'([^\\}]+)\\}/',
							'{template:'.$templateFileName.'}',
							$strings
						);
						// 公開ファイルに書き込み実行
						$writer			= new system_DataFileWriter();
						if( $writer->open( $request, $pageUri, 'w', 'public' ) ) {
							$writer->write( $strings );
							$writer->close( $request );
						}
					}
					// 指定テンプレートがページファイルを含んでいるか確認する
					if( preg_match('/^[tT](|[rR][uU][eE])$/',$applyPages) > 0 ) {
						foreach( $GLOBALS['SPIDER_USER_AGENT_CLASS_HASH'] as $agentKey => $agentName ) {
							$agentPageUri	= '/'.$agentKey.$pageUri;
							// pages内の適用
							$uriData	= $templateObject->_getSettingSaveUri().'/pages'.$agentPageUri;
							$realPath	= system_DataFileWriter::getRealAbsolutePath( $request, $uriData, DIR_NAME_DATA );
							if( file_exists($realPath) ){
								$pageBody	= file_get_contents($realPath);
								$pageObject	= new content_DaoPage($pageUri);
								$pageObject->load( $request );
								$pageObject->saveBody( $request, $agentKey, $pageBody );
								// publicファイルを確認
								$uriData	= $templateObject->_getSettingSaveUri().'/public'.$pageUri;
								$realPath	= system_DataFileWriter::getRealAbsolutePath( $request, $uriData, DIR_NAME_DATA );
								if( file_exists($realPath) ){
									$pageBody	= file_get_contents($realPath);
									$writer		= new system_DataFileWriter();
									if( $writer->open($request,$pageUri,'w','public') ) {
										$writer->write($pageBody);
										$writer->close($request);
									}
								}
								// .defaultを確認
								$uriData	= $templateObject->_getSettingSaveUri().'/public'.dirname($pageUri).'/.default';
								$realPath	= system_DataFileWriter::getRealAbsolutePath( $request, $uriData, DIR_NAME_DATA );
								if( file_exists($realPath) ){
									$pageBody	= file_get_contents($realPath);
									$writer		= new system_DataFileWriter();
									if( $writer->open($request,dirname($pageUri).'/.default','w','public') ) {
										$writer->write($pageBody);
										$writer->close($request);
									}
								}
								// ページをリビルド
								$pageObject->rebuild( $request, $agentKey );
							}
						}
					} else if( preg_match('/^[iI][mM][pP][oO][rR][tT]$/',$applyPages) > 0 ) {
						// 現在のページをテンプレートにインポート
						foreach( $GLOBALS['SPIDER_USER_AGENT_CLASS_HASH'] as $agentKey => $agentName ) {
							$agentPageUri		= '/'.$agentKey.$pageUri;
							$templatePageUri	= $templateObject->_getSettingSaveUri().'/pages'.$agentPageUri;
							$contentPageUri		= '/content/pages'.$agentPageUri;
							$srcPath			= system_DataFileWriter::getRealAbsolutePath( $request, $contentPageUri );
							if( file_exists($srcPath) ) {
								if( system_DataFileWriter::import( $request, $templatePageUri, $srcPath ) ) {
								} else {
									$request->addError($agentName.'のページ取り込みに失敗しました。');
								}
							}
						} 
						// publicファイルを確認
						$uriData	= $templateObject->_getSettingSaveUri().'/public'.$pageUri;
						if( system_DataFileWriter::isExists( $request, $pageUri, 'public' ) ) {
							$pubBody	= system_DataFileWriter::getContents( $request, $pageUri, 'public' );
							$writer		= new system_DataFileWriter();
							if( $writer->open($request,$uriData,'w', DIR_NAME_DATA) ) {
								$writer->write($pubBody);
								$writer->close($request);
							}
						}
						// .defaultを確認
						$uriData	= $templateObject->_getSettingSaveUri().'/public'.dirname($pageUri).'/.default';
						if( system_DataFileWriter::isExists( $request, dirname($pageUri).'/.default', 'public' ) ) {
							$pubBody	= system_DataFileWriter::getContents( $request, dirname($pageUri).'/.default', 'public' );
							$writer		= new system_DataFileWriter();
							if( $writer->open($request,$uriData,'w', DIR_NAME_DATA) ) {
								$writer->write($pubBody);
								$writer->close($request);
							}
						}
					}
				}
			}
		}
		$request->setAttribute('design.template.apply.pageUri',$pageUri);
		$request->setAttribute('design.template.apply.templateFileName',$templateFileName);
	}
}
?>