<?php
/*
 * content/DaoPage.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once(dirname(dirname(__FILE__))
	.DIRECTORY_SEPARATOR.'system'
	.DIRECTORY_SEPARATOR.'AbstractData.class.php');
require_once(dirname(dirname(__FILE__))
	.DIRECTORY_SEPARATOR.'system'
	.DIRECTORY_SEPARATOR.'DataFileWriter.class.php');
require_once( dirname(__FILE__)
	. DIRECTORY_SEPARATOR . 'package_define.inc.php' );
require_once( dirname(__FILE__)
	. DIRECTORY_SEPARATOR . 'Variable.class.php' );
class content_DaoPage extends system_AbstractData {
	/** ページURI	*/
	var $uri;
	/** 出力文字コード	*/
	var $charset	= 'UTF-8';
	/** 利用テンプレート	*/
	var $template;
	/** ページタイトル	*/
	var $title;
	/** ページ概要	*/
	var $description;
	/** ページキーワード	*/
	var $keyword;
	/** 実行モジュール	*/
	var $modules;
	/**
	 * コンストラクタ
	 */
	function content_DaoPage( $uri = null ) {
		if( !is_null($uri) ) {
			$this->uri	= $uri;
		}
	}
	/**
	 * URIの書式が正しいか確認します
	 */
	function validateUri() {
		if( is_null($this->uri) || strlen($this->uri) == 0 ) {
			return false;
		} else if( preg_match('/^\\//',$this->uri) == 0 ) {
			return false;
		} else if( preg_match('/\\/$/',$this->uri) > 0 ) {
			return false;
		}
		return true;
	}
	/**
	 * ページの情報を読み込みます
	 */
	function load( & $request ) {
		if( !$this->validateUri() ) {
			return false;
		}
		$this->modules	= '';
		if( system_DataFileWriter::isExists( $request, $this->uri, 'public' ) ) {
			$contents	= system_DataFileWriter::getContents($request, $this->uri, 'public' );
			if( preg_match('/include_once(.+)spider\\.inc\\.php/',$contents) > 0
				|| preg_match('/require_once(.+)spider\\.inc\\.php/',$contents) > 0  ) {
				// spider管理ファイルの場合
				if( preg_match('/'.util_CharUtility::escapeRegxStr('{dynamic-page}').'/',$contents, $matches) > 0 ) {
					// ダイナミックページ設定があるなら
					if( preg_match('/'.util_CharUtility::escapeRegxStr('{charset:').'([^\\}]+)\\}/',$contents, $matches) > 0 ) {
						// charsetタグ
						$this->charset	= $matches[1];
					}
					if( preg_match('/'.util_CharUtility::escapeRegxStr('{template:').'([^\\}]+)\\}/',$contents, $matches) > 0 ) {
						// テンプレートタグ
						$this->template	= $matches[1];
					}
					if( preg_match('/'.util_CharUtility::escapeRegxStr('{preset:page_title ').'([^\\}]+)\\}/',$contents, $matches) > 0 ) {
						// タイトル
						$this->title	= $matches[1];
						$this->title	= preg_replace('/^\\\'/','',$this->title);
						$this->title	= preg_replace('/\\\'$/','',$this->title);
					} else if( preg_match('/'.util_CharUtility::escapeRegxStr('{page-title:').'([^\\}]+)\\}/',$contents, $matches) > 0 ) {
						// タイトルタグ
						$this->title	= $matches[1];
					}
					if( preg_match('/'.util_CharUtility::escapeRegxStr('{preset:description ').'([^\\}]+)\\}/',$contents, $matches) > 0 ) {
						// 概要
						$this->description	= $matches[1];
						$this->description	= preg_replace('/^\\\'/','',$this->description);
						$this->description	= preg_replace('/\\\'$/','',$this->description);
					}
					if( preg_match('/'.util_CharUtility::escapeRegxStr('{preset:keyword ').'([^\\}]+)\\}/',$contents, $matches) > 0 ) {
						// キーワード
						$this->keyword	= $matches[1];
						$this->keyword	= preg_replace('/^\\\'/','',$this->keyword);
						$this->keyword	= preg_replace('/\\\'$/','',$this->keyword);
					}
					if( preg_match_all( '/'.util_CharUtility::escapeRegxStr('{module:').'([^\\}]+)\\}/'
						, $contents, $matches, PREG_PATTERN_ORDER ) > 0 ) {
						// 全てのモジュールタグを確認
						if( is_array($matches) && is_array($matches[1]) ) {
							foreach( $matches[1] as $moduleStr ) {
								if( strlen($moduleStr) > 0 ) {
									$this->modules	.= $moduleStr."\n";
								}
							}
						}
					}
					return true;
				} else {
					return false;
				}
			} else {
				return false;
			}
		}
	}
	/**
	 * ページ情報を保存します
	 */
	function save( & $request ) {
		if( !$this->validateUri() ) {
			return false;
		}
		$canSave	= false;
		if( system_DataFileWriter::isExists( $request, $this->uri, 'public' ) ) {
			$contents	= system_DataFileWriter::getContents($request, $this->uri, 'public' );
			if( preg_match('/include_once(.+)spider\\.inc\\.php/',$contents) > 0
				|| preg_match('/require_once(.+)spider\\.inc\\.php/',$contents) > 0  ) {
				if( preg_match('/'.util_CharUtility::escapeRegxStr('{dynamic-page}').'/',$contents, $matches) > 0 ) {
					$canSave	= true;
				}
			}
		} else {
			$canSave	= true;
		}
		if( $canSave ) {
			$folderCount	= substr_count($this->uri,'/') - 1;
			$spiderPath		= '';
			for( $i=0; $i<$folderCount; $i++ ) {
				$spiderPath	.= '../';
			}
			if( strlen($spiderPath) == 0 ) {
				$spiderPath	= './';
			}
			$spiderPath	.= 'spider.inc.php';
			$writer			= new system_DataFileWriter();
			if( $writer->open( $request, $this->uri, 'w', 'public' ) ) {
				$writer->write('<?php include_once(\''.$spiderPath.'\'); ?>'."\n");
				if( strlen($this->charset) > 0 ) {
					$writer->write('{charset:'.$this->charset.'}'."\n");
				}
				if( strlen($this->template) > 0 ) {
					$writer->write('{template:'.$this->template.'}'."\n");
				}
				if( strlen($this->title) > 0 ) {
					$writer->write('{preset:page_title \''.$this->title.'\'}'."\n");
				}
				if( strlen($this->description) > 0 ) {
					$writer->write('{preset:description \''.$this->description.'\'}'."\n");
				}
				if( strlen($this->keyword) > 0 ) {
					$writer->write('{preset:keyword \''.$this->keyword.'\'}'."\n");
				}
				if( strlen(trim($this->modules)) > 0 ) {
					$this->modules	= str_replace("\r\n","\n",$this->modules);
					$this->modules	= str_replace("\r","\n",$this->modules);
					$moduleArray	= explode("\n",$this->modules);
					foreach( $moduleArray as $moduleName ) {
						$writer->write('{module:'.$moduleName.'}'."\n");
					}
				}
				$writer->write('{dynamic-page}');
				$writer->close( $request );
			}
			$this->rebuildAll( $request );
		}
	}
	/**
	 * 指定エージェントのページ本文を取得する
	 */
	function getBody( & $request, $agent ) {
		if( !$this->validateUri() ) {
			return false;
		}
		$pageFileUri	= '/'.$agent.$this->uri;
		if( system_DataFileWriter::isExists( $request,'/content/pages'.$pageFileUri) ) {
			// データフォルダに本文ファイルがあるなら本文ファイルを取得
			return system_DataFileWriter::getContents($request, '/content/pages'.$pageFileUri);
		} else if( system_DataFileWriter::isExists($request,$pageFileUri,DIR_NAME_PAGES) ) {
			return system_DataFileWriter::getContents($request,$pageFileUri,DIR_NAME_PAGES);
		} else {
			return '';
		}
	}
	/**
	 * 指定エージェントのページ本文を保存する
	 */
	function saveBody( & $request, $agent, $body ) {
		if( !$this->validateUri() ) {
			return false;
		}
		$pageFileUri	= '/content/pages/'.$agent.$this->uri;
		if( strlen($body) > 0 ) {
			$writer			= new system_DataFileWriter();
			if( $writer->open( $request, $pageFileUri, 'w' ) ) {
				$writer->write( $body );
				$writer->close( $request );
			}
		} else {
			system_DataFileWriter::delete( $request, $pageFileUri );
		}
	}
	/**
	 * 全てのページをリビルドする
	 */
	function rebuildAll( & $request ) {
		if( !$this->validateUri() ) {
			return false;
		}
		foreach( $GLOBALS['SPIDER_USER_AGENT_CLASS_HASH'] as $agent => $agentName ) {
			$this->rebuild( $request, $agent );
		}
	}
	/**
	 * 指定エージェントのページをリビルドする
	 */
	function rebuild( & $request, $agent ) {
		if( !$this->validateUri() ) {
			return false;
		}
		$bodyStrings	= $this->getBody( $request, $agent );
		$pageFileUri	= '/'.$agent.$this->uri;
		if( strlen( $bodyStrings ) > 0 ) {
			// サイト変数を読み込む
			$variableObject	= new content_Variable( $request );
			// サイト変数の置換処理
			$keyArray	= $variableObject->getKeyArray( $request );
			if( is_array($keyArray) ) {
				foreach( $keyArray as $key ) {
					$repWord		= '{value:'.$key.'}';
					$bodyStrings	= str_replace($repWord,$variableObject->getValue( $request, $key ),$bodyStrings);
				}
				// ページディレクトリに出力
				$writer			= new system_DataFileWriter();
				if( $writer->open( $request, $pageFileUri, 'w', DIR_NAME_PAGES ) ) {
					$writer->write( $bodyStrings );
					$writer->close( $request );
				}
			}
		} else {
			// 本文がないならファイルを削除する
			system_DataFileWriter::delete( $request, $pageFileUri, DIR_NAME_PAGES );
		}
	}
	/**
	 * ページ関連ファイルを全て削除する
	 */
	function deleteAll( & $request, $uri = null ) {
		if( !$this->validateUri() ) {
			return false;
		}
		// 全てのファイルを削除
		foreach( $GLOBALS['SPIDER_USER_AGENT_CLASS_HASH'] as $agent => $agentName ) {
			$pageFileUri	= '/content/pages/'.$agent.$this->uri;
			system_DataFileWriter::delete( $request, $pageFileUri, DIR_NAME_DATA );
			$pageFileUri	= '/'.$agent.$this->uri;
			system_DataFileWriter::delete( $request, $pageFileUri, DIR_NAME_PAGES );
		}
	}
	/**
	 * このページの本文で利用されているファイルの一覧を取得します
	 */
	function getRelatedFileUriArray( & $request, $uri = null ) {
		if( !$this->validateUri() ) {
			return false;
		}
		$fileUriArray	= array();
		foreach( $GLOBALS['SPIDER_USER_AGENT_CLASS_HASH'] as $agent => $agentName ) {
			$body	= $this->getBody( $request, $agent );
			// 外部src
			if( preg_match_all( '/[sS][rR][cC]\\=[\'\"](\\/[^\'\"]+\\.[a-zA-Z]+)[\'\"]/'
				, $body
				, $matcheArray
				, PREG_PATTERN_ORDER ) > 0 ) {
				$fileUriArray	= array_merge($fileUriArray,$matcheArray[1]);
			}
		}
		// 重複削除
		$fileUriArray	= array_unique($fileUriArray);
		return array_unique($fileUriArray);
	}
}
?>