<?php include_once( "../../spider.inc.php" ); ?>
{template:admin_default.tpl}
{module:system.login.Require}
{preset:page_title 'システム設定 > システム情報'}

	<div class="panc">
		<a href="../">管理パネルトップ</a>
		&gt; システム情報
	</div>

	<h1>
		システム設定
		&gt; システム情報
	</h1>
	
	{if:IS_ERROR}
	<ul class="error">
	{foreach:errors error}
		<li>{write:error}</li>
	{/foreach}
	</ul><br />
	
	{else}

		<p>
			<?php echo RELEASE_NAME; ?>が動作するようにアップロードされているか設置状況を確認し、<br />
			赤字のエラーメッセージがでている場合は問題を解決してください。<br />
		</p>
		<h2>設置URL</h2>
		<table class="detail" style="width:96%;margin:0 auto;">
		<tbody>
		<tr>
			<th style="width:14em;">自動判断したURL:</th>
			<td class="view-url" id="real-url"><?php echo SPIDER_URL_BASE; ?></td>
		</tr>
		<tr>
			<th style="width:14em;">実際の設置URL:</th>
			<td class="view-url" id="auto-url"><?php echo SPIDER_URL_BASE; ?></td>
		</tr>
		</tbody>
		</table>
		
		<p id="url-message"></p>
		
		<h2>パーミッション環境</h2>
		<?php
			$thisPageFilePath	= realpath($_SERVER['SCRIPT_FILENAME']);
			$execUser	= '';
			$execGroup	= '';
			$ownerUser	= fileowner($thisPageFilePath);
			$ownerGroup	= filegroup($thisPageFilePath);
			$checkFile	= DIR_PATH_WORK.'/check';
			if( @touch($checkFile) ) {
				$execUser	= fileowner($checkFile);
				$execUser	= filegroup($checkFile);
				@unlink($checkFile);
			}
		?>
		<p>
			実行者 = <?php echo $execUser; ?>
			&nbsp; / &nbsp;
			所有者 = <?php echo $ownerUser; ?>
			<br />
			<?php if( $execUser == $ownerUser ) { ?>
				設置フォルダ内にファイルやフォルダを作成することができます。
			<?php } else { ?>
				<?php if( !is_writable(dirname($thisPageFilePath)) || !is_executable(dirname($thisPageFilePath)) ) { $isGlobalErrors =true; ?>
					<span class="msg-error">インストールするには設置フォルダを書込・実行可能に設定してください。</span>
				<?php } else { ?>
					設置フォルダ内にファイルやフォルダを作成することができます。
				<?php } ?>
			<?php } ?>
		</p>
		
		<h2>作成チェック</h2>
		<?php if( @include_once(DIR_PATH_LIB.'/util/HttpRequest.class.php') ) { ?>
		<table class="detail" style="width:96%;margin:0 auto;">
		<tbody>
		<tr>
			<th style="width:14em;">実行ファイル</th>
			<td>
				<?php
					$errors	= array();
					$requireExtPermittionCheck	= false;
					$checkExecFilePath			= preg_replace('/\\/$/','',realpath(SPIDER_BASE_PATH)).'/check.php';
					$checkExecFileUrl			= SPIDER_URL_BASE.'check.php';
					if( @copy($thisPageFilePath, $checkExecFilePath) ) {
						@chmod($checkExecFilePath, SPIDER_PERMITTION_PUBLIC_FILE);
						// コピーして作成したファイルにアクセスしてみる
						$httpRequest	= new util_HttpRequest($checkExecFileUrl,'get');
						if( $httpRequest->send(null,30) ) {
							if( $httpRequest->statusCode != 200 ) {
								array_push($errors, 'プログラムで生成したphpファイルへのアクセスでエラーが発生しています。 ERROR='.$httpRequest->statusCode.' '.$httpRequest->statusMessage.'<br />'
									.'spider/unique_setting.inc.phpをテキストエディタで開いてSPIDER_PERMITTION_PUBLIC_FILEの値を調整してからアップロードしてください。');
								$requireExtPermittionCheck	= true;
							}
						} else {
							array_push($errors, 'サーバーでHTTP通信をおこなうことができませんでした。');
						}
						@unlink($checkExecFilePath);
					} else {
						array_push($errors, '設置フォルダ内にファイルを作成できません。設置フォルダのパーミッションを確認してください。');
					}
					if( count($errors) > 0 ) {
						$isGlobalErrors	= true;
				?>
					<p class="msg-error">
					<?php foreach( $errors as $error ) { ?>
						<?php echo $error; ?><br />
					<?php } ?>
					</p>
					<?php if( $requireExtPermittionCheck ) { ?>
					<!-- TODO: 次バージョンで追加パーミッション確認	-->
					<p class="msg-error">
						このサーバーでは、<?php echo RELEASE_NAME; ?>初期のphpファイル作成時のパーミッション設定( <?php printf('%03o',SPIDER_PERMITTION_PUBLIC_FILE); ?> )でphpファイルを実行できないようです。
						<br />
						解決するには、<span style="font-weight:bold;">[設置フォルダ]/spider/unique_setting.inc.php</span> ファイルをテキストエディタで開いて<br />
						下記のファイル作成パーミッションの設定を修正してサーバーにアップしなおしてください。<br />
					</p>
					<div>修正箇所) unique_setting.inc.php &nbsp; 24行目: 0666をそれぞれホスティング会社指定の動作可能なパーミッションに変更してください。</div>
<pre style="margin-top:0px;">
/** プログラム生成ファイルパーミッション: 公開フォルダ以下のphpファイル	*/
define('SPIDER_PERMITTION_PUBLIC_FILE',<span style="color:#0000ff;font-weight:bold;">0666</span>);
</pre>			
					<?php } ?>
				<?php } else { ?>
					<p class="msg-enable">ファイル作成パーミッション設定を変更する必要はありません。</p>
				<?php } ?>
			</td>
		</tr>
		<tr>
			<th style="width:14em;">実行ファイル配置フォルダ</th>
			<td>
				<?php
					$errors	= array();
					$requireExtPermittionCheck	= false;
					$checkExecFolderPath	= preg_replace('/\\/$/','',realpath(SPIDER_BASE_PATH)).'/check';
					$checkExecFilePath		= $checkExecFolderPath.'/check.php';
					if( file_exists($checkExecFolderPath) ) {
						if( file_exists( $checkExecFilePath ) ) {
							@unlink($checkExecFilePath);
						}
						@rmdir($checkExecFolderPath);
					}
					if( @mkdir($checkExecFolderPath, SPIDER_PERMITTION_PUBLIC_FOLDER) ) {
						@chmod($checkExecFolderPath, SPIDER_PERMITTION_PUBLIC_FOLDER);
						if( @copy(realpath(SPIDER_BASE_PATH.'/checkinstall.php'), $checkExecFilePath)) {
							@chmod($checkExecFilePath, SPIDER_PERMITTION_PUBLIC_FILE);
							// コピーして作成したファイルにアクセスしてみる
							$httpRequest	= new util_HttpRequest(SPIDER_URL_BASE.'check/check.php','get');
							if( $httpRequest->send(null,30) ) {
								if( $httpRequest->statusCode != 200 ) {
									array_push($errors, 'プログラムで生成したphpファイルへのアクセスでエラーが発生しています。 ERROR='.$httpRequest->statusCode.' '.$httpRequest->statusMessage.'<br />'
										.'spider/unique_setting.inc.phpをテキストエディタで開いてSPIDER_PERMITTION_PUBLIC_FOLDERの値を調整してからアップロードしてください。');
									$requireExtPermittionCheck	= true;
								}
							} else {
								array_push($errors, 'サーバーでHTTP通信をおこなうことができませんでした。');
							}
							@unlink($checkExecFilePath);
						}
						@rmdir($checkExecFolderPath);
					} else {
						array_push($errors, '設置フォルダ内にフォルダを作成できません。設置フォルダを書込・実行可能に設定してください。');
					}
					if( count($errors) > 0 ) {
						$isGlobalErrors	= true;
				?>
					<p class="msg-error">
					<?php foreach( $errors as $error ) { ?>
						<?php echo $error; ?><br />
					<?php } ?>
					</p>
					<?php if( $requireExtPermittionCheck ) { ?>
					<!-- TODO: 次バージョンで追加パーミッション確認	-->
					<p class="msg-error">
						このサーバーでは、<?php echo RELEASE_NAME; ?>初期のphp配置フォルダ作成時のパーミッション設定( <?php printf('%03o',SPIDER_PERMITTION_PUBLIC_FOLDER); ?> )でphpファイルを実行できないようです。
						<br />
						解決するには、<span style="font-weight:bold;">[設置フォルダ]/spider/unique_setting.inc.php</span> ファイルをテキストエディタで開いて<br />
						ファイル作成パーミッションの設定を修正してサーバーにアップしなおしてください。<br />
					</p>
<div>修正箇所) unique_setting.inc.php &nbsp; 26行目: 0777をそれぞれホスティング会社指定の動作可能なパーミッションに変更してください。</div>
<pre style="margin-top:0px;">
/** プログラム生成ファイルパーミッション: 公開フォルダ以下のフォルダ	*/
define('SPIDER_PERMITTION_PUBLIC_FOLDER',<span style="color:#0000ff;font-weight:bold;">0777</span>);
</pre>			
					<?php } ?>
				<?php } else { ?>
					<p class="msg-enable">フォルダ作成パーミッション設定を変更する必要はありません。</p>
				<?php } ?>
			</td>
		</tr>
		</tbody>
		</table>			
		<?php } else { ?>
			<p class="msg-error">通信ライブラリ読み込みに失敗しました。実行ファイル作成パーミッションチェックを行えませんでした。</p>
		<?php } ?>
		
		<h2>アプリケーションデータフォルダ</h2>
		<?php
			$isWritableData		= is_writable(DIR_PATH_DATA);
			$isWritablelib		= is_writable(DIR_PATH_LIB);
			$isWritablePages	= is_writable(DIR_PATH_PAGES);
			$isWritableWidgets	= is_writable(DIR_PATH_WIDGETS);
			$isWritableTmplates	= is_writable(DIR_PATH_TEMPLATES);
			$isWritableWork		= is_writable(DIR_PATH_WORK);
		?>
		<table class="detail" style="width:96%;margin:0 auto;">
		<tbody>
		<tr>
			<th><?php echo DIR_PATH_DATA; ?></th>
			<?php if( $isWritableData ) { ?>
			<td class="view-url" style="background-color:#a0a0ff;">OK</td>
			<?php } else { $isGlobalErrors = true; ?>
			<td class="view-url" style="background-color:#ffa0a0;">NG</td>
			<?php } ?>
		</tr>
		<tr>
			<th><?php echo DIR_PATH_LIB; ?></th>
			<?php if( $isWritablelib ) { ?>
			<td class="view-url" style="background-color:#a0a0ff;">アップデートを利用できると思われます</td>
			<?php } else { ?>
			<td class="view-url" style="background-color:#ffffa0;">アップデートを利用できません</td>
			<?php } ?>
		</tr>
		<tr>
			<th><?php echo DIR_PATH_PAGES; ?></th>
			<?php if( $isWritablePages ) { ?>
			<td class="view-url" style="background-color:#a0a0ff;">OK</td>
			<?php } else { $isGlobalErrors	= true; ?>
			<td class="view-url" style="background-color:#ffa0a0;">NG</td>
			<?php } ?>
		</tr>
		<tr>
			<th><?php echo DIR_PATH_WIDGETS; ?></th>
			<?php if( $isWritableWidgets ) { ?>
			<td class="view-url" style="background-color:#a0a0ff;">OK</td>
			<?php } else { $isGlobalErrors = true; ?>
			<td class="view-url" style="background-color:#ffa0a0;">NG</td>
			<?php } ?>
		</tr>
		<tr>
			<th><?php echo DIR_PATH_TEMPLATES; ?></th>
			<?php if( $isWritableTmplates ) { ?>
			<td class="view-url" style="background-color:#a0a0ff;">OK</td>
			<?php } else { $isGlobalErrors = true; ?>
			<td class="view-url" style="background-color:#ffa0a0;">NG</td>
			<?php } ?>
		</tr>
		<tr>
			<th><?php echo DIR_PATH_WORK; ?></th>
			<?php if( $isWritableWork ) { ?>
			<td class="view-url" style="background-color:#a0a0ff;">OK</td>
			<?php } else { $isGlobalErrors	= true; ?>
			<td class="view-url" style="background-color:#ffa0a0;">NG</td>
			<?php } ?>
		</tr>
		</tbody>
		</table>
		
		<h2>自動判断した実行環境</h2>
		<table class="detail" style="width:96%;margin:0 auto;">
		<tbody>
		<tr>
			<th style="width:14em;">SPIDER_ORG_URL_DOC</th>
			<td class="view-url"><?php echo SPIDER_ORG_URL_DOC; ?></td>
		</tr>
		<tr>
			<th style="width:14em;">SPIDER_ORG_URL_BASE</th>
			<td class="view-url"><?php echo SPIDER_ORG_URL_BASE; ?></td>
		</tr>
		<tr>
			<th style="width:14em;">SPIDER_ORG_URL_REQUEST</th>
			<td class="view-url"><?php echo SPIDER_ORG_URL_REQUEST; ?></td>
		</tr>
		<tr>
			<th style="width:14em;">SPIDER_ORG_URI_BASE</th>
			<td class="view-url"><?php echo SPIDER_ORG_URI_BASE; ?></td>
		</tr>
		<tr>
			<th style="width:14em;">SPIDER_ORG_URI_REQUEST</th>
			<td class="view-url"><?php echo SPIDER_ORG_URI_REQUEST; ?></td>
		</tr>


		<tr>
			<th style="width:14em;">SPIDER_URL_DOC</th>
			<td class="view-url"><?php echo SPIDER_URL_DOC; ?></td>
		</tr>
		<tr>
			<th style="width:14em;">SPIDER_URL_BASE</th>
			<td class="view-url"><?php echo SPIDER_URL_BASE; ?></td>
		</tr>
		<tr>
			<th style="width:14em;">SPIDER_URL_REQUEST</th>
			<td class="view-url"><?php echo SPIDER_URL_REQUEST; ?></td>
		</tr>
		<tr>
			<th style="width:14em;">SPIDER_URI_BASE</th>
			<td class="view-url"><?php echo SPIDER_URI_BASE; ?></td>
		</tr>
		<tr>
			<th style="width:14em;">SPIDER_URI_REQUEST</th>
			<td class="view-url"><?php echo SPIDER_URI_REQUEST; ?></td>
		</tr>


		<tr>
			<th style="width:14em;">SPIDER_URI_APP</th>
			<td class="view-url"><?php echo SPIDER_URI_APP; ?></td>
		</tr>
		<tr>
			<th style="width:14em;">DIR_PATH_SPIDER</th>
			<td class="view-url"><?php echo DIR_PATH_SPIDER; ?></td>
		</tr>

		</tbody>
		</table>

<style type="text/css">
pre {
	width: 95%;
	margin: 0 auto;
	border: dotted 1px #808080;
	background-color: #f0f0f0;
	padding: 5px;
}
span.msg-enable {
	color: #0000dd;
}
span.msg-error {
	color: #dd0000;
}
</style>
	{/if}
