<?php include_once( "../../../spider.inc.php" ); ?>
{charset:UTF-8}
{template:admin_default.tpl}
{module:shopping.category.LoadList}
{module:shopping.product.Confirm}
{preset:page_title 'ショップ管理 > ' . SHOPPING_LABEL_PRODUCT . '管理 > 追加・編集'}

	<div class="panc">
		<a href="../../">管理パネルトップ</a>
		{if:is_object(shopping.product.product_object->'searchDataObject')}
		&gt; <a href="../../search/data/detail.php?schdi={write:shopping.product.product_object->'searchDataObject'->'data_id'}">{write:shopping.product.product_object->'searchDataObject'->'subject'}</a>
		&gt; <a href="./?schdi={write:shopping.product.product_object->'searchDataObject'->'data_id'}">{write:SHOPPING_LABEL_PRODUCT}一覧</a>
		{else}
		&gt; <a href="../">ショップ管理</a>
		&gt; <a href="./">{write:SHOPPING_LABEL_PRODUCT}管理</a>
		{/if}
		{if:strlen(shopping.product.product_object->'product_number')==0}
		&gt; {write:SHOPPING_LABEL_PRODUCT}の新規追加
		{else}
		&gt; <a href="./detail.php?shpdn={write:shopping.product.product_object->'product_number'}">{write:shopping.product.product_object->'product_name'}</a>
		&gt; 編集
		{/if}
	</div>

	<h1>
		{write:SHOPPING_LABEL_PRODUCT}管理
		{if:is_object(shopping.product.product_object->'searchDataObject')}
			&gt; {write:shopping.product.product_object->'searchDataObject'->'subject'}
		{/if}
		{if:strlen(shopping.product.product_object->'product_number')==0}
		&gt; {write:SHOPPING_LABEL_PRODUCT}の新規追加
		{else}
		&gt; {write:shopping.product.product_object->'product_name'}
		&gt; 編集
		{/if}
	</h1>

{if:IS_ERROR}
	<ul class="error">
	{foreach:errors error}
		<li>{write:error}</li>
	{/foreach}
	</ul>
	<p style="text-align:center;">
		<input type="button" value="戻る"
			onclick="window.history.back();"
		/><br />
	</p>
	<br />
{else}
	
	<form name="cform" action="./execute.php?shpdn={write:shopping.product.product_object->'product_number'}&amp;schdi={write:shopping.product.product_object->'search_data_id'}" method="post">
	<p style="text-align:center;">
		入力内容に間違いなければ「実行」ボタンをクリックしてください。
	</p>
	
	<table class="detail" style="width:96%;margin:0 auto;">
	<tbody>
	<tr>
		<th style="width:12em;">{write:SHOPPING_LABEL_PRODUCT}ID</th>
		<td>{write:shopping.product.product_object->'product_id'}</td>
	</tr>
	<tr>
		<th style="width:12em;">{write:SHOPPING_LABEL_PRODUCT}名</th>
		<td>{write:shopping.product.product_object->'product_name'}</td>
	</tr>
	<tr>
		<th style="width:12em;">{write:SHOPPING_LABEL_PRODUCT}名フリガナ</th>
		<td>{write:shopping.product.product_object->'product_kana'}</td>
	</tr>
	<tr>
		<th style="width:12em;">数え方</th>
		<td>{write:shopping.product.product_object->'unit_string'}</td>
	</tr>
	<tr>
		<th style="width:12em;">所属カテゴリ</th>
		<td>
			{foreach:shopping.category.data_array num categoryObject}
			{set:child_category_array categoryObject->'child_category_object_array'}
				{if:in_array(categoryObject->'category_id',shopping.product.product_object->'categoryIdArray')}{write:categoryObject->'category_name'}<br />{/if}
				{foreach:child_category_array childCategoryObject}
				{set:grand_child_category_array childCategoryObject->'child_category_object_array'}
					{if:in_array(childCategoryObject->'category_id',shopping.product.product_object->'categoryIdArray')}{write:categoryObject->'category_name'}&nbsp;-&nbsp;{write:childCategoryObject->'category_name'}<br />{/if}
					{foreach:grand_child_category_array grandChildCategoryObject}
						{if:in_array(grandChildCategoryObject->'category_id',shopping.product.product_object->'categoryIdArray')}{write:categoryObject->'category_name'}&nbsp;-&nbsp;{write:childCategoryObject->'category_name'}&nbsp;-&nbsp;{write:grandChildCategoryObject->'category_name'}<br />{/if}
					{/foreach}
				{/foreach}
			{/foreach}
		</td>
	</tr>
	<tr>
		<th style="width:12em;">状態</th>
		<td>{write:SHOPPING_PRODUCT_STATUS_HASH[shopping.product.product_object->'status_flag']}
		</td>
	</tr>
	<tr>
		<th style="width:12em;">閲覧許可</th>
		<td style="padding:0px;">
			{foreach:MEMBER_MEMBER_CLASS_HASH key value}
			<input type="checkbox" name="member_viewable[]" value="{write:key}"
			{if:in_array(key,shopping.product.product_object->'memberViewableArray')} checked{/if}
			disabled="disabled"
			/>{write:mb_substr(value,0,10)}
			{/foreach}
		</td>
	</tr>
	<tr>
		<th style="width:12em;">{write:SHOPPING_LABEL_ORDER}許可</th>
		<td style="padding:0px;">
			{foreach:MEMBER_MEMBER_CLASS_HASH key value}
			<input type="checkbox" name="member_purchasable[]" value="{write:key}"
			{if:in_array(key,shopping.product.product_object->'memberPurchasableArray')} checked{/if}
			disabled="disabled"
			/>{write:mb_substr(value,0,10)}
			{/foreach}
		</td>
	</tr>
	<tr>
		<th style="width:12em;">商品種別<span class="required">※</span></th>
		<td>
			{write:SHOPPING_DELIVERY_TYPE_HASH[shopping.product.product_object->'delivery_type']}
		</td>
	</tr>
	<tr>
		<th style="width:12em;white-space:nowrap;">カレンダー種別</th>
		<td>
			{if:'1'==shopping.product.product_object->'calendar_type'}
				個別カレンダー利用
			{else}
				全体カレンダー利用
			{/if}
		</td>
	</tr>
	<tr>
		<th style="width:12em;">検索キーワード</th>
		<td>{write:shopping.product.product_object->'keywords'}</td>
	</tr>
	<tr>
		<th style="width:12em;">キャッチコピー</th>
		<td>{write:nl2br(shopping.product.product_object->'catch_copy')}</td>
	</tr>
	<tr>
		<th style="width:12em;">順序番号</th>
		<td>{write:shopping.product.product_object->'order_number'}</td>
	</tr>
	<tr>
		<th style="width:12em;">公式紹介URL</th>
		<td>{write:shopping.product.product_object->'product_url'}</td>
	</tr>
	<tr>
		<th style="width:12em;">紹介文</th>
		<td>{write:nl2br(shopping.product.product_object->'description')}</td>
	</tr>
	<tr>
		<th style="width:12em;">関連商品ID</th>
		<td>
		{foreach:shopping.product.product_object::relatedProductIdArray relatedId}
			{write:relatedId},
		{/foreach}
		</td>
	</tr>
	</tbody>
	</table>
	<br />
	
	<h2>{write:SHOPPING_LABEL_PRODUCT}画像</h2>
	{set:fileIdArrayOrg shopping.product.product_object->'fileIdArray_org'}
	{set:fileIdArray shopping.product.product_object->'fileIdArray'}
	{set:uploader shopping.product.product_object->'uploader'}
	{set:fileBinObjectHash uploader::fileBinObjectHash}
	<table class="detail" style="width:96%;margin:0 auto;">
	<tbody>
	<?php for( $GLOBALS['num']=0; $GLOBALS['num']<10; $GLOBALS['num']++ ){ ?>
	<tr>
		<th style="width:12em;">画像{write:num}</th>
		<td>
			<table style="border-style:none;">
			<tbody>
			<tr>
				<td style="width:48%;vertical-align:middle;text-align:center;border-style:none;">
					{if:isset(fileIdArrayOrg[num])}<img src="/file/download.php?fi={write:fileIdArrayOrg[num]}&amp;w=180&amp;h=180" />{else}登録なし{/if}
				</td>
				<td style="width:4%;vertical-align:middle;text-align:center;border-style:none;">→</td>
				<td style="width:48%;vertical-align:middle;text-align:center;border-style:none;">
					{if:isset(fileBinObjectHash[num])}
						<!-- アップロードされている -->
						<img src="/file/download.php?t=tmp&amp;fi={write:fileBinObjectHash[num]->'file_id'}&amp;w=180&amp;h=180" />
					{else}
						<!-- アップロードなし -->
						{if:isset(fileIdArrayOrg[num]) && isset(fileIdArray[num]) && fileIdArrayOrg[num]==fileIdArray[num]}
							<img src="/file/download.php?fi={write:fileIdArrayOrg[num]}&amp;w=180&amp;h=180" />
						{else}
							登録なし
						{/if}
					{/if}
				</td>
			</tr>
			</tbody>
			</table>
		</td>
	</tr>
	<?php } ?>
	</tbody>
	</table>
	<br />
	
	{if:strlen(shopping.product.product_object->'detail_comment')>0}
	<h2>追加説明文(HTML可)</h2>
	<div style="width:96%;margin:0 auto;border:solid 1px #808080;padding:3px;">
		{write:shopping.product.product_object->'detail_comment' noescape}
	</div>
	<br />
	{/if}
	
	<h2 class="global">{write:SHOPPING_LABEL_ORDER}オプション</h2>
	<?php
		for( $GLOBALS['optionNumber']=1; $GLOBALS['optionNumber']<=5; $GLOBALS['optionNumber']++ ) {
			$GLOBALS['optionVarName']		= 'option'.$GLOBALS['optionNumber'].'_name';
			$GLOBALS['optionItemsName']	= 'option'.$GLOBALS['optionNumber'].'_items';
			$GLOBALS['optionUrlName']		= 'option'.$GLOBALS['optionNumber'].'_url';
			$GLOBALS['optionExpName']	= 'option'.$GLOBALS['optionNumber'].'_explanation';
			$GLOBALS['optionCalcName']		= 'option'.$GLOBALS['optionNumber'].'_calculate';
			$optionItemArray	= explode("\n",str_replace("\n\n","\n",str_replace("\r\n","\n",str_replace("\r","\n",trim($GLOBALS['shopping.product.product_object']->$GLOBALS['optionItemsName'])))));
			$GLOBALS['optionType']		= $optionItemArray[0];
			if( '__INPUT_TYPE_TEXT__' == $GLOBALS['optionType'] ) {
				$GLOBALS['optionCols']	= $optionItemArray[1];
			} else if( '__INPUT_TYPE_TEXTAREA__' == $GLOBALS['optionType'] ) {
				$GLOBALS['optionCols']	= $optionItemArray[1];
				$GLOBALS['optionRows']	= $optionItemArray[2];
			} else {
				$GLOBALS['optionType']	= '__SELECT__';
			}
	?>
	{if:strlen(trim(shopping.product.product_object->optionItemsName))>0}
	<table class="detail" style="width:95%;margin:0 auto;">
	<tbody>
	<tr>
		<th style="width:12em;">オプション{write:optionNumber}項目名</th>
		<td>{write:shopping.product.product_object->optionVarName}</td>
	</tr>
	<tr>
		<th style="width:12em;">オプション{write:optionNumber}設定</th>
		<td>
			{if:optionType=='__INPUT_TYPE_TEXT__'}
				[テキスト] 入力欄サイズ：{write:optionCols}
			{else-if:optionType=='__INPUT_TYPE_TEXTAREA__'}
				[複数行テキスト] 横幅：{write:optionCols} 行数：{write:optionRows}
			{else-if:strlen(trim(shopping.product.product_object->optionItemsName))>0}
				[選択ボックス]<br />
				{write:nl2br(shopping.product.product_object->optionItemsName)}
			{/if}
		</td>
	</tr>
	<tr>
		<th style="width:12em;">オプション{write:optionNumber}説明文</th>
		<td>
			{write:shopping.product.product_object->optionExpName}
		</td>
	</tr>
	<tr>
		<th style="width:12em;">オプション金額計算方法</th>
		<td>
			{if:'1'!=shopping.product.product_object->optionCalcName}注文数で乗算する{/if}
			{if:'1'==shopping.product.product_object->optionCalcName}注文数で乗算しない{/if}
		</td>
	</tr>
	</tbody>
	</table><br />
	{/if}
	<?php } ?>
	
	{if:strlen(shopping.product.product_object->'wholesaler_name')>0 || strlen(shopping.product.product_object->'wholesaler_email')>0 || strlen(shopping.product.product_object->'wholesaler_note')>0}
	<h2 class="global">卸元情報</h2>
	<table class="detail" style="width:95%;margin:0 auto;">
	<tbody>
	<tr>
		<th style="width:12em;">卸業者名</th>
		<td>{write:shopping.product.product_object->'wholesaler_name'}</td>
	</tr>
	<tr>
		<th style="width:12em;">卸業者メールアドレス</th>
		<td>{write:shopping.product.product_object->'wholesaler_email'}</td>
	</tr>
	<tr>
		<th style="width:12em;">卸業者メモ</th>
		<td>{write:nl2br(shopping.product.product_object->'wholesaler_note')}</td>
	</tr>
	</tbody>
	</table>
	<br />
	{/if}
	
	{if:strlen(shopping.product.product_object->'product_number')==0}
	{set:shoppingProductUnitObject shopping.product.product_object->'unitObjectArray'[0]}
	<!-- 新規作成の場合のみ販売単位を同時作成できる -->
	<h2 class="global">販売単位の作成</h2>
	<table class="detail" style="width:96%;margin:0 auto;">
	<tbody>
	<tr>
		<th style="width:12em;">販売単位名</th>
		<td>{write:shoppingProductUnitObject->'unit_name'}</td>
	</tr>
	<tr>
		<th style="width:12em;">販売単位名フリガナ</th>
		<td>{write:shoppingProductUnitObject->'unit_kana'}</td>
	</tr>
	<tr>
		<th style="width:12em;">Web用在庫数</th>
		<td>
			{if:'-4'==shoppingProductUnitObject->'stock'}
				在庫連動(合計)<br />
				{write:shoppingProductUnitObject->'stock_relation'}<br />
				在庫共有減算数:{write:shoppingProductUnitObject->'stock_relation_count'}個
			{else-if:'-3'==shoppingProductUnitObject->'stock'}
				在庫連動(最多)<br />
				{write:shoppingProductUnitObject->'stock_relation'}<br />
				在庫共有減算数:{write:shoppingProductUnitObject->'stock_relation_count'}個
			{else-if:'-2'==shoppingProductUnitObject->'stock'}
				在庫連動(最少)<br />
				{write:shoppingProductUnitObject->'stock_relation'}<br />
				在庫共有減算数:{write:shoppingProductUnitObject->'stock_relation_count'}個
			{else-if:'-1'==shoppingProductUnitObject->'stock'}
				無制限
			{else}
				{write:shoppingProductUnitObject->'stock'}
			{/if}
		</td>
	</tr>
	<tr>
		<th style="width:12em;">実在庫数</th>
		<td>
			{if:''==shoppingProductUnitObject->'stock_display'}
				Web用在庫数と同じ
			{else-if:'-1'==shoppingProductUnitObject->'stock_display'}
				無制限
			{else}
				{write:shoppingProductUnitObject->'stock_display'}
			{/if}
		</td>
	</tr>
	<tr>
		<th style="width:12em;">付与ポイント数</th>
		<td>{write:shoppingProductUnitObject->'present_point'}Pt.</td>
	</tr>
	<tr>
		<th style="width:12em;">梱包目安値</th>
		<td>
			{write:shoppingProductUnitObject->'delivery_weight'}
		</td>
	</tr>
	<tr>
		<th style="width:12em;">標準価格(税込)</th>
		<td>
			{write:number_format(shoppingProductUnitObject->'price_standard')}円
		</td>
	</tr>
	<tr>
		<th style="width:12em;">販売価格(税込)</th>
		<td>
			{write:number_format(shoppingProductUnitObject->'price_sell')}円
		</td>
	</tr>
	<tr>
		<th style="width:12em;">仕入れ値(税込)</th>
		<td>
			{write:number_format(shoppingProductUnitObject->'cost')}円
		</td>
	</tr>
	<tr>
		<th style="width:12em;">月次課金価格(税込)</th>
		<td>
			{write:number_format(shoppingProductUnitObject->'price_monthly')}円
		</td>
	</tr>
	<tr>
		<th style="width:12em;">プロモ割引</th>
		<td>
			{if:shoppingProductUnitObject->'discount_exception'!='1'}通常{/if}
			{if:shoppingProductUnitObject->'discount_exception'=='1'}割引しない{/if}
		</td>
	</tr>
	{if:shoppingProductUnitObject->'shoppingProductObject'->'delivery_type'==900}
	<tr>
		<th style="width:12em;">チェックイン時間</th>
		<td>
			{write:shoppingProductUnitObject->'default_start_time'}
		</td>
	</tr>
	<tr>
		<th style="width:12em;">チェックアウト時間</th>
		<td>
			{write:substr(shoppingProductUnitObject->'default_start_time',0,2) + (shoppingProductUnitObject->'service_term'/(60*60)) - 24}:00
		</td>
	</tr>
	{else-if:shoppingProductUnitObject->'shoppingProductObject'->'delivery_type'>=200}
	<tr>
		<th style="width:12em;">サービス提供時間</th>
		<td>
			{if:(shoppingProductUnitObject->'service_term' % (60*60))==0}
				{write:(shoppingProductUnitObject->'service_term' / (60*60))}時間
			{else-if:(shoppingProductUnitObject->'service_term' % (60))==0}
				{write:(shoppingProductUnitObject->'service_term' / (60))}分
			{else}
				{write:(shoppingProductUnitObject->'service_term')}秒
			{/if}
		</td>
	</tr>
	{/if}
	{if:shoppingProductUnitObject->'shoppingProductObject'->'delivery_type'>=200}
	<tr>
		<th style="width:12em;">予約日制限</th>
		<td>
			{if:strlen(shoppingProductUnitObject->'rsv_permit_start')>0 && shoppingProductUnitObject->'rsv_permit_start'>0}
			{write:shoppingProductUnitObject->'rsv_permit_start'}営業日後から
			{else}
			当日から
			{/if}
			{if:strlen(shoppingProductUnitObject->'rsv_permit_limit')>0 && shoppingProductUnitObject->'rsv_permit_limit'>0}
				{write:shoppingProductUnitObject->'rsv_permit_limit'}日後まで
			{else}
			制限なく
			{/if}
			予約可能
		</td>
	</tr>
	{/if}
	</tbody>
	</table><br />
	{/if}
	
	<p style="text-align:center;">
		<input type="submit" value="実行する"
		/><input type="button" value="戻る"
			onclick="window.history.back();"
		/><br />
	</p>
	<p style="text-align:center;">
	</p>
	</form>
	<br />

{/if}
	<hr style="width:96%;margin:0 auto;margin-top:1em;" />
	{if:is_object(shopping.product.product_object->'searchDataObject')}
	<div style="width:95%;margin:0 auto;text-align:right;">
		<a href="./?schdi={write:shopping.product.product_object->'searchDataObject'->'data_id'}">{write:shopping.product.product_object->'searchDataObject'->'subject'}の施設一覧</a>
		|
		<a href="../../search/data/detail.php?schdi={write:shopping.product.product_object->'searchDataObject'->'data_id'}">{write:shopping.product.product_object->'searchDataObject'->'subject'}の詳細</a>
	</div>
	{/if}
	<div style="width:96%;margin:0 auto;text-align:right;">
		{if:strlen(shopping.product.product_object->'product_number')==0}
		{else}
		<a href="./detail.php?shpdn={write:shopping.product.product_object->'product_number'}">&gt;&gt; {write:shopping.product.product_object->'product_name'}の詳細へ戻る</a>
		{/if}
		{if:is_object(shopping.product.product_object->'searchDataObject')}
		&nbsp;&nbsp;
		&gt;&gt; <a href="../../search/data/detail.php?schdi={write:shopping.product.product_object->'searchDataObject'->'data_id'}">{write:shopping.product.product_object->'searchDataObject'->'subject'}の詳細に戻る</a>
		{/if}
		&nbsp;&nbsp;
		<a href="./">&gt;&gt; {write:SHOPPING_LABEL_PRODUCT}一覧へ戻る</a>
	</div>