<?php include_once( "../../../spider.inc.php" ); ?>
{charset:UTF-8}
{template:admin_default.tpl}
{module:member.member.Form}
{preset:page_title MEMBER_PERSONAL_LABEL . '管理 > 個人情報の保存確認'}

	<div class="panc">
		<a href="../../">管理パネルトップ</a>
		&gt; <a href="../">{write:MEMBER_PERSONAL_LABEL}情報一覧</a>
		{if:strlen(member.member.memberObject->'member_number')>0}
		&gt; <a href="./detail.php?mi={write:member.member.memberObject->'member_id'}">{write:member.member.memberObject->'view_name'}さんの詳細情報</a>
		&gt; 編集
		{else}
		&gt; {write:MEMBER_PERSONAL_LABEL}情報の新規登録
		{/if}
	</div>

	<h1>
		{write:MEMBER_PERSONAL_LABEL}管理
		{if:strlen(member.member.memberObject->'member_number')>0}
		&gt; {write:member.member.memberObject->'view_name'}さんの詳細情報
		&gt; 編集
		{else}
		&gt; {write:MEMBER_PERSONAL_LABEL}情報の新規登録
		{/if}
	</h1>
	
{if:IS_ERROR}
	<ul class="error">
	{foreach:errors error}
		<li>{write:error}</li>
	{/foreach}
	</ul>
{else}

	<form name="mform" action="./confirm.php?mn={write:member.member.memberObject->'member_number'}" method="post">
	<h2 class="global">基本情報</h2>
	<table class="detail" style="width:96%;margin:0 auto;">
	<tbody>
	<tr>
		<th style="font-size:0.8em;width:14em;white-space: nowrap;">{write:MEMBER_PERSONAL_LABEL}ID</th>
		<td>
			{if:strlen(member.member.memberObject->'member_number')==0}
			<input type="text" name="member_id" size="20" value="{write:member.member.memberObject->'member_id'}" style="ime-mode:inactive;" /><input type="button" value="重複確認"
				onclick="systemUniqueIsRegistable(document.mform.member_id.value, '{write:member.member.memberObject->'member_id_org'}', 'unique' )" />
			{else}
				{write:member.member.memberObject->'member_id'}
				<input type="hidden" name="member_id" value="{write:member.member.memberObject->'member_id'}" />
			{/if}
		</td>
	</tr>
	<tr>
		<th style="font-size:0.8em;width:14em;white-space: nowrap;">ニックネーム<span class="required">※</span></th>
		<td>
			<input type="text" name="view_name" size="15" value="{write:member.member.memberObject->'view_name'}" style="ime-mode:active;" />
		</td>
	</tr>
	<tr>
		<th style="font-size:0.8em;width:14em;white-space: nowrap;">姓名</th>
		<td>
			<input type="text" name="family_name" size="10" value="{write:member.member.memberObject->'family_name'}" style="ime-mode:active;" />
			<input type="text" name="first_name" size="10" value="{write:member.member.memberObject->'first_name'}" style="ime-mode:active;" />
		</td>
	</tr>
	<tr>
		<th style="font-size:0.8em;width:14em;white-space: nowrap;">姓名フリガナ</th>
		<td>
			<input type="text" name="family_kana" size="10" value="{write:member.member.memberObject->'family_kana'}" style="ime-mode:active;" />
			<input type="text" name="first_kana" size="10" value="{write:member.member.memberObject->'first_kana'}" style="ime-mode:active;" />
		</td>
	</tr>
	</tbody>
	</table><br />	
	
	<h2 class="global">ログイン情報</h2>
	
	<table class="detail" style="width:96%;margin:0 auto;">
	<tbody>
	<tr>
		<th style="font-size:0.8em;width:14em;white-space: nowrap;">種別<span class="required">※</span></th>
		<td>
			{foreach:MEMBER_MEMBER_CLASS_HASH classNumber className}
			<input type="radio" id="member_class_{write:classNumber}" name="member_class" value="{write:classNumber}"
				{if:member.member.memberObject->'member_class'==classNumber} checked{/if}
			/><label for="member_class_1">{write:className}</label>
			{/foreach}
		</td>
	</tr>
	<tr>
		<th style="font-size:0.8em;width:14em;white-space: nowrap;">ログインID<span class="required">※</span></th>
		<td><input type="text" name="login_id" size="20" value="{write:member.member.memberObject->'login_id'}" style="ime-mode:inactive;" /><input type="button" value="重複確認"
			onclick="systemLoginIsRegistable(document.mform.login_id.value, '{write:member.member.memberObject->'member_id'}' )" /></td>
	</tr>
	<tr>
		<th style="font-size:0.8em;width:14em;white-space: nowrap;">パスワード{if:strlen(member.member.memberObject->'member_number')==0}<span class="required">※</span>{/if}</th>
		<td>
			<input type="text" name="login_password" size="20" value="{write:member.member.memberObject->decodePassword( request, member.member.memberObject->'login_password' )}" style="ime-mode:inactive;" />
			{if:strlen(member.member.memberObject->'member_number')>0}<br /><span style="font-size:x-small;color:#ff0000;">※パスワードは変更する場合のみ入力してください。</span>{/if}
		</td>
	</tr>
	<tr>
		<th style="font-size:0.8em;width:14em;white-space: nowrap;">メールアドレス</th>
		<td><input type="text" name="pc_mail" size="30" value="{write:member.member.memberObject->'pc_mail'}" style="ime-mode:inactive;" /></td>
	</tr>
	<tr>
		<th style="font-size:0.8em;width:14em;white-space: nowrap;">携帯メールアドレス</th>
		<td><input type="text" name="mb_mail" size="30" value="{write:member.member.memberObject->'mb_mail'}" style="ime-mode:inactive;" /></td>
	</tr>
	{if:strlen(member.member.memberObject->'member_number')>0}
	{else}
	<tr>
		<th style="font-size:0.8em;width:14em;white-space: nowrap;">ポイント</th>
		<td>
			初期ポイント入力：<input type="text" name="point" size="5" value="{write:member.member.memberObject->'point'}" style="ime-mode:inactive;" /> Pt.
			<br /><br />
			▼履歴コメント<br />
			<textarea name="action_label" cols="20" rows="2" style="ime-mode:active;">{write:member.member.memberObject->'action_label'}</textarea>
		</td>
	</tr>
	{/if}
	</tbody>
	</table><br />	

	<h2 class="global">住所１</h2>
	
	<table class="detail" style="width:96%;margin:0 auto;">
	<tbody>
	<tr>
		<th style="font-size:0.8em;width:14em;white-space: nowrap;">国名</th>
		<td>
			<input type="text" name="country_name" size="30" value="{write:member.member.memberObject->'country_name'}" style="ime-mode:inactive;" />
		</td>
	</tr>
	<tr>
		<th style="font-size:0.8em;width:14em;white-space: nowrap;">都道府県</th>
		<td>
			<select name="prefecture_number">
				<option value="">選択</option>
				{foreach:PREFECTURE_HASH prefNumber prefName}
				<option value="{write:prefNumber}"
					{if:prefNumber==member.member.memberObject->'prefecture_number'} selected{/if}
					/>{write:prefName}</option>
				{/foreach}
			</select>
		</td>
	</tr>
	<tr>
		<th style="font-size:0.8em;width:14em;white-space: nowrap;">郵便番号</th>
		<td>
			<input type="text" name="zip_code_pre" size="3" value="{write:member.member.memberObject->'zip_code_pre'}" style="ime-mode:inactive;"
				/>-<input type="text" name="zip_code_pst" size="4" value="{write:member.member.memberObject->'zip_code_pst'}" style="ime-mode:inactive;"
				/>
			<input type="hidden" name="zip_code" value="{write:member.member.memberObject->'zip_code'}" />
		</td>
	</tr>
	<tr>
		<th style="font-size:0.8em;width:14em;white-space: nowrap;">住所・番地</th>
		<td>
			<input type="text" name="address" size="50" value="{write:member.member.memberObject->'address'}" style="ime-mode:active;" />
		</td>
	</tr>
	<tr>
		<th style="font-size:0.8em;width:14em;white-space: nowrap;">建物名・部屋番号</th>
		<td>
			<input type="text" name="building" size="50" value="{write:member.member.memberObject->'building'}" style="ime-mode:active;" />
		</td>
	</tr>
	<tr>
		<th style="font-size:0.8em;width:14em;white-space: nowrap;">電話番号</th>
		<td>
			<input type="text" name="telephone_number_area" size="4" value="{write:member.member.memberObject->'telephone_number_area'}"style="ime-mode:inactive;"
			/>-<input type="text" name="telephone_number_city" size="5" value="{write:member.member.memberObject->'telephone_number_city'}"style="ime-mode:inactive;"
			/>-<input type="text" name="telephone_number_local" size="5" value="{write:member.member.memberObject->'telephone_number_local'}"style="ime-mode:inactive;"
			/>
		</td>
	</tr>
	<tr>
		<th style="font-size:0.8em;width:14em;white-space: nowrap;">FAX番号</th>
		<td>
			<input type="text" name="faximili_number_area" size="4" value="{write:member.member.memberObject->'faximili_number_area'}"style="ime-mode:inactive;"
			/>-<input type="text" name="faximili_number_city" size="5" value="{write:member.member.memberObject->'faximili_number_city'}"style="ime-mode:inactive;"
			/>-<input type="text" name="faximili_number_local" size="5" value="{write:member.member.memberObject->'faximili_number_local'}"style="ime-mode:inactive;"
			/>
		</td>
	</tr>
	<tr>
		<th style="font-size:0.8em;width:14em;white-space: nowrap;">携帯電話番号</th>
		<td>
			<input type="text" name="mobile_number_area" size="4" value="{write:member.member.memberObject->'mobile_number_area'}"style="ime-mode:inactive;"
			/>-<input type="text" name="mobile_number_city" size="5" value="{write:member.member.memberObject->'mobile_number_city'}"style="ime-mode:inactive;"
			/>-<input type="text" name="mobile_number_local" size="5" value="{write:member.member.memberObject->'mobile_number_local'}"style="ime-mode:inactive;"
			/>
		</td>
	</tr>
	</tbody>
	</table><br />	
	
	<h2 class="global">住所２</h2>
	
	<table class="detail" style="width:96%;margin:0 auto;">
	<tbody>
	<tr>
		<th style="font-size:0.8em;width:14em;white-space: nowrap;">都道府県</th>
		<td>
			<select name="prefecture_number2">
				<option value="">選択</option>
				{foreach:PREFECTURE_HASH prefNumber prefName}
				<option value="{write:prefNumber}"
					{if:prefNumber==member.member.memberObject->'prefecture_number2'} selected{/if}
					/>{write:prefName}</option>
				{/foreach}
			</select>
		</td>
	</tr>
	<tr>
		<th style="font-size:0.8em;width:14em;white-space: nowrap;">郵便番号</th>
		<td>
			<input type="text" name="zip_code2_pre" size="3" value="{write:member.member.memberObject->'zip_code2_pre'}" style="ime-mode:inactive;"
				/>-<input type="text" name="zip_code2_pst" size="4" value="{write:member.member.memberObject->'zip_code2_pst'}" style="ime-mode:inactive;"
				/>
			<input type="hidden" name="zip_code2" value="{write:member.member.memberObject->'zip_code2'}" />
		</td>
	</tr>
	<tr>
		<th style="font-size:0.8em;width:14em;white-space: nowrap;">住所・番地</th>
		<td>
			<input type="text" name="address2" size="50" value="{write:member.member.memberObject->'address2'}" style="ime-mode:active;" />
		</td>
	</tr>
	<tr>
		<th style="font-size:0.8em;width:14em;white-space: nowrap;">建物名・部屋番号</th>
		<td>
			<input type="text" name="building2" size="50" value="{write:member.member.memberObject->'building2'}" style="ime-mode:active;" />
		</td>
	</tr>
	<tr>
		<th style="font-size:0.8em;width:14em;white-space: nowrap;">電話番号</th>
		<td>
			<input type="text" name="telephone_number2_area" size="4" value="{write:member.member.memberObject->'telephone_number2_area'}"style="ime-mode:inactive;"
			/>-<input type="text" name="telephone_number2_city" size="5" value="{write:member.member.memberObject->'telephone_number2_city'}"style="ime-mode:inactive;"
			/>-<input type="text" name="telephone_number2_local" size="5" value="{write:member.member.memberObject->'telephone_number2_local'}"style="ime-mode:inactive;"
			/>
		</td>
	</tr>
	<tr>
		<th style="font-size:0.8em;width:14em;white-space: nowrap;">FAX番号</th>
		<td>
			<input type="text" name="faximili_number2_area" size="4" value="{write:member.member.memberObject->'faximili_number2_area'}"style="ime-mode:inactive;"
			/>-<input type="text" name="faximili_number2_city" size="5" value="{write:member.member.memberObject->'faximili_number2_city'}"style="ime-mode:inactive;"
			/>-<input type="text" name="faximili_number2_local" size="5" value="{write:member.member.memberObject->'faximili_number2_local'}"style="ime-mode:inactive;"
			/>
		</td>
	</tr>
	</tbody>
	</table><br />	
	
	<h2 class="global">所属</h2>
	
	<table class="detail" style="width:96%;margin:0 auto;">
	<tbody>
	<tr>
		<th style="font-size:0.8em;width:14em;white-space: nowrap;">会社名</th>
		<td>
			<input type="text" name="company_name" size="30" value="{write:member.member.memberObject->'company_name'}" style="ime-mode:active;" />
		</td>
	</tr>
	<tr>
		<th style="font-size:0.8em;width:14em;white-space: nowrap;">部署名</th>
		<td>
			<input type="text" name="section_name" size="30" value="{write:member.member.memberObject->'section_name'}" style="ime-mode:active;" />
		</td>
	</tr>
	</tbody>
	</table><br />	
	
	<h2 class="global">付加情報</h2>
	
	<table class="detail" style="width:96%;margin:0 auto;">
	<tbody>
	<tr>
		<th style="font-size:0.8em;width:14em;white-space: nowrap;">ホームページ</th>
		<td>
			<input type="text" name="url" size="80" value="{write:member.member.memberObject->'url'}" style="ime-mode:inactive;" />
		</td>
	</tr>
	<tr>
		<th style="font-size:0.8em;width:14em;white-space: nowrap;">性別</th>
		<td>
			{foreach:MEMBER_MEMBER_SEX_HASH typeKey typeName}
			<input type="radio" name="sex" value="{write:typeKey}"
				{if:typeKey==member.member.memberObject->'sex'} checked{/if}
				/> {write:typeName}
			{/foreach}
		</td>
	</tr>
	<tr>
		<th style="font-size:0.8em;width:14em;white-space: nowrap;">生年月日</th>
		<td>
			西暦 <select name="birth_year">
				<option value="">選択</option>
				<?php for( $i=date('Y'); $i>1900; $i-- ) { $request->setAttribute('page.year',$i); ?>
				<option value="{write:page.year}"
					{if:page.year==member.member.memberObject->'birth_year'} selected{/if}
				>{write:page.year}</option>
				<?php } ?>
			</select>年
			<select name="birth_month">
				<option value="">選択</option>
				<?php for( $i=1; $i<=12; $i++ ) { $request->setAttribute('page.month',sprintf('%02d',$i)); ?>
				<option value="{write:page.month}"
					{if:page.month==member.member.memberObject->'birth_month'} selected{/if}
				>{write:page.month}</option>
				<?php } ?>
			</select>月
			<select name="birth_day">
				<option value="">選択</option>
				<?php for( $i=1; $i<=31; $i++ ) { $request->setAttribute('page.day',sprintf('%02d',$i)); ?>
				<option value="{write:page.day}"
					{if:page.day==member.member.memberObject->'birth_day'} selected{/if}
				>{write:page.day}</option>
				<?php } ?>
			</select>日
		</td>
	</tr>
	<tr>
		<th style="font-size:0.8em;width:14em;white-space: nowrap;">血液型</th>
		<td>
			{foreach:MEMBER_MEMBER_BLOOD_TYPE_HASH typeKey typeName}
			<input type="radio" name="blood_type" value="{write:typeKey}"
				{if:typeKey==member.member.memberObject->'blood_type'} checked{/if}
				/> {write:typeName}
			{/foreach}
		</td>
	</tr>
	<tr>
		<th style="font-size:0.8em;width:14em;white-space: nowrap;">身長</th>
		<td>
			<input type="text" name="height" size="6" value="{write:member.member.memberObject->'height'/10}"style="ime-mode:inactive;" /> (単位:cm)
		</td>
	</tr>
	<tr>
		<th style="font-size:0.8em;width:14em;white-space: nowrap;">体重</th>
		<td>
			<input type="text" name="weight" size="6" value="{write:member.member.memberObject->'weight'/10}"style="ime-mode:inactive;" /> (単位:kg)
		</td>
	</tr>
	<tr>
		<th style="font-size:0.8em;width:14em;white-space: nowrap;">バスト / ウエスト / ヒップ</th>
		<td>
			<input type="text" name="bust" size="3" value="{write:member.member.memberObject->'bust'}"style="ime-mode:inactive;" />
			 / <input type="text" name="waist" size="3" value="{write:member.member.memberObject->'waist'}"style="ime-mode:inactive;" />
			 / <input type="text" name="hip" size="3" value="{write:member.member.memberObject->'hip'}"style="ime-mode:inactive;" /> (単位:cm)
		</td>
	</tr>
	</tbody>
	</table>
	<br />
	
	<p style="text-align:center;">
		<input type="submit" value="{if:strlen(member.member.memberObject->'member_number')>0}変更する{else}登録する{/if}"
		/>
	</p>
	
	</form>

{/if}
	<hr style="width:96%;margin:0 auto;margin-top:1em;" />
	<div style="width:96%;margin:0 auto;text-align:right;">
		{if:strlen(member.member.memberObject->'member_number')>0}
		<a href="./detail.php?mi={write:member.member.memberObject->'member_id'}">&gt;&gt; {write:member.member.memberObject->'view_name'}さんの詳細へ戻る</a>
		&nbsp;&nbsp;
		&gt;&gt; <a href="./bank/form.php?mi={write:member.member.memberObject->'member_id'}">銀行口座設定</a>
		&nbsp;&nbsp;
		&gt;&gt; <a href="../history/correspond.php?mi={write:member.member.memberObject->'member_id'}">対応履歴</a>
		&nbsp;&nbsp;
		&gt;&gt; <a href="../history/point.php?mi={write:member.member.memberObject->'member_id'}">ポイント履歴</a>
		&nbsp;&nbsp;
		&gt;&gt; <a href="../history/login.php?mi={write:member.member.memberObject->'member_id'}">ログイン履歴</a>
		&nbsp;&nbsp;
		&gt;&gt; <a href="./reject/form.php?mi={write:member.member.memberObject->'member_id'}">メール拒否設定</a>
		&nbsp;&nbsp;
		{/if}
		<a href="../">&gt;&gt; {write:MEMBER_PERSONAL_LABEL}一覧へ戻る</a>
	</div>