<?php include_once( "../../spider.inc.php" ); ?>
{charset:UTF-8}
<?php header( 'Content-type: text/plain;charset=UTF-8' ); ?>
/**
 * ファイルサイズを変更します
 */
function contentFileImageResize(img,maxWidth,maxHeight) {
	if( img ) {
		var orgImage	= new Image();
		orgImage.src	= img.src;
		
		var orgWidth	= orgImage.width;
		var orgHeight	= orgImage.height;
		var outWidth	= orgWidth;
		var outHeight	= orgHeight;
		if( orgWidth > maxWidth ) {
			// 横幅調整
			outWidth	= maxWidth;
			outHeight	= Math.floor(orgHeight * (outWidth/orgWidth));
		}
		if( outHeight > maxHeight ) {
			// 高さ調整
			outWidth	= Math.floor(outWidth * (maxHeight/outHeight));
			outHeight	= maxHeight;
		}
		img.width		= outWidth;
		img.height		= outHeight;
		img.style.width		= String(outWidth) + 'px';
		img.style.height	= String(outHeight) + 'px';
	}
}
/**
 * Ajaxアップロードフォームを表示します
 */
var contentFileHttpObject;
function contentFileViewUploadForm() {
	var folderUri,fileName,folderSelect,callbackFunc;
	if( arguments.length == 4 ) {
		folderUri		= arguments[0];
		fileName		= arguments[1];
		if( arguments[2] ) {
			folderSelect	= 'true';
		} else {
			folderSelect	= 'false';
		}
		callbackFunc		= arguments[3];
	} else if( arguments.length == 3 ) {
		folderUri		= arguments[0];
		fileName		= arguments[1];
		if( arguments[2] ) {
			folderSelect	= 'true';
		} else {
			folderSelect	= 'false';
		}
		callbackFunc		= null;
	} else if( arguments.length == 2 ) {
		folderUri	= arguments[0];
		fileName	= arguments[1];
		folderSelect	= 'false';
		callbackFunc		= null;
	} else if( arguments.length == 1 ) {
		folderUri	= arguments[0];
		fileName	= '';
		folderSelect	= 'false';
		callbackFunc		= null;
	} else {
		folderUri	= '/upload';
		fileName	= '';
		folderSelect	= 'false';
		callbackFunc		= null;
	}
	var formUri	= '<?php echo SPIDER_URI_BASE.SYSTEM_DIR_NAME_ADMIN_PANEL; ?>/content/file/upload/ajax_form.php?'
		+'folder='+escape(folderUri)
		+'&upname='+escape(fileName)
		+'&fs='+escape(folderSelect);
	FormerCommon.displayGrayOut(999);

	var formBlock	= document.createElement('div');
	formBlock.callbackFunc	= callbackFunc;
	formBlock.id	= 'content-file-upload-innerblock';
	formBlock.style.backgroundColor	= "#ff0000";
	formBlock.style.width			= '800px';
	formBlock.style.zIndex			= '9999';
	formBlock.style.position		= 'absolute';
	formBlock.style.left			= ( ( FormerCommon.getPageWidth()/2 ) - 400 ) + 'px';
	if(window.attachEvent){
		window.attachEvent('onscroll',contentFileViewUploadFormResize);
	}else{
		window.addEventListener('scroll',contentFileViewUploadFormResize,false);
	}
	var bodyTags 	= document.getElementsByTagName('body');
	bodyTags[0].appendChild(formBlock);

	contentFileHttpObject	= FormerCommon.createHttpRequest(contentFileViewUploadFormResult);
	contentFileHttpObject.targetBlock	= formBlock;
	if( contentFileHttpObject ) {
		contentFileHttpObject.open("GET",formUri,true);
		contentFileHttpObject.send(null);
	} else {
		alert('サーバー通信作成に失敗しました!');
	}	
}
function contentFileViewUploadFormResult() {
	if ((contentFileHttpObject.readyState == 4) && (contentFileHttpObject.status == 200)){
		if( contentFileHttpObject.targetBlock ) {
			contentFileHttpObject.targetBlock.innerHTML	= contentFileHttpObject.responseText;
		}
	} else if ((contentFileHttpObject.readyState == 4) && (contentFileHttpObject.status != 200)){
		alert('アップロードフォームの取得に失敗しました!');
	}
}
function contentFileViewUploadFormResize() {
	var formBlock	= document.getElementById('content-file-upload-innerblock');
	if( formBlock ) {
		if ( document.documentElement.clientHeight ) {
			formBlock.style.top	= ((document.documentElement.clientHeight-formBlock.offsetHeight)/2 + document.documentElement.scrollTop)+'px';
		} else {
			formBlock.style.top	= ((document.body.clientHeight-formBlock.offsetHeight)/2 + document.body.scrollTop) + 'px';
		}
	}
}
function contentFileViewUploadFormClose() {
	var formBlock	= document.getElementById('content-file-upload-innerblock');
	var bodyTags 	= document.getElementsByTagName('body');
	if( formBlock ) {
		if( formBlock.callbackFunc ) {
			var funcType	= typeof(formBlock.callbackFunc);
			if( 'function' == funcType ) {
				formBlock.callbackFunc();
			} else if( 'string' == funcType ) {
				eval(formBlock.callbackFunc);
			}
		}
		bodyTags[0].removeChild(formBlock);
	}
	FormerCommon.displayWhiteIn();
}
/**
 * コンテンツ一覧取得関数
 */
var contentGetConentHttpdObject;
function contentGetContentList(targetFolder,outputFunction) {
	contentGetConentHttpdObject	= FormerCommon.createHttpRequest(contentGetContentListResult);
	contentGetConentHttpdObject.outputFunction	= outputFunction;
	contentGetConentHttpdObject.targetFolder	= targetFolder;
	if( contentGetConentHttpdObject ) {
		var url	= '<?php echo SPIDER_URI_BASE.SYSTEM_DIR_NAME_ADMIN_PANEL; ?>/content/xmlcontent.php?ccurf=' + encodeURIComponent(targetFolder);
		contentGetConentHttpdObject.open("GET",url,true);
		contentGetConentHttpdObject.send(null);
	} else {
		alert('サーバー通信作成に失敗しました!');
	}
}
function contentGetContentListResult() {
	if ((contentGetConentHttpdObject.readyState == 4) && (contentGetConentHttpdObject.status == 200)){
		var contentObjectArray	= new Array();
		var domDoc	= contentGetConentHttpdObject.responseXML;
		if( domDoc ) {
			var nodes	= domDoc.getElementsByTagName('content');
			if( nodes.length > 0 ) {
				for( var num=0; num<nodes.length; num++ ) {
					var targetContent	= nodes[num];
					var contentObj		= new Object();
					contentObj.type			= targetContent.getAttribute("type");
					contentObj.name			= targetContent.getAttribute("name");
					contentObj.folder		= targetContent.getAttribute("folder");
					contentObj.thumbnail	= targetContent.getAttribute("thumbnail");
					contentObj.title		= targetContent.getAttribute("title");
					contentObj.template		= targetContent.getAttribute("template");
					contentObj.size			= targetContent.getAttribute("size");
					contentObj.width		= targetContent.getAttribute("width");
					contentObj.height		= targetContent.getAttribute("height");
					contentObjectArray.push(contentObj);
				}
			}
			if( contentGetConentHttpdObject.outputFunction) {
				var funcType	= typeof(contentGetConentHttpdObject.outputFunction);
				if( 'function' == funcType ) {
					contentGetConentHttpdObject.outputFunction(contentObjectArray);
				} else if( 'string' == funcType ) {
					eval(ccontentGetConentHttpdObject.outputFunction);
				}
			}
		} else {
			alert('正常なXMLが取得できませんでした！');
		}
	} else if ((contentGetConentHttpdObject.readyState == 4) && (contentGetConentHttpdObject.status != 200)){
		alert(contentGetConentHttpdObject.targetFolder + 'のコンテンツ取得に失敗しました！');
	}
}
/**
 * フォルダ一覧取得関数
 */
var contentGetFolderHttpObject;
function contentGetFolderList(targetFolder,outputFunction) {
	contentGetFolderHttpObject	= FormerCommon.createHttpRequest(contentGetFolderListResult);
	contentGetFolderHttpObject.outputFunction	= outputFunction;
	contentGetFolderHttpObject.targetFolder		= targetFolder;
	if( contentGetFolderHttpObject ) {
		var url	= '<?php echo SPIDER_URI_BASE.SYSTEM_DIR_NAME_ADMIN_PANEL; ?>/content/xmlfolder.php?ccurf=' + encodeURIComponent(targetFolder);
		contentGetFolderHttpObject.open("GET",url,true);
		contentGetFolderHttpObject.send(null);
	} else {
		alert('サーバー通信作成に失敗しました!');
	}
}
function contentGetFolderListResult() {
	if ((contentGetFolderHttpObject.readyState == 4) && (contentGetFolderHttpObject.status == 200)){
		var folderInfoObjectArray	= new Array();
		var domDoc	= contentGetFolderHttpObject.responseXML;
		if( domDoc ) {
			var nodes	= domDoc.getElementsByTagName('folder');
			if( nodes.length > 0 ) {
				for( var num=0; num<nodes.length; num++ ) {
					var folderInfoNode	= nodes[num];
					var folderObject	= new Object();
					folderObject.name	= folderInfoNode.getAttribute("name");
					folderObject.parent	= contentGetFolderHttpObject.targetFolder;
					folderInfoObjectArray.push(folderObject);
				}
			}
			if( contentGetFolderHttpObject.outputFunction) {
				var funcType	= typeof(contentGetFolderHttpObject.outputFunction);
				if( 'function' == funcType ) {
					contentGetFolderHttpObject.outputFunction(folderInfoObjectArray);
				} else if( 'string' == funcType ) {
					eval(ccontentGetFolderHttpObject.outputFunction);
				}
			}
		} else {
			alert('正常なXMLが取得できませんでした！');
		}
	} else if ((contentGetFolderHttpObject.readyState == 4) && (contentGetFolderHttpObject.status != 200)){
		alert(contentGetFolderHttpObject.targetFolder + 'のコンテンツ取得に失敗しました！');
	}
}
/**
 * HTMLパーツ一覧取得関数
 */
var contentGetWidgetHttpdObject;
function contentGetWidgetList(outputFunction) {
	contentGetWidgetHttpdObject	= FormerCommon.createHttpRequest(contentGetWidgetListResult);
	contentGetWidgetHttpdObject.outputFunction	= outputFunction;
	if( contentGetWidgetHttpdObject ) {
		var url	= '<?php echo SPIDER_URI_BASE.SYSTEM_DIR_NAME_ADMIN_PANEL; ?>/content/xmlwidget.php';
		contentGetWidgetHttpdObject.open("GET",url,true);
		contentGetWidgetHttpdObject.send(null);
	} else {
		alert('サーバー通信作成に失敗しました!');
	}
}
function contentGetWidgetListResult() {
	if ((contentGetWidgetHttpdObject.readyState == 4) && (contentGetWidgetHttpdObject.status == 200)){
		var widgetObjectArray	= new Array();
		var domDoc	= contentGetWidgetHttpdObject.responseXML;
		if( domDoc ) {
			var nodes	= domDoc.getElementsByTagName('widget');
			if( nodes.length > 0 ) {
				for( var num=0; num<nodes.length; num++ ) {
					var targetWidget	= nodes[num];
					var widgetObj		= new Object();
					widgetObj.fileName		= targetWidget.getAttribute("fileName");
					widgetObj.viewName		= targetWidget.getAttribute("viewName");
					widgetObj.description	= targetWidget.getAttribute("description");
					widgetObjectArray.push(widgetObj);
				}
			}
			if( contentGetWidgetHttpdObject.outputFunction) {
				var funcType	= typeof(contentGetWidgetHttpdObject.outputFunction);
				if( 'function' == funcType ) {
					contentGetWidgetHttpdObject.outputFunction(widgetObjectArray);
				} else if( 'string' == funcType ) {
					eval(ccontentGetWidgetHttpdObject.outputFunction);
				}
			}
		} else {
			alert('正常なXMLが取得できませんでした！');
		}
	} else if ((contentGetWidgetHttpdObject.readyState == 4) && (contentGetWidgetHttpdObject.status != 200)){
		alert('HTMLパーツ情報一覧の取得に失敗しました！');
	}
}
/**
 * 画像差し込みパネルを表示する関連関数
 */
var contentImageHttpObject;
function contentToImagePastePanel() {
	var divBlock,targetFolder,textFormer,rows,pageNumber;
	if( arguments.length >= 5 ) {
		divBlock		= arguments[0];
		targetFolder	= arguments[1];
		textFormer		= arguments[2];
		rows			= arguments[3];
		pageNumber		= arguments[4];
	} else if( arguments.length == 4 ) {
		divBlock		= arguments[0];
		targetFolder	= arguments[1];
		textFormer		= arguments[2];
		rows			= arguments[3];
		pageNumber		= 1;
	} else if( arguments.length == 3 ) {
		divBlock		= arguments[0];
		targetFolder	= arguments[1];
		textFormer		= arguments[2];
		rows			= 12;
		pageNumber		= 1;
	} else {
		alert('画像一覧呼び出しでエラーが発生しました!');
		return;
	}
	divBlock.innerHTML		= '';
	contentImageHttpObject	= FormerCommon.createHttpRequest( contentToImagePastePanelResult );
	contentImageHttpObject.targetFolder		= targetFolder;
	contentImageHttpObject.targetBlock		= divBlock;
	contentImageHttpObject.textFormer		= textFormer;
	contentImageHttpObject.rows				= rows;
	contentImageHttpObject.pageNumber		= pageNumber;
	if( contentImageHttpObject ) {
		var url	= '<?php echo SPIDER_URI_BASE.SYSTEM_DIR_NAME_ADMIN_PANEL; ?>/content/xmlcontent.php?ccurf=' + encodeURIComponent(contentImageHttpObject.targetFolder);
		contentImageHttpObject.open("GET",url,true);
		contentImageHttpObject.send(null);
	} else {
		alert('サーバー通信作成に失敗しました!');
	}
}
function contentToImagePastePanelResult( contentObjectArray ) {
	if ((contentImageHttpObject.readyState == 4) && (contentImageHttpObject.status == 200)){
		var contentObjectArray	= new Array();
		var blockWidth			= contentImageHttpObject.targetBlock.clientWidth;
		var imageBlockWidth		= blockWidth/2 - 10;
		var imageMax			= imageBlockWidth - 10;
		var imageBlockHeight	= imageBlockWidth + 20;
		var imageThumbArray		= new Array();
		var domDoc	= contentImageHttpObject.responseXML;
		if( domDoc ) {
			var nodes	= domDoc.getElementsByTagName('content');
			if( nodes.length > 0 ) {
				for( var num=0; num<nodes.length; num++ ) {
					var targetContent	= nodes[num];
					var contentObject	= new Object();
					contentObject.type		= targetContent.getAttribute("type");
					contentObject.name		= targetContent.getAttribute("name");
					contentObject.folder	= targetContent.getAttribute("folder");
					contentObject.thumbnail	= targetContent.getAttribute("thumbnail");
					contentObject.title		= targetContent.getAttribute("title");
					contentObject.template	= targetContent.getAttribute("template");
					contentObject.size		= targetContent.getAttribute("size");
					contentObject.width		= targetContent.getAttribute("width");
					contentObject.height	= targetContent.getAttribute("height");
					if( contentObject.type == 'image' ) {
						contentObjectArray.push(contentObject);
					}
				}
				// 画像の数情報表示
				if( contentObjectArray.length > 0 ) {
					var offset		= 0;
					var pageCount	= 1;
					var infoDiv	= document.createElement('div');
					infoDiv.style.textAlign	= 'center';
					infoDiv.style.fontSize	= 'x-small';
					infoDiv.innerHTML	= 'Total' + contentObjectArray.length;
					if( contentObjectArray.length > contentImageHttpObject.rows ) {
						pageCount	= Math.ceil(contentObjectArray.length/contentImageHttpObject.rows);
						if( contentImageHttpObject.pageNumber > pageCount ) {
							contentImageHttpObject.pageNumber	= pageCount;
						}
						infoDiv.innerHTML	+= ' : '
							+ contentImageHttpObject.pageNumber + '/' + pageCount + 'Page';
						offset	= ( contentImageHttpObject.pageNumber - 1 ) * contentImageHttpObject.rows;
					} else {
						contentImageHttpObject.pageNumber	= 1;
					}
					contentImageHttpObject.targetBlock.appendChild(infoDiv);
					for( var num=offset; (num < contentObjectArray.length && num < offset+contentImageHttpObject.rows); num++ ) {
						var contentObject	= contentObjectArray[num];
						var imageBlock	= contentToImagePasteCreateImageBlock( contentObject, contentImageHttpObject.textFormer, imageMax, imageMax );
						imageBlock.style.width	= String( imageBlockWidth ) + 'px';
						imageBlock.style.height	= String( imageBlockHeight ) + 'px';
						imageBlock.style.cssFloat	= 'left';
						imageBlock.style.styleFloat	= 'left';
						imageBlock.style.marginLeft	= '5px';
						contentImageHttpObject.targetBlock.appendChild(imageBlock);
						imageThumbArray.push(imageBlock);
					}
					var pageDiv	= document.createElement('div');
					pageDiv.style.clear		= 'left';
					pageDiv.style.textAlign	= 'right';
					pageDiv.style.padding	= '10px';
					pageDiv.style.fontSize	= 'x-small';
					if( contentImageHttpObject.pageNumber > 1 ) {
						var prevBtn	= document.createElement('input');
						prevBtn.type	= 'button';
						prevBtn.value	= '<<';
						prevBtn.style.fontSize	= 'x-small';
						prevBtn.targetFolder	= contentImageHttpObject.targetFolder;
						prevBtn.targetBlock		= contentImageHttpObject.targetBlock;
						prevBtn.textFormer		= contentImageHttpObject.textFormer;
						prevBtn.rows			= contentImageHttpObject.rows;
						prevBtn.currentPage		= contentImageHttpObject.pageNumber;
						prevBtn.onclick	= function() {
							contentToImagePastePanel(this.targetBlock,this.targetFolder,this.textFormer,this.rows,this.currentPage-1);
						};
						pageDiv.appendChild(prevBtn);
					}
					if( contentImageHttpObject.pageNumber < pageCount ) {
						var nextBtn	= document.createElement('input');
						nextBtn.type	= 'button';
						nextBtn.value	= '>>';
						nextBtn.style.fontSize	= 'x-small';
						nextBtn.targetFolder	= contentImageHttpObject.targetFolder;
						nextBtn.targetBlock		= contentImageHttpObject.targetBlock;
						nextBtn.textFormer		= contentImageHttpObject.textFormer;
						nextBtn.rows			= contentImageHttpObject.rows;
						nextBtn.currentPage		= contentImageHttpObject.pageNumber;
						nextBtn.onclick	= function() {
							contentToImagePastePanel(this.targetBlock,this.targetFolder,this.textFormer,this.rows,this.currentPage+1);
						};
						pageDiv.appendChild(nextBtn);
					}
					contentImageHttpObject.targetBlock.appendChild(pageDiv);
				} else {
					var infoDiv	= document.createElement('div');
					infoDiv.style.textAlign	= 'center';
					infoDiv.style.padding	= '10px';
					infoDiv.style.fontSize	= 'x-small';
					infoDiv.innerHTML		= '画像が見つかりませんでした';
					contentImageHttpObject.targetBlock.appendChild(infoDiv);
				}
			} else {
				var infoDiv	= document.createElement('div');
				infoDiv.style.textAlign	= 'center';
				infoDiv.style.padding	= '10px';
				infoDiv.style.fontSize	= 'x-small';
				infoDiv.innerHTML		= '画像が見つかりませんでした';
				contentImageHttpObject.targetBlock.appendChild(infoDiv);
			}
			for( var n=0; n<imageThumbArray.length; n++ ){
				imageThumbArray[n].reload();
			}
		} else {
			alert('正常なXMLが取得できませんでした！');
		}
	} else if ((contentImageHttpObject.readyState == 4) && (contentImageHttpObject.status != 200)){
		alert(contentImageHttpObject.targetFolder + 'のコンテンツ取得に失敗しました！');
	}
}
function contentToImagePasteCreateImageBlock(contentObject,textFormer,maxWidth,maxHeight) {
	var imageBlock	= document.createElement('table');
	var tbodyObj	= document.createElement('tbody');
	imageBlock.appendChild( tbodyObj );
	var tr1Obj		= document.createElement('tr');
	tbodyObj.appendChild( tr1Obj );
	var td1Obj		= document.createElement('td');
	td1Obj.style.textAlign		= 'center';
	td1Obj.style.verticalAlign	= 'middle';
	tr1Obj.appendChild( td1Obj );
	var thumbImg	= new Image();
	thumbImg.id		= escape(contentObject.name);
	thumbImg.textFormer	= textFormer;
	thumbImg.contentObject = contentObject;
	thumbImg.src	= contentObject.thumbnail;
	thumbImg.style.cursor		= 'pointer';
	contentFileImageResize(thumbImg,maxWidth,maxHeight);
	thumbImg.onclick	= function() {
		var str	= '<img src="' + contentObject.folder + '/' + contentObject.name+ '" />';
		this.textFormer.paste(str);
	};
	thumbImg.reload		= function() {
		this.src = this.contentObject.thumbnail;
	}
	imageBlock.thumbImg = thumbImg;
	td1Obj.appendChild(thumbImg);
	var tr2Obj		= document.createElement('tr');
	tbodyObj.appendChild( tr2Obj );
	var td2Obj		= document.createElement('td');
	td2Obj.style.textAlign		= 'center';
	td2Obj.style.verticalAlign	= 'middle';
	tr2Obj.appendChild( td2Obj );
	// 左寄せ貼り付け
	var btnL	= new Image();
	var url		= '<?php echo SPIDER_URI_BASE.SYSTEM_DIR_NAME_ADMIN_PANEL; ?>/content/images/icon/image_left.gif';
	btnL.src	= url;
	btnL.style.cursor	= 'pointer';
	btnL.textFormer		= textFormer;
	btnL.onclick	= function() {
		var str	= '<img src="' + contentObject.folder + '/' + contentObject.name+ '" style="float:left;margin-right:1em;margin-bottom:1em;" />';
		this.textFormer.paste(str);
	};
	td2Obj.appendChild(btnL);
	// センター貼り付け
	var btnC	= new Image();
	var url		= '<?php echo SPIDER_URI_BASE.SYSTEM_DIR_NAME_ADMIN_PANEL; ?>/content/images/icon/image_center.gif';
	btnC.src	= url;
	btnC.style.marginLeft	= '1px';
	btnC.style.cursor		= 'pointer';
	btnC.textFormer	= textFormer;
	btnC.onclick	= function() {
		var str	= '<img src="' + contentObject.folder + '/' + contentObject.name+ '" />';
		this.textFormer.paste(str);
	};
	td2Obj.appendChild(btnC);
	// 右寄せ貼り付け
	var btnR	= new Image();
	var url		= '<?php echo SPIDER_URI_BASE.SYSTEM_DIR_NAME_ADMIN_PANEL; ?>/content/images/icon/image_right.gif';
	btnR.src	= url;
	btnR.style.marginLeft	= '1px';
	btnR.style.cursor		= 'pointer';
	btnR.textFormer	= textFormer;
	btnR.onclick	= function() {
		var str	= '<img src="' + contentObject.folder + '/' + contentObject.name+ '" style="float:right;margin-left:1em;margin-bottom:1em;" />';
		this.textFormer.paste(str);
	};
	td2Obj.appendChild(btnR);
	
	return imageBlock;
}