// TextFormer version 0.5
// CopyRight(C) m_nakashima@users.sourceforge.jp
// http://sourceforge.jp/projects/shopformer/
// m_nakashima@users.sourceforge.jp
//
TextFormer = function() {
	var textAreaElement;
	var saveMethod;
	var closeMethod;
	if( arguments.length == 0 ) {
		alert('need textarea element!');
		return;
	} else if( arguments.length == 1 ) {
		textAreaElement	= arguments[0];
	} else if( arguments.length == 2 ) {
		textAreaElement	= arguments[0];
		saveMethod		= arguments[1];
	} else if( arguments.length == 3 ) {
		textAreaElement	= arguments[0];
		saveMethod		= arguments[1];
		closeMethod		= arguments[2];
	}
	var self					= document.createElement('div');
	if( !TextFormer.path ) {
		var scriptTags 	= document.getElementsByTagName('script');
		for(var i=0,n=scriptTags.length;i<n;i++) {
			if(scriptTags[i].src.match('textformer.js')) {
				TextFormer.path = scriptTags[i].src.replace('textformer.js','');
			}
		}
	}
	self.orgTextArea	= textAreaElement;
	self.id						= textAreaElement.id + '_textFormer';
	self.defautFontSize			= 12;
	self.defaultLineHeight		= 14;
	self.defaultLineCount		= 30;
	self.subject				= '';
	self.lineCount				= self.defaultLineCount;
	
	self.style.display			= 'block';
	self.style.margin			= '0 auto';
	self.style.backgroundColor	= '#BBBBBB';
	self.style.borderStyle		= 'solid';
	self.style.borderWidth		= '1px';
	self.style.fontFamily		= 'monospace';
	
	var parentNode	= textAreaElement.parentNode;
	parentNode.insertBefore(self, textAreaElement);
	self.orgWidth				= self.clientWidth;
	self.orgHeight				= self.clientHeight;
	
	// パネル部品の追加
	self.buttonPanelId				= textAreaElement.id+'_button';
	self.linesPanelId				= textAreaElement.id+'_lines';
	self.linesTextPanelId			= textAreaElement.id+'_lines_text';
	self.editorPanelId				= textAreaElement.id+'_editor';
	self.bottomPanelId				= textAreaElement.id+'_bottom';
	self.subjectPanelId				= textAreaElement.id+'_subject';
	if (window.navigator.appName.toLowerCase().indexOf("microsoft") > -1) {
		// ボタンパネルの追加
		self.buttonPanel			= document.createElement('div');
		self.buttonPanel.id			= self.buttonPanelId;
		self.appendChild(self.buttonPanel);
		// 行数表示パネルの追加
		self.lineTextPanel				= document.createElement('div');
		self.lineTextPanel.id			= self.linesTextPanelId;
		self.linePanel					= document.createElement('div');
		self.linePanel.id				= self.linesPanelId;
		self.linePanel.appendChild(self.lineTextPanel);
		self.appendChild(self.linePanel);
		// テキストエリアの追加
		self.textArea					= document.createElement('textarea');
		self.textArea.id				= self.editorPanelId;
		self.textArea.wrap				= 'off';
		self.appendChild(self.textArea);
	} else {
		// テキストエリア改行なし属性追加の為innnerHTMLにwrap=offで追加する(W3C非推奨)
		var str	=
			'<div id="'+self.buttonPanelId+'"></div>'
			+'<div id="'+self.linesPanelId+'"><div id="'+self.linesTextPanelId+'"></div></div>'
			+'<textarea id="'+self.editorPanelId+'" name="'+textAreaElement.name+'" wrap="off"></textarea>'
		;
		self.innerHTML		+= str;
		self.buttonPanel	= document.getElementById(self.buttonPanelId);
		self.linePanel		= document.getElementById(self.linesPanelId);
		self.lineTextPanel	= document.getElementById(self.linesTextPanelId);
		self.textArea		= document.getElementById(self.editorPanelId);
	}
	self.bottomPanel				= document.createElement('div');
	self.appendChild(self.bottomPanel);
	
	// テキストエリア本文の取得
	self.textArea.textformer		= self;
	self.textArea.name				= textAreaElement.name;
	var strings	= textAreaElement.value;
	while( strings.indexOf(TextFormer.TAB) >= 0 ) {
		strings	= strings.replace(TextFormer.TAB,"    ");
	}
	self.textArea.value				= strings;
	self.textArea.onscroll			= function() {
		this.textformer.rewriteLineNumber();
	};
	self.getText					= function() {
		return this.textArea.value;
	};
	self.setText					= function(text) {
		this.textArea.value	= text;
	};
	self.appendText					= function(text) {
		this.textArea.value	+= text;
	};
	self.paste						= function(text) {
		var orgScroll	= this.textArea.scrollTop;
		this.textArea.focus();
		if( document.selection && document.selection.createRange ) {
			var range = document.selection.createRange();
			range.text = text;
			range.select();
		} else {
			var cursorPos = this.textArea.selectionStart;
			if((cursorPos == null) || (cursorPos == 0)) {
				this.textArea.value = this.textArea.value + text;
			} else {
				var textLength = this.textArea.value.length;
				var beforText = this.textArea.value.substr(0, cursorPos);
				var afterText = this.textArea.value.substr(cursorPos, textLength);
				this.textArea.value = beforText + text + afterText;
				this.textArea.setSelectionRange(cursorPos+text.length, cursorPos+text.length);
			}
		}
		this.textArea.scrollTop	= orgScroll;
	};
	self.toDisable					= function() {
		this.textArea.disabled	= 'disabled';
	};
	self.toEnable					= function() {
		this.textArea.disabled	= null;
	};

	//
	// ボタン操作
	//
	self.buttonLeftArray	= new Array();
	self.buttonRightArray	= new Array();
	// ボタンを再表示
	self.reviewButtons = function() {
		this.buttonPanel.innerHTML	= '';
		// タイトル再表示
		this.subjectPanel					= document.createElement('div');
		this.subjectPanel.style.width		= '100%';
		this.subjectPanel.style.height		= '24px';
		this.subjectPanel.style.lineHeight	= '24px';
		this.subjectPanel.style.fontSize	= '10px';
		this.subjectPanel.style.color		= '#606060';
		this.subjectPanel.style.textAlign	= 'center';
		this.subjectPanel.id				= this.subjectPanelId;
		if( this.subject && this.subject.length > 0 ) {
			this.subjectPanel.innerHTML			= this.subject;
		} else {
			this.subjectPanel.innerHTML			= 'TextFormer';
		}
		this.buttonPanel.appendChild(this.subjectPanel);
		// 左側ボタン
		var leftButtonPanel	= document.createElement('div');
		leftButtonPanel.style.display		= 'block';
		leftButtonPanel.style.marginTop		= '-24px';
		leftButtonPanel.style.width			= '48%';
		leftButtonPanel.style.cssFloat		= 'left';
		leftButtonPanel.style.styleFloat	= 'left';
		for( var num=0; num < this.buttonLeftArray.length; num++ ) {
			this.buttonLeftArray[num].style.cssFloat	= 'left';
			this.buttonLeftArray[num].style.styleFloat	= 'left';
			leftButtonPanel.appendChild(this.buttonLeftArray[num]);
		}
		this.buttonPanel.appendChild(leftButtonPanel);
		// 右側ボタン
		var rightButtonPanel	= document.createElement('div');
		rightButtonPanel.style.display		= 'block';
		rightButtonPanel.style.marginTop	= '-24px';
		rightButtonPanel.style.width		= '48%';
		rightButtonPanel.style.cssFloat		= 'right';
		rightButtonPanel.style.styleFloat	= 'right';
		for( var num=0; num < this.buttonRightArray.length; num++ ) {
			this.buttonRightArray[num].style.cssFloat	= 'right';
			this.buttonRightArray[num].style.styleFloat	= 'right';
			rightButtonPanel.appendChild(this.buttonRightArray[num]);
		}
		this.buttonPanel.appendChild(rightButtonPanel);
	};
	// ボタンを追加する
	self.addButton = function(buttonObject,float) {
		if( 'right' == float ) {
			this.buttonRightArray.push(buttonObject);
		} else {
			this.buttonLeftArray.push(buttonObject);
		}
		this.reviewButtons();
	};
	// ボタンを削除する
	self.removeButton = function(target) {
		if( 'close' == target ) {
			target	= this.id+'-close-button';
		} else if( 'max' == target ) {
			target	= this.id+'-maximize-button';
		} else if( 'spread' == target ) {
			target	= this.id+'-spread-button';
		} else if( 'cutdown' == target ) {
			target	= this.id+'-cutdown-button';
		} else if( 'save' == target ) {
			target	= this.id+'-maximize-button';
		}
		var newLeftArray	= new Array();
		var newRightArray	= new Array();
		// 左側ボタン
		for( var num=0; num < this.buttonLeftArray.length; num++ ) {
			if( this.buttonLeftArray[num].id != target ) {
				newLeftArray.push(this.buttonLeftArray[num]);
			}
		}
		// 右側ボタン
		for( var num=0; num < this.buttonRightArray.length; num++ ) {
			if( this.buttonRightArray[num].id != target ) {
				newRightArray.push(this.buttonRightArray[num]);
			}
		}
		this.buttonLeftArray	= newLeftArray;
		this.buttonRightArray	= newRightArray;
		this.reviewButtons();
	};

	// 閉じるボタン
	self.buttonClose		= new TextFormer.ButtonClose(self,closeMethod);
	self.addButton(self.buttonClose,'right');
	
	// 最大化ボタン
	self.buttonMaximize		= new TextFormer.ButtonMaximize(self);
	self.addButton(self.buttonMaximize,'right');

	// エリア拡張ボタン
	self.buttonSpread		= new TextFormer.ButtonSpread(self);
	self.addButton(self.buttonSpread,'right');

	// 縮小ボタン
	self.buttonCutdown		= new TextFormer.ButtonCutdown(self);
	self.addButton(self.buttonCutdown,'right');
	
	// 保存ボタン
	self.buttonSave		= new TextFormer.ButtonSave(self,saveMethod);
	self.addButton(self.buttonSave,'left');
	
	// タイトルを設定するメソッド
	self.setSubject = function( subject ) {
		this.subject	= subject;
		this.subjectPanel.innerHTML			= this.subject;
	};
	// 現在の行数を取得
	self.curLineCount = 0;
	self.countCurrentLines = function() {
		var editText	= this.getText().replace(TextFormer.CR+TextFormer.LF,TextFormer.LF);
		editText		= editText.replace(TextFormer.CR,TextFormer.LF);
		return editText.split(TextFormer.LF).length + 1;
	};
	// 行番号を再表示する
	self.rewriteLineNumber = function() {
		var lineCount	= this.countCurrentLines();
		if( this.curLineCount != lineCount ) {
			// 行数が増えていたら内部の数字を書きなおす
			this.curLineCount = lineCount;
			this.lineTextPanel.innerHTML	= '';
			for( var num=1; num<=lineCount; num++ ) {
				var lElm	= document.createElement('div');
				lElm.innerHTML	= String(num)+'\n';
				lElm.style.margin	= '0px';
				lElm.style.padding	= '0px';
				lElm.style.paddingRight	= '2px';
				this.lineTextPanel.appendChild(lElm);
			}
		}
		var pos = parseInt(this.textArea.scrollTop);
		this.lineTextPanel.style.marginTop	= String(-pos) + 'px';
	};
	// 現在のdivに合わせた最大行数を計算する
	self.setMaxLineCount = function() {
		var innerHeight		= this.clientHeight - this.buttonSave.height - ( this.defaultLineHeight );
		this.lineCount		= Math.floor( innerHeight / this.defaultLineHeight );
		if( this.lineCount < 11 ) {
			this.lineCount	= 11;
			this.style.height	= String( (this.defaultLineHeight*12) + this.buttonSave.height);
		}
	};
	// selfの大きさに中の部品をフィットさせます
	self.toFitInnerParts = function() {
		this.setMaxLineCount();
		// ボタンパネルのスタイル
		this.buttonPanel.style.width			= '100%';
		this.buttonPanel.style.height			= '24px';
		this.buttonPanel.style.background		= 'url('+TextFormer.path+'images/back_button_panel.gif) repeat-x';
		// 行数表示パネルのスタイル
		this.linePanel.style.margin					= '0px';
		this.linePanel.style.paddingBottom	= '0px';
		this.linePanel.style.overflow				= 'hidden';
		this.linePanel.style.width					= String(this.defautFontSize*3) + 'px';
		this.linePanel.style.styleFloat			= 'left';
		this.linePanel.style.cssFloat				= 'left';
		this.linePanel.style.textAlign			= 'right';
		this.linePanel.style.backgroundColor= '#EFEFEF';
		this.linePanel.style.color					= '#AAAAAA';
		this.linePanel.style.fontSize				= String(this.defautFontSize) + 'px';
		this.linePanel.style.lineHeight			= String(this.defaultLineHeight) + 'px';
		this.linePanel.style.borderStyle		= 'none';
		this.linePanel.style.borderWidth		= '0px';
		this.linePanel.style.height					= ( this.defaultLineHeight * this.lineCount ) + 'px';
		// テキストエリアのスタイル
		this.textArea.style.display				= 'block';
		this.textArea.style.margin				= '0px';
		this.textArea.style.width					= String(this.clientWidth-Math.floor(this.defautFontSize*3.5))+'px';
		this.textArea.style.styleFloat		= 'left';
		this.textArea.style.cssFloat			= 'left';
		this.textArea.style.borderStyle		= 'none';
		this.textArea.style.borderWidth		= '0px';
		this.textArea.style.fontFamily		= 'monospace';
		this.textArea.style.fontSize			= String(this.defautFontSize) + 'px';
		this.textArea.style.lineHeight		= String(this.defaultLineHeight) + 'px';
		this.textArea.style.height				= ( (this.defaultLineHeight * this.lineCount) - 5 ) + 'px';
		// 下部パネルのスタイル
		this.bottomPanel.innerHTML				= 'TextFormer ver 0.5 Powered By <a href="http://sourceforge.jp/projects/shopformer/" target="_blank">www.mds-tools.com</a>.';
		this.bottomPanel.style.fontSize			= '10px';
		this.bottomPanel.style.styleClear		= 'both';
		this.bottomPanel.style.cssClear			= 'both';
		this.bottomPanel.style.clear			= 'both';
		this.bottomPanel.style.textAlign		= 'right';
		this.bottomPanel.style.fontFamily		= 'monospace';
		this.bottomPanel.style.fontWeight		= '100';
		this.bottomPanel.style.fontSize			= String(Math.floor(this.defautFontSize*0.9)) + 'px';
		this.bottomPanel.style.lineHeight		= String(this.defaultLineHeight) + 'px';
		this.rewriteLineNumber();
	};
	// 入れ子の外側ブロックのサイズに合わせてselfの大きさを変更します
	self.toFitOuter = function() {
		if( TextFormer.currentMaxInstance
			&& TextFormer.currentMaxInstance.id == this.id ) {
			return;
		}
		if( this.parentNode.tagName == 'td'
			|| this.parentNode.tagName == 'TD'
			|| this.parentNode.tagName == 'th'
			|| this.parentNode.tagName == 'TH'
		) {
			// テーブル内の場合は外まで確認
			var node	= this.parentNode;
			while( node && node.tagName != 'TABLE' && node.tagName != 'table' ) {
				node	= node.parentNode;
			}
			if( node && node.parentNode && node.parentNode.clientWidth ) {
				this.style.width	= String(node.parentNode.clientWidth-10)+'px';
			} else if( node && node.parentNode && node.parentNode.style && node.parentNode.style.width ) {
				this.style.width		= String(parseInt(node.parentNode.style.width)-10)+'px';
			}
		} else if( this.parentNode && this.parentNode.clientWidth ){
			// テーブルでない場合で親のサイズが取得可能な場合
			this.style.width		= String(this.parentNode.clientWidth-10)+'px';
		} else if( this.parentNode && this.parentNode.style && this.parentNode.style.width ) {
			// テーブルでない場合で親のサイズをスタイルから取得できる場合
			this.style.width		= String(parseInt(this.parentNode.style.width)-10)+'px';
		} else {
			this.style.width		= '100%';
		}
		// 高さは固定40行に調整
		this.style.height	= String(this.defaultLineHeight*42 + 24) + 'px';
		this.toFitInnerParts();
	};
	// 現在のウィンドウ内で最大化します
	self.toMax = function() {
		TextFormer.currentMaxInstance	= this;
		this.orgWidth				= this.clientWidth;
		this.orgHeight				= this.clientHeight;
		this.style.position			= 'absolute';
		// 親ノードpositionのオールクリア
		var node				= this.parentNode;
		while( node && node.tagName != 'html' ) {
			if( node.style && node.style.position ) {
				node.sposbak		= node.style.position;
				node.style.position	= 'static';
			} else if( node.style ) {
				node.style.position	= 'static';
			}
			node				= node.parentNode;
		}
		this.style.top				= '0px';
		this.style.left				= '0px';
		this.style.zIndex			= '999';
		this.style.height			= String( FormerCommon.getPageHeight() ) + 'px';
		var cWidth	= 640;
		var cHeight	= 480;
		if( window.innerWidth ) {
			cWidth	= window.innerWidth;
			if( FormerCommon.getPageHeight() > window.innerHeight ) {
				cWidth	-= 20;
			}
			cHeight	= window.innerHeight;
		} else if ( document.documentElement ) {
			cWidth	= document.documentElement.clientWidth;
			cHeight	= document.documentElement.clientHeight;
		} else if (document.all) {
			cWidth	= document.body.clientWidth;
			cHeight	= document.body.clientHeight;
		} else {
			cWidth	= FormerCommon.getPageWidth();
			cHeight	= FormerCommon.getPageHeight();
		}
		this.style.width			= String( cWidth ) + 'px';
		this.style.height			= String( cHeight ) + 'px';
		this.removeButton('spread');
		this.removeButton('cutdown');
		this.toFitInnerParts();
	};
	// 最大化状態から復元します
	self.toMin = function() {
		TextFormer.currentMaxInstance	= null;
		// 親ノードpositionの復元
		var node				= this.parentNode;
		while( node && node.tagName != 'body' ) {
			if( node.style && node.sposbak ) {
				node.style.position	= node.sposbak;
				node.sposbak	= null;
			} else if( node.style ){
				node.style.position	= 'static';
			}
			node				= node.parentNode;
		}
		this.style.position			= 'static';
		this.addButton(this.buttonSpread,'right');
		this.addButton(this.buttonCutdown,'right');
		this.toFitOuter();
	};
	self.spread = function() {
		if( this.lineCount < 100 ) {
			this.lineCount	+= 5;
		}
		var spreadHeight			= this.defaultLineHeight * 5;
		var nextHeight				= this.defaultLineHeight * this.lineCount;
		this.style.height			= String( nextHeight + this.buttonSave.height + ( this.defaultLineHeight * 2 ) ) + 'px';
		this.toFitInnerParts();
	};
	self.cutdown = function() {
		if( this.lineCount > 5 ) {
			this.lineCount	-= 5;
		}
		var cutdownHeight			= this.defaultLineHeight * 5;
		var nextHeight				= this.defaultLineHeight * this.lineCount;
		this.style.height			= String(nextHeight + this.buttonSave.height + ( this.defaultLineHeight * 2 ) ) + 'px';
		this.toFitInnerParts();
	};
	// テキストエリア内ショートカットボタン処理
	self.textArea.onkeydown		= function(eve) {
		var downKey = '';
		var isCtrl  = false;
		var orgScroll	= this.scrollTop;
		this.textformer.rewriteLineNumber();
		if(eve){
			if(eve.keyCode != 0){
				downKey = eve.keyCode;
				isCtrl	= eve.ctrlKey;
			} else {
				downKey = eve.charCode;
				isCtrl	= eve.ctrlKey;
			}
		}else{
			if(event.keyCode != 0){
				downKey = event.keyCode;
				isCtrl	= event.ctrlKey;
			} else {
				downKey = event.charCode;
				isCtrl	= event.ctrlKey;
			}
		}
		if( isCtrl && downKey==83 ) {
			if(eve){
				eve.preventDefault();
				eve.stopPropagation();
				eve.cancelBubble=true;
				eve.returnValue=false;
			} else {
				event.keyCode = 0;
				event.cancelBubble=true;
				event.returnValue=false;
			}
			this.textformer.buttonSave.onclick(eve);
			return false;
		} else if( downKey == 9 ) {
			if(eve){
				var cursorPos = this.selectionStart;
				if((cursorPos == null) || (cursorPos == 0)) {
					this.value = this.value + "  ";
				} else {
					var textLength = this.value.length;
					var beforText = this.value.substr(0, cursorPos);
					var afterText = this.value.substr(cursorPos, textLength);
					this.value = beforText + "  " + afterText;
					this.setSelectionRange(cursorPos+2, cursorPos+2);
				}
			} else {
				var range = document.selection.createRange();
				range.text = "    ";
				range.select();
			}
			this.focus();
			this.scrollTop	= orgScroll;
			return false;
		}
	};
	self.remove = function() {
		var parentNode	= this.parentNode;
		parentNode.insertBefore(this.orgTextArea,this);
		parentNode.removeChild(this);
		var newTexformerArray	= new Array();
		for( var num=0; num<TextFormer.instansArray.length; num++ ){
			if( TextFormer.instansArray[num].id != this.id ){
				newTexformerArray.push(TextFormer.instansArray[num]);
			}
		}
		TextFormer.instansArray	= newTexformerArray;
	};
	self.toFitOuter();
	self.rewriteLineNumber();
	parentNode.removeChild(textAreaElement);
	var cmd	= 'document.getElementById("' + self.id + '").toFitOuter();';
	setTimeout(cmd,1000);
	setTimeout(cmd,3000);
	TextFormer.instansArray.push(self);
	return self;
}
TextFormer.LF	= String.fromCharCode(10);
TextFormer.CR	= String.fromCharCode(13);
TextFormer.TAB	= String.fromCharCode(9);
/**
 * 標準ボタン
 */
TextFormer.ButtonSave = function(textformerElement,saveMethod) {
	var self	= new TextFormer.ButtonCommon(
		textformerElement,
		textformerElement.id+'-save-button',
		TextFormer.path + 'images/button_save.gif',
		TextFormer.path + 'images/button_save_on.gif',
		saveMethod
	);
	return self;
}
TextFormer.ButtonSpread = function( textformerElement ) {
	var cmd		= 'this.textformerElement.spread();';
	var self	= new TextFormer.ButtonCommon(
		textformerElement,
		textformerElement.id+'-spread-button',
		TextFormer.path + 'images/button_expand.gif',
		TextFormer.path + 'images/button_expand_on.gif',
		cmd
	);
	return self;
}
TextFormer.ButtonCutdown = function( textformerElement ) {
	var cmd		= 'this.textformerElement.cutdown();';
	var self	= new TextFormer.ButtonCommon(
		textformerElement,
		textformerElement.id+'-cutdown-button',
		TextFormer.path + 'images/button_shrink.gif',
		TextFormer.path + 'images/button_shrink_on.gif',
		cmd
	);
	return self;
}
TextFormer.ButtonMaximize = function( textformerElement ) {
	var cmd		= 'this.changeImage();';
	var self	= new TextFormer.ButtonCommon(
		textformerElement,
		textformerElement.id+'-maximize-button',
		TextFormer.path + 'images/button_tomax.gif',
		TextFormer.path + 'images/button_tomax_on.gif',
		cmd
	);
	self.isMax			= false;
	self.changeImage	= function() {
		if( this.isMax ) {
			// 現在最大なら
			this.srcOff		= TextFormer.path + 'images/button_tomax.gif';
			this.srcOn		= TextFormer.path + 'images/button_tomax_on.gif';
			this.alt		= '最大化';
			this.src		= this.srcOff;
			this.textformerElement.toMin();
			this.isMax		= false;
		} else {
			// 現在通常なら
			this.srcOff		= TextFormer.path + 'images/button_tomin.gif';
			this.srcOn		= TextFormer.path + 'images/button_tomin_on.gif';
			this.alt		= '元に戻す';
			this.src		= this.srcOff;
			this.textformerElement.toMax();
			this.isMax		= true;
		}
	};
	return self;
}
TextFormer.ButtonClose = function( textformerElement, closeMethod ) {
	var self	= new TextFormer.ButtonCommon(
		textformerElement,
		textformerElement.id+'-close-button',
		TextFormer.path + 'images/button_close.gif',
		TextFormer.path + 'images/button_close_on.gif',
		closeMethod
	);
	return self;
}
/**
 * 汎用ボタンオブジェクト
 */
TextFormer.ButtonCommon = function(textformerElement,id,offImageUri,onImageUri,execString) {
	var self				= new Image();
	self.id					= id;
	self.textformerElement	= textformerElement;
	self.textformerId		= textformerElement.id;
	self.srcOff				= offImageUri;
	self.srcOn				= onImageUri;
	self.src				= self.srcOn;
	self.src				= self.srcOff;
	self.execString			= execString;
	self.onmouseover		= function(e) {
		this.src			= this.srcOn;
		this.style.cursor	= 'pointer';
	};
	self.onmouseout	= function(e) {
		this.src		= this.srcOff;
	};
	self.onclick	= function(e) {
		if( this.execString ) {
			var type	= typeof(this.execString);
			if( 'function' == type ) {
				this.execString;
			} else if( 'string' == type ) {
				eval(this.execString);
			}
		}
	};
	return self;
}
TextFormer.currentMaxInstance;
TextFormer.instansArray		= new Array();
TextFormer.resizeMax		= function() {
	for( var i=0; i<TextFormer.instansArray.length; i++ ) {
		if( TextFormer.currentMaxInstance
			&& TextFormer.currentMaxInstance.id == TextFormer.instansArray[i].id ) {
		} else {
			TextFormer.instansArray[i].toFitOuter();
		}
	}
	if( TextFormer.currentMaxInstance ) {
		var cWidth	= 640;
		var cHeight	= 480;
		if( window.innerWidth ) {
			cWidth	= window.innerWidth;
			if( FormerCommon.getPageHeight() > window.innerHeight ) {
				cWidth	-= 20;
			}
			cHeight	= window.innerHeight;
		} else if ( document.documentElement ) {
			cWidth	= document.documentElement.clientWidth;
			cHeight	= document.documentElement.clientHeight;
		} else if (document.all) {
			cWidth	= document.body.clientWidth;
			cHeight	= document.body.clientHeight;
		} else {
			cWidth	= FormerCommon.getPageWidth();
			cHeight	= FormerCommon.getPageHeight();
		}
		TextFormer.currentMaxInstance.style.width	= String( cWidth ) + 'px';
		TextFormer.currentMaxInstance.style.height	= String( cHeight ) + 'px';
		TextFormer.currentMaxInstance.toFitInnerParts();
	}
}
TextFormer.moveMax		= function() {
	for( var i=0; i<TextFormer.instansArray.length; i++ ) {
		if( TextFormer.currentMaxInstance
			&& TextFormer.currentMaxInstance.id == TextFormer.instansArray[i].id ) {
		} else {
			TextFormer.instansArray[i].toFitOuter();
		}
	}
	if( TextFormer.currentMaxInstance ) {
		var marginTop	= 0;
		if ( document.documentElement.clientHeight && document.documentElement.scrollHeight ) {
			marginTop	= document.documentElement.scrollTop;
		} else {
			marginTop	= document.body.scrollTop;
		}
		TextFormer.currentMaxInstance.style.top	= String(marginTop)+'px';
	}
}
if(window.attachEvent){
	window.attachEvent('onresize',TextFormer.resizeMax);
	window.attachEvent('onscroll',TextFormer.moveMax);
}else{
	window.addEventListener('resize',TextFormer.resizeMax,false);
	window.addEventListener('scroll',TextFormer.moveMax,false);
}