<?php
require_once(dirname(__FILE__).DIRECTORY_SEPARATOR.'functions.inc.php');
require_once(dirname(dirname(dirname(dirname(__FILE__)))).DIRECTORY_SEPARATOR.'define.inc.php');
class util_mobile_Terminal {
	
	/** 機種名	*/
	var $terminal_name;
	/** 携帯キャリア	*/
	var $carrier;
	/** 携帯ベンダ	*/
	var $vender;
	/** 携帯世代	*/
	var $generation;
	/** ユーザーエージェント	*/
	var $user_agent;
	/** ユーザーエージェント	*/
	var $user_agents	= array();
	/** 端末製造番号	*/
	var $terminal_id;
	/** SIMカードID	*/
	var $sim_id;
	/** 実際に接続しているユーザーエージェント	*/
	var $connect_agent;
	
	/**
	 * コンストラクタ
	 */
	function util_mobile_Terminal() {
	}
	/**
	 * インスタンス作成静的メソッド
	 */
	function getInstance() {
		$connect_agent	= $_SERVER['HTTP_USER_AGENT'];
//		$connect_agent	= 'DoCoMo/2.0 P900i(c100;TB;W24H11;serXXXXXXXXXXXXXXX;iccxxxxxxxxxxxxxxxxxxxx)';
		$is_defined	= false;
		foreach( $GLOBALS['SPIDER_USER_AGENT_CLASS_REGX_HASH'] as $regx_str => $carrier ) {
			if( preg_match( $regx_str, $connect_agent ) > 0 ) {
				$result_carrier	= $carrier;
				$is_defined			= true;
				break;
			}
		}
		if( $is_defined ) {
		} else {
			return null;
		}
		// キャッシュファイルのパス
		$cache_path	= DIR_PATH_CACHE.DIRECTORY_SEPARATOR.'util';
		if( !is_dir( $cache_path ) ) {
			if( @mkdir($cache_path,SPIDER_PERMITTION_DATA_FOLDER) ) {
				@chmod($cache_path,SPIDER_PERMITTION_DATA_FOLDER);
			} else {
				return false;
			}
		}
		$cache_path	.= DIRECTORY_SEPARATOR.'mobile';
		if( !is_dir( $cache_path ) ) {
			if( @mkdir($cache_path,SPIDER_PERMITTION_DATA_FOLDER) ) {
				@chmod($cache_path,SPIDER_PERMITTION_DATA_FOLDER);
			} else {
				return false;
			}
		}
		$cache_path	.= DIRECTORY_SEPARATOR.$result_carrier.'.ca';
		$target_carrier_hash	= array();
		if( !file_exists($cache_path) ) {
			if( 'docomo2' == $result_carrier ) {
				$target_carrier_hash	= util_mobile_getDoCoMoAgentHash();
			} else if( 'docomo' == $result_carrier ) {
				$target_carrier_hash	= util_mobile_getDoCoMoAgentHash();
			} else if( 'au' == $result_carrier ) {
				$target_carrier_hash	= util_mobile_getAuAgentHash();
			} else if( 'softbank' == $result_carrier ) {
				$target_carrier_hash	= util_mobile_getSoftBankAgentHash();
			}
			$str	= serialize( $target_carrier_hash );
			$fp		= @fopen( $cache_path, 'w' );
			if( $fp ) {
				if (@flock($fp, LOCK_EX)) {
					@fwrite( $fp, $str );
					@flock($fp, LOCK_UN);
				} else {
					return false;
				}
				@fclose( $fp );
			} else {
				return false;
			}
		} else {
			$str					= file_get_contents( $cache_path );
			$target_carrier_hash	= unserialize($str);
		}

		$terminal_object				= null;
		foreach( $target_carrier_hash as $matches => $object ) {
			$matches	= str_replace('/','\\/',$matches );
			$matches	= str_replace('.','\\.',$matches );
			$matches	= str_replace('(','\\(',$matches );
			$matches	= str_replace(')','\\)',$matches );
			$matches	= str_replace('[','\\[',$matches );
			$matches	= str_replace(']','\\]',$matches );
			$matches	= '/'.$matches.'/';
			if( preg_match( $matches, $connect_agent ) > 0 ) {
				$object->connect_agent	= $connect_agent;
				if( 'docomo2' == $result_carrier ) {
					$object->perseSubscririberIdFromDoCoMo();
				} else if( 'docomo' == $result_carrier ) {
					$object->perseSubscririberIdFromDoCoMo();
				} else if( 'au' == $result_carrier ) {
					$object->terminal_id = $_SERVER['HTTP_X_UP_SUBNO'];
				} else if( 'softbank' == $result_carrier ) {
					$object->perseSubscririberIdFromSoftBank();
				}
				return $object;
			}
		}
		return null;
	}
	/**
	 * DoCoMo terminal ID
	 */
	function perseSubscririberIdFromDoCoMo() {
		if ( ereg( "DoCoMo\\/1.0", $this->connect_agent ) ) {
			$str = substr( $this->connect_agent, strpos( $this->connect_agent, "/ser" ) );
			$this->terminal_id = str_replace( "/ser", "", $str );
		} else {
			$str = substr( $this->connect_agent, strpos( $this->connect_agent, "(" ) );
			$str = substr( $this->connect_agent, 0, strpos( $this->connect_agent, ")" ) );
			$val_array = explode( ";", $str );
			foreach ( $val_array as $val ) {
				if ( ereg( "ser", $val ) ) {
					// ser
					$this->terminal_id = str_replace( "ser", "", $val );
				} else if ( ereg( "icc", $val ) ) {
					// icc
					$this->sim_id = str_replace( "icc", "", $val );
				}
			}
		}
	}
	/**
	 * softbank
	 */
	function perseSubscririberIdFromSoftBank() {
		$val_array	= explode( "/", $this->connect_agent );
		$tid_str	= "";
		foreach ( $val_array as $val ) {
			if ( ereg( "^SN", $val ) ) {
				$tid_str = $val;
				list( $sn, $browser ) = explode( " ", $tid_str );
				$this->terminal_id = str_replace( "SN", "", $sn );
				break;
			}
			if(strlen($this->terminal_name)>0){
				$this->terminal_name	.= "/";
			}
			$this->terminal_name	.= $val;
		}
	}
}
?>