<?php
/**
 * 
 */
class util_mobile_PictCharConverter {
	function util_mobile_PictCharConverter() {
	}
	function convert( $strings, $from='docomou', $to='auto', $convert_escaped=false, $target_encoding='UTF-8' ) {
		$USER_AGENT_TYPE_REGX_ARRAY	= array(
			'/^KDDI\\-/'							=> 'au',
			'/^UP\\.Browser\\/[0-9\\.]+\\-/'	=> 'au',
			'/^J\\-PHONE/'						=> 'softbank',
			'/^Vodafone/'							=> 'softbank',
			'/^SoftBank/'							=> 'softbank',
			'/^DoCoMo\\/2/'						=> 'docomou',
			'/^DoCoMo\\/1/'						=> 'docomos',
		);
		if( preg_match('/^[aA][uU][tT][oO]$/', $to ) > 0 ) {
			$agent	= $_SERVER['HTTP_USER_AGENT'];
			foreach( $USER_AGENT_TYPE_REGX_ARRAY as $regx => $name ) {
				if( preg_match($regx,$agent) > 0 ) {
					$to	= $name;
					break;
				}
			}
		}
		if( $from != $to ) {
			$rule_file_path	= dirname(__FILE__).DIRECTORY_SEPARATOR.'rules'
				.DIRECTORY_SEPARATOR.$from.'2'.$to.'.inc.php'
			;
			if( file_exists( $rule_file_path ) ) {
				require_once( $rule_file_path );
				$hash_name	= 'PICT_CHAR_'.strtoupper($from.'2'.$to);
				foreach( $GLOBALS[$hash_name] as $key => $value ) {
					if( strtoupper($target_encoding) != 'UTF-8' ) {
						// 変換対象文字列の文字コードがUTF-8でないならキーを変換対象文字コードに合わせる
						$key	= mb_convert_encoding($key,$target_encoding,'UTF-8');
					}
					$strings	= str_replace( $key, $value, $strings );
					if( $convert_escaped ) {
						$nkey		= htmlspecialchars( $key );
						$strings	= str_replace( $nkey, $value, $strings );
					}
				}
			}
		}
		return $strings;
	}
}
?>