<?php
/*
 * topic/LoadList.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once(dirname(__FILE__)
.DIRECTORY_SEPARATOR.'PackageConfig.class.php');
class topic_LoadList extends system_login_ModuleBase {
	function topic_LoadList() {
	}
	function execute( & $request ) {
		
		
		if( !defined('TOPIC_FILE_URI_TOPICS') || strlen(TOPIC_FILE_URI_TOPICS)==0 ) {
			$request->addError('設定が正しく行われていません。');
			return false;
		}
		
		// ページング
		$pageRows			= stripslashes( $_GET['pr'] );
		$pageNumber			= stripslashes( $_GET['pn'] );
		if( preg_match('/^[0-9]{1,7}$/',$pageNumber) == 0 ) {
			$pageNumber		= 1;
		}
		if( preg_match('/^[0-9]{1,3}$/',$pageRows) == 0 ) {
			$pageRows		= 20;
		}
		$offset		= $pageRows * ( $pageNumber - 1 );
		$totalCount	= 0;
		$totalPage	= 0;
		$topicObjectHash	= array();
		$topicFilePath	= system_DataFileWriter::getRealAbsolutePath( $request, TOPIC_FILE_URI_TOPICS, DIR_NAME_DATA );
		if( $topicFilePath ) {
			if( !file_exists($topicFilePath) ) {
				if( @touch( $topicFilePath ) ) {
					@chmod( $topicFilePath, 0666 );
				}
			} else {
				// ファイルがあるなら読み込み
				$fpr	= @fopen( $topicFilePath, 'r' );
				if( $fpr ) {
					$currentLineNumber	= 0;
					while (!feof($fpr)) {
						$line = trim(fgets($fpr));
						if( strlen($line) > 0 ) {
							if( $currentLineNumber >= $offset && $currentLineNumber < $offset + $pageRows) {
								$topicObj	= spider_Controller::createObject('topic_Topic');
								$topicObj->setFieldByCsvLine( $line );
								$topicObjectHash[$currentLineNumber]	= $topicObj;
							}
							$currentLineNumber++;
						}
					}
					$totalCount	= $currentLineNumber;
					$totalPage	= ceil($totalCount/$pageRows);
					@fclose($fpr);
				} else {
					$request->addError('記事一覧ファイルのオープンに失敗しました。');
				}
			}
		}
		
		$request->setAttribute('topic.topicObjectHash',$topicObjectHash);
		$request->setAttribute('topic.totalCount',$totalCount);
		$request->setAttribute('topic.totalPage',$totalPage);
		$request->setAttribute('topic.pageNumber',$pageNumber);
		$request->setAttribute('topic.pageRows',$pageRows);
	}
}
?>