<?php
/*
 * topic/Confirm.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once(dirname(__FILE__)
.DIRECTORY_SEPARATOR.'PackageConfig.class.php');
class topic_Confirm extends system_login_ModuleBase {
	function topic_Confirm() {
	}
	function execute( & $request ) {
		
		$topicId				= stripslashes( $_GET['tid'] );
		$sessionObjectName		= 'topic.modify.object.'.$topicId;
		$sessionConfirmName		= 'topic.modify.confirm.'.$topicId;
		$topicObject			= spider_Controller::createObject('topic_Topic');
		$loginUserObject		= $this->getLoginUserObject( $request );
		$request->removeSession($sessionConfirmName);
		
		if( strlen($topicId) == 0 ) {
			// 記事ID未指定の場合は新規作成
			$topicObject	= spider_Controller::createObject('topic_Topic');
			$topicObject->convertForView( $request );
		} else if( preg_match('/^[0-9]+$/',$topicId) == 0 ) {
			// 記事IDが不正
			$request->addError('記事の指定方法が正しくありません。');
		} else {
			// 番号指定があるなら記事を読み込み
			$topicObject	= spider_Controller::createObject('topic_Topic');
			if( $topicObject->load( $request, $topicId ) ) {
				// 表示の為の調整
				$topicObject->convertForView( $request );
			} else {
				$request->addError('指定された記事は存在しません。');
			}
		}

		// 入力値のセットとチェック
		$topicObject->topicDate_year	= trim(stripslashes($_POST['topicDate_year']));
		$topicObject->topicDate_month	= trim(stripslashes($_POST['topicDate_month']));
		$topicObject->topicDate_day		= trim(stripslashes($_POST['topicDate_day']));
		$topicObject->topicDate_hour	= trim(stripslashes($_POST['topicDate_hour']));
		$topicObject->topicDate_min		= trim(stripslashes($_POST['topicDate_min']));
		$topicObject->topicDate_sec		= trim(stripslashes($_POST['topicDate_sec']));
		
		$topicObject->templateFile		= trim(stripslashes($_POST['templateFile']));
		$topicObject->subject			= trim(stripslashes($_POST['subject']));
		$topicObject->author			= trim(stripslashes($_POST['author']));
		$topicObject->category			= trim(stripslashes($_POST['category']));
		$topicObject->description		= trim(stripslashes($_POST['description']));
		$topicObject->body				= trim(stripslashes($_POST['body']));
		$topicObject->enableNl2Br		= trim(stripslashes($_POST['enableNl2Br']));
		$topicObject->enableHtml		= trim(stripslashes($_POST['enableHtml']));
		
		// 改行コード統一
		$topicObject->description	= str_replace("\r\n","\n",$topicObject->description);
		$topicObject->description	= str_replace("\r","\n",$topicObject->description);
		$topicObject->body			= str_replace("\r\n","\n",$topicObject->body);
		$topicObject->body			= str_replace("\r","\n",$topicObject->body);
		
		// 投稿題名
		if( strlen(trim($topicObject->subject)) == 0 ) {
			$request->addError('タイトルは必ず入力してください。');
		} else if( strlen(trim($topicObject->subject)) > 180 ) {
			$request->addError('タイトルは全角60文字以内で入力してください。');
		}
		// 配信者名
		if( strlen(trim($topicObject->author)) == 0 ) {
			$request->addError('配信者名は必ず入力してください。');
		} else if( strlen(trim($topicObject->author)) > 180 ) {
			$request->addError('配信者名は全角60文字以内で入力してください。');
		}
		// 記事カテゴリ
		if( strlen(trim($topicObject->category)) == 0 ) {
		} else if( strlen(trim($topicObject->category)) > 180 ) {
			$request->addError('記事カテゴリは全角60文字以内で入力してください。');
		}
		// 記事概要
		if( strlen(trim(strip_tags($topicObject->description))) == 0 ) {
			$request->addError('記事概要は必ず入力してください。');
		} else if( strlen(trim(strip_tags($topicObject->description))) > 180 ) {
			$request->addError('記事概要は全角60文字以内で入力してください。');
		}
		// 本文
		if( strlen(trim($topicObject->body)) == 0 ) {
			$request->addError('本文は必ず入力してください。');
		} else if( strlen(trim($topicObject->body)) > 15000 ) {
			$request->addError('本文は全角5千文字以内で入力してください。');
		}
		// 投稿日時
		if( preg_match('/^[0-9]{4}$/',$topicObject->topicDate_year) == 0
			|| preg_match('/^[0-9]{1,2}$/',$topicObject->topicDate_month) == 0
			|| preg_match('/^[0-9]{1,2}$/',$topicObject->topicDate_day) == 0 ) {
			$request->addError('記事の日付を正しく入力してください。');
			$topicObject->topicDate	= '';
		} else if( checkdate($topicObject->topicDate_month,$topicObject->topicDate_day,$topicObject->topicDate_year) ) {
			$topicObject->topicDate		= $topicObject->topicDate_year
				.'-'.$topicObject->topicDate_month.'-'.$topicObject->topicDate_day;
		} else {
			$topicObject->topicDate	= '';
		}
		if( strlen($topicObject->topicDate) > 0 ) {
			if( preg_match('/^[0-9]{1,2}$/',$topicObject->topicDate_hour) > 0
				&& $topicObject->topicDate_hour >= 0
				&& $topicObject->topicDate_hour < 24
				&& preg_match('/^[0-9]{1,2}$/',$topicObject->topicDate_min) > 0
				&& $topicObject->topicDate_min >= 0
				&& $topicObject->topicDate_min < 60
				&& preg_match('/^[0-9]{1,2}$/',$topicObject->topicDate_sec) > 0
				&& $topicObject->topicDate_sec >= 0
				&& $topicObject->topicDate_sec < 60
			) {
				$topicObject->topicDate		.= ' '.$topicObject->topicDate_hour
					.':'.$topicObject->topicDate_min.':'.$topicObject->topicDate_sec;
			}
		}
		
		if( $request->isError() ) {
			$request->removeSession($sessionConfirmName);
		} else {
			$request->setSession($sessionConfirmName,'OK');
		}
		$request->setSession($sessionObjectName,$topicObject);
		$request->setAttribute('topic.topicObject',$topicObject);
	}
}
?>