<?php
/*
 * system/package/LoadListExists.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once(dirname(dirname(__FILE__))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php');
/**
 * spider : 管理者パッケージ 全一覧取得用アクションモジュールクラス
 * 
 * spiderのページから呼び出して実行します。
 * 
 * @package system
 * @subpackage package
 * @category module
 * @version 1.2.00
 * @copyright Copyright(c)2011, Shopformer Development Team. <shopformer-dev@lists.sourceforge.jp>
 * @author Masanori Nakashima
 * @access public
 * @abstract
 */
class system_package_LoadListExists extends system_login_ModuleBase {
	function system_package_LoadListExists() {
	}
	function execute( & $request ) {

		$package_array	= array();
		$lib_dir	= DIR_PATH_LIB;
		if ( is_dir( $lib_dir ) ) {
			if ( $dh = opendir($lib_dir) ) {
				while (($name = readdir($dh)) !== false) {
					$file_path	= $lib_dir . DIRECTORY_SEPARATOR . $name;
					$file_type	= filetype($file_path);
					if( is_dir($file_path) && !preg_match('/^\\./',$name ) ) {
						$package_config_path	= $file_path.DIRECTORY_SEPARATOR."PackageConfig.class.php";
						if( file_exists($package_config_path) ) {
							require_once( $package_config_path );
							$config_object_name	= $name."_PackageConfig";
							$config_object	= new $config_object_name;
							$package_array[$name]	= $config_object;
						}
					}
				}
				closedir($dh);
			}
		}
		// パッケージを並べ替える
		$package_order_hash	= array();
		foreach( $package_array as $key => $config_object ) {
			if( !isset($package_order_hash[$config_object->getPackageOrder()]) || !is_array( $package_order_hash[$config_object->getPackageOrder()] ) ) {
				$package_order_hash[$config_object->getPackageOrder()]	= array();
			}
			array_push( $package_order_hash[$config_object->getPackageOrder()], $config_object );
		}
		ksort( $package_order_hash );
		$package_ordered_array	= array();
		foreach( $package_order_hash as $package_array ) {
			foreach( $package_array as $config_object ) {
				$package_ordered_array[$config_object->getPackageId()]	= $config_object;
			}
		}
		$request->setAttribute( 'system.package.existsPackageObjectHash', $package_ordered_array );
	}
	function post_process( & $request ) {
	}
}
?>