<?php
/*
 * system/login/UserGuest.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once(dirname(__FILE__).DIRECTORY_SEPARATOR.'AbstractUser.class.php');
/**
 * システム管理者情報を保持するsystem_login_AbstractUserクラスの実装オブジェクトクラス
 * @package system
 * @subpackage login
 * @category DAO
 * @version 1.2.00
 * @copyright Copyright(c)2011, Shopformer Development Team. <shopformer-dev@lists.sourceforge.jp>
 * @author Masanori Nakashima
 * @access public
 */
class system_login_UserGuest extends system_login_AbstractUser {
	/** 最終ログイン日時	*/
	var $lastLoginDate;
	/** 最終アクセスユーザーエージェント	*/
	var $userAgent;
	/** 最終アクセスリモートアドレス	*/
	var $remoteAddress;
	/**
	 * コンストラクタ
	 */
    function system_login_UserGuest() {
    }
	/**
	 * ログインIDからユーザーを読み込む抽象メソッド
	 * @param object $request spider_HttpRequestクラスのインスタンス
	 * @param string $loginId ログインID
	 * @return boolean 一意のユーザを読み込むことができればtrue
	 */
	function loadLoginUser( & $request, $loginId ) {
		return true;
	}
	/**
	 * ユーザー固有のIDを取得します
	 */
	function getUniqueId() {
		return session_id();
	}
	/**
	 * ログインIDを取得します
	 */
	function getLoginId(){
		return session_id();
	}
	/**
	 * ログインパスワードを取得します
	 */
	function getLoginPassword(){
		return '';
	}
	/**
	 * ログインパスワードを照合します
	 * @param spider_HttpRequest &$request spider_HttpRequestクラスオブジェクトの参照
	 * @param string $inputPassword 入力されたパスワード
	 * @return boolean パスワードが一致したらtrue
	 */
	function confirmPassword( & $request, $inputPassword ) {
		return false;
	}
	/**
	 * ログインパスワードをランダムに再発行します
	 * @param spider_HttpRequest &$request spider_HttpRequestクラスオブジェクトの参照
	 * @return mixed 新しく発行したパスワード文字列。再発行に失敗したらfalse。
	 */
	function renewPassword( & $request ) {
		return false;
	}
	/**
	 * ログイン者の表示名称を取得します
	 */
	function getUserViewName() {
		return 'ゲスト';
	}
	/**
	 * 最終ログイン日時を設定します
	 * @param $lastLoginDatetime
	 */
	function setLastLoginDate($lastLoginDatetime) {
		$this->lastLoginDate	= $lastLoginDatetime;
		return true;
	}
	/**
	 * 最終ログイン日時を取得します
	 */
	function getLastLoginDate(){
		return $this->lastLoginDate;
	}
	/**
	 * ログイン時のユーザーエージェントを設定します
	 */
	function setLoginUserAgent( $userAgent ) {
		$this->userAgent	= $userAgent;
		return true;
	}
	/**
	 * ログイン時のユーザーエージェントを取得します
	 */
	function getLoginUserAgent() {
		return $this->userAgent;
	}
	/**
	 * ログイン時のリモートアドレスを設定します
	 */
	function setLoginRemoteAddress($remoteAddress) {
		$this->remoteAddress	= $remoteAddress;
		return true;
	}
	/**
	 * ログイン時のリモートアドレスを取得します
	 */
	function getLoginRemoteAddress(){
		return $this->remoteAddress;
	}
	/**
	 * システムグループレベルを取得します
	 * SYSTEM_LOGIN_USER_ADMINISTRATORS 0 管理者グループ
	 * SYSTEM_LOGIN_USER_POWERS パワーユーザーグループ
	 * SYSTEM_LOGIN_USER_USERS 一般ユーザーグループ
	 * SYSTEM_LOGIN_USER_GUEST ゲストユーザー グループ
	 */
	function getLoginGroupLevel(){
		return SYSTEM_LOGIN_USER_GUEST;
	}
	/**
	 * 指定のパッケージIDを利用する権限があるか確認します
	 */
	function hasPackagePermittion( $packageId ) {
		// ゲストなので全てfalseを返す
		return true;
	}
	/**
	 * 指定のURIを表示する権限があるか確認します
	 */
	function hasUriPermittion( $uri ) {
		return false;
	}
	//
	// データ扱いの権限に関するメソッド
	//
	/**
	 * 本オブジェクトのデータを渡されたAbstractUserが閲覧できるか確認します
	 * @param &$request spider_HttpRequestオブジェクト
	 * @param $abstractUser system_login_AbstractUser実装クラスインスタンス
	 */
	function canViewData( & $request, $abstractUser ) {
		return true;
	}
	/**
	 * 渡されたAbstractDataオブジェクトに対する編集権限があるか確認します
	 * @param &$request spider_HttpRequestオブジェクト
	 * @param $abstractUser system_login_AbstractUser実装クラスインスタンス
	 */
	function canEditData( & $request, $abstractUser ) {
		return true;
	}
	//
	// パスワードリマインダ関連
	//
	/**
	 * パスワードリマインダメールを送信
	 * @param $request spider_HttpRequestオブジェクト参照
	 * @param $targetAddress 送信ターゲットメールアドレス指定
	 */
	function sendPaswordReminder( & $request, $targetAddress ) {
		return false;
	}
	/**
	 * このユーザー宛てにメールを送信
	 * @param $request spider_HttpRequestオブジェクト参照
	 * @param $targetAddress 送信ターゲットメールアドレス指定
	 * @param $templateName メールテンプレート名
	 * @param $bcc ブラインドカーボンコピーアドレス
	 * @return 成功したらtrue、失敗したらfalse
	 */
	function sendInformationMail( & $request, $targetAddress, $templateName='', $bcc=null ) {
		return false;
	}
	/**
	 * 送信メールテンプレート情報を名称から取得
	 * @param $request spider_HttpRequestオブジェクト参照
	 * @param $templateName メールテンプレート名
	 * @return array array('subject'=>[], 'text_body'=>[], 'html_body'=>[] )
	 */
	function getMailInformation( & $request, $templateName ) {
		return false;
	}
}
?>