<?php
/*
 * system/login/Exists.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once( dirname(__FILE__)
.DIRECTORY_SEPARATOR.'ModuleBase.class.php');
/**
 * ログイン用アクションモジュールクラス
 * 
 * 管理システムにログインする機能を提供します。
 * ログイン情報読み込みの処理は設定ファイルに指定されたsystem_admin_IFLoginインターフェースの
 * 実装に移譲します。設定ファイルにログイン情報読み込み処理が指定されていない場合、
 * システム管理者ログイン情報を利用してログイン処理を行います。
 * 
 * @package system
 * @subpackage login
 * @category module
 * @version 1.2.00
 * @copyright Copyright(c)2011, Shopformer Development Team. <shopformer-dev@lists.sourceforge.jp>
 * @author Masanori Nakashima
 * @access public
 */
class system_login_Exists extends system_login_ModuleBase {
	function system_login_Exists(){
	}
	function execute( & $request ) {

		$userClassNameArray	= array();
		if( !$request->isError() ) {
			// 全てのユーザー定義クラスの読み込み
			$userClassNameArray	= $this->getUserClassName($request);
		}

		$command	= stripslashes( $_GET['cmd'] );
		$keyId		= '';
		$uniqueId	= '';
		if( preg_match('/[uU][nN][iI][qQ][uU][eE]/',$command) > 0 ) {
			$keyId		= stripslashes( $_GET['uid'] );
			$uniqueId	= stripslashes( $_GET['uidorg'] );
			if ( strlen( $keyId ) < 1 ) {
				$request->addLocaledError('system.error.login.user.requireid',SPIDER_LOG_LEVEL_ERROR,array());
			}
		} else {
			$keyId		= stripslashes( $_GET['lid'] );
			$uniqueId	= stripslashes( $_GET['uid'] );
			if ( strlen( $keyId ) < 1 ) {
				$request->addLocaledError('system.error.login.user.requireloginid',SPIDER_LOG_LEVEL_ERROR,array());
			}
		}
		if( !$request->isError() ) {
			// 全ての定義クラスで優先順に指定ログインIDの情報を読み込めるか確認
			$this->existsLoginUser( $request, $userClassNameArray, $keyId, $uniqueId, $command );
		}
	}
	/**
	 * 全てのユーザー定義クラスの取得
	 */
	function getUserClassName( $request ) {
		return system_PackageConfig::loadAllUserClassFile( $request );
	}
	/**
	 * 全ての定義クラスで優先順に指定IDの情報を読み込めるか確認
	 */
	function existsLoginUser( & $request, $userClassNameArray, $keyId, $uniqueId, $command ) {
		$loginInformationObject	= null;
		$isExists		= false;
		$isRegistable	= true;
		foreach( $userClassNameArray as $userClassName ) {
			if( class_exists($userClassName) ) {
				$loginInformationObject	= new $userClassName;
				if( is_a($loginInformationObject,'system_login_AbstractUser') ) {
					// ユーザークラスの実装として定義されている
					if( preg_match('/[uU][nN][iI][qQ][uU][eE]/',$command) > 0 ) {
						if( $loginInformationObject->loadLoginUserByUniqueId( $request, $keyId ) ) {
							$isExists	= true;
						}
					} else {
						if( $loginInformationObject->loadLoginUser( $request, $keyId ) ) {
							$isExists	= true;
						}
					}
					if ( $isExists === true ) {
						if( $uniqueId == $loginInformationObject->getUniqueId() ) {
							$isRegistable	= true;
						} else {
							$isRegistable	= false;
						}
						break;
					}
				} else {
					// AbstractUserの実装ではない
					$request->addLocaledError('system.error.config.invalidsendclassname',SPIDER_LOG_LEVEL_ERROR,array($userClassName));
					break;
				}
			}
		}
		$request->setAttribute('system.login.isExistsLoginId',$isExists);
		$request->setAttribute('system.login.isRegistableLoginId',$isRegistable);
	}
}
?>