<?php
/*
 * system/define.inc.php
 * systemパッケージ変数定義用ファイル
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
/** パッケージバージョン	*/
define('SYSTEM_VERSION', '1.2.00');
/** システム設定保存フォルダ名		*/
define('SYSTEM_DIR_NAME_CONFIGURATION',	'system' );
/** システム設定保存ファイル名		*/
define('SYSTEM_FILE_NAME_CONFIGURATION',	'configuration.dat' );

/** システム設定保存フォルダパス	*/
define('SYSTEM_DIR_PATH_CONFIGURATION',	DIR_PATH_DATA.DIRECTORY_SEPARATOR.SYSTEM_DIR_NAME_CONFIGURATION);
/** システム設定保存ファイルパス	*/
define('SYSTEM_FILE_PATH_CONFIGURATION',	SYSTEM_DIR_PATH_CONFIGURATION.DIRECTORY_SEPARATOR.SYSTEM_FILE_NAME_CONFIGURATION);

/** ユーザ：管理者デフォルト表示名	*/
define( 'SYSTEM_LOGIN_ADMINISTRATOR_NAME',					'システム管理者' );
/** ユーザ：管理者ユーザID	*/
define( 'SYSTEM_LOGIN_ADMINISTRATOR_USER_ID',				'SYSADMIN');
/** ユーザ：管理者デフォルトログインID	*/
define( 'SYSTEM_LOGIN_ADMINISTRATOR_LOGIN_ID',			'admin' );
/** ユーザ：管理者デフォルトログインパスワード	*/
define( 'SYSTEM_LOGIN_ADMINISTRATOR_LOGIN_PASSWORD',		'admin' );
/** 特権管理者情報保存ファイル名称			*/
define( 'SYSTEM_LOGIN_FILE_NAME_ADMINISTRATOR_SAVE',		'administrator' );
/** 特権管理者情報保存ファイルパス			*/
define( 'SYSTEM_LOGIN_FILE_PATH_ADMINISTRATOR_SAVE',
	SYSTEM_DIR_PATH_CONFIGURATION.DIRECTORY_SEPARATOR.SYSTEM_LOGIN_FILE_NAME_ADMINISTRATOR_SAVE );

/** セッション名称：ログインベースURI	*/
define( 'SYSTEM_SESSION_NAME_LOGIN_BASE_URI',	'system.login.login_base_uri' );

/** セッション名称：最後に閲覧しようとしたログインエラーページ	*/
define( 'SYSTEM_SESSION_NAME_LAST_LOGIN_ERROR_URI',	'system.login.require_login.uri.'.str_replace('/','.',SPIDER_ORG_URI_BASE) );
/** セッション名称：ログインユーザーのログインユーザーオブジェクト	*/
define( 'SYSTEM_SESSION_NAME_LOGIN_INFORMATION', 'system.login.information'.str_replace('/','.',SPIDER_ORG_URI_BASE) );
/** セッション名称：ログインユーザーが利用しているログインユーザー定義クラス	*/
define( 'SYSTEM_SESSION_NAME_LOGIN_CLASS_NAME', 'system.login.class_name'.str_replace('/','.',SPIDER_ORG_URI_BASE) );
/** セッション名称：インストールオブジェクトハッシュ保存名	*/
define( 'SYSTEM_SESSION_NAME_PACKAGE_INSTALL_OBJECT_HASH',		'system.package.install.config_object_array' );
/** セッション名称：インストール確認保存名	*/
define( 'SYSTEM_SESSION_NAME_PACKAGE_INSTALL_CONFIRM_RESULT',	'system.package.install.confirm_result' );
/** セッション名称：インストール総数保存名	*/
define( 'SYSTEM_SESSION_NAME_PACKAGE_INSTALL_TOTAL_COUNT', 'system.package.install.total_count');
/** クッキー名称：ログインクッキー	*/
define( 'SYSTEM_COOKIE_NAME_LOGIN_ID',	'MDSMID' );
/** クッキー名称：ログインパスワード	*/
define( 'SYSTEM_COOKIE_NAME_LOGIN_PASSWORD',	'MDSMPW' );

/** ログインユーザーグループ：システム管理者グループ	*/
define( 'SYSTEM_LOGIN_USER_ADMINISTRATORS',	0 );
/** ログインユーザーグループ：パワーユーザーグループ	*/
define( 'SYSTEM_LOGIN_USER_POWERS',				10 );
/** ログインユーザーグループ：一般ユーザーグループ	*/
define( 'SYSTEM_LOGIN_USER_USERS',				100 );
/** ログインユーザーグループ：ゲストユーザーグループ	*/
define( 'SYSTEM_LOGIN_USER_GUEST',				200 );


/** メール送信方法	*/
$GLOBALS['SYSTEM_SEND_METHOD']	= array(
	'sendmail'	=> array( 'class_name' => 'SendMail', 'view_name' => 'sendmailコマンド' ),
	'phpmail'	=> array( 'class_name' => 'PHP', 'view_name' => 'PHP mail関数' ),
	'smtp'		=> array( 'class_name' => 'SMTP', 'view_name' => 'SMTP接続' ),
);

/** パスワード再通知メールハッシュ	*/
$GLOBALS['SYSTEM_TOOLS_NOTIFY_MAIL_BODY_HASH'] = array(
	'default'	=> 'デフォルト',
	'mobile'	=> 'モバイル用',
);

if( defined('DIR_PATH_DATA') && !file_exists( SYSTEM_DIR_PATH_CONFIGURATION ) ){
	if( @mkdir(SYSTEM_DIR_PATH_CONFIGURATION,SPIDER_PERMITTION_DATA_FOLDER) ) {
		@chmod(SYSTEM_DIR_PATH_CONFIGURATION,SPIDER_PERMITTION_DATA_FOLDER);
	} else {
		die('Fatal Error');
	}
}
if( file_exists(DIR_PATH_DATA.DIRECTORY_SEPARATOR.'system.define.inc.php') ) {
	require_once(DIR_PATH_DATA.DIRECTORY_SEPARATOR.'system.define.inc.php');
}
?>