<?php
/**
 * framework-spider: Web execute main file
 * 
 * CopyRight(C)Framework-Spider Developer Team. 2011. All Right Reserved.<br /> 
 * URL         : http://sourceforge.jp/projects/frameworkspider/<br />
 * Mail        : frameworkspider-dev@lists.sourceforge.jp<br />
 * Auther      : Masanori Nakashima<br />
 * Modifier    : Masanori Nakashima<br />
 * Last Updated: 2011.04.11<br />
 * 
 * @package spider
 * @version 1.3.00
 * @copyright Copyright(c)2010, Masanori Nakashima <m_nakashima@users.sourceforge.jp>
 * @author Masanori Nakashima <m_nakashima@users.sourceforge.jp>
 * @access public
 */
// read system definition if file exists
if( defined('FILE_PATH_SYSTEM_DEFINITION')
&& file_exists( FILE_PATH_SYSTEM_DEFINITION ) ){
	require_once( FILE_PATH_SYSTEM_DEFINITION );
}

// create main object
require_once(dirname(__FILE__).DIRECTORY_SEPARATOR.'HttpRequest.class.php');
require_once(dirname(__FILE__).DIRECTORY_SEPARATOR.'HttpOutput.class.php');
require_once(dirname(__FILE__).DIRECTORY_SEPARATOR.'Controller.class.php');
$GLOBALS['request'] = new spider_HttpRequest();
$GLOBALS['request_object'] = & $GLOBALS['request'];
$GLOBALS['output'] = new spider_HttpOutput();
$GLOBALS['output_object'] = & $GLOBALS['output'];
$GLOBALS['controller'] = new spider_Controller($GLOBALS['request'],$GLOBALS['output']);
// exec file check
$actionFilePath = realpath($_SERVER['SCRIPT_FILENAME']);
if ( str_replace( '\\', '/', realpath(__FILE__) )
== str_replace( '\\', '/', $actionFilePath ) ){
	header( 'Content-type: text/plain;charset=UTF-8' );
	die($GLOBALS['spider.messages']['spider.controller.directaccess']);
}
// env check
if( !$GLOBALS['controller']->checkEnv( $GLOBALS['request'] ) ) {
	$message	= implode("\n",$GLOBALS['request']->errors);
	spider_HttpOutput::exitWithMessage($message);
}

// set request parameter to request object
$GLOBALS['request']->setAttribute('postparams',$_POST);
foreach( $_POST as $key => $value ){
	$GLOBALS['request']->setAttribute('post.'.$key,$value);
}
$GLOBALS['request']->setAttribute('getparams',$_GET);
foreach( $_GET as $key => $value ) {
	$GLOBALS['request']->setAttribute('get.'.$key,$value);
}
foreach( $_COOKIE as $key => $value ) {
	$GLOBALS['request']->setAttribute('cookie.'.$key,$value );
}
// set attribute spider constants
$constHash = get_defined_constants();
foreach($constHash as $key => $val ){
	if( strpos($key,'SPIDER_') === 0 ){
		$GLOBALS['request']->setAttribute($key,$val);
	}
}
$spiderBaseUrl = SPIDER_URL_BASE;
$GLOBALS['request']->setAttribute( 'spider.base_url', $spiderBaseUrl );
$spiderBaseUri = SPIDER_URI_BASE;
$GLOBALS['request']->setAttribute( 'spider.base_uri', $spiderBaseUri );
$spiderBasePath = SPIDER_BASE_PATH;
$GLOBALS['request']->setAttribute( 'spider.base_path', $spiderBasePath );
$spiderAccessUri= SPIDER_URI_REQUEST;
$GLOBALS['request']->setAttribute( 'spider.access_uri', $spiderAccessUri );
$spiderAccessUrl= SPIDER_URL_REQUEST;

if( defined('SPIDER_ACCESS_URL_HTTP') ) {
	$spiderNomalUrl = SPIDER_ACCESS_URL_HTTP;
	$GLOBALS['request']->setAttribute( 'SPIDER_ACCESS_URL_HTTP', $spiderNomalUrl );
	$GLOBALS['request']->setAttribute( 'spider.nomal_url', $spiderNomalUrl );
}
if( defined('APPLICATION_NML_URL') ){
	$spiderNomalUrl = APPLICATION_NML_URL;
	$GLOBALS['request']->setAttribute( 'APPLICATION_NML_URL', $spiderNomalUrl );
	$GLOBALS['request']->setAttribute( 'spider.nomal_url', $spiderNomalUrl );
}
if( defined('APPLICATION_SSL_URL') ) {
	$spiderSslUrl = APPLICATION_SSL_URL;
	$GLOBALS['request']->setAttribute( 'APPLICATION_SSL_URL', $spiderSslUrl );
	$GLOBALS['request']->setAttribute( 'spider.ssl_url', $spiderSslUrl );
}
if( defined('SPIDER_ACCESS_URL_SSL') ) {
	$spiderSslUrl = SPIDER_ACCESS_URL_SSL;
	$GLOBALS['request']->setAttribute( 'SPIDER_ACCESS_URL_SSL', $spiderSslUrl );
	$GLOBALS['request']->setAttribute( 'spider.ssl_url', $spiderSslUrl );
}

// include preprocess file if file exists
if( is_array($GLOBALS['SPIDER_PREVIOUS_SCRIPT_FILE_PATH_ARRAY'])
	&& count($GLOBALS['SPIDER_PREVIOUS_SCRIPT_FILE_PATH_ARRAY']) > 0 ) {
	foreach( $GLOBALS['SPIDER_PREVIOUS_SCRIPT_FILE_PATH_ARRAY'] as $script_path ) {
		$script_path	= trim( $script_path );
		if( strlen($script_path) > 0 && file_exists( $script_path) ) {
			include_once( $script_path );
		}
	}
}
// execute main process
$GLOBALS['controller']->execute( $GLOBALS['request'], $GLOBALS['output'] );
die;
?>