<?php
/**
 * framework-spider: command common file
 * 
 * CopyRight(C)Framework-Spider Developer Team. 2011. All Right Reserved.<br /> 
 * URL         : http://sourceforge.jp/projects/frameworkspider/<br />
 * Mail        : frameworkspider-dev@lists.sourceforge.jp<br />
 * Auther      : Masanori Nakashima<br />
 * Modifier    : Masanori Nakashima<br />
 * Last Updated: 2011.04.11<br />
 * 
 * @package spider
 * @version 1.2.00
 * @copyright Copyright(c)2010, Masanori Nakashima <m_nakashima@users.sourceforge.jp>
 * @author Masanori Nakashima <m_nakashima@users.sourceforge.jp>
 * @access public
 */
define('DIR_PATH_SPIDER_DATA', dirname(dirname(dirname(__FILE__))));
define('DIR_PATH_SPIDER', DIR_PATH_SPIDER_DATA);

// include definitions
require_once( DIR_PATH_SPIDER.DIRECTORY_SEPARATOR.'define.inc.php' );
if( defined('FILE_PATH_SYSTEM_DEFINITION')
&& file_exists( FILE_PATH_SYSTEM_DEFINITION ) ){
	require_once( FILE_PATH_SYSTEM_DEFINITION );
}
// create main object
require_once(dirname(__FILE__).DIRECTORY_SEPARATOR.'HttpRequest.class.php');
require_once(dirname(__FILE__).DIRECTORY_SEPARATOR.'HttpOutput.class.php');
require_once(dirname(__FILE__).DIRECTORY_SEPARATOR.'Controller.class.php');
$GLOBALS['request'] = new spider_HttpRequest();
$GLOBALS['request_object'] = & $GLOBALS['request'];
$GLOBALS['output'] = new spider_HttpOutput();
$GLOBALS['output_object'] = & $GLOBALS['output'];
$GLOBALS['controller'] = new spider_Controller($GLOBALS['request'],$GLOBALS['output']);
// env check
if( !$GLOBALS['controller']->checkEnv( $GLOBALS['request'] ) ) {
	$message	= implode("\n",$GLOBALS['request']->errors);
	spider_HttpOutput::exitWithMessage($message);
}
// set charset
mb_language('japanese');
mb_internal_encoding('UTF-8');
ob_start('mb_output_handler');
if( preg_match('/[wW][iI][nN]/',$_ENV['OS'] ) > 0 ) {
	mb_http_output('SJIS-win');
} else if( preg_match('/[eE][uU][cC][jJ][pP]/', $_ENV['LANG'] ) > 0 ) {
	mb_http_output('EUC_JP');
} else if( preg_match('/[uU][tT][fF]\\-8/', $_ENV['LANG'] ) > 0 ) {
	mb_http_output('UTF-8');
}
// command check
$is_cli		= false;
if( preg_match('/[cC][lL][iI]/',php_sapi_name()) > 0 ) {
	$is_cli	= true;
} else if( preg_match('/[hH][aA][nN][dD][lL][eE][rR]/',php_sapi_name()) > 0 ) {
	header('Content-Type: text/plain; charset=UTF-8;');
	echo "Core Error!!\n";
	echo "this process called by php spi version.\n";
	echo "please call on commandline.\n";
	exit(0);
} else {
	echo "Core Error!!\n";
	echo "this process called by php unknown version.\n";
	echo "please call on commandline.\n";
	exit(0);
}

ob_implicit_flush( true );
if ( file_exists( DIR_PATH_SPIDER.DIRECTORY_SEPARATOR.'unique_setting.inc.php' ) ) {
	include_once( DIR_PATH_SPIDER.DIRECTORY_SEPARATOR.'unique_setting.inc.php' );
}
?>