<?php
/*
 * shopping/setting/delivery/Execute.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once(dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php');
class shopping_setting_delivery_Execute extends system_login_ModuleBase {
	function shopping_setting_delivery_Execute() {
	}
	function execute( & $request ) {
		
		$dbo						= $request->getAttribute( 'dbo' );
		$priceHash					= $_POST['price'];
		$deliveryFreePayment		= trim(stripslashes($_POST['delivery_free_payment']));
		$deliveryTypeOperation		= trim(stripslashes($_POST['delivery_type_operation']));
		$deliveryWrappingOptions	= trim(stripslashes($_POST['wrapping_options']));
		$deliveryWrappingFreeWords	= trim(stripslashes($_POST['wrapping_words']));
		$deliveryWishfulDayStart	= trim(stripslashes($_POST['delivery_wishful_day_start']));
		$deliveryWishfulDayEnd		= trim(stripslashes($_POST['delivery_wishful_day_end']));
		$wishfulTimes				= trim(stripslashes($_POST['wishful_times']));
		
		if( preg_match('/^[0-9]{1,7}$/',$deliveryFreePayment) == 0 ) {
			$request->addLocaledError('shopping.error.setting.delivery.invalidcondfree',SPIDER_LOG_LEVEL_ERROR,array(''));
		}
		if( preg_match('/^[0-9]{1}$/',$deliveryTypeOperation) == 0 ) {
			$request->addLocaledError('shopping.error.setting.delivery.invalidcoolusage',SPIDER_LOG_LEVEL_ERROR,array(''));
		}
		$deliveryWrappingOptions	= str_replace("\r\n","\n",$deliveryWrappingOptions);
		$deliveryWrappingOptions	= str_replace("\r","\n",$deliveryWrappingOptions);
		$deliveryWrappingOptions	= str_replace("\n\n","\n",$deliveryWrappingOptions);
		$deliveryWrappingOptions	= str_replace("\n\n","\n",$deliveryWrappingOptions);
		$deliveryWrappingOptions	= str_replace("\n\n","\n",$deliveryWrappingOptions);
		$deliveryWrappingOptions	= str_replace("\n\n","\n",$deliveryWrappingOptions);
		$deliveryWrappingOptions	= str_replace("\n\n","\n",$deliveryWrappingOptions);
		$deliveryWrappingOptionArray	= explode("\n",$deliveryWrappingOptions);
		if( count($deliveryWrappingOptionArray) > 10 ) {
			$request->addLocaledError('shopping.error.setting.delivery.overwrappingcount',SPIDER_LOG_LEVEL_ERROR,array(''));
		} else {
			foreach($deliveryWrappingOptionArray as $wrappingStr ) {
				if( strlen($wrappingStr) > 120 ) {
					$request->addLocaledError('shopping.error.setting.delivery.invalidwrapping',SPIDER_LOG_LEVEL_ERROR,array(''));
					break;
				}
			}
		}
		$wishfulTimes		= str_replace("\r\n","\n",$wishfulTimes);
		$wishfulTimes		= str_replace("\r","\n",$wishfulTimes);
		$wishfulTimes		= str_replace("\n\n","\n",$wishfulTimes);
		$wishfulTimes		= str_replace("\n\n","\n",$wishfulTimes);
		$wishfulTimes		= str_replace("\n\n","\n",$wishfulTimes);
		$wishfulTimes		= str_replace("\n\n","\n",$wishfulTimes);
		$wishfulTimes		= str_replace("\n\n","\n",$wishfulTimes);
		$wishfulTimesArray	= explode("\n",$wishfulTimes);
		if( count($wishfulTimesArray) > 10 ) {
			$request->addLocaledError('shopping.error.setting.delivery.overdeltimecount',SPIDER_LOG_LEVEL_ERROR,array(''));
		} else {
			foreach($wishfulTimesArray as $timeStr ) {
				if( strlen($timeStr) > 240 ) {
					$request->addLocaledError('shopping.error.setting.delivery.invaliddeltimecount',SPIDER_LOG_LEVEL_ERROR,array(''));
					break;
				}
			}
		}
		if( 'on' != $deliveryWrappingFreeWords ) {
			$deliveryWrappingFreeWords	= 'off';
		}
		if( preg_match('/^[0-9]{0,3}$/',$deliveryWishfulDayStart) == 0 ) {
			$request->addLocaledError('shopping.error.setting.delivery.invaliddeldays',SPIDER_LOG_LEVEL_ERROR,array(''));
		}
		if( preg_match('/^[0-9]{0,3}$/',$deliveryWishfulDayEnd) == 0 ) {
			$request->addLocaledError('shopping.error.setting.delivery.invaliddeldaye',SPIDER_LOG_LEVEL_ERROR,array(''));
		}
		if( !is_array($priceHash) ) {
			$request->addLocaledError('shopping.error.setting.delivery.invaliddelcharge',SPIDER_LOG_LEVEL_ERROR,array(''));
		} else {
			foreach( $priceHash as $type => $weightHash ) {
				foreach( $weightHash as $weight => $prefHash ) {
					if( !is_array($prefHash) ) {
						$request->addLocaledError('shopping.error.setting.delivery.invaliddelcharge',SPIDER_LOG_LEVEL_ERROR,array(''));
						break;
					} else {
						foreach( $prefHash as $prefNum => $price ) {
							if( preg_match('/^[0-9]{1,2}$/',$prefNum) == 0 ) {
								$request->addLocaledError('shopping.error.setting.delivery.invalidpref',SPIDER_LOG_LEVEL_ERROR,array(''));
								break;
							}
							if( preg_match('/^[0-9]{1,7}$/',$price) == 0 ) {
								$request->addLocaledError('shopping.error.setting.delivery.invaliddelprefchg',SPIDER_LOG_LEVEL_ERROR,array($weight,$GLOBALS['PREFECTURE_HASH'][$prefNum]));
							}
						}
					}
				}
			}
		}
		if( $request->isError() ) {
		} else {
			// 設定を全て削除
			$sql	= 'DELETE FROM '.TABLE_NAME_SHOPPING_DELIVERY_SETTING;
			$dbo->query($sql);
			// 設定をインサート
			foreach( $priceHash as $deliveryType => $weightHash ) {
				foreach( $weightHash as $weight => $prefHash ) {
					foreach( $prefHash as $prefNum => $price ) {
						$sql	= 'INSERT INTO '. TABLE_NAME_SHOPPING_DELIVERY_SETTING.'('
							.'setting_id,delivery_type,delivery_weight,prefecture_number,delivery_price,updated_date,registered_date'
							.') VALUES('
							.$dbo->quote('A'.sprintf('%02d',$deliveryType).sprintf('%03d',$weight).sprintf('%03d',$prefNum))
							.','.$deliveryType
							.','.$weight
							.','.$prefNum
							.','.$price
							.',NOW(),NOW()'
							.')';
						$dbo->query($sql);
					}
				}
			}
			// 無料条件の設定変更
			$shoppingPackageConfig	= spider_Controller::createObject('shopping_PackageConfig');
			if( $shoppingPackageConfig->load( $request ) ) {
				$shoppingPackageConfig->definitionHash['SHOPPING_DELIVERY_FREE_PRICE']	= $deliveryFreePayment;
				$shoppingPackageConfig->definitionHash['SHOPPING_DELIVERY_TYPE_OPERATION']	= $deliveryTypeOperation;
				$shoppingPackageConfig->definitionHash['SHOPPING_DELIVERY_RAPPING_FREEWORD']	= $deliveryWrappingFreeWords;
				$shoppingPackageConfig->definitionHash['SHOPPING_DELIVERY_WISHFUL_DAY_START']	= $deliveryWishfulDayStart;
				$shoppingPackageConfig->definitionHash['SHOPPING_DELIVERY_WISHFUL_DAY_END']	= $deliveryWishfulDayEnd;
				if( $shoppingPackageConfig->save( $request ) ) {
				} else {
					$request->addLocaledError('system.error.writer.save',SPIDER_LOG_LEVEL_FATAL,array(''));
				}
			}
			// ラッピングの種類選択肢
			$fileWriter	= spider_Controller::createObject('system_DataFileWriter');
			if( $fileWriter->open( $request, SHOPPING_RAPPING_FILE_URI, 'w', DIR_NAME_DATA ) ) {
				$fileWriter->write( $deliveryWrappingOptions );
				$fileWriter->close( $request );
			}
			// 希望配送時間選択肢
			$fileWriter	= spider_Controller::createObject('system_DataFileWriter');
			if( $fileWriter->open( $request, SHOPPING_WISHFUL_TIME_FILE_URI, 'w', DIR_NAME_DATA ) ) {
				$fileWriter->write( $wishfulTimes );
				$fileWriter->close( $request );
			}
		}
		$request->setAttribute('shopping.setting.delivery.deliveryPriceHash',$priceHash);
		$request->setAttribute('shopping.setting.delivery.deliveryFreePayment',$deliveryFreePayment);
		$request->setAttribute('shopping.setting.delivery.deliveryTypeOperation',$deliveryTypeOperation);
	}
}
?>