<?php
/*
 * shopping/scripts/insetDeliveryPrice.cmd.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-02-12
 * 
 */
// コマンド共通モジュール取り込み
require_once(dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'spider'
.DIRECTORY_SEPARATOR.'spider.cmd.php');
// データベース接続クラスの読み込み
require_once(dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'database2'
.DIRECTORY_SEPARATOR.'Connect.class.php');
// システム設定クラスの読み込み
require_once(dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'system'
.DIRECTORY_SEPARATOR.'PackageConfig.class.php');
// ショッピングパッケージ設定クラス
require_once(dirname(dirname(__FILE__))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php');

//
// 処理開始
//
$systemPackageConfigObject	= new system_PackageConfig();
if( $systemPackageConfigObject->load($GLOBALS['request']) ) {
} else {
	$GLOBALS['request']->addLocaledError('system.error.common.noinstalled',SPIDER_LOG_LEVEL_ERROR,array());
}
$shoppingPackageConfigObject	= new shopping_PackageConfig();
if( $shoppingPackageConfigObject->load($GLOBALS['request']) ) {
} else {
	$GLOBALS['request']->addLocaledError('system.error.common.noinstalled',SPIDER_LOG_LEVEL_ERROR,array());
}

//
// データベースに接続する
//
database2_Connect::execute( $GLOBALS['request'] );
$dbo	= $GLOBALS['request']->getAttribute('dbo');
$sql	= 'DELETE FROM '.TABLE_NAME_SHOPPING_DELIVERY_SETTING;
$dbo->query($sql);
// 初期の送料設定を挿入
for( $deliveryType=0; $deliveryType<=1; $deliveryType++ ) {
	for( $weight=10; $weight<=30; $weight=$weight+10 ) {
		foreach( $GLOBALS['PREFECTURE_HASH'] as $prefNum => $prefName ) {
			$sql	= 'INSERT INTO '. TABLE_NAME_SHOPPING_DELIVERY_SETTING.'('
				.'setting_id,delivery_type,delivery_weight,prefecture_number,delivery_price,updated_date,registered_date'
				.') VALUES('
				.$dbo->quote('A'.sprintf('%02d',$deliveryType).sprintf('%03d',$weight).sprintf('%03d',$prefNum))
				.','.$deliveryType
				.','.$weight
				.','.$prefNum
				.','.($weight*50)
				.',NOW(),NOW()'
				.')';
			$dbo->query($sql);
		}
	}
}

//
// データベース切断
//
database2_Connect::post_process( $GLOBALS['request'] );
?>