<?php
/*
 * shopping/promotion/LoadList.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-02-12
 * 
 */
require_once( dirname(dirname(__FILE__))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php');
class shopping_promotion_LoadList extends system_login_ModuleBase {
	
	function shopping_promotion_LoadList() {
	}
	function execute( & $request ) {

		$dbo				= $request->getAttribute( 'dbo' );
		$pageRows			= $request->getParam('pr','get');
		$pageNumber			= $request->getParam('pn','get');
		$queryWords			= $request->getParam('shpq','get');
		$sortItem			= $_GET['shpsi'];
		$sortOrder			= $_GET['shpso'];
		$statusFlag			= trim( stripslashes( $_GET['shpmpstf']) );
		
		$userAgentClass	= $request->getAttribute('spider.access_agent_class');

		$accessAgentClass	= $request->getAttribute('spider.access_agent_class');
		$loginUserObject	= $this->getLoginUserObject( $request );
		// ページング制御
		if ( !is_numeric( $pageNumber ) || $pageNumber < 1 ) {
			$pageNumber	= 1;
		}
		if ( !is_numeric( $pageRows ) || $pageRows < 1 ) {
			if( 'au'==$userAgentClass || 'docomo'==$userAgentClass || 'docomo2'==$userAgentClass || 'softbank'==$userAgentClass) {
				$pageRows		= 5;
			} else {
				$pageRows		= 20;
			}
		} else if ( $pageRows > 1000 ) {
			if( 'au'==$userAgentClass || 'docomo'==$userAgentClass || 'docomo2'==$userAgentClass || 'softbank'==$userAgentClass) {
				$pageRows		= 5;
			} else {
				$pageRows		= 20;
			}
		}
		// 並び替え制御
		$sortOrderArray = array();
		if ( is_array($sortOrder) ) {
			$sortOrderArray = $sortOrder;
		} else {
			if ( strlen(trim($sortOrder)) > 0 ) {
				array_push($sortOrderArray,$sortOrder);
			}
		}
		$sortItemArray			= array();
		$orderConditionArray	= array();
		$duplicateCheckArray	= array();
		if ( is_array($sortItem) ) {
			$sortItemArray = $sortItem;
		} else {
			if ( strlen(trim($sortItem)) > 0 ) {
				array_push($sortItemArray,$sortItem);
			}
		}
		// 並べ替え
		if ( count($sortItemArray) == 0 ) {
			// 並び替え項目が指定されていなければ、「登録日」を設定
			array_push($sortItemArray,'reg');
		}
		foreach ( $sortItemArray as $key => $sortItemName ) {
			$orderCondition	= '';
			if ( strlen(trim($sortItemName)) > 0 && !in_array($sortItemName,$duplicateCheckArray) ) {
				// 並び替えの設定
				if ( strlen(trim($sortOrderArray[$key])) == 0 ) {
					// 何も指定されていなければ、降順
					$sortOrderArray[$key]	= 'DESC';
				} else {
					if( preg_match('/^[aA][sS][cC]$/',$sortOrderArray[$key] ) > 0 ) {
						$sortOrderArray[$key]	= 'ASC';
					} else {
						$sortOrderArray[$key]	= 'DESC';
					}
				}

				if( 'did' == $sortItemName ) {
					$orderCondition	= TABLE_NAME_SHOPPING_PROMOTION.'.promotion_id '.$sortOrderArray[$key];
				} else if ( 'upd' == $sortItemName ) {
					$orderCondition	= TABLE_NAME_SHOPPING_PROMOTION.'.updated_date '.$sortOrderArray[$key];
				} else if ( 'dname' == $sortItemName ) {
					$orderCondition	= TABLE_NAME_SHOPPING_PROMOTION.'.promotion_kana '.$sortOrderArray[$key]
						.', '.TABLE_NAME_SHOPPING_PROMOTION.'.promotion_name ' . $sortOrderArray[$key]
					;
				} else {
					$sortItemName	= 'reg';
					$orderCondition	= TABLE_NAME_SHOPPING_PROMOTION.'.registered_date '.$sortOrderArray[$key];
				}
				array_push($orderConditionArray,$orderCondition);
				array_push($duplicateCheckArray,$sortItemName);
			}
		}
		$orderConditionString	= '';
		if ( count( $orderConditionArray ) > 0 ) {
			$orderConditionString	= ' ORDER BY ' . implode( ', ', $orderConditionArray );
		}
		
		$condition_array	= array();
		$joinTables			= array();
		
		// 状態フラグ条件
		if( $this->isLogin( $request ) && SYSTEM_LOGIN_USER_ADMINISTRATORS == $loginUserObject->getLoginGroupLevel() ) {
			if( preg_match('/^[0-9]{1,3}$/',$statusFlag) > 0 ) {
				$str = TABLE_NAME_SHOPPING_PROMOTION.'.status_flag='.$statusFlag;
				array_push( $condition_array, $str );
			} else {
				$str = '( '.TABLE_NAME_SHOPPING_PROMOTION.'.status_flag>=0'
					.' AND '.TABLE_NAME_SHOPPING_PROMOTION.'.status_flag<200 )';
				array_push( $condition_array, $str );
			}
		} else {
			$str = '( '.TABLE_NAME_SHOPPING_PROMOTION.'.status_flag>=100'
				.' AND '.TABLE_NAME_SHOPPING_PROMOTION.'.status_flag<200 )';
			array_push( $condition_array, $str );
		}
		
		// 検索ワード
		if ( strlen(trim($queryWords)) > 0 ) {
			$queryWords	= str_replace('　', ' ', $queryWords);
			$queryWordArray	= explode(' ',$queryWords);
			foreach( $queryWordArray as $queryWord ) {
				if( strlen($queryWord) > 0 ) {
					// 検索文字列
					$str	= '( '.TABLE_NAME_SHOPPING_PROMOTION.'.promotion_id LIKE ' . $dbo->quote( '%'.$queryWord.'%' )
						. ' OR '
						. TABLE_NAME_SHOPPING_PROMOTION.'.member_id LIKE ' . $dbo->quote( '%'.$queryWord.'%' )
						. ' OR '
						. TABLE_NAME_SHOPPING_PROMOTION.'.promotion_name LIKE ' . $dbo->quote( '%'.$queryWord.'%' )
						. ' OR '
						. TABLE_NAME_SHOPPING_PROMOTION.'.promotion_kana LIKE ' . $dbo->quote( '%'.$queryWord.'%' )
						. ' OR '
						. TABLE_NAME_SHOPPING_PROMOTION.'.promotion_code LIKE ' . $dbo->quote( '%'.$queryWord.'%' )
						. ' OR '
						. TABLE_NAME_SHOPPING_PROMOTION.'.description LIKE ' . $dbo->quote( '%'.$queryWord.'%' )
					;
					$str	.= ' )'	;
					array_push( $condition_array, $str );
				}
			}
		}
		
		$condition_string	= '';
		if ( count( $condition_array ) > 0 ) {
			$condition_string	= ' WHERE ' . implode( ' AND ', $condition_array );
		}
		
		// トータル件数を取得
		$sql	= 'SELECT COUNT(DISTINCT('.TABLE_NAME_SHOPPING_PROMOTION. '.promotion_id)) '
			. ' FROM ' . TABLE_NAME_SHOPPING_PROMOTION
		;
		if ( in_array( TABLE_NAME_SHOPPING_PROMOTION, $joinTables ) ) {
			$sql	.= ' LEFT OUTER JOIN ' . TABLE_NAME_SHOPPING_PROMOTION
				. ' ON ' . TABLE_NAME_SHOPPING_PROMOTION . '.promotion_id='.TABLE_NAME_SHOPPING_PROMOTION.'.promotion_id '
			;
		}
		$sql	.= $condition_string;
		$totalCount	= 0;
		$totalCount	= $dbo->queryOne( $sql );
		if ( $totalCount === false ) {
			$request->addLocaledError('database2.error.common',SPIDER_LOG_LEVEL_FATAL,array($sql));
		} else {
			if ( is_numeric( $totalCount ) || $totalCount < 0 ) {
				$totalPage		= ceil( $totalCount / $pageRows );
			} else {
				$totalCount	= 0;
				$totalPage		= 1;
			}
		}
		// オフセットの整理
		if ( !is_numeric( $pageNumber ) || $pageNumber <= 0 ) {
			$pageNumber	= 1;
		} else if ( $pageNumber > $totalPage	 ) {
			$pageNumber	= $totalPage;
		}
		
		// IDをページ分取得
		$sql	= 'SELECT DISTINCT '.TABLE_NAME_SHOPPING_PROMOTION.'.* '
			. ' FROM ' . TABLE_NAME_SHOPPING_PROMOTION
		;
		if ( in_array( TABLE_NAME_SHOPPING_PROMOTION, $joinTables ) ) {
			$sql	.= ' LEFT OUTER JOIN ' . TABLE_NAME_SHOPPING_PROMOTION
				. ' ON ' . TABLE_NAME_SHOPPING_PROMOTION . '.promotion_id='.TABLE_NAME_SHOPPING_PROMOTION.'.promotion_id '
			;
		}
		$sql	.= $condition_string
			. ' GROUP BY '
			.TABLE_NAME_SHOPPING_PROMOTION.'.promotion_id '
			. $orderConditionString
		;
		$dbo->setLimit( $pageRows, ( $pageNumber - 1 ) * $pageRows );
		$shoppingProductObject	= spider_Controller::createObject('shopping_DaoShoppingPromotion');
		$promotionObjectArray	= $dbo->queryAll( $sql, $shoppingProductObject, true, false );
		if ( $promotionObjectArray === false ) {
			$request->addLocaledError('database2.error.common',SPIDER_LOG_LEVEL_FATAL,array($sql));
		} else {
			$promotionIdArray		= array();
			$promotionObjectHash		= array();
			foreach( $promotionObjectArray as $key => $object ) {
				$promotionId			= $object->promotion_id;
				$this->setLockStatus( $request, $object );
				$promotionObjectHash[$promotionId]	= $object;
				array_push($promotionIdArray,$object->promotion_id);
			}
			$promotionObjectArray	= $promotionObjectHash;
			
			$request->setAttribute( 'shopping.promotion.promotion_array',		$promotionObjectArray );
			$request->setAttribute( 'shopping.promotion.total_count',		$totalCount );
			$request->setAttribute( 'shopping.promotion.total_page',		$totalPage );
			$request->setAttribute( 'shopping.promotion.page_number',		$pageNumber );
			$request->setAttribute( 'shopping.promotion.page_rows',			$pageRows );
			$request->setAttribute( 'shopping.promotion.query',				$queryWords );
			$request->setAttribute( 'shopping.promotion.sort_item_array',			$sortItemArray );
			$request->setAttribute( 'shopping.promotion.sort_order_array',		$sortOrderArray );
			$request->setAttribute( 'shopping.promotion.status_flag',		$statusFlag );
			
			$has_next_page	= false;
			if( $pageNumber < $totalPage ) {
				$has_next_page	= true;
			}
			$request->setAttribute( 'shopping.promotion.has_next_page', $has_next_page );
			$has_prev_page	= false;
			if( $pageNumber > 1 ) {
				$has_prev_page	= true;
			}
			$request->setAttribute( 'shopping.promotion.has_prev_page', $has_prev_page );
			
			// ページナビゲーション配列作成
			$page_navi_array = array();
			if ( $pageNumber < 10 ) {
				if ( $totalPage < 10 ) {
					for($i=1;$i<=$totalPage;$i++) {
						array_push($page_navi_array,$i);
					}
				} else {
					for($i=1;$i<=10;$i++) {
						array_push($page_navi_array,$i);
					}
				}
			} else if ( $pageNumber > ($totalPage-10) ) {
				for($i=($totalPage-10);$i<=$totalPage;$i++) {
					array_push($page_navi_array,$i);
				}
			} else {
				for($i=($pageNumber-5);$i<=($pageNumber+5);$i++) {
					array_push($page_navi_array,$i);
				}
			}
			$request->setAttribute('shopping.promotion.page_navi_array', $page_navi_array );
		}
	}
}
?>