<?php
/*
 * shopping/product/unit/Status.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once(dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php');
class shopping_product_unit_Status extends system_login_ModuleBase {
	function shopping_product_unit_Status(){
	}
	function execute( & $request ) {
		$dbo		= $request->getAttribute( 'dbo' );
		$unitNumber	= $request->getParam('unit_number','post');
		$statusFlag	= $request->getParam('status_flag','post');
		$shoppingProductUnitObject	= spider_Controller::createObject('shopping_DaoShoppingProductUnit');
		$loginUserObject	= $this->getLoginUserObject( $request );
		if( preg_match('/^[0-9]{1,6}$/',$unitNumber) > 0 ) {
			// データ番号が指定されているなら編集の為読み込み
			if( $dbo->loadByNumber( $shoppingProductUnitObject, $unitNumber ) ) {
				if( false === $this->lockData( $request, $shoppingProductUnitObject ) ) {
					$request->addLocaledError('system.error.common.data.locked',SPIDER_LOG_LEVEL_ERROR,array(''));
				} else {
					if ( !$shoppingProductUnitObject->canEditData( $request, $loginUserObject ) ) {
						$request->addLocaledError('system.error.login.user.noauthexec',SPIDER_LOG_LEVEL_ERROR,array());
					} else if( strlen($GLOBALS['SHOPPING_PRODUCT_STATUS_HASH'][$statusFlag]) == 0 ) {
						$request->addLocaledError('shopping.error.common.invalidstatus',SPIDER_LOG_LEVEL_ERROR,array(''));
					} else {
						// 問題がなければ、状態をオブジェクトにセット
						$shoppingProductUnitObject->status_flag		= $statusFlag;
						$shoppingProductUnitObject->updated_date	= date('Y-m-d H:i:s');
						if ( !$shoppingProductUnitObject->canEditStatus( $request, $loginUserObject ) ) {
							$request->addLocaledError('system.error.login.user.noauthexec',SPIDER_LOG_LEVEL_ERROR,array());
						} else {
							// 問題なければ更新
							if( $dbo->update($shoppingProductUnitObject,false) ) {
								// 販売単位が公開されて商品が非公開の場合は商品を自動公開する
								if( $statusFlag == 101 && $shoppingProductUnitObject->shoppingProductObject->status_flag < 100 ) {
									$shoppingProductUnitObject->shoppingProductObject->status_flag = 101;
									$shoppingProductUnitObject->shoppingProductObject->updated_date	= date('Y-m-d H:i:s');
									if( $dbo->update($shoppingProductUnitObject->shoppingProductObject,false) ) {
									} else {
										$request->addLocaledError('database2.error.update',SPIDER_LOG_LEVEL_ERROR,array(''));
									}
								}
							} else {
								$request->addLocaledError('database2.error.update',SPIDER_LOG_LEVEL_FATAL,array(''));
							}
						}
					}
					$this->unlockData( $request, $shoppingProductUnitObject );
				}
			} else {
				$request->addLocaledError('shopping.error.product.unit.invalidid',SPIDER_LOG_LEVEL_FATAL,array(''));
			}
		} else {
			$request->addLocaledError('shopping.error.product.unit.invalidid',SPIDER_LOG_LEVEL_FATAL,array(''));
		}
		$request->setAttribute('shopping.product.unit.unit_object',		$shoppingProductUnitObject);
	}
}
?>