<?php
/*
 * shopping/product/unit/LoadOrderItems.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once(dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php' );
/**
 * 指定年月日の指定販売単位申し込みを読み込みます
 */
class shopping_product_unit_LoadOrderItems extends system_login_ModuleBase {
	
	function shopping_product_unit_LoadOrderItems(){
		array_push($this->require_module_array,'shopping.calendar.Load');
		array_push($this->require_module_array,'shopping.product.unit.Load');
	}
	function execute( & $request ) {
		$dbo				= $request->getAttribute( 'dbo' );
		$targetYear			= $request->getParam('sclty','get');
		$targetMonth		= $request->getParam('scltm','get');
		$targetDay			= $request->getParam('scltd','get');
		$shoppingProductUnitObject	= $request->getAttribute('shopping.product.unit.unit_object');
		// 妥当性検査
		if( preg_match('/^(19[789][0-9]|20[0123][0-9])$/',$targetYear) == 0 ) {
			$targetYear		= date('Y');
		}
		if( preg_match('/^((|0)[1-9]|1[012])$/',$targetMonth) == 0 ) {
			$targetMonth	= date('m');
		}
		$firstWeekDay 			= date('w',strtotime(date($targetYear.'-'.$targetMonth.'-1')));
		$targetMonthDayCount	= date('t',strtotime(date($targetYear.'-'.$targetMonth.'-1')));
		$startDate				= $targetYear.'-'.$targetMonth.'-01 00:00:00';
		$limitDate				= $targetYear.'-'.$targetMonth.'-'.$targetMonthDayCount.' 23:59:59';
		if( preg_match('/^[0-9]{1,2}$/',$targetDay) > 0 && $targetDay > 0 && $targetDay <= $targetMonthDayCount ) {
			$startDate		= $targetYear.'-'.$targetMonth.'-'.$targetDay.' 00:00:00';
			$limitDate		= date('Y-m-d H:i:s',strtotime($startDate));
		} else {
			$startDate		= $targetYear.'-'.$targetMonth.'-01 00:00:00';
			$limitDate		= $targetYear.'-'.$targetMonth.'-'.$targetMonthDayCount.' 23:59:59';
		}
		// 在庫連動確認
		$unitIdArray	= array($shoppingProductUnitObject->unit_id);
		if( $shoppingProductUnitObject->delivery_type < -1 ) {
			$shoppingProductUnitObject->optimizeLoadedVars( $dbo );
			$unitIdArray	= array_merge($unitIdArray,$shoppingProductUnitObject->stockRelationArray);
			$unitIdArray	= array_unique($unitIdArray);
		}
		// 申し込みアイテムを問い合わせ
		$sql	= 'SELECT '.TABLE_NAME_SHOPPING_ORDER_ITEM.'.* '
		.', '.TABLE_NAME_SHOPPING_ORDER_ADDRESS.'.address_name'
		.' FROM '.TABLE_NAME_SHOPPING_ORDER_ITEM
		.' LEFT OUTER JOIN '.TABLE_NAME_SHOPPING_ORDER_ADDRESS
		.' ON '.TABLE_NAME_SHOPPING_ORDER_ADDRESS.'.address_id='.TABLE_NAME_SHOPPING_ORDER_ITEM.'.address_id'
		.' LEFT OUTER JOIN '.TABLE_NAME_SHOPPING_ORDER
		.' ON '.TABLE_NAME_SHOPPING_ORDER.'.order_id='.TABLE_NAME_SHOPPING_ORDER_ITEM.'.order_id'
		.' WHERE '.TABLE_NAME_SHOPPING_ORDER.'.status_flag<200'
		.' AND ('.TABLE_NAME_SHOPPING_ORDER_ITEM.'.svc_limit_date>='.$dbo->quote($startDate)
		.' OR '.TABLE_NAME_SHOPPING_ORDER_ITEM.'.svc_start_date<='.$dbo->quote($limitDate).' )'
		.' AND ( '.TABLE_NAME_SHOPPING_ORDER_ITEM.'.unit_id IN (\''.implode('\',\'',$unitIdArray).'\')'
		.' OR '.TABLE_NAME_SHOPPING_ORDER_ITEM.'.used_unit_id IN (\''.implode('\',\'',$unitIdArray).'\') )';
		$orderedInfoHash		= array();
		$orderedCountHash	= array();
		$resultHash		= $dbo->queryAll( $sql, 'hash');
		if ( $resultHash === false ) {
			$request->addLocaledError('database2.error.common',SPIDER_LOG_LEVEL_FATAL,array($sql));
		} else {
			// 情報を時系列に整理する
			if( $shoppingProductUnitObject->delivery_type >= 900 ) {
				// 宿泊予約の場合は日までの多次元連想配列に整理
				foreach( $resultHash as $row ) {
					for( $num=strtotime($row['svc_start_date']);
					date('Ymd',$num)<date('Ymd',strtotime($row['svc_limit_date']));
					$num+=(60*60*24) ) {
						if( $targetYear == date('Y',$num) && $targetMonth == date('m',$num) ) {
							// 同月内なら配列に追加してカウントアップ
							$tDay	= date('d',$num);
							if( !is_array($orderedInfoHash[$tDay]) ) {
								$orderedInfoHash[$tDay]	= array();
							}
							if( !isset($orderedCountHash[$tDay]) ) {
								$orderedCountHash[$tDay]	= 0;
							}
							array_push($orderedInfoHash[$tDay],$row);
							$orderedCountHash[$tDay]	+= $row['order_count'];
						}
					}
				}
			} else if( $shoppingProductUnitObject->delivery_type >= 200 ) {
				// 時間予約の場合は時間までの多次元配列に整理
				foreach( $resultHash as $row ) {
					for( $num=strtotime($row['svc_start_date']);
					date('YmdHi',$num)<date('YmdHi',strtotime($row['svc_limit_date']));
					$num+=(60*30) ) {
						if( $targetYear == date('Y',$num) && $targetMonth == date('m',$num) ) {
							// 同月内なら配列に追加してカウントアップ
							$tDay	= date('d',$num);
							$tHour	= date('Hi',$num);
							if( !is_array($orderedInfoHash[$tDay]) ) {
								$orderedInfoHash[$tDay]	= array();
							}
							if( !is_array($orderedInfoHash[$tDay][$tHour]) ) {
								$orderedInfoHash[$tDay][$tHour]	= array();
							}
							
							if( !is_array($orderedCountHash[$tDay]) ) {
								$orderedCountHash[$tDay]= array();
							}
							if( !isset($orderedCountHash[$tDay][$tHour]) ) {
								$orderedCountHash[$tDay][$tHour]= 0;
							}
							array_push($orderedInfoHash[$tDay][$tHour],$row);
							$orderedCountHash[$tDay][$tHour]	+= $row['order_count'];
						}
					}
				}
			} else {
				// その他の場合はそのままの配列
				$orderedInfoHash	= $resultHash;
			}
		}
		// カレンダーチェック状況をセッションから取得
		$selectedDateHash	= $request->getSession('shopping.order.selectedDateHash',SPIDER_SESSION_SCOPE_GLOBAL);
		if( !is_array($selectedDateHash) ) {
			$selectedDateHash	= array();
		}
		$request->setAttribute('shopping.product.unit.targetYear', $targetYear);
		$request->setAttribute('shopping.product.unit.targetMonth', $targetMonth);
		$request->setAttribute('shopping.product.unit.targetDay', $targetDay);
		$request->setAttribute('shopping.product.unit.targetMonthDayCount', $targetMonthDayCount);
		$request->setAttribute('shopping.product.unit.firstWeekDay', $firstWeekDay);
		$request->setAttribute('shopping.product.unit.orderedInfoHash', $orderedInfoHash);
		$request->setAttribute('shopping.product.unit.orderedCountHash', $orderedCountHash);
		$request->setAttribute('shopping.order.selectedDateHash', $selectedDateHash);
	}
}
?>