<?php
/*
 * shopping/product/unit/Load.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once( dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php' );
class shopping_product_unit_Load extends system_login_ModuleBase {
	
	function shopping_product_unit_Load(){
	}
	function execute( & $request ) {
		
		$dbo						= $request->getAttribute( 'dbo' );
		$unitNumber					= stripslashes( $_GET['shpun'] );
		$unitId						= stripslashes( $_GET['shpui'] );
		$sessionObjectName			= 'shopping.product.unit.modify.object.'.$unitNumber;
		$sessionConfirmName			= 'shopping.product.unit.modify.confirm.'.$unitNumber;
		$shoppingProductUnitObject	= $request->getSession($sessionObjectName);
		if( is_object( $shoppingProductUnitObject ) && is_object($shoppingProductUnitObject->uploader) ) {
			$shoppingProductUnitObject->uploader->deleteTempFiles( $request );
		}
		$loginUserObject				= $this->getLoginUserObject( $request );
		$compareShoppingProductObject	= spider_Controller::createObject('shopping_DaoShoppingProductUnit');
		$request->removeSession($sessionObjectName);
		$request->removeSession($sessionConfirmName);
		
		// セッションにないなら作成する
		$shoppingProductUnitObject	= spider_Controller::createObject('shopping_DaoShoppingProductUnit');
		if( preg_match('/^[0-9]+$/',$unitNumber) > 0 ) {
			// 販売単位番号が指定されているなら読み込み
			if( $dbo->loadByNumber( $shoppingProductUnitObject, $unitNumber, true ) ){
			} else {
				$request->addLocaledError('shopping.error.product.unit.notfound',SPIDER_LOG_LEVEL_FATAL,array(''));
			}
		} else if( strlen(trim($unitId)) > 0 ) {
			// 販売単位IDが指定されているなら読み込み
			if( $dbo->loadById( $shoppingProductUnitObject, $unitId, true ) ){
			} else {
				$request->addLocaledError('shopping.error.product.unit.notfound',SPIDER_LOG_LEVEL_FATAL,array(''));
			}
		} else {
			// IDが指定されていないならエラー
			$request->addLocaledError('shopping.error.product.unit.invalidid',SPIDER_LOG_LEVEL_FATAL,array(''));
		}
		
		if( !$request->isError() ) {
			// メンバ調整
			$shoppingProductUnitObject->optimizeLoadedVars($dbo);
			// 公開設定
			if( $this->isLogin( $request )
				&& SYSTEM_LOGIN_USER_ADMINISTRATORS == $loginUserObject->getLoginGroupLevel() ) {
			} else {
				if ( !in_array($loginUserObject->member_class,$shoppingProductUnitObject->memberViewableArray) ) {
					$request->addLocaledError('shopping.error.product.permittion.view',SPIDER_LOG_LEVEL_FATAL,array(''));
				}
			}
			// 検索データ連携
			$shoppingProductUnitObject->shoppingProductObject->loadRelatedSearchData( $dbo );
		}

		if( !$request->isError() ) {
			// unit_numberが設定済みならロック処理
			if( strlen($shoppingProductUnitObject->unit_number ) > 0 ) {
				if( $this->setLockStatus( $request, $shoppingProductUnitObject ) ) {
				}
			}
		}
		$request->setAttribute('shopping.product.unit.unit_object',		$shoppingProductUnitObject);
	}
}
?>