<?php
/*
 * shopping/product/download/Execute.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once(dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php');
class shopping_product_download_Execute extends system_login_ModuleBase {
	function shopping_product_download_Execute(){
	}
	function execute( & $request ) {
		// 変数取得
		$dbo					= $request->getAttribute( 'dbo' );
		$sessionHashName		= 'shopping.product.download.columnSelectedArray';
		$sessionOffsetName		= 'shopping.product.download.currentOffset';
		$columnSelectedArray	= $request->getSession($sessionHashName);
		// 一度に書き込む数を固定
		$writeAtOnce	= 1;
		
		if( !is_array($columnSelectedArray) && strlen($columnSelectedArray) == 0 ) {
			$request->addLocaledError('system.error.common.csvdl.selectcolumn',SPIDER_LOG_LEVEL_FATAL,array(''));
		}
		// ダウンロードする対象クエリの確認
		$totalCount		= 0;
		$queryHash	= $request->getSession(SHOPPING_SESSION_NAME_PRODUCT_SEARCH_LAST_QUERY, SPIDER_SESSION_SCOPE_GLOBAL);
		if( !is_array($queryHash) ) {
			$request->addLocaledError('system.error.common.session.timeout',SPIDER_LOG_LEVEL_ERROR,array());
		} else if( strlen($queryHash['countQuery']) == 0 || strlen($queryHash['loadQuery']) == 0 ) {
			$request->addLocaledError('system.error.common.session.timeout',SPIDER_LOG_LEVEL_ERROR,array());
		} else {
			$totalCount	= $dbo->queryOne($queryHash['countQuery']);
			if ( $totalCount === false ) {
				$request->addLocaledError('database2.error.common',SPIDER_LOG_LEVEL_FATAL,array($queryHash['countQuery']));
			}
		}

		if( !$request->isError() ) {
			// 現在のオフセットを確認し登録されていなければ0に設定
			$offset			= $request->getSession($sessionOffsetName);
			if( preg_match('/^[0-9]+$/', $offset) == 0 ) {
				$offset		= 0;
			}
			$csvColumnOrder	= array();
			$pos	= 0;
			foreach( $columnSelectedArray as $columnVarName ) {
				$csvColumnOrder[$columnVarName]	= $pos;
				$pos++;
			}
			$dbo->setLimit( $writeAtOnce, $offset );
			$shoppingProductObject	= spider_Controller::createObject('shopping_DaoShoppingProduct');
			$productObjectArray	= $dbo->queryAll( $queryHash['loadQuery'], $shoppingProductObject, true, false );
			if ( $productObjectArray === false ) {
				$request->addLocaledError('database2.error.common',SPIDER_LOG_LEVEL_FATAL,array($queryHash['loadQuery']));
			} else {
				// ダウンロード一時ファイルURI
				$tmpUri	= '/shopping/product/download/products.csv';
				$writer	= spider_Controller::createObject('system_DataFileWriter');
				if( 0 == $offset ) {
					// オフセットが0の場合書き込みモードでオープン
					if( $writer->open( $request, $tmpUri, 'w', DIR_NAME_TMP) ) {
						// カラム名を一行目に出力
						foreach( $columnSelectedArray as $num => $columnVarName ) {
							if( $num > 0 ) { $writer->write(','); }
							$columnViewName	= '';
							if( isset($GLOBALS['SHOPPING_PRODUCT_CSV_DEFINITION'][$columnVarName]) ) {
								$columnViewName	= $GLOBALS['SHOPPING_PRODUCT_CSV_DEFINITION'][$columnVarName];
							} else {
								$columnViewName	= $GLOBALS['SHOPPING_PRODUCT_UNIT_CSV_DEFINITION'][$columnVarName];
							}
							$writer->write(mb_convert_encoding('"'.str_replace('"','""',$columnViewName).'"', 'SJIS-win', 'UTF-8'));
						}
						$writer->write("\n");
					}
				} else {
					// オフセットが0以上の場合追記モードでオープン
					$writer->open( $request, $tmpUri, 'a+', DIR_NAME_TMP);
				}
				if( !$request->isError() ) {
					foreach( $productObjectArray as $productObject ) {
						$csvLine	= $productObject->getCsvString($request,$csvColumnOrder);
						if( strlen(trim($csvLine)) > 0 ) {
							$csvLine	= mb_convert_encoding( $csvLine, 'SJIS-win', 'UTF-8' );
							$writer->write( $csvLine );
						}
					}
					$writer->close( $request );
				}
			}
		}


		// CSV書き込み処理後にエラーを確認
		if( $request->isError() ) {
			// エラーが発生したら処理を中断してセッション等を削除
			$request->removeSession($sessionHashName);
			$request->removeSession($sessionOffsetName);
		} else {
			// エラーがないならオフセットを進める
			$offset	+= $writeAtOnce;
			if( $offset >= $totalCount ) {
				// 総数より進んだら処理完了してダウンロード
				$filePath	= system_DataFileWriter::getRealAbsolutePath($request, $tmpUri, DIR_NAME_TMP);
				$request->removeSession($sessionHashName);
				$request->removeSession($sessionOffsetName);
				$download_file_name = 'products_'.date('YmdHi').'.csv';
				$request->setResponseHeader('Content-Type', 'application/comma-separated-values; charset="Shift_JIS"');
				$request->setResponseHeader('Content-Disposition', 'attachment; filename="'.$download_file_name.'"');
				$request->setResponseHeader('Cache-Control', 'no-store, no-cache, must-revalidate, pre-check=0, post-check=0, max-age=0');
				$request->setResponseHeader('Pragma', '');
				$request->setResponseHeader('Expires', '0');
				$request->setResponseFile( $filePath );
			} else {
				// 総数より少ないならオフセットを更新して作成処理を続行 
				$request->setSession($sessionOffsetName,$offset);
			}
		}
		$request->setAttribute('shopping.product.download.writeAtOnce', $writeAtOnce );
		$request->setAttribute('shopping.product.download.offset', $offset );
		$request->setAttribute('shopping.product.download.culumnSelectedArray', $columnSelectedArray );
		$request->setAttribute('shopping.product.download.totalCount', $totalCount );

	}
	/**
	 * モジュールの後処理を行います。
	 * このメソッドをオーバーライドすることにより、モジュールの後処理として実行されます。
	 * @param $request 
	 */
	function post_process( & $request ) {
	}
}
?>