<?php
/*
 * shopping/product/unit/LoadList.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once( dirname(dirname(__FILE__))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php' );
class shopping_product_LoadRecent extends system_login_ModuleBase {
	function shopping_product_LoadRecent() {
	}
	function execute( & $request ) {
		$dbo	= $request->getAttribute( 'dbo' );
		$recentProductObjectArray	= array();
		if( isset($_COOKIE['SHPPID']) && strlen(trim($_COOKIE['SHPPID'])) > 0 ){
			$recentProductIdStrings	= trim($_COOKIE['SHPPID']);
			$recentProductIdArray		= explode(',',$recentProductIdStrings);
			$quotedProductIdArray		= array();
			foreach($recentProductIdArray as $productId) {
				if( strlen(trim($productId)) > 0 ){
					$quotedId	= $dbo->quote(trim($productId));
					array_push($quotedProductIdArray,$quotedId);
				}
			}
			if( count($quotedProductIdArray) > 0 ){
				$sql	= 'SELECT * FROM '.TABLE_NAME_SHOPPING_PRODUCT
				.' WHERE status_flag >= 100 AND status_flag < 200'
				.' AND product_id IN ('.implode(',',$quotedProductIdArray).')';
				$shoppingProductObject	= spider_Controller::createObject('shopping_DaoShoppingProduct');
				$productObjectArray	= $dbo->queryAll( $sql, $shoppingProductObject, true, false );
				if ( $productObjectArray === false ) {
					$request->addLocaledError('database2.error.common',SPIDER_LOG_LEVEL_FATAL,array($sql));
				} else {
					foreach($recentProductIdArray as $productId) {
						foreach( $productObjectArray as $productObject ){
							if( $productObject->product_id == $productId ){
								array_push($recentProductObjectArray,$productObject);
								break;
							}
						}
					}
				}
			}
		}
		$request->setAttribute( 'shopping.product.recentProductArray',	$recentProductObjectArray );
	}
}
?>