<?php
/*
 * shopping/order/step/ConfirmPurchaser.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-10-04
 */
require_once(dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php' );
require_once( dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'DaoShoppingOrder.class.php' );
class shopping_order_step_ConfirmPurchaser extends system_login_ModuleBase {
	/**
	 * コンストラクタ
	 */
	function shopping_order_step_ConfirmPurchaser() {
		array_push($this->require_module_array,'shopping.LoadConfig');
		array_push($this->require_module_array,'shopping.order.option.LoadList');
		array_push($this->require_module_array,'shopping.order.settlement.LoadList');
		if( isset($_GET['shpoi']) && strlen(trim($_GET['shpoi'])) > 0 ) {
			array_push($this->require_module_array,'shopping.order.CartAdmin');
		} else {
			array_push($this->require_module_array,'shopping.order.Cart');
		}
		array_push($this->require_module_array,'shopping.order.step.ConfirmStock');
		// 下位互換モジュール実行
		array_push($this->require_module_array,'shopping.order.step.ConfirmOptions');
	}
	/**
	 * executeメソッド
	 */
	function execute( & $request ) {
		// 属性値取得
		$loginUserObject	= $this->getLoginUserObject( $request );
		$redirect			= $request->getParam('redirect','post');
		// カートオブジェクトの取得
		$shoppingOrderObject	= $request->getAttribute('shopping.order.orderObject');
		// POST入力値を状況に応じてオブジェクトに設定する
		$this->setMemberValues( $request, $shoppingOrderObject );
		// 購入者情報の妥当性検査
		$requrireMailAddress = true;
		if( $this->isLogin( $request )
		&& SYSTEM_LOGIN_USER_ADMINISTRATORS == $loginUserObject->getLoginGroupLevel() ) {
			$requrireMailAddress = false;
		}
		$shoppingOrderObject->validatePurchaser( $request, $requrireMailAddress );
		$operationType		= $shoppingOrderObject->confirmModifyPermittion( $request, $loginUserObject );
		if( $this->isLogin( $request )
		&& 'member_daomember' == strtolower(get_class($loginUserObject)) ) {
			// 会員ログインの場合はメールアドレス確認入力はチェックしない
		} else if( $this->isLogin( $request )
		&& ( 1 == $operationType || 3 == $operationType )
		&& strlen(trim($_POST['member_id'])) > 0 ) {
			// 管理者ログインで会員情報指定の場合はメールアドレスはチェックしない
		} else {
			// ログインしていない、または、管理者ログインでメールアドレスが入力されている場合
			if( $requrireMailAddress && strlen($shoppingOrderObject->memberObject->email_retype) == 0 ) {
				$shoppingOrderObject->memberObject->addColumnError($request,'email_retype', 'shopping.error.cart.invalidretypemail');
			} else if( $shoppingOrderObject->memberObject->email_retype != $shoppingOrderObject->memberObject->email ) {
				$shoppingOrderObject->memberObject->addColumnError($request,'email_retype', 'shopping.error.cart.invalidretypemail');
			}
		}
		// エラーがある場合は前のページにリダイレクトを設定
		if( $request->isError() ){
			if( preg_match('/^([fF](|[aA][lL][sS][eE])|[nN][oO](|[nN][eE]))$/',$redirect) == 0 ) {
				if( strlen($_SERVER['HTTP_REFERER']) > 0 ) {
					$request->redirectTo($_SERVER['HTTP_REFERER']);
				} else if( preg_match('/^\\.\\//',trim($_POST['referer'])) > 0 ) {
					$request->redirectTo(trim($_POST['referer']));
				}
			} else {
			}
		} else {
			$confirmResult	= 'OK';
			$shoppingOrderObject->columnErrorHash	= array();
			$request->setSession(SHOPPING_SESSION_NAME_ORDER_CONFIRM_PURCHASER,$confirmResult);
		}
		$request->setAttribute('shopping.order.orderObject',	$shoppingOrderObject );
	}
	/**
	 * ログイン状態に応じてPOST入力をメンバーオブジェクトに設定
	 * @param $request spider_HttpRequestオブジェクトインスタンス
	 * @param $shoppingOrderObject shopping_DaoShoppingOrder
	 */
	function setMemberValues( & $request, & $shoppingOrderObject ) {
		$memberObject		= & $shoppingOrderObject->memberObject;
		$dbo				= $request->getAttribute( 'dbo' );
		$loginUserObject	= $this->getLoginUserObject( $request );
		$operationType		= $shoppingOrderObject->confirmModifyPermittion( $request, $loginUserObject );
		// 最初にメールアドレスを確認
		if( $this->isLogin( $request )
		&& 'member_daomember' == strtolower(get_class($loginUserObject))
		&& ( $operationType == 2 || strlen($shoppingOrderObject->owner_id) == 0 ) ) {
			// 会員ログインの場合現在のＤＢ内容を読み込みし直す
			$newMemberObject	= spider_Controller::createObject('member_DaoMember');
			if( $dbo->loadById($newMemberObject,$loginUserObject->getUniqueId()) ) {
				$shoppingOrderObject->memberObject	= $newMemberObject;
				$memberObject		= & $shoppingOrderObject->memberObject;
			} else {
				$request->addLocaledError('shopping.error.order.loadmember',SPIDER_LOG_LEVEL_ERROR,array());
				return;
			}
			// 未入力の会員情報は変更入力可能
			if( strlen($memberObject->family_name_org) == 0 ) {
				$memberObject->family_name	= $request->getParam('family_name','post');
			}
			if( strlen($memberObject->first_name_org) == 0 ) {
				$memberObject->first_name	= $request->getParam('first_name','post');
			}
			$viewName	= $request->getParam('view_name','post');
			if( strlen($viewName) > 0 ){
				$memberObject->view_name		= $viewName;
			} else {
				$memberObject->view_name		= $memberObject->family_name.' '.$memberObject->first_name;
			}
			if( strlen($memberObject->family_kana_org) == 0 ) {
				$memberObject->family_kana	= $request->getParam('family_kana','post');
			}
			if( strlen($memberObject->first_kana_org) == 0 ) {
				$memberObject->first_kana	= $request->getParam('first_kana','post');
			}
			// 連絡先
			if( strlen($memberObject->zip_code_org) == 0 ) {
				$memberObject->zip_code_pre		= $request->getParam('zip_code_pre','post');
				$memberObject->zip_code_pst		= $request->getParam('zip_code_pst','post');
			}
			if( strlen($memberObject->country_name) == 0 ) {
				$memberObject->country_name				= $request->getParam('country_name','post');
			}
			if( strlen($memberObject->prefecture_number_org) == 0 ) {
				$memberObject->prefecture_number	= $request->getParam('prefecture_number','post');
			}
			if( strlen($memberObject->address_org) == 0 ) {
				$memberObject->address		= $request->getParam('address','post');
				$memberObject->building		= $request->getParam('building','post');
			}
			if( strlen($memberObject->telephone_number_org) == 0 ) {
				$memberObject->telephone_number		= $request->getParam('telephone_number','post');
				$memberObject->telephone_number_area	= $request->getParam('telephone_number_area','post');
				$memberObject->telephone_number_city	= $request->getParam('telephone_number_city','post');
				$memberObject->telephone_number_local	= $request->getParam('telephone_number_local','post');
			}
			if( strlen($memberObject->faximili_number_org) == 0 ) {
				$memberObject->faximili_number			= $request->getParam('faximili_number','post');
				$memberObject->faximili_number_area		= $request->getParam('faximili_number_area','post');
				$memberObject->faximili_number_city		= $request->getParam('faximili_number_city','post');
				$memberObject->faximili_number_local	= $request->getParam('faximili_number_local','post');
			}
			if( strlen($memberObject->mobile_number_org) == 0 ) {
				$memberObject->mobile_number			= $request->getParam('mobile_number','post');
				$memberObject->mobile_number_area		= $request->getParam('mobile_number_area','post');
				$memberObject->mobile_number_city		= $request->getParam('mobile_number_city','post');
				$memberObject->mobile_number_local		= $request->getParam('mobile_number_local','post');
			}
			// 連絡先２
			if( strlen($memberObject->zip_code2_org) == 0 ) {
				$memberObject->zip_code2_pre			= $request->getParam('zip_code2_pre','post');
				$memberObject->zip_code2_pst			= $request->getParam('zip_code2_pst','post');
			}
			if( strlen($memberObject->prefecture_number2_org) == 0 ) {
				$memberObject->prefecture_number2		= $request->getParam('prefecture_number2','post');
			}
			if( strlen($memberObject->address2_org) == 0 ) {
				$memberObject->address2					= $request->getParam('address2','post');
				$memberObject->building2				= $request->getParam('building2','post');
			}
			if( strlen($memberObject->telephone_number2_org) == 0 ) {
				$memberObject->telephone_number2		= $request->getParam('telephone_number2','post');
				$memberObject->telephone_number2_area	= $request->getParam('telephone_number2_area','post');
				$memberObject->telephone_number2_city	= $request->getParam('telephone_number2_city','post');
				$memberObject->telephone_number2_local	= $request->getParam('telephone_number2_local','post');
			}
			if( strlen($memberObject->faximili_number2_org) == 0 ) {
				$memberObject->faximili_number2			= $request->getParam('faximili_number2','post');
				$memberObject->faximili_number2_area	= $request->getParam('faximili_number2_area','post');
				$memberObject->faximili_number2_city	= $request->getParam('faximili_number2_city','post');
				$memberObject->faximili_number2_local	= $request->getParam('faximili_number2_local','post');
			}
			// 所属
			if( strlen($memberObject->company_name_org) == 0 ) {
				$memberObject->company_name	= $request->getParam('company_name','post');
			}
			if( strlen($memberObject->section_name_org) == 0 ) {
				$memberObject->section_name	= $request->getParam('section_name','post');
			}
			// プロフィール
			if( strlen($memberObject->sex_org) == 0 ) {
				$memberObject->sex	= $request->getParam('sex','post');
			}
			if( strlen($memberObject->birth_year_org) == 0 ) {
				$memberObject->birth_year	= $request->getParam('birth_year','post');
			}
			if( strlen($memberObject->birth_month_org) == 0 ) {
				$memberObject->birth_month	= $request->getParam('birth_month','post');
			}
			if( strlen($memberObject->birth_day_org) == 0 ) {
				$memberObject->birth_day	= $request->getParam('birth_day','post');
			}
			if( strlen($memberObject->blood_type_org) == 0 ) {
				$memberObject->blood_type	= $request->getParam('blood_type','post');
			}
			// ORDERオブジェクトに設定
			$shoppingOrderObject->optimize();
			// 通知先メールは選択可能
			if( isset($_POST['mail_flag']) ) {
				// 入力されているなら設定
				$mailFlag	= $request->getParam('mail_flag','post');
				if( '2' == $mailFlag && strlen($memberObject->mb_mail)>0 ) {
					$shoppingOrderObject->mail_flag	= 2;
				} else {
					$shoppingOrderObject->mail_flag	= 1;
				}
			} else {
				// 入力されていないならユーザーエージェントから自動判断
				$agentClass	= $request->getAttribute('spider.access_agent_class');
				if( 'default' != $agentClass && strlen($memberObject->mb_mail)>0 ) {
					$shoppingOrderObject->mail_flag	= 2;
				} else {
					$shoppingOrderObject->mail_flag	= 1;
				}
			}
			$shoppingOrderObject->optimize();
			$this->setLoginUserObject( $request, $memberObject );
			// 会員ログインの場合ほかの情報は入力させない
			return;
		} else if( $this->isLogin( $request )
		&& ( 1 == $operationType || 3 == $operationType ) && strlen(trim($_POST['member_id'])) > 0 ) {
			// 管理者ログインでメンバーIDが指定の場合、入力値セット前に最新の状態を読み込む
			$memberObject->member_id	= trim(stripslashes($_POST['member_id']));
			if( $dbo->loadById($memberObject,$memberObject->member_id) ) {
				$shoppingOrderObject->setMemberObject( $memberObject );
			} else {
				$request->addLocaledError('shopping.error.order.loadmember',SPIDER_LOG_LEVEL_ERROR,array());
				return false;
			}
			// 会員ログインでID指定購入の場合はメール送信先は選択
			$mailFlag	= $request->getParam('mail_flag','post');
			if( '0' == $mailFlag ) {
				$shoppingOrderObject->mail_flag	= 0;
				if( strlen($memberObject->pc_mail) > 0 ) {
					$memberObject->email		= $memberObject->pc_mail;
					$shoppingOrderObject->email	= $memberObject->pc_mail;
				} else {
					$memberObject->email		= $memberObject->mb_mail;
					$shoppingOrderObject->email	= $memberObject->mb_mail;
				}
			} else if( '2' == $mailFlag && strlen($memberObject->mb_mail)>0 ) {
				$shoppingOrderObject->mail_flag	= 2;
				$memberObject->email		= $memberObject->mb_mail;
				$shoppingOrderObject->email	= $memberObject->mb_mail;
			} else if( strlen($memberObject->pc_mail) == 0 ) {
				$shoppingOrderObject->mail_flag	= 2;
				$memberObject->email		= $memberObject->mb_mail;
				$shoppingOrderObject->email	= $memberObject->mb_mail;
			} else {
				$shoppingOrderObject->mail_flag	= 1;
				$memberObject->email		= $memberObject->pc_mail;
				$shoppingOrderObject->email	= $memberObject->pc_mail;
			}
		} else {
			// 会員情報が指定されていない場合は同一メールアドレスのレコードがあるか確認
			$memberConfirmObject		= spider_Controller::createObject('member_DaoMember');
			$sql	= 'SELECT member_number, member_id FROM '.TABLE_NAME_MEMBER
				.' WHERE ( member_class=0 OR status_flag<100 OR status_flag>=200 )'
				.' AND ( pc_mail='.$dbo->quote(trim(stripslashes($_POST['email'])))
					.' OR mb_mail='.$dbo->quote(trim(stripslashes($_POST['email']))).' )'
				.' ORDER BY member_number DESC';
			$result	= $dbo->queryAll( $sql, $memberConfirmObject,true,true );
			if( false === $result ) {
			} else if(count($result)>0){
				// 同一メールアドレスのレコードがあるなら再利用
				$memberObject	= $result[0];
				// 再利用時メールアドレスは削除しておく
				$memberObject->pc_mail			= null;
				$memberObject->mb_mail			= null;
				$shoppingOrderObject->setMemberObject( $memberObject );
			} else {
				// レコードがないなら新規に作り直し
				$memberObject	= spider_Controller::createObject('member_DaoMember');
			}
			// ログインIDはランダムに作り直し
			$memberObject->login_password		= util_CharUtility::get_rundom_password(8);
			// 入力メールアドレスを設定
			$shoppingOrderObject->setEmail( $request->getParam('email','post') );
			$memberObject->email_retype	= $request->getParam('email_retype','post');
			// 会員登録希望入力を受け付け
			$memberObject->member_class	= $request->getParam('member_class','post');
			if( preg_match('/^[0-9]{1,3}$/',$memberObject->member_class) == 0 ) {
				$memberObject->member_class	= '0';
				$memberObject->login_id	= $memberObject->member_id;
				$shoppingOrderObject->mail_flag	= 1;
				if( strlen($memberObject->mb_mail)>0 ) {
					// 設定されているのが携帯メールなら
					$shoppingOrderObject->mail_flag	= 2;
				}
			} else {
				if( strlen(trim($memberObject->login_id)) == 0 ) {
					// ログインIDが設定されていないならログインIDをメールアドレスに設定
					$memberObject->login_id	= $shoppingOrderObject->email;
				}
				$shoppingOrderObject->mail_flag	= 11;
				if( strlen($memberObject->mb_mail)>0 ) {
					// 設定されているのが携帯メールなら
					$shoppingOrderObject->mail_flag	= 12;
				}
			}
			// 管理者ログインの場合のみメール送信フラグを0に指定できる
			if( $this->isLogin( $request )
			&& SYSTEM_LOGIN_USER_ADMINISTRATORS == $loginUserObject->getLoginGroupLevel() ) {
				$mailFlag	= $request->getParam('mail_flag','post');
				if( '0' == $mailFlag ) {
					$shoppingOrderObject->mail_flag	= 0;
				}
			}
		}

		// 購入が発生する場合は個人情報の状態フラグを有効にする
		$memberObject->status_flag			= 101;

		// 入力値メンバに再セット
		$memberObject->family_name			= $request->getParam('family_name','post');
		$memberObject->first_name			= $request->getParam('first_name','post');
		$viewName	= $request->getParam('view_name','post');
		if( strlen($viewName) > 0 ){
			$memberObject->view_name		= $viewName;
		} else {
			$memberObject->view_name		= $memberObject->family_name.' '.$memberObject->first_name;
		}
		// 連絡先
		$memberObject->country_name				= $request->getParam('country_name','post');
		$memberObject->zip_code_pre			= $request->getParam('zip_code_pre','post');
		$memberObject->zip_code_pst			= $request->getParam('zip_code_pst','post');
		$memberObject->prefecture_number	= $request->getParam('prefecture_number','post');
		$memberObject->address				= $request->getParam('address','post');
		$memberObject->building				= $request->getParam('building','post');
		$memberObject->telephone_number		= $request->getParam('telephone_number','post');
		$memberObject->telephone_number_area	= $request->getParam('telephone_number_area','post');
		$memberObject->telephone_number_city	= $request->getParam('telephone_number_city','post');
		$memberObject->telephone_number_local	= $request->getParam('telephone_number_local','post');
		$memberObject->faximili_number			= $request->getParam('faximili_number','post');
		$memberObject->faximili_number_area		= $request->getParam('faximili_number_area','post');
		$memberObject->faximili_number_city		= $request->getParam('faximili_number_city','post');
		$memberObject->faximili_number_local	= $request->getParam('faximili_number_local','post');
		$memberObject->mobile_number			= $request->getParam('mobile_number','post');
		$memberObject->mobile_number_area		= $request->getParam('mobile_number_area','post');
		$memberObject->mobile_number_city		= $request->getParam('mobile_number_city','post');
		$memberObject->mobile_number_local		= $request->getParam('mobile_number_local','post');
		// 連絡先２
		$memberObject->zip_code2_pre			= $request->getParam('zip_code2_pre','post');
		$memberObject->zip_code2_pst			= $request->getParam('zip_code2_pst','post');
		$memberObject->prefecture_number2		= $request->getParam('prefecture_number2','post');
		$memberObject->address2					= $request->getParam('address2','post');
		$memberObject->building2				= $request->getParam('building2','post');
		$memberObject->telephone_number2		= $request->getParam('telephone_number2','post');
		$memberObject->telephone_number2_area	= $request->getParam('telephone_number2_area','post');
		$memberObject->telephone_number2_city	= $request->getParam('telephone_number2_city','post');
		$memberObject->telephone_number2_local	= $request->getParam('telephone_number2_local','post');
		$memberObject->faximili_number2			= $request->getParam('faximili_number2','post');
		$memberObject->faximili_number2_area	= $request->getParam('faximili_number2_area','post');
		$memberObject->faximili_number2_city	= $request->getParam('faximili_number2_city','post');
		$memberObject->faximili_number2_local	= $request->getParam('faximili_number2_local','post');

		$memberObject->sex				= $request->getParam('sex','post');
		$memberObject->birth_year		= $request->getParam('birth_year','post');
		$memberObject->birth_month		= $request->getParam('birth_month','post');
		$memberObject->birth_day		= $request->getParam('birth_day','post');
		$memberObject->blood_type		= $request->getParam('blood_type','post');
		$memberObject->company_name		= $request->getParam('company_name','post');
		$memberObject->section_name		= $request->getParam('section_name','post');
		$shoppingOrderObject->optimize();
	}
}
?>