<?php
/*
 * shopping/order/settlement/LoadList.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once(dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php' );
/**
 * shopping_order_settlement_LoadList
 * spiderモジュール：shoppingパッケージ インストール済み決済方法プラグイン読み込みモジュール
 * 
 */
class shopping_order_settlement_LoadListExists extends system_login_ModuleBase {
	
	function shopping_order_settlement_LoadListExists() {
	}
	function execute( & $request ) {
		// 利用可能な決済方法の読み込み
		$settleMethodObjectArray	= array();
		$settleDir	= dirname(dirname(__FILE__)).DIRECTORY_SEPARATOR.'settlement';
		if( is_dir($settleDir) ) {
			if( $dh = @opendir($settleDir) ) {
				while (($fileName = readdir($dh)) !== false) {
					if( preg_match('/^Method/',$fileName) > 0 && 'MethodBase.class.php' != $fileName ) {
						$className		= 'shopping_order_settlement_'.preg_replace('/\\.class\\.php$/','',$fileName);
						$settleObject	= spider_Controller::createObject($className);
						// 設定読み込み
						$settleObject->load( $request );
						if( !is_array($settleObject->memberClassArray) || count($settleObject->memberClassArray) == 0 ) {
							$settleObject->memberClassArray	= array_keys($GLOBALS['MEMBER_MEMBER_CLASS_HASH']);
						}
						$settleMethodObjectArray[$settleObject->getMethodNumber()]	= $settleObject;
					}
				}
				@closedir($settleDir);
			}
		}
		ksort($settleMethodObjectArray);
		$request->setAttribute('shopping.order.settlement.methodExistsObjectArray',	$settleMethodObjectArray );
	}
}
?>