<?php
/*
 * shopping/order/option/Form.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once(dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php' );
class shopping_order_option_Form extends system_login_ModuleBase {
	function shopping_order_option_Form() {
	}
	function execute( & $request ) {
		$searchDataId			= $request->getParam('schdi','get');
		$optionFileUri			= SHOPPING_OPTIONS_FILE_URI;
		if( preg_match('/^[0-9a-zA-Z]+$/',$searchDataId) > 0 ) {
			$optionFileUri	= dirname(SHOPPING_OPTIONS_FILE_URI).'/extoptions/'.$searchDataId;
		}
		$optionNumber			= mb_convert_kana(trim(stripslashes($_GET['sop'])),'a');
		$sessionObjectName		= 'shopping.order.option.modify.object.'.$optionNumber;
		$sessionConfirmName		= 'shopping.order.option.modify.confirm.'.$optionNumber;
		$loginUserObject		= $this->getLoginUserObject( $request );
		// 検索パッケージ連携
		if( strlen(trim($searchDataId)) > 0 ) {
			$dbo		= $request->getAttribute( 'dbo' );
			$searchDataObject	= spider_Controller::createObject('search_DaoSearchData');
			if( $dbo->loadById($searchDataObject,$searchDataId) ) {
				if( $this->isLogin( $request )
				&& $loginUserObject->getUniqueId() == $searchDataObject->owner_id
				|| SYSTEM_LOGIN_USER_ADMINISTRATORS == $loginUserObject->getLoginGroupLevel() ) {
					$request->setAttribute('shopping.order.option.searchDataObject',$searchDataObject);
				} else {
					$request->addLocaledError('system.error.login.user.noauthexec',SPIDER_LOG_LEVEL_ERROR,array());
				}
			} else {
				$request->addLocaledError('shopping.error.search.notfound',SPIDER_LOG_LEVEL_FATAL,array(''));
			}
		}
		// オプションクラスファイルを要求
		if( $dh	= @opendir(dirname(__FILE__).DIRECTORY_SEPARATOR.'type') ) {
			while (($fileName = readdir($dh)) !== false) {
				if( preg_match('/\\.class\\.php$/',$fileName) > 0 ){
					$absolutePath	= dirname(__FILE__).DIRECTORY_SEPARATOR.'type'.DIRECTORY_SEPARATOR.$fileName;
					require_once($absolutePath);
				}
			}
		} else {
			$request->addLocaledError('shopping.error.option.loadfolder',SPIDER_LOG_LEVEL_ERROR,array());
			return false;
		}
		
		$optionObject			= $request->getSession($sessionObjectName);
		$compareOption			= spider_Controller::createObject('shopping_DaoShoppingOrderOption');
		$request->removeSession($sessionObjectName);
		$request->removeSession($sessionConfirmName);
		if( !is_null($optionObject) && is_a($optionObject,get_class($compareOption)) ) {
			// セッションにあるならそのまま利用
		} else {
			$strings	= system_DataFileWriter::getContents( $request, $optionFileUri );
			$optionHash	= unserialize($strings);
			if( !is_array($optionHash) ) {
				$optionHash	= array();
			}
			if( strlen($optionNumber) == 0 ) {
				// 番号未指定の場合はフォーム画面暫定でTextで作成
				$optionObject	= spider_Controller::createObject('shopping_order_option_type_Text');
				$nextNumber	= 0;
				foreach( $optionHash as $key => $object ) {
					if( $key >= $nextNumber ) {
						$nextNumber	= $key + 1;
					}
				}
				$optionObject->optionNumber	= $nextNumber;
			} else if( preg_match('/^[0-9]{1,3}$/',$optionNumber) == 0 ) {
				// 番号が不正
				$request->addLocaledError('shopping.error.option.notfound',SPIDER_LOG_LEVEL_ERROR,array());
			} else {
				// 番号指定があるなら
				$optionObject	= $optionHash[$optionNumber];
				if( is_null($optionObject) || !is_a($optionObject,get_class($compareOption)) ) {
					$request->addLocaledError('shopping.error.option.notfound',SPIDER_LOG_LEVEL_ERROR,array());
				} else {
				}
			}
		}
		$request->setAttribute('shopping.order.option.optionObject',$optionObject);
	}
}
?>