<?php
/*
 * shopping/order/option/Confirm.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once(dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php' );
class shopping_order_option_Confirm extends system_login_ModuleBase {
	function shopping_order_option_Confirm() {
	}
	function execute( & $request ) {
		$searchDataId			= $request->getParam('schdi','get');
		$optionFileUri			= SHOPPING_OPTIONS_FILE_URI;
		if( preg_match('/^[0-9a-zA-Z]+$/',$searchDataId) > 0 ) {
			$optionFileUri	= dirname(SHOPPING_OPTIONS_FILE_URI).'/extoptions/'.$searchDataId;
		}
		$optionNumber			= mb_convert_kana(trim(stripslashes($_GET['sop'])),'a');
		$sessionObjectName		= 'shopping.order.option.modify.object.'.$optionNumber;
		$sessionConfirmName		= 'shopping.order.option.modify.confirm.'.$optionNumber;
		$loginUserObject		= $this->getLoginUserObject( $request );
		$request->removeSession($sessionObjectName);
		$request->removeSession($sessionConfirmName);
		
		// 検索パッケージ連携
		if( strlen(trim($searchDataId)) > 0 ) {
			$dbo		= $request->getAttribute( 'dbo' );
				$searchDataObject	= spider_Controller::createObject('search_DaoSearchData');
				if( $dbo->loadById($searchDataObject,$searchDataId) ) {
					if( $this->isLogin( $request )
					&& $loginUserObject->getUniqueId() == $searchDataObject->owner_id
					|| SYSTEM_LOGIN_USER_ADMINISTRATORS == $loginUserObject->getLoginGroupLevel() ) {
						$request->setAttribute('shopping.order.option.searchDataObject',$searchDataObject);
					} else {
						$request->addLocaledError('system.error.login.user.noauthexec',SPIDER_LOG_LEVEL_ERROR,array());
					}
				} else {
					$request->addLocaledError('shopping.error.search.notfound',SPIDER_LOG_LEVEL_FATAL,array(''));
				}
		}
		// オプションクラスファイルを要求
		if( $dh	= @opendir(dirname(__FILE__).DIRECTORY_SEPARATOR.'type') ) {
			while (($fileName = readdir($dh)) !== false) {
				if( preg_match('/\\.class\\.php$/',$fileName) > 0 ){
					$absolutePath	= dirname(__FILE__).DIRECTORY_SEPARATOR.'type'.DIRECTORY_SEPARATOR.$fileName;
					require_once($absolutePath);
				}
			}
		} else {
			$request->addLocaledError('shopping.error.option.loadfolder',SPIDER_LOG_LEVEL_ERROR,array());
			return false;
		}
		
		$strings		= system_DataFileWriter::getContents( $request, $optionFileUri );
		$optionHash		= unserialize($strings);
		if( !is_array($optionHash) ) {
			$optionHash	= array();
		}

		$optionObject	= null;
		if( strlen($optionNumber) == 0 ) {
			$optionObject	= spider_Controller::createObject('shopping_DaoShoppingOrderOption');
		} else if( preg_match('/^[0-9]{0,2}$/',$optionNumber) == 0 ) {
			$request->addLocaledError('shopping.error.option.notfound',SPIDER_LOG_LEVEL_ERROR,array());
			return false;
		} else if( !isset($optionHash[$optionNumber]) ) {
			$request->addLocaledError('shopping.error.option.notfound',SPIDER_LOG_LEVEL_ERROR,array());
			return false;
		} else {
			$optionObject	= $optionHash[$optionNumber];
		}
		$compareOption	= spider_Controller::createObject('shopping_DaoShoppingOrderOption');

		$optionType		= stripslashes($_POST['optionType']);
		$className		= 'shopping_order_option_type_'.ucfirst($optionType);
		if( class_exists($className) ) {
			$optionObject				= spider_Controller::createObject($className);
			$optionObject->optionNumber	= trim(stripslashes($_POST['optionNumber']));;
			$optionObject->optionName	= mb_convert_kana(trim(stripslashes($_POST['optionName'])),'KVa');
			$optionObject->width		= mb_convert_kana(trim(stripslashes($_POST['width'])),'a');
			$optionObject->height		= mb_convert_kana(trim(stripslashes($_POST['height'])),'a');
			$optionObject->required		= mb_convert_kana(trim(stripslashes($_POST['required'])),'a');
			$optionObject->options		= mb_convert_kana(trim(stripslashes($_POST['options'])),'KVa');
			$optionObject->prices		= mb_convert_kana(trim(stripslashes($_POST['prices'])),'KVa');
			$optionObject->costs		= mb_convert_kana(trim(stripslashes($_POST['costs'])),'KVa');
			$optionObject->explain		= mb_convert_kana(trim(stripslashes($_POST['explain'])),'KVa');
			
			$optionObject->options		= str_replace("\r\n","\n",$optionObject->options);
			$optionObject->options		= str_replace("\r","\n",$optionObject->options);
			$optionObject->prices		= str_replace("\r\n","\n",$optionObject->prices);
			$optionObject->prices		= str_replace("\r","\n",$optionObject->prices);
			$optionObject->costs		= str_replace("\r\n","\n",$optionObject->costs);
			$optionObject->costs		= str_replace("\r","\n",$optionObject->costs);

			$optionObject->explain		= str_replace("\r\n","\n",$optionObject->explain);
			$optionObject->explain		= str_replace("\r","\n",$optionObject->explain);
			if( strlen($optionObject->required) > 0 ) {
				$optionObject->required	= true;
			} else {
				$optionObject->required	= false;
			}
			
			if( preg_match('/^[0-9]{0,2}$/',$optionObject->optionNumber) == 0 ) {
				$request->addLocaledError('shopping.error.option.invalidnumber',SPIDER_LOG_LEVEL_ERROR,array());
			} else if( strlen($optionNumber) > 0 && strlen($optionObject->optionNumber) > 0 ) {
				// 編集の場合
				if( $optionObject->optionNumber != $optionNumber ) {
					// オプション番号が変更されている場合
					if( isset($optionHash[$optionObject->optionNumber]) ) {
						// オプションが既にあるならエラー
						$request->addLocaledError('shopping.error.option.duplicatednumber',SPIDER_LOG_LEVEL_ERROR,array());
					}
				}
			} else if( strlen($optionObject->optionNumber) > 0 ) {
				// 新規の場合
				if( isset($optionHash[$optionObject->optionNumber]) ) {
					// オプションが既にあるならエラー
					$request->addLocaledError('shopping.error.option.duplicatednumber',SPIDER_LOG_LEVEL_ERROR,array());
				}
			} else {
				// 新規の場合でオプション番号指定がないなら連番
				$nextNumber	= 0;
				foreach( $optionHash as $key => $object ) {
					if( $key >= $nextNumber ) {
						$nextNumber	= $key + 1;
					}
				}
				$optionObject->optionNumber	= $nextNumber;
			}
			foreach( $optionHash as $oNum => $cOptionObject ) {
				if( $cOptionObject->optionName == $optionObject->optionName
				&& $cOptionObject->optionNumber != $optionObject->optionNumber ) {
					$request->addLocaledError('shopping.error.option.duplicatename',SPIDER_LOG_LEVEL_ERROR,array());
					break;
				}
			}
			if( preg_match('/^[0-9]{0,2}$/',$optionObject->width) == 0 ) {
				$request->addLocaledError('shopping.error.option.invalidwidth',SPIDER_LOG_LEVEL_ERROR,array());
			}
			if( preg_match('/^[0-9]{0,2}$/',$optionObject->height) == 0 ) {
				$request->addLocaledError('shopping.error.option.invalidheight',SPIDER_LOG_LEVEL_ERROR,array());
			}
			if( preg_match('/^[0-9]*$/',str_replace("\n","",$optionObject->prices)) == 0 ) {
				$request->addLocaledError('shopping.error.option.invalidprice',SPIDER_LOG_LEVEL_ERROR,array());
			}
			if( preg_match('/^[0-9]*$/',str_replace("\n","",$optionObject->costs)) == 0 ) {
				$request->addLocaledError('shopping.error.option.invalidcost',SPIDER_LOG_LEVEL_ERROR,array());
			}
			
		} else {
			$request->addLocaledError('shopping.error.option.typenotfound',SPIDER_LOG_LEVEL_ERROR,array());
		}

		if( $request->isError() ) {
			$request->removeSession($sessionConfirmName);
		} else {
			$request->setSession($sessionConfirmName,'OK');
		}
		$request->setSession($sessionObjectName,$optionObject);
		$request->setAttribute('shopping.order.option.optionObject',$optionObject);
	}
}
?>