<?php
/*
 * shopping/order/ServiceTerm.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once( dirname(dirname(__FILE__))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php' );
class shopping_order_ServiceTerm extends system_login_ModuleBase {
	function shopping_order_ServiceTerm() {
		array_push($this->require_module_array,'system.login.Require');
		array_push($this->require_module_array,'database2.Transaction');
		array_push($this->require_module_array,'shopping.order.settlement.LoadList');
	}
	function execute( & $request ) {
		$dbo			= $request->getAttribute( 'dbo' );
		$orderItemId	= $request->getParam('item_id','post');
		$svcStartDate	= $request->getParam('svc_start_date','post');
		$svcLimitDate	= $request->getParam('svc_limit_date','post');
		$isNotify		= $request->getParam('is_notify','post');
		$loginUserObject	= $this->getLoginUserObject( $request );
		$oldOrderObject		= null;
		if( strlen($orderItemId) == 0 ) {
			$request->addLocaledError('shopping.error.order.required',SPIDER_LOG_LEVEL_ERROR,array(''));
			return;
		} else if( strtotime($svcLimitDate) <= strtotime($svcStartDate) ) {
			$request->addLocaledError('shopping.error.cart.requiredate',SPIDER_LOG_LEVEL_ERROR,array(''));
			return;
		}
		// 変更前情報の保存変数
		$oldSvcStartDate=null;
		$oldSvcLimitDate=null;
		// 対象のアイテムを読み込み
		$orderItemObject	= spider_Controller::createObject('shopping_DaoShoppingOrderItem');
		if( $dbo->loadById( $orderItemObject, $orderItemId, true ) ) {
			if( $orderItemObject->delivery_type < 200 ) {
				$request->addLocaledError('system.error.common.invalidusage',SPIDER_LOG_LEVEL_ERROR,array(''));
				return;
			}
			$oldSvcStartDate	= $orderItemObject->svc_start_date;
			$oldSvcLimitDate	= $orderItemObject->svc_limit_date;
		}
		// 対象のORDER情報を取得
		$operationType		= 0;
		$oldOrderObject		= spider_Controller::createObject('shopping_DaoShoppingOrder');
		if( $dbo->loadById( $oldOrderObject, $orderItemObject->order_id, true ) ) {
			$oldOrderObject->optimize();
			// 操作ユーザーの判断
			$operationType	= $oldOrderObject->confirmModifyPermittion( $request, $loginUserObject );
		} else {
			$request->addLocaledError('shopping.error.order.notfound',SPIDER_LOG_LEVEL_FATAL,array(''));
			return;
		}
		// 販売単位オブジェクトの取得
		$shoppingProductUnitObject	= $orderItemObject->getUnitObject( $request );
		if( !is_object($shoppingProductUnitObject) ) {
			$request->addLocaledError('shopping.error.product.notfound',SPIDER_LOG_LEVEL_ERROR,array(''));
			return;
		}
		$shoppingProductUnitObject->optimizeLoadedVars($dbo);
		// 指定期間の予約可能数を取得
		$maxStock	= $shoppingProductUnitObject->getStock($request,$svcStartDate,$svcLimitDate,$orderItemId);
		if( $maxStock < $orderItemObject->order_count ) {
			$request->addLocaledError('shopping.error.cart.enablekeepterm',SPIDER_LOG_LEVEL_ERROR,array(''));
			return;
		}
		// 項目の期間を更新
		$orderItemObject->svc_start_date	= $svcStartDate;
		$orderItemObject->svc_limit_date	= $svcLimitDate;
		if( $dbo->update( $orderItemObject ) ){
			if($orderItemObject->useUnitStock( $request )){
			} else {
				$request->addLocaledError('database2.error.update',SPIDER_LOG_LEVEL_FATAL,array(''));
				return;
			}
		} else {
			$request->addLocaledError('database2.error.update',SPIDER_LOG_LEVEL_FATAL,array(''));
			return;
		}
		// 金額を再計算する為に読み込み
		$shoppingOrderObject	= spider_Controller::createObject('shopping_DaoShoppingOrder');
		if( $dbo->loadById( $shoppingOrderObject, $orderItemObject->order_id) ) {
			// 金額の再計算
			$shoppingOrderObject->calculate( $request, true );
			// 更新日と状態の変更
			$shoppingOrderObject->updated_date	= date('Y-m-d H:i:s');
			// データベース更新
			if( $dbo->update( $shoppingOrderObject ) ){
			} else {
				$request->addLocaledError('database2.error.update',SPIDER_LOG_LEVEL_FATAL,array(''));
				return;
			}
		} else {
			$request->addLocaledError('shopping.error.order.notfound',SPIDER_LOG_LEVEL_FATAL,array(''));
			return;
		}
		$historyNote	= '['.date('Y-m-d H:i',strtotime($oldSvcStartDate)).' - '.date('Y-m-d H:i',strtotime($oldSvcLimitDate)).']'
		.'から['.date('Y-m-d H:i',strtotime($svcStartDate)).' - '.date('Y-m-d H:i',strtotime($svcLimitDate))
		.']に変更され、金額が\\'.number_format($oldOrderObject->payment_total)
		.'から\\'.number_format($shoppingOrderObject->payment_total).'になりました。';
		if(!$shoppingOrderObject->writeHistoryNote( $request, '期間変更', $historyNote, '', $loginUserObject )){
			$request->addLocaledError('shopping.error.order.failtohistory',SPIDER_LOG_LEVEL_FATAL,array(''));
		}
		// メール通知の判断
		$requireSendMail	= false;
		if( 2 == $operationType ) {
			$requireSendMail	= true;
			if( $oldOrderObject->status_flag > 5 ){
				// 変更前が仮予約・申請中以外の場合は記録を残す
				$oldOrderObject->saveSerialized( $request );
			}
		} else if( preg_match('/^([tT](|[rR][uU][eE])|[yY](|[eE][sS]))$/',$isNotify) > 0 ){
			$requireSendMail	= true;
		}
		if( $requireSendMail ) {
			// 送信用に情報を整形
			require_once(dirname(__FILE__).'/Optimize.class.php');
			shopping_order_Optimize::_setEnvironmentFor11x( $request, $shoppingOrderObject );
			shopping_order_Optimize::_setEnvironmentFor11x( $request, $oldOrderObject );
			$bcc	= null;
			// 通知メール
			if(defined('SHOPPING_MAIL_ADDRESS_NOTIFY') && strlen(SHOPPING_MAIL_ADDRESS_NOTIFY) > 0 ) {
				$bcc	= SHOPPING_MAIL_ADDRESS_NOTIFY;
			}
			// 申込者にメール通知
			$memberObject	= & $shoppingOrderObject->memberObject;
			$targetMail		= null;
			if( ( $shoppingOrderObject->mail_flag == 2 || $shoppingOrderObject->mail_flag == 12 )
			&& strlen($memberObject->mb_mail) > 0 ) {
				$targetMail	= $memberObject->mb_mail;
			} else if( strlen($memberObject->pc_mail) > 0 ) {
				$targetMail	= $memberObject->pc_mail;
			}
			if( is_null($targetMail) ) {
				$request->addLocaledError('shopping.error.order.invalidmail',SPIDER_LOG_LEVEL_FATAL,array(''));
			} else {
				// 変更前の情報の文章を作成
				$orgTemplateInfo	= $oldOrderObject->getMailTemplateInformation( $request,'SHOPMAILODRINFO',$targetMail);
				$replaceHash			= array();
				$replaceHash['old_order_information']	= $orgTemplateInfo['body'];
				if( $shoppingOrderObject->sendInformationMail( $request, $targetMail, 'SHOPMAILTHANKSMD', $bcc, '', $replaceHash, $loginUserObject ) ) {
				} else {
					$request->addLocaledError('shopping.error.order.failtonotifymail',SPIDER_LOG_LEVEL_FATAL,array(''));
				}
			}
			// オーナーへのメール通知
			if( !$request->isError() ) {
				$ownerMemberObjectArray	= $shoppingOrderObject->getProducerMemberObjectArray( $request );
				foreach( $ownerMemberObjectArray as $ownerMemberObject ) {
					// オーナーへのメールはＰＣを優先
					$email	= $ownerMemberObject->pc_mail;
					if( strlen($email) == 0 && strlen($ownerMemberObject->mb_mail) > 0 ) {
						$email	= $ownerMemberObject->mb_mail;
					}
					if( strlen($email) > 0 ) {
						$orgTemplateInfo	= $oldOrderObject->getMailTemplateInformation( $request,'SHOPMAILODRINFO',SHOPPING_MAIL_ADDRESS_NOTIFY);
						$replaceHash			= array();
						$replaceHash['old_order_information']	= $orgTemplateInfo['body'];
						if($shoppingOrderObject->sendInformationMail( $request, $email, 'SHOPMAILNOTIFYMD', null, '', $replaceHash, $loginUserObject ) ) {
						} else {
							$request->addLocaledError('shopping.error.order.failtoownermail',SPIDER_LOG_LEVEL_FATAL,array(''));
						}
					}
				}
			}
			// 管理者に通知メール
			if( !$request->isError() && defined('SHOPPING_MAIL_ADDRESS_NOTIFY') && strlen(SHOPPING_MAIL_ADDRESS_NOTIFY) > 0 ){
					spider_Controller::loadClassDefinition('util_Mail');
				$mailAddressArray	= util_Mail::divideCsvEmail( SHOPPING_MAIL_ADDRESS_NOTIFY );
				foreach( $mailAddressArray as $addNum => $address ) {
					$orgTemplateInfo	= $oldOrderObject->getMailTemplateInformation( $request,'SHOPMAILODRINFO',SHOPPING_MAIL_ADDRESS_NOTIFY);
					$replaceHash			= array();
					$replaceHash['old_order_information']	= $orgTemplateInfo['body'];
					if( $shoppingOrderObject->sendInformationMail( $request, $address, 'SHOPMAILNOTIFYMD', null, '', $replaceHash, $loginUserObject ) ) {
					} else {
						$request->addLocaledError('shopping.error.order.failtoadminmail',SPIDER_LOG_LEVEL_FATAL,array(''));
						break;
					}
				}
			}
		}
		$request->setAttribute('shopping.order.orderItemObject',	$orderItemObject );
	}
}
?>