<?php
/*
 * shopping/order/SendMail.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once( dirname(dirname(__FILE__))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php' );
class shopping_order_SendMail extends system_login_ModuleBase {
	function shopping_order_SendMail() {
		array_push($this->require_module_array,'system.login.Require');
		array_push($this->require_module_array,'shopping.order.settlement.LoadList');
		array_push($this->require_module_array,'shopping.order.settlement.LoadListExists');
	}
	function execute( & $request ) {
		$dbo						= $request->getAttribute( 'dbo' );
		$orderId				= $request->getParam('order_id','post');
		$mailTemplateId	= $request->getParam('template_id','post');
		$sendOwner			= $request->getParam('send_owner','post');
		$sendAdmin			= $request->getParam('send_admin','post');
		$shoppingOrderObject	= spider_Controller::createObject('shopping_DaoShoppingOrder');
		$loginUserObject		= $this->getLoginUserObject( $request );
		if( preg_match('/^[0-9]+$/',$orderId) > 0 ) {
			// 番号があるなら読み込み
			if( $dbo->loadById( $shoppingOrderObject, $orderId, true ) ) {
			} else {
				$request->addLocaledError('shopping.error.order.notfound',SPIDER_LOG_LEVEL_FATAL,array(''));
			}
		} else if( preg_match('/^[0-9a-zA-Z\\-\\_\\.]+$/',$orderId) > 0 ) {
			// IDがあるなら読み込み
			if( $dbo->loadById( $shoppingOrderObject, $orderId, true ) ) {
			} else {
				$request->addLocaledError('shopping.error.order.notfound',SPIDER_LOG_LEVEL_FATAL,array(''));
			}
		} else {
			$request->addLocaledError('shopping.error.order.notfound',SPIDER_LOG_LEVEL_FATAL,array(''));
		}
		// 操作しようとしているログイン者がこの申し込みにどうかかわっているか確認
		$operationType	= 0;
		if( !$request->isError() ) {
			$operationType	= $shoppingOrderObject->confirmModifyPermittion( $request, $loginUserObject );
		}
		if( $operationType == 0 || $operationType == 2) {
			$request->addLocaledError('system.error.login.user.noauthexec',SPIDER_LOG_LEVEL_ERROR,array());
		}
		// メールテンプレートの存在確認
		$memberMailTemplate	= spider_Controller::createObject('member_DaoMemberMailTemplate');
		if( $dbo->loadById($memberMailTemplate,$mailTemplateId) ){
			if(strlen($memberMailTemplate->subject)==0 && strlen($memberMailTemplate->subject_mobile)==0 ){
				$request->addLocaledError('shopping.error.cart.admin.nomailbody',SPIDER_LOG_LEVEL_ERROR,array());
			} else if(strlen($memberMailTemplate->text_body_mobile)==0 && strlen($memberMailTemplate->text_body_default)==0 ){
				$request->addLocaledError('shopping.error.cart.admin.nomailbody',SPIDER_LOG_LEVEL_ERROR,array());
			}
		} else {
			$request->addLocaledError('member.error.mail.template.notfound',SPIDER_LOG_LEVEL_FATAL,array(''));
		}
		// メール通知
		if( !$request->isError() ) {
			$bcc	= null;
			// 通知メールBCC
			if(defined('SHOPPING_MAIL_ADDRESS_BCC') && strlen(SHOPPING_MAIL_ADDRESS_BCC) > 0 ) {
				$bcc	= SHOPPING_MAIL_ADDRESS_BCC;
			}
			// 送信情報の整形
			require_once(dirname(__FILE__).'/Optimize.class.php');
			shopping_order_Optimize::_setEnvironmentFor11x( $request, $shoppingOrderObject );
			// 申込者に送信
			$memberObject	= & $shoppingOrderObject->memberObject;
			$targetMail		= null;
			if( ( $shoppingOrderObject->mail_flag == 2 || $shoppingOrderObject->mail_flag == 12 )
			&& strlen($memberObject->mb_mail) > 0 ) {
				$targetMail	= $memberObject->mb_mail;
			} else if( strlen($memberObject->pc_mail) > 0 ) {
				$targetMail	= $memberObject->pc_mail;
			}
			if( is_null($targetMail) ) {
				$request->addLocaledError('shopping.error.order.invalidmail',SPIDER_LOG_LEVEL_FATAL,array(''));
			} else {
				if( $shoppingOrderObject->sendInformationMail( $request, $targetMail, $mailTemplateId, $bcc, '', array(), $loginUserObject ) ) {
				} else {
					$request->addLocaledError('shopping.error.order.failtonotifymail',SPIDER_LOG_LEVEL_FATAL,array(''));
				}
			}
			// オーナーに通知
			if( preg_match('/^([tT](|[rR][uU][eE])|[yY](|[eE][sS]))$/',$sendOwner) > 0 ){
				$ownerMemberObjectArray	= $shoppingOrderObject->getProducerMemberObjectArray( $request );
				foreach( $ownerMemberObjectArray as $ownerMemberObject ) {
					// オーナーへのメールはＰＣを優先
					$email	= $ownerMemberObject->pc_mail;
					if( strlen($email) == 0 && strlen($ownerMemberObject->mb_mail) > 0 ) {
						$email	= $ownerMemberObject->mb_mail;
					}
					if( strlen($email) > 0 ) {
						if($shoppingOrderObject->sendInformationMail( $request, $email, $mailTemplateId, $bcc, '', array(), $loginUserObject ) ) {
						} else {
							$request->addLocaledError('shopping.error.order.failtoownermail',SPIDER_LOG_LEVEL_FATAL,array(''));
							break;
						}
					}
				}
			}
			// 管理者宛てに通知
			if( preg_match('/^([tT](|[rR][uU][eE])|[yY](|[eE][sS]))$/',$sendAdmin) > 0 ){
				if( !$request->isError() && defined('SHOPPING_MAIL_ADDRESS_NOTIFY') && strlen(SHOPPING_MAIL_ADDRESS_NOTIFY) > 0 ) {
					spider_Controller::loadClassDefinition('util_Mail');
					$mailAddressArray	= util_Mail::divideCsvEmail( SHOPPING_MAIL_ADDRESS_NOTIFY );
					foreach( $mailAddressArray as $addNum => $address ) {
						if( $shoppingOrderObject->sendInformationMail( $request, $address, $mailTemplateId, null, '', array(), $loginUserObject ) ) {
						} else {
							$request->addLocaledError('shopping.error.order.failtoadminmail',SPIDER_LOG_LEVEL_FATAL,array(''));
							break;
						}
					}
				}
			}
		}
		$request->setAttribute('shopping.order.orderObject',	$shoppingOrderObject );
	}
}
?>