<?php
/*
 * shopping/flag/Confirm.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Last Update: 2010-02-12
 * 
 */
require_once( dirname(dirname(__FILE__))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php' );
require_once( dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'content'
.DIRECTORY_SEPARATOR.'Uploader.class.php');
class shopping_flag_Confirm extends system_login_ModuleBase {
	
	function shopping_flag_Confirm(){
	}
	function execute( & $request ) {
		
		$dbo						= $request->getAttribute( 'dbo' );
		$shoppingProductFlagNumber	= stripslashes( $_GET['shpfn'] );
		$sessionObjectName			= 'shopping.flag.modify.object.'.$shoppingProductFlagNumber;
		$sessionConfirmName			= 'shopping.flag.modify.confirm.'.$shoppingProductFlagNumber;
		$shoppingProductFlagObject	= $request->getSession($sessionObjectName);
		$request->removeSession($sessionConfirmName);
		
		if( 'shopping_daoshoppingproductflag' == strtolower(get_class($shoppingProductFlagObject)) ){
			// セッションに登録済みの場合アップロードファイルがあれば削除
			if( is_object($shoppingProductFlagObject->contentUploader)
				&& 'content_uploader' == strtolower(get_class($shoppingProductFlagObject->contentUploader)) ) {
				$shoppingProductFlagObject->contentUploader->initialize( $request );
			}
		}
		
		// データベースの最新状態から差分をとる為読み込みしなおす
		$shoppingProductFlagObject	= spider_Controller::createObject('shopping_DaoShoppingProductFlag');
		if( strlen(trim($shoppingProductFlagNumber)) > 0 ) {
			// 管理者IDが指定されていないなら編集の為読み込み
			if( $dbo->loadByNumber( $shoppingProductFlagObject, $shoppingProductFlagNumber ) ) {
			} else {
				$request->addLocaledError('shopping.error.flag.notfound',SPIDER_LOG_LEVEL_FATAL,array(''));
			}
		}
		// 入力値のセットとチェック
		$shoppingProductFlagObject->flag_id	= stripslashes($_POST['flag_id']);
		$shoppingProductFlagObject->flag_name	= stripslashes($_POST['flag_name']);
		$shoppingProductFlagObject->order_number	= stripslashes($_POST['order_number']);
		$shoppingProductFlagObject->description	= stripslashes($_POST['description']);

		// 入力値の妥当性検査を行う
		$shoppingProductFlagObject->validate( $request );
		
		// 削除ファイルの指示
		$delete_fileIdArray	= $_POST['delete_fileIdArray'];
		if( is_array( $delete_fileIdArray ) ) {
			$newFileIdArray	= array();
			foreach($shoppingProductFlagObject->fileIdArray as $key => $tFileId ) {
				if( !in_array($tFileId,$delete_fileIdArray) ) {
					// 削除対象にないなら追加
					array_push( $newFileIdArray, $tFileId);
				}
			}
			$shoppingProductFlagObject->fileIdArray	= $newFileIdArray;
		}
		
		if( !$request->isError() ) {
			// エラーがなければファイルアップロード処理
			$shoppingProductFlagObject->contentUploader	= new content_Uploader('upfile');
			// 一時アップロード実行
			$shoppingProductFlagObject->contentUploader->uploadConfirm( $request, '/upload/shopping/flag/',
				array( array('width'=>100,'height'=>24) ) );
		}

		if( $request->isError() ) {
			$request->removeSession($sessionConfirmName);
		} else {
			$request->setSession($sessionConfirmName,'OK');
		}
		$request->setSession($sessionObjectName,$shoppingProductFlagObject);
		$request->setAttribute('shopping.flag.flag_object',		$shoppingProductFlagObject);
	}
}
?>