<?php
/*
 * shopping/calendar/Load.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-02-12
 * 
 */
require_once( dirname(dirname(__FILE__))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php' );
class shopping_calendar_Load extends system_login_ModuleBase {
	
	function shopping_calendar_Load(){
		array_push($this->require_module_array,'database2.Connect');
	}
	function execute( & $request ) {
		$dbo			= $request->getAttribute( 'dbo' );
		$targetYear		= $request->getParam('sclty','get');
		$targetMonth	= $request->getParam('scltm','get');
		$targetDay		= $request->getParam('scltd','get');
		$productId		= $request->getParam('shpdi','get');
		$unitId				= $request->getParam('shpui','get');
		if( preg_match('/^(19[789][0-9]|20[0123][0-9])$/',$targetYear) == 0 ) {
			$targetYear		= date('Y');
		}
		if( preg_match('/^((|0)[1-9]|1[012])$/',$targetMonth) == 0 ) {
			$targetMonth	= date('m');
		}
		$firstWeekDay 				= date('w',strtotime(date($targetYear.'-'.$targetMonth.'-1')));
		$targetMonthDayCount	= date('t',strtotime(date($targetYear.'-'.$targetMonth.'-1')));
		
		$scheduleHash	= array();
		if( strlen($unitId) > 0 ) {
			// 販売単位が指定されている場合
			$unitObject	= $request->getAttribute('shopping.product.unit.unit_object');
			if( !is_object($unitObject) ) {
				$unitObject	= spider_Controller::createObject('shopping_DaoShoppingProductUnit');
				if( $dbo->loadById($unitObject,$unitId) ) {
					$request->setAttribute('shopping.product.unit.unit_object',$unitObject);
				} else {
					$request->addLocaledError('shopping.error.product.unit.notfound',SPIDER_LOG_LEVEL_ERROR,array());
				}
			}
			if( !$request->isError()){
				if( 1 == $unitObject->calendar_type ){
					$scheduleHash	= shopping_calendar_Load::selectMonthScheduleHash( $request, $targetYear, $targetMonth, $unitId );
				} else if( 2 == $unitObject->calendar_type ){
					$scheduleHash	= shopping_calendar_Load::selectMonthScheduleHash( $request, $targetYear, $targetMonth, null, $unitObject->product_id );
				} else {
					$scheduleHash	= shopping_calendar_Load::selectMonthScheduleHash( $request, $targetYear, $targetMonth );
				}
			}
		} else if( strlen($productId) > 0 ) {
			// 商品が指定されている場合
			$productObject	= $request->getAttribute('shopping.product.product_object');
			if( !is_object($productObject) ) {
				$productObject	= spider_Controller::createObject('shopping_DaoShoppingProduct');
				if( $dbo->loadById($productObject,$productId, true) ) {
					$request->setAttribute('shopping.product.product_object',$productObject);
				} else {
					$request->addLocaledError('shopping.error.product.notfound',SPIDER_LOG_LEVEL_ERROR,array());
				}
			}
			if( !$request->isError()){
				if( 1 == $unitObject->calendar_type ){
					$scheduleHash	= shopping_calendar_Load::selectMonthScheduleHash( $request, $targetYear, $targetMonth, null, $productId );
				} else {
					$scheduleHash	= shopping_calendar_Load::selectMonthScheduleHash( $request, $targetYear, $targetMonth );
				}
			}
		} else {
			$scheduleHash	= shopping_calendar_Load::selectMonthScheduleHash( $request, $targetYear, $targetMonth );
		}
		
		$request->setAttribute('shopping.calendar.targetYear', $targetYear);
		$request->setAttribute('shopping.calendar.targetMonth', $targetMonth);
		$request->setAttribute('shopping.calendar.targetDay', $targetDay);
		$request->setAttribute('shopping.calendar.productId', $productId);
		$request->setAttribute('shopping.calendar.unitId', $unitId);
		$request->setAttribute('shopping.calendar.firstWeekDay', $firstWeekDay);
		$request->setAttribute('shopping.calendar.targetMonthDayCount', $targetMonthDayCount);
		$request->setAttribute('shopping.calendar.scheduleHash', $scheduleHash);
		$request->setAttribute('shopping.calendar.targetMonthDayCount', $targetMonthDayCount);
		$request->setAttribute('shopping.calendar.firstWeekDay', $firstWeekDay);
	}
	/**
	 * 指定販売単位の月毎の予定をセレクトする静的メソッド
	 * @param &$request spider_HttpRequestインスタンス参照
	 * @param $targetYear 西暦年
	 * @param $targetMonty 月
	 * @param $unitId 販売単位ID
	 * @param $productId 商品ID
	 * @return array 予定を日ごとに配列で保持した2次元連想配列
	 */
	function getUnitMonthScheduleHash( &$request, $targetYear, $targetMonth, $unitId, $productId=null ) {
		$hash	= shopping_calendar_Load::selectMonthScheduleHash( $request, $targetYear, $targetMonth, $unitId );
		if( false === $hash ) {
			return false;
		} else if( !is_array($hash) || count($hash) == 0 ) {
			$hash	= shopping_calendar_Load::selectMonthScheduleHash( $request, $targetYear, $targetMonth, null, $productId );
			if( false === $hash ) {
				return false;
			} else if( !is_array($hash) || count($hash) == 0 ) {
				return shopping_calendar_Load::selectMonthScheduleHash( $request, $targetYear, $targetMonth );
			} else {
				return $hash;
			}
		} else {
			return $hash;
		}
	}
	/**
	 * 月毎の予定をセレクトする静的メソッド
	 * @param &$request spider_HttpRequestインスタンス参照
	 * @param $targetYear 西暦年
	 * @param $targetMonty 月
	 * @param $unitId 販売単位ID
	 * @param $productId 商品ID
	 * @return array 予定を日ごとに配列で保持した2次元連想配列
	 */
	function selectMonthScheduleHash( &$request, $targetYear, $targetMonth, $unitId=null, $productId=null ) {
		$dbo	= $request->getAttribute( 'dbo' );
		$targetMonthDayCount	= date('t',strtotime(date($targetYear.'-'.$targetMonth.'-1')));
		// 指定年月の営業時間をセレクト
		$sql	= 'SELECT *, ';
		if( 'pgsql' == strtolower($dbo->databaseType) ) {
			$sql	.= 'TO_CHAR(start_date,\'DD\') AS start_day,'
			.' TO_CHAR(close_date,\'DD\') AS close_day';
		} else if( 'mysql' == strtolower($dbo->databaseType) ) {
			$sql	.= 'DATE_FORMAT(start_date,\'%d\') AS start_day,'
			.' DATE_FORMAT(close_date,\'%d\') AS close_day';
		}
		$sql	.= ' FROM '.TABLE_NAME_SHOPPING_CALENDAR.' WHERE ';
		if( strlen($unitId) > 0 ) {
			$sql	.= ' unit_id='.$dbo->quote($unitId);
		} else if( strlen($productId) > 0 ) {
			$sql	.= ' product_id='.$dbo->quote($productId);
			$sql	.= ' AND ( unit_id='.$dbo->quote('').' OR unit_id IS NULL )';
		} else {
			$sql .= ' ( unit_id='.$dbo->quote('').' OR unit_id IS NULL )';
			$sql .= ' AND ( product_id='.$dbo->quote('').' OR product_id IS NULL )';
		}
		$sql	.=' AND start_date<='.$dbo->quote($targetYear.'-'.$targetMonth.'-'.$targetMonthDayCount.' 23:59:59')
		. ' AND close_date>='.$dbo->quote($targetYear.'-'.$targetMonth.'-01 00:00:00');
		$sql	.= ' ORDER BY start_date ASC, close_date ASC';
		$scheduleHash	= array();
		$resultHash		= $dbo->queryAll( $sql, 'hash');
		if ( $resultHash === false ) {
			$request->addLocaledError('database2.error.common',SPIDER_LOG_LEVEL_FATAL,array($sql));
			return false;
		} else if( count($resultHash) > 0 ){
			// 日付ごとに予定があることを整理
			foreach( $resultHash as $row ) {
				for( $num=$row['start_day']; $num<=$row['close_day']; $num++ ) {
					if( !is_array($scheduleHash[$num]) ) {
						$scheduleHash[$num]	= array();
					}
					array_push($scheduleHash[$num],$row);
				}
			}
			return $scheduleHash;
		} else {
			return null;
		}
	}
}
?>