<?php
/*
 * shopping/calendar/Add.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-02-12
 * 
 */
require_once( dirname(dirname(__FILE__))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php' );
class shopping_calendar_Add extends system_login_ModuleBase {
	
	function shopping_calendar_Add(){
		array_push($this->require_module_array,'database2.Connect');
	}
	function execute( & $request ) {
		$dbo				= $request->getAttribute( 'dbo' );
		$startDate	= $request->getParam('start_date','post');
		$closeDate	= $request->getParam('close_date','post');
		$productId	= $request->getParam('product_id','post');
		$unitId			= $request->getParam('unit_id','post');
		$priceSell	= $request->getParam('price_sell','post');
		$stock			= $request->getParam('stock','post');
		$scheduleNote	= $request->getParam('schedule_note','post');
		// 妥当性検査
		spider_Controller::loadClassDefinition('util_ValidateFunctions');
		if( strlen($startDate) == 0 ) {
			$request->addLocaledError('shopping.error.calendar.startdaterequired',SPIDER_LOG_LEVEL_ERROR,array());
		} else if( !util_ValidateFunctions::isAvailableDatetimeFormat($startDate) ) {
			$request->addLocaledError('shopping.error.calendar.startdateoutofrange',SPIDER_LOG_LEVEL_ERROR,array());
		}
		if( strlen($closeDate) == 0 ) {
			$request->addLocaledError('shopping.error.calendar.enddaterequired',SPIDER_LOG_LEVEL_ERROR,array());
		} else if( !util_ValidateFunctions::isAvailableDatetimeFormat($closeDate) ) {
			$request->addLocaledError('shopping.error.calendar.enddateoutofrange',SPIDER_LOG_LEVEL_ERROR,array());
		}
		if( strlen($productId) > 0 ) {
			// 商品指定があるなら存在チェック
			if( strlen($productId) > 16 ) {
				$request->addLocaledError('shopping.error.product.invalidid',SPIDER_LOG_LEVEL_ERROR,array());
			} else {
				$shoppingProductObject	= spider_Controller::createObject('shopping_DaoShoppingProduct');
				if( $dbo->loadById($shoppingProductObject,$productId) ) {
				} else {
					$request->addLocaledError('shopping.error.product.notfound',SPIDER_LOG_LEVEL_ERROR,array());
				}
			}
		}
		if( strlen($unitId) > 0 ) {
			// 販売単位指定があるなら存在チェック
			if( strlen($unitId) > 16 ) {
				$request->addLocaledError('shopping.error.product.unit.invalidid',SPIDER_LOG_LEVEL_ERROR,array());
			} else {
				$shoppingProductUnitObject	= spider_Controller::createObject('shopping_DaoShoppingProductUnit');
				if( $dbo->loadById($shoppingProductUnitObject,$unitId) ) {
					if( preg_match('/^[0-9]{0,6}$/',$priceSell) == 0 ) {
						$priceSell	= null;
						$request->addLocaledError('shopping.error.calendar.invalidprice',SPIDER_LOG_LEVEL_ERROR,array());
					}
					if( preg_match('/^[0-9]{0,6}$/',$stock) == 0 ) {
						$stock	= null;
						$request->addLocaledError('shopping.error.calendar.invalidstock',SPIDER_LOG_LEVEL_ERROR,array());
					}
				} else {
					$request->addLocaledError('shopping.error.product.unit.notfound',SPIDER_LOG_LEVEL_ERROR,array());
				}
			}
		} else {
			$priceSell	= null;
		}
		// 問題ないならインサート
		if( $request->isError() ) {
		} else {
			$sql	= '';
			$priceSellVal	= $priceSell;
			if( is_null($priceSellVal) || strlen($priceSellVal)==0) {
				$priceSellVal	= 'NULL';
			}
			$stockVal	= $stock;
			if( is_null($stockVal) || strlen($stockVal)==0) {
				$stockVal	= 'NULL';
			}
			$unitIdVal	= $dbo->quote($unitId);
			if( is_null($unitId) || strlen($unitId)==0) {
				$unitIdVal	= 'NULL';
			}
			$productIdVal	= $dbo->quote($productId);
			if( is_null($productId) || strlen($productId)==0) {
				$productIdVal	= 'NULL';
			}
			// 同一時間帯設定のチェック
			$sql	= 'SELECT schedule_number FROM '.TABLE_NAME_SHOPPING_CALENDAR
			.' WHERE start_date='.$dbo->quote($startDate)
			.' AND close_date='.$dbo->quote($closeDate);
			if( is_null($unitId) || strlen($unitId)==0){
				$sql	.= ' AND (unit_id='.$dbo->quote('').' OR unit_id IS NULL )';
			} else {
				$sql	.= ' AND unit_id='.$dbo->quote($unitId);
			}
			if( is_null($productId) || strlen($productId)==0){
				$sql	.= ' AND (product_id='.$dbo->quote('').' OR product_id IS NULL )';
			} else {
				$sql	.= ' AND product_id='.$dbo->quote($productId);
			}
			$scheduleNumberArray	= $dbo->queryAll($sql,'hash');
			if( false === $scheduleNumberArray ){
				$request->addLocaledError('database2.error.common',SPIDER_LOG_LEVEL_ERROR,array($sql));
			} else if( count($scheduleNumberArray) > 0 ){
				// まったく同じ開始終了時間のものがある場合は在庫と料金を更新
				foreach( $scheduleNumberArray as $row ){
					$scheduleNumber	= $row['schedule_number'];
					$sql	= 'UPDATE '.TABLE_NAME_SHOPPING_CALENDAR.' SET '
					.' stock='.$stockVal.', price_sell='.$priceSellVal
					.',schedule_note='.$dbo->quote($scheduleNote)
					.' WHERE schedule_number='.$scheduleNumber;
					if( false === $dbo->query($sql) ){
						$request->addLocaledError('database2.error.update',SPIDER_LOG_LEVEL_ERROR,array($sql));
					}
				}
			} else {
				// 重複時間に設定しようとしていないか確認する
				$sql	= 'SELECT COUNT(schedule_number) FROM '.TABLE_NAME_SHOPPING_CALENDAR
				.' WHERE ('
				.' start_date BETWEEN '.$dbo->quote($startDate).' AND '.$dbo->quote($closeDate)
				.' OR '
				.' close_date BETWEEN '.$dbo->quote($startDate).' AND '.$dbo->quote($closeDate).')';
				if( is_null($unitId) || strlen($unitId)==0){
					$sql	.= ' AND (unit_id='.$dbo->quote('').' OR unit_id IS NULL )';
				} else {
					$sql	.= ' AND unit_id='.$dbo->quote($unitId);
				}
				if( is_null($productId) || strlen($productId)==0){
					$sql	.= ' AND (product_id='.$dbo->quote('').' OR product_id IS NULL )';
				} else {
					$sql	.= ' AND product_id='.$dbo->quote($productId);
				}
				$depCount	= $dbo->queryOne($sql);
				if( false === $depCount ){
					$request->addLocaledError('database2.error.common',SPIDER_LOG_LEVEL_ERROR,array($sql));
				} else if( $depCount > 0 ){
					$request->addLocaledError('shopping.error.calendar.duplicated',SPIDER_LOG_LEVEL_ERROR,array());
				} else {
					$sql	= 'INSERT INTO '.TABLE_NAME_SHOPPING_CALENDAR.'(start_date,close_date,product_id,unit_id,price_sell,stock,schedule_note) VALUES ('
					.$dbo->quote($startDate).','.$dbo->quote($closeDate).','.$productIdVal.','.$unitIdVal.','.$priceSellVal.','.$stockVal.','.$dbo->quote($scheduleNote).')';
					if( $dbo->query($sql) ) {
					} else {
						$request->addLocaledError('database2.error.update',SPIDER_LOG_LEVEL_ERROR,array($sql));
					}
				}
			}
		}
		$request->setAttribute('shopping.calendar.startDate', $startDate);
		$request->setAttribute('shopping.calendar.closeDate', $closeDate);
		$request->setAttribute('shopping.calendar.scheduleNote', $scheduleNote);
		$request->setAttribute('shopping.calendar.productId', $productId);
		$request->setAttribute('shopping.calendar.unitId', $unitId);
		$request->setAttribute('shopping.calendar.priceSell', $priceSell);
	}
}
?>