<?php
/**
 * 検索パッケージに関連した会員検索条件を付加する接続オブジェクトクラス
 */
require_once( dirname(__FILE__)
.DIRECTORY_SEPARATOR.'PackageConfig.class.php');
require_once( dirname(dirname(__FILE__))
.DIRECTORY_SEPARATOR.'search'
.DIRECTORY_SEPARATOR.'Connector.class.php');
require_once( dirname(dirname(__FILE__))
.DIRECTORY_SEPARATOR.'util'
.DIRECTORY_SEPARATOR.'CharUtility.class.php');
require_once( dirname(__FILE__)
.DIRECTORY_SEPARATOR.'DaoShoppingPromotion.class.php');
class shopping_SearchConnector extends search_Connector {
	function shopping_SearchConnector() {
	}
	/**
	 * データ検索条件のWHEREに追加する条件文字列を取得
	 * @param $requst spider_HttpRequstオブジェクト参照
	 */
	function getWhereConditionStrings( & $request ) {
		$dbo		= $request->getAttribute( 'dbo' );
		$returnCondition	= '';
		$conditionArray		= array();
		$productName			= $request->getParam('schshppi','get');
		$categoryIdArray	= $request->getParam('schshpci','get','array');
		if( strlen($productName) > 0 ) {
			$sql	= TABLE_NAME_SEARCH_DATA.'.data_id IN ('
				.' SELECT DISTINCT '.TABLE_NAME_SHOPPING_PRODUCT.'.search_data_id'
				.' FROM '.TABLE_NAME_SHOPPING_PRODUCT
				.' WHERE '
				.TABLE_NAME_SHOPPING_PRODUCT.'.status_flag<200'
				.' AND '
				.TABLE_NAME_SHOPPING_PRODUCT.'.product_name LIKE '.$dbo->quote('%'.$productName.'%')
				.' OR '
				.TABLE_NAME_SHOPPING_PRODUCT.'.product_kana LIKE '.$dbo->quote('%'.$productName.'%')
				.' OR '
				.TABLE_NAME_SHOPPING_PRODUCT.'.product_id LIKE '.$dbo->quote('%'.$productName.'%')
				.' )';
			array_push($conditionArray,$sql);
			$request->setAttribute('search.shopping.productName',$productName);
		}
		if( count($categoryIdArray)> 0 && strlen($categoryIdArray[0]) > 0 ){
			$quotedCategoryIdArray	= array();
			foreach($categoryIdArray as $cId ){
				if( strlen($cId) > 0 ){
					array_push($quotedCategoryIdArray, '"'.str_replace('"','\\"',$cId).'"');
				}
			}
			if( count($quotedCategoryIdArray) > 0 ){
				foreach( $quotedCategoryIdArray as $shopCid ) {
					$sql	= TABLE_NAME_SEARCH_DATA.'.data_id IN ('
						.' SELECT '.TABLE_NAME_SHOPPING_PRODUCT.'.search_data_id'
						.' FROM '.TABLE_NAME_SHOPPING_PRODUCT
						.' WHERE '
						.TABLE_NAME_SHOPPING_PRODUCT.'.status_flag<200'
						.' AND '
						.TABLE_NAME_SHOPPING_PRODUCT.'.product_id IN ( '
						.' SELECT '.TABLE_NAME_SHOPPING_CATEGORY_PRODUCT.'.product_id '
						.' FROM '.TABLE_NAME_SHOPPING_CATEGORY_PRODUCT
						.' WHERE '.TABLE_NAME_SHOPPING_CATEGORY_PRODUCT.'.category_id='.$shopCid
						.' ) )';
					array_push($conditionArray,$sql);
				}
				$request->setAttribute('search.shopping.categoryIdArray',$categoryIdArray);
			}
		}
		if( count($conditionArray) > 0 ){
			$returnCondition	= implode(' AND ',$conditionArray);
		}
		return $returnCondition;
	}
	/**
	 * データ検索フォームに表示する入力フォーム文字列を取得
	 * @param $requst spider_HttpRequstオブジェクト参照
	 */
	function getSearchFormStrings( & $request ) {
		$productName	= trim($request->getParam('schshppi','get'));
		$str		= ''.$GLOBALS['SHOPPING_LABEL_PRODUCT'].': <input type="text" name="schshppi" size="20" value="'.htmlspecialchars($productName).'" />';
		return $str;
	}
	/**
	 * データ登録した際の追加自動処理があれば記述します
	 * @param $requst spider_HttpRequstオブジェクト参照
	 * @param $memberObject member_DaoMemberオブジェクト参照
	 */
	function additionalPostInsertProcess( & $request, & $memberObject ) {
	}
	/**
	 * データ更新した際の追加自動処理があれば記述します
	 * @param $requst spider_HttpRequstオブジェクト参照
	 * @param $memberObject member_DaoMemberオブジェクト参照
	 */
	function additionalPostUpdateProcess( & $request, & $memberObject ) {
	}
	/**
	 * 個々のデータに追加するリンクを取得
	 * @param $requst spider_HttpRequstオブジェクト参照
	 * @param $searchDataObject search_DaoSearchDataオブジェクト参照
	 * @return string リンクタグ文字列の配列
	 */
	function getDataLinkArray( & $request, & $searchDataObject ) {
		return array(
			'<a href="/'.SYSTEM_DIR_NAME_ADMIN_PANEL.'/shopping/order/?schdi='.$searchDataObject->data_id.'">予約一覧</a>',
			'<a href="/'.SYSTEM_DIR_NAME_ADMIN_PANEL.'/shopping/product/?schdi='.$searchDataObject->data_id.'">登録'.$GLOBALS['SHOPPING_LABEL_PRODUCT'].'一覧</a>',
			'<a href="/'.SYSTEM_DIR_NAME_ADMIN_PANEL.'/shopping/product/form.php?schdi='.$searchDataObject->data_id.'">新規'.$GLOBALS['SHOPPING_LABEL_PRODUCT'].'追加</a>',
		);
	}
}
?>