<?php
/*
 * shopping/DaoShoppingPromotion.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once( dirname(__FILE__)
.DIRECTORY_SEPARATOR.'PackageConfig.class.php');
/**
 * shopping_DaoShoppingPromotion
 * shoppingパッケージ データアクセスオブジェクトクラス shopping_promotionテーブル用
 */
class shopping_DaoShoppingPromotion extends database2_AbstractData {
	/** シリアル番号	*/
	var $promotion_number;
	/** プロモーションID	*/
	var $promotion_id;
	/** 関連会員ID	*/
	var $member_id;
	/** プロモーションコード	*/
	var $promotion_code;
	/** プロモーションランク	*/
	var $promotion_rank	= 0;
	/** 卸販売許可フラグ	*/
	var $buying_flag	= 0;
	/** 卸販売割引率	*/
	var $buying_rate	= 0;
	/** プロモーション名	*/
	var $promotion_name;
	/** プロモーション名フリガナ	*/
	var $promotion_kana;
	/** 状態フラグ： 0=新規, 101=稼働中, 255=削除済	*/
	var $status_flag	= 0;
	
	// 成果報酬と割引に関するメンバ
	/** 成果報告金額の消費税設定: 0=税込, 1=税抜き切り捨て, 2=税抜き切り上げ, 3=税抜き四捨五入	*/
	var $exec_tax		= 0;
	/** 成果タグが必要な場合に文字列入力	*/
	var $exec_tag;
	/** 成果報告URLリクエストが必要な場合にURL入力	*/
	var $exec_url;
	/** 成果タグに注文アイテム繰り返しが必要な場合のひとつひとつのアイテムに関する文字フォーマット	*/
	var $tag_item_format;
	/** 成果タグに注文アイテム繰り返しが必要な場合のアイテム結合文字列	*/
	var $tag_item_implode;
	/** プロモーション経由申し込み時のお客様の割引タイプ rate=百分率割引, money=金額固定割引, それ以外=割引なし	*/
	var $discount_type;
	/** プロモーション経由申し込み時のお客様の割引値	*/
	var $discount_value;
	/** プロモーション成果報酬のタイプ rate=売上に対する百分率報酬, money=金額固定報酬, それ以外=報酬なし	*/
	var $pay_type;
	/** プロモーション成果報酬の値	*/
	var $pay_value;
	/** 概要	*/
	var $description;
	/** 更新日	*/
	var $updated_date;
	/** 登録日	*/
	var $registered_date;
	/** 登録者ID	*/
	var $owner_id;
	/** 変更者ＩＤ	*/
	var $modifier_id;
	// オブジェクトのみのフィールド
	/** 関連メンバーオブジェクト	**/
	var $memberObject;
	/** 関連メンバー銀行口座情報	*/
	var $memberBankAccountObject;
	/**
	 * コンストラクタ
	 */
	function shopping_DaoShoppingPromotion(){
	}
	/**
	 * 付加情報を読み込みます
	 */
	function loadRelation( $dbo ) {
		$this->member_id	= trim($this->member_id);
		if( strlen($this->member_id) > 0 ) {
			$this->memberObject	= spider_Controller::createObject('member_DaoMember');
			if( $dbo->loadById( $this->memberObject, $this->member_id) ) {
				// 銀行口座情報があったら読み込む
				$this->memberBankAccountObject	= spider_Controller::createObject('member_DaoMemberBankAccount');
				$sql	= 'SELECT * FROM '.TABLE_NAME_MEMBER_BANK_ACCOUNT
					.' WHERE member_id='.$dbo->quote($this->member_id)
					.' AND order_number=0';
				if( $this->memberBankAccountObject = $dbo->queryRow( $sql, $this->memberBankAccountObject ) ) {
				} else {
					$this->memberBankAccountObject	= null;
				}
			} else {
				$this->memberObject	= null;
			}
		} else {
			$this->memberObject	= null;
		}
	}
	/**
	 * インサート前に行いたい処理
	 * @param MDBObject $dbo MDB2オブジェクトかその互換オブジェクト
	 * @return boolean 成功したらtrue
	 */
	function pre_insert( $dbo ) {
		return true;
	}
	/**
	 * インサート後に行いたい処理
	 * @param MDBObject $dbo MDB2オブジェクトかその互換オブジェクト
	 * @return boolean 成功したらtrue
	 */
	function post_insert( $dbo ) {
		return true;
	}
	/**
	 * アップデート前に行いたい処理
	 * @param MDBObject $dbo MDB2オブジェクトかその互換オブジェクト
	 * @return boolean 成功したらtrue
	 */
	function pre_update( $dbo ) {
		return true;
	}
	/**
	 * アップデート後に行いたい処理
	 * @param MDBObject $dbo MDB2オブジェクトかその互換オブジェクト
	 * @return boolean 成功したらtrue
	 */
	function post_update( $dbo ) {
		return true;
	}
	//
	// 成果報告に関連するメソッド
	//
	/**
	 * 関連プロモーションの成果報告HTMLタグを取得します
	 * @param $request spider_HttpRequestオブジェクト参照
	 * @param $shoppingOrderObject shopping_DaoShoppingOrderオブジェクト参照
	 */
	function getReportHtmlTag( & $request, & $shoppingOrderObject ) {
		if( strlen(trim($this->exec_tag)) > 0 ) {
			return $this->_convertReportStrings( $request, $shoppingOrderObject, $this->exec_tag );
		}
		return '';
	}
	/**
	 * 関連プロモーションの成果報告URLへのHTTPリクエストを実行します
	 * @param $request spider_HttpRequestオブジェクト参照
	 * @param $shoppingOrderObject shopping_DaoShoppingOrderオブジェクト参照
	 */
	function sendReportHttpRequest( & $request, & $shoppingOrderObject ) {
		if( strlen(trim($this->exec_url)) > 0 ) {
			$reportUrl	= $this->_convertReportStrings( $request, $shoppingOrderObject, $this->exec_url );
			// 暫定でGETレポート固定
			spider_Controller::loadClassDefinition('util_HttpRequest');
			$httpRequestObject	= new util_HttpRequest( $reportUrl );
			if( $httpRequestObject->send(null) ) {
				return true;
			} else {
				return false;
			}
		}
		return true;
	}
	/**
	 * プロモーション成果報告用の文字列置き換えメソッド
	 * @param $request spider_HttpRequestオブジェクト参照
	 * @param $shoppingOrderObject shopping_DaoShoppingOrderオブジェクト参照
	 * @param $formatString フォーマット文字列
	 * @return string 変換後のフォーマット文字列
	 */
	function _convertReportStrings( & $request, & $shoppingOrderObject, $formatString ) {
		// タグ中の注文IDと合計金額を置換する
		$formatString	= str_replace('{write:order_id}',$shoppingOrderObject->order_id,$formatString);
		$formatString	= str_replace('{write:member_id}',$shoppingOrderObject->memberObject->member_id,$formatString);
		$paymentTotal	= 0;
		if( 1 == $this->exec_tax ) {
			$paymentTotal	= floor($shoppingOrderObject->payment_total * ( 100 / 105 ));
		} else if( 2 == $this->exec_tax ) {
			$paymentTotal	= ceil($shoppingOrderObject->payment_total * ( 100 / 105 ));
		} else if( 3 == $this->exec_tax ) {
			$paymentTotal	= round($shoppingOrderObject->payment_total * ( 100 / 105 ),0,PHP_ROUND_HALF_UP);
		} else {
			$paymentTotal	= $shoppingOrderObject->payment_total;
		}
		$formatString	= str_replace('{write:payment_total}',$paymentTotal,$formatString);
		// オブジェクトメンバの置換
		$vars		= get_object_vars($shoppingOrderObject);
		if( is_array($vars) ) {
			foreach( $vars as $k => $v ) {
				if( !is_array( $v ) && !is_object($v) ) {
					$formatString	= str_replace('{write:order::'.$k.'}',$v,$formatString);
				}
			}
		}
		$vars		= get_object_vars($shoppingOrderObject->memberObject);
		if( is_array($vars) ) {
			foreach( $vars as $k => $v ) {
				if( !is_array( $v ) && !is_object($v) ) {
					$formatString	= str_replace('{write:purchaser::'.$k.'}',$v,$formatString);
				}
			}
		}
		// 注文アイテム処理
		$buyingTotal	= 0;
		$itemsFormat	= $this->tag_item_format;
		$itemLineArray	= array();
		// 注文アイテム
		foreach($shoppingOrderObject->shoppingOrderAddressObjectArray as $key => $addressObject){
			foreach($addressObject->shoppingOrderItemObjectArray as $itemNum => $orderItemObject){
				$itemsFormat	= str_replace('{write:unit_id}',$orderItemObject->unit_id,$itemsFormat);
				$itemsFormat	= str_replace('{write:count}',$orderItemObject->order_count,$itemsFormat);
				// 購入商品金額
				$priceSell	= 0;
				$pricePay	= 0;
				$priceSell	= $orderItemObject->getPriceSell($request);
				if( 1 == $this->exec_tax ) {
					$priceSell	= floor($priceSell * ( 100 / 105 ));
					$pricePay	= floor($orderItemObject->getTotalPaymentPrice($request) * ( 100 / 105 ));
				} else if( 2 == $this->exec_tax ) {
					$priceSell	= ceil($priceSell * ( 100 / 105 ));
					$pricePay	= ceil($orderItemObject->getTotalPaymentPrice($request) * ( 100 / 105 ));
				} else if( 3 == $this->exec_tax ) {
					$priceSell	= round($priceSell * ( 100 / 105 ),0,PHP_ROUND_HALF_UP);
					$pricePay	= round($orderItemObject->getTotalPaymentPrice($request) * ( 100 / 105 ),0,PHP_ROUND_HALF_UP);
				} else {
					$priceSell	= $priceSell;
					$pricePay	= $orderItemObject->getTotalPaymentPrice($request);
				}
				$buyingTotal	+= $priceSell;
				$itemsFormat	= str_replace('{write:unit_price}',$priceSell,$itemsFormat);
				$itemsFormat	= str_replace('{write:price_sell}',$priceSell,$itemsFormat);
				$itemsFormat	= str_replace('{write:payment_price}',$pricePay,$itemsFormat);
				array_push($itemLineArray,$itemsFormat);
			}
		}
		if(count($itemLineArray)>0) {
			$itemsString	= implode($this->tag_item_implode,$itemLineArray);
		}
		$formatString	= str_replace('{write:order_items}',$itemsString,$formatString);
		// 購入合計金額（手数料を含まない純粋な購入商品の合計金額）
		$formatString	= str_replace('{write:buying_total}',$buyingTotal,$formatString);
		// アクセス時のGETパラメータを取得する
		if( strlen($shoppingOrderObject->access_param) > 0 ) {
			$paramHash	= array();
			$params	= explode('&',$shoppingOrderObject->access_param);
			foreach( $params as $param ) {
				list($key,$val)	= explode('=',$param);
				$key	= urldecode($key);
				$val	= urldecode($val);
				$paramHash[$key]	= $val;
			}
			foreach( $paramHash as $key => $val ) {
				if( strlen($key) > 0 && strlen($val) > 0 ) {
					$formatString	= str_replace('{write:access_param.'.$key.'}',$val,$formatString);
				}
			}
		}
		return $formatString;
	}
	//
	// アクセス記録関連
	//
	/**
	 * アクセス時のGETパラメータを保存用文字列にして返します
	 * @param GETパラメータのURLエンコード文字列
	 */
	function _getAccessParamStrings() {
		$params		= array();
		foreach( $_GET as $key => $val ) {
			if( 'afid' != $key ) {
				array_push( $params, urlencode($key).'='.urlencode($val) );
			}
		}
		return implode('&',$params);
	}
	/**
	 * アクセスログを記録してアクセスIDを取得
	 * @param $request spider_HttpRequestオブジェクト参照
	 * @return string 32文字のアクセスID
	 */
	function writeAccessLog( & $request ) {
		$dbo			= $request->getAttribute( 'dbo' );
		// 文字列を作成
		$requestUri		= SPIDER_URI_REQUEST;
		$httpReferrer	= $_SERVER['HTTP_REFERER'];
		$remoteHost		= $_SERVER['REMOTE_HOST'];
		$remoteAddresss	= $_SERVER['REMOTE_ADDR'];
		$userAgent		= $_SERVER['HTTP_USER_AGENT'];
		// GETパラメータを取得
		$params		= array();
		foreach( $_GET as $key => $val ) {
			if( 'afid' != $key ) {
				array_push( $params, urlencode($key).'='.urlencode($val) );
			}
		}
		$accessParam	= $this->_getAccessParamStrings();
		
		// SQLエラー回避の為 文字列長が長すぎたらカット
		if( strlen($requestUri) > 255 ) {
			$requestUri	= substr($requestUri,0,255);
		}
		if( strlen($httpReferrer) > 255 ) {
			$httpReferrer	= substr($httpReferrer,0,255);
		}
		if( strlen($remoteHost) > 255 ) {
			$remoteHost	= substr($remoteHost,0,255);
		}
		if( strlen($remoteAddresss) > 64 ) {
			$remoteAddresss	= substr($remoteAddresss,0,64);
		}
		if( strlen($userAgent) > 255 ) {
			$userAgent	= substr($userAgent,0,255);
		}
		// アクセスIDを発行する
		$accessIdPrefix	= sprintf('%06d',$this->promotion_number);
		$newAccessId	= $accessIdPrefix.time().util_CharUtility::get_rundom_key();
		$counter		= 0;
		while( true ) {
			if( $counter > 100 ) {
				$request->addLocaledError('shopping.error.dao.promotion.failtocreateid',SPIDER_LOG_LEVEL_ERROR,array());
				return false;
			}
			$sql	= 'SELECT COUNT(access_number) FROM '.TABLE_NAME_SHOPPING_PROMOTION_ACCESS_LOG.' WHERE access_id='.$dbo->quote($newAccessId);
			$countR	= $dbo->queryOne($sql);
			if( false === $countR ) {
				$request->addLocaledError('shopping.error.dao.promotion.failtowritelog',SPIDER_LOG_LEVEL_ERROR,array());
				return false;
			} else if( $countR == 0 ) {
				break;
			} else {
				$newAccessId	= $accessIdPrefix.time().util_CharUtility::get_rundom_key();
				$counter++;
			}
		}
		// インサート
		$sql	= 'INSERT INTO '.TABLE_NAME_SHOPPING_PROMOTION_ACCESS_LOG
			.' (access_id,promotion_code,access_date,request_uri,access_param,remote_host,remote_address,http_referrer,user_agent) VALUES('
			.$dbo->quote($newAccessId)
			.', '.$dbo->quote($this->promotion_code)
			.', '.$dbo->quote(date('Y-m-d H:i:s'))
			.', '.$dbo->quote($requestUri)
			.', '.$dbo->quote($accessParam)
			.', '.$dbo->quote($remoteHost)
			.', '.$dbo->quote($remoteAddresss)
			.', '.$dbo->quote($httpReferrer)
			.', '.$dbo->quote($userAgent)
			.')';
		$dbo->query($sql);
		return $newAccessId;
	}
	//
	// 妥当性検査関連
	//
	/**
	 * 設定された値の妥当性検査を行います
	 * @param $request spider_HttpRequestオブジェクト参照
	 */
	function validate( & $request ) {
		$dbo	= $request->getAttribute( 'dbo' );
		// プロモーションID
		if( strlen($this->promotion_id) == 0 ) {
		} else if( preg_match('/^[0-9a-zA-Z]{4,16}$/',$this->promotion_id) == 0 ) {
			$request->addLocaledError('shopping.error.dao.promotion.invalidid',SPIDER_LOG_LEVEL_ERROR,array());
		} else {
			// 重複チェック
			$sql	= '';
			if( strlen($this->promotion_number) > 0 ) {
				$sql	= 'SELECT COUNT(promotion_number) FROM '.TABLE_NAME_SHOPPING_PROMOTION
					.' WHERE promotion_number<>'.$this->promotion_number
					.' AND promotion_id='.$dbo->quote($this->promotion_id)
				;
			} else {
				$sql	= 'SELECT COUNT(promotion_number) FROM '.TABLE_NAME_SHOPPING_PROMOTION
					.' WHERE  promotion_id='.$dbo->quote($this->promotion_id)
				;
			}
			$existCount	= $dbo->queryOne( $sql );
			if( $existCount === false ) {
				$request->addLocaledError('database2.error.common',SPIDER_LOG_LEVEL_ERROR,array($sql));
			} else if( $existCount > 0 ) {
				$request->addLocaledError('shopping.error.dao.promotion.duplicatedid',SPIDER_LOG_LEVEL_ERROR,array());
			}
		}
		// プロモーション名
		if( strlen($this->promotion_name) == 0 ) {
			$request->addLocaledError('shopping.error.dao.promotion.requirename',SPIDER_LOG_LEVEL_ERROR,array());
		} else if( strlen($this->promotion_name) > 240 ) {
			$request->addLocaledError('shopping.error.dao.promotion.invalidname',SPIDER_LOG_LEVEL_ERROR,array());
		}
		// プロモーション名フリガナ
		if( strlen($this->promotion_kana) == 0 ) {
		} else if( strlen($this->promotion_kana) > 240 ) {
			$request->addLocaledError('shopping.error.dao.promotion.requirekana',SPIDER_LOG_LEVEL_ERROR,array());
		}
		// 紹介コード
		if( strlen($this->promotion_code) == 0 ) {
			$request->addLocaledError('shopping.error.dao.promotion.requirecode',SPIDER_LOG_LEVEL_ERROR,array());
		} else if( preg_match('/^[0-9a-zA-Z]{4,16}$/',$this->promotion_code) == 0 ) {
			$request->addLocaledError('shopping.error.dao.promotion.invalidcode',SPIDER_LOG_LEVEL_ERROR,array());
		} else {
			// 重複チェック
			$sql	= '';
			if( strlen($this->promotion_number) > 0 ) {
				$sql	= 'SELECT COUNT(promotion_number) FROM '.TABLE_NAME_SHOPPING_PROMOTION
					.' WHERE promotion_number<>'.$this->promotion_number
					.' AND promotion_code='.$dbo->quote($this->promotion_code)
				;
			} else {
				$sql	= 'SELECT COUNT(promotion_number) FROM '.TABLE_NAME_SHOPPING_PROMOTION
					.' WHERE  promotion_code='.$dbo->quote($this->promotion_code)
				;
			}
			$existCount	= $dbo->queryOne( $sql );
			if( $existCount === false ) {
				$request->addLocaledError('database2.error.common',SPIDER_LOG_LEVEL_ERROR,array($sql));
			} else if( $existCount > 0 ) {
				$request->addLocaledError('shopping.error.dao.promotion.duplicatedcode',SPIDER_LOG_LEVEL_ERROR,array());
			}
		}
		// プロモーションランク
		if( strlen($this->promotion_rank) == 0 ) {
			$request->addLocaledError('shopping.error.dao.promotion.requirerank',SPIDER_LOG_LEVEL_ERROR,array());
		} else if( preg_match('/^[0-9]{1,3}$/',$this->promotion_rank) == 0 ) {
			$request->addLocaledError('shopping.error.dao.promotion.invalidrank',SPIDER_LOG_LEVEL_ERROR,array());
		}
		// 割引
		if( preg_match('/^[rR][aA][tT][eE]$/',$this->discount_type) > 0 ) {
			if( preg_match('/^[0-9]{1,3}/',$this->discount_value) == 0 ) {
				$request->addLocaledError('shopping.error.dao.promotion.invalidratediscount',SPIDER_LOG_LEVEL_ERROR,array());
			} else if( $this->discount_value < 0 || $this->discount_value > 99 ) {
				$request->addLocaledError('shopping.error.dao.promotion.invalidratediscount',SPIDER_LOG_LEVEL_ERROR,array());
			}
		} else if( preg_match('/^[mM][oO][nN][eE][yY]$/',$this->discount_type) > 0 ) {
			if( preg_match('/^[0-9]{1,3}/',$this->discount_value) == 0 ) {
				$request->addLocaledError('shopping.error.dao.promotion.invalidmoneydiscount',SPIDER_LOG_LEVEL_ERROR,array());
			} else if( $this->discount_value < 0 || $this->discount_value > 9999999 ) {
				$request->addLocaledError('shopping.error.dao.promotion.invalidmoneydiscount',SPIDER_LOG_LEVEL_ERROR,array());
			}
		} else {
			$this->discount_value	= null;
		}
		// 成果報告金額 消費税
		if( strlen($this->exec_tax) == 0 || preg_match('/^[0-9]$/',$this->exec_tax)==0 ) {
			$this->exec_tax	= 0;
		}
		// 成果報告タグ
		if( strlen($this->exec_tag) == 0 ) {
		} else if( strlen($this->exec_tag) > 3000 ) {
			$request->addLocaledError('shopping.error.dao.promotion.invalidexectag',SPIDER_LOG_LEVEL_ERROR,array());
		}
		// 成果報告URL
		if( strlen($this->exec_url) == 0 ) {
		} else if( strlen($this->exec_url) > 255 ) {
			$request->addLocaledError('shopping.error.dao.promotion.invalidexecurl',SPIDER_LOG_LEVEL_ERROR,array());
		}
		// 成果報告タグ中のアイテムフォーマット
		if( strlen($this->tag_item_format) == 0 ) {
		} else if( strlen($this->tag_item_format) > 3000 ) {
			$request->addLocaledError('shopping.error.dao.promotion.invaliditemformat',SPIDER_LOG_LEVEL_ERROR,array());
		}
		// 成果報告タグ中のアイテム結合文字
		if( strlen($this->tag_item_implode) == 0 ) {
		} else if( strlen($this->tag_item_implode) > 3000 ) {
			$request->addLocaledError('shopping.error.dao.promotion.invaliditemimplode',SPIDER_LOG_LEVEL_ERROR,array());
		}
		
		// 報酬
		if( preg_match('/^[rR][aA][tT][eE]$/',$this->pay_type) > 0 ) {
			if( preg_match('/^[0-9]{1,3}/',$this->pay_value) == 0 ) {
				$request->addLocaledError('shopping.error.dao.promotion.invalidratefee',SPIDER_LOG_LEVEL_ERROR,array());
			} else if( $this->pay_value < 0 || $this->pay_value > 99 ) {
				$request->addLocaledError('shopping.error.dao.promotion.invalidratefee',SPIDER_LOG_LEVEL_ERROR,array());
			}
		} else if( preg_match('/^[mM][oO][nN][eE][yY]$/',$this->pay_type) > 0 ) {
			if( preg_match('/^[0-9]{1,3}/',$this->pay_value) == 0 ) {
				$request->addLocaledError('shopping.error.dao.promotion.invalidmoneyfee',SPIDER_LOG_LEVEL_ERROR,array());
			} else if( $this->pay_value < 0 || $this->pay_value > 9999999 ) {
				$request->addLocaledError('shopping.error.dao.promotion.invalidmoneyfee',SPIDER_LOG_LEVEL_ERROR,array());
			}
		} else {
			$this->pay_value	= null;
		}
		
		// 管理メモ
		if( strlen($this->description) == 0 ) {
		} else if( strlen($this->description) > 4500 ) {
			$request->addLocaledError('shopping.error.cart.admin.memo.overlength',SPIDER_LOG_LEVEL_ERROR,array(''));
		}
		
		// 関連会員ID
		if( strlen($this->member_id) == 0 ) {
			$this->buying_flag	= '0';
			$this->buying_rate	= '0';
			$this->memberObject	= null;
			$this->memberBankAccountObject	= null;
		} else if( strlen($this->member_id) > 16 ) {
			$request->addLocaledError('shopping.error.dao.promotion.invalidmemberid',SPIDER_LOG_LEVEL_ERROR,array());
		} else {
			$this->memberObject	= spider_Controller::createObject('member_DaoMember');
			if( $dbo->loadById( $this->memberObject, $this->member_id) ) {
				// 銀行口座情報があったら読み込む
				$this->memberBankAccountObject	= spider_Controller::createObject('member_DaoMemberBankAccount');
				$sql	= 'SELECT * FROM '.TABLE_NAME_MEMBER_BANK_ACCOUNT
					.' WHERE member_id='.$dbo->quote($this->member_id)
					.' AND order_number=0';
				if( $this->memberBankAccountObject = $dbo->queryRow( $sql, $this->memberBankAccountObject ) ) {
				} else {
					$this->memberBankAccountObject	= null;
				}
			} else {
				$request->addLocaledError('shopping.error.dao.promotion.invalidmemberid',SPIDER_LOG_LEVEL_ERROR,array());
				$this->memberObject	= null;
			}
			// 卸販売許可フラグ
			if( strlen($this->buying_flag) == 0 ) {
				$this->buying_flag	= '0';
			} else if( preg_match('/^[0-9]{1}$/',$this->buying_flag) == 0 ) {
				$request->addLocaledError('shopping.error.dao.promotion.invalidbuyingflag',SPIDER_LOG_LEVEL_ERROR,array());
			}
			// 卸販売率
			if( strlen($this->buying_rate) == 0 ) {
				$this->buying_rate	= '0';
			} else if( preg_match('/^[0-9]{1,2}$/',$this->buying_rate) == 0 ) {
				$request->addLocaledError('shopping.error.dao.promotion.invalidbuyingrate',SPIDER_LOG_LEVEL_ERROR,array());
			} else if( $this->buying_rate > 99 ) {
				$request->addLocaledError('shopping.error.dao.promotion.invalidbuyingrate',SPIDER_LOG_LEVEL_ERROR,array());
			}
		}
		return true;
	}
}
?>