<?php
/*
 * shopping/DaoShoppingProductFlag.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once( dirname(__FILE__)
.DIRECTORY_SEPARATOR.'PackageConfig.class.php' );
/**
 * shopping_DaoShoppingProductFlag
 * shoppingパッケージ データアクセスオブジェクトクラス shopping_product_flagテーブル用
 */
class shopping_DaoShoppingProductFlag extends database2_AbstractData {
	/** シリアル番号	*/
	var $flag_number;
	/** フラグID	*/
	var $flag_id;
	/** フラグ名	*/
	var $flag_name;
	/** 状態フラグ	*/
	var $status_flag	= 0;
	/** 順序番号	*/
	var $order_number	= 0;
	/** フラグ概要	*/
	var $description;
	/** 更新日	*/
	var $updated_date;
	/** 登録日	*/
	var $registered_date;
	/** 所有者ＩＤ	*/
	var $owner_id;
	/** 変更者ＩＤ	*/
	var $modifier_id;

	/** オブジェクト拡張：旧フラグ番号（※削除済みのIDと一致した場合に利用）	*/
	var $sourceFlagNumber	= '';
	
	/**
	 * コンストラクタ
	 */
	function shopping_DaoShoppingProductFlag(){
	}
	function _load_optional_data( $dbo ) {
	}
	/**
	 * インサート前に行いたい処理
	 * @param MDBObject $dbo MDB2オブジェクトかその互換オブジェクト
	 * @return boolean 成功したらtrue
	 */
	function pre_insert( $dbo ) {
		// フラグIDが削除済みのIDと一致した場合、旧情報を削除する
		if ( strlen($this->sourceFlagNumber)>0 ) {
			$sql	= 'DELETE FROM '.TABLE_NAME_SHOPPING_PRODUCT_FLAG.' WHERE flag_number='.$this->sourceFlagNumber;
			$result = $dbo->query( $sql );
			if( false === $result ) {
				return false;
			}
		}
		return true;
	}
	/**
	 * インサート後に行いたい処理
	 * @param MDBObject $dbo MDB2オブジェクトかその互換オブジェクト
	 * @return boolean 成功したらtrue
	 */
	function post_insert( $dbo ) {
		return true;
	}
	/**
	 * アップデート前に行いたい処理
	 * @param MDBObject $dbo MDB2オブジェクトかその互換オブジェクト
	 * @return boolean 成功したらtrue
	 */
	function pre_update( $dbo ) {
		return true;
	}
	/**
	 * アップデート後に行いたい処理
	 * @param MDBObject $dbo MDB2オブジェクトかその互換オブジェクト
	 * @return boolean 成功したらtrue
	 */
	function post_update( $dbo ) {
		// 旧flag_idと新flag_isを比較
		if ( $this->flag_id_org != $this->flag_id ) {
			// flag_idが変更されていた場合、関連テーブルを更新する
			$sql = 'UPDATE FROM '.TABLE_NAME_SHOPPING_PRODUCT_UNIT_FLAG_RELATION
				. ' SET flag_id='.$dbo->quote($this->flag_id)
				. ' WHERE flag_id='.$dbo->quote($this->flag_id_org)
			;
			$result = $dbo->query( $sql );
			if( false === $result ) {
				return false;
			}
		}
		return true;
	}
	/**
	 * 設定された値の妥当性検査を行います
	 */
	function validate( & $request ) {
		$dbo	= $request->getAttribute( 'dbo' );
		// フラグID
		if( strlen(trim($this->flag_id)) > 0 ) {
			if( strlen(trim($this->flag_id)) > 10 ) {
				$request->addLocaledError('shopping.error.dao.flag.invalidid',SPIDER_LOG_LEVEL_ERROR,array());
			} else if( !preg_match('/^[0-9a-zA-Z]+$/', $this->flag_id) ) {
				$request->addLocaledError('shopping.error.dao.flag.invalidid',SPIDER_LOG_LEVEL_ERROR,array());
			} else {
				$compareShoppingProductFlagObject	= spider_Controller::createObject('shopping_DaoShoppingProductFlag');
				if ( $dbo->loadById( $compareShoppingProductFlagObject, $this->flag_id ) ) {
					if( $this->flag_number != $compareShoppingProductFlagObject->flag_number ) {
						if ( $compareShoppingProductFlagObject->status_flag<200 ) {
							$request->addLocaledError('shopping.error.dao.flag.duplidatedid',SPIDER_LOG_LEVEL_ERROR,array());
						} else {
							// 旧フラグ情報を上書きするため、ソースフラグ番号に代入
							$this->sourceFlagNumber	= $compareShoppingProductFlagObject->flag_number;
						}
					}
				}
			}
		}
		// フラグ名
		if( strlen(trim($this->flag_name)) == 0 ) {
			$request->addLocaledError('shopping.error.dao.flag.requirename',SPIDER_LOG_LEVEL_ERROR,array());
		} else if( strlen(trim($this->flag_name)) > 60 ) {
			$request->addLocaledError('shopping.error.dao.flag.invalidname',SPIDER_LOG_LEVEL_ERROR,array());
		}
		// 順序番号
		if( strlen(trim($this->order_number)) == 0 ) {
			$this->order_number	= 0;
		} else if( preg_match('/^[0-9]{1,4}$/',$this->order_number) == 0 ) {
			$request->addLocaledError('shopping.error.dao.flag.invalidorder',SPIDER_LOG_LEVEL_ERROR,array());
		} else if ( $this->order_number < 0 ) {
			$request->addLocaledError('shopping.error.dao.flag.invalidorder',SPIDER_LOG_LEVEL_ERROR,array());
		} else if ( $this->order_number >= 10000 ) {
			$request->addLocaledError('shopping.error.dao.flag.invalidorder',SPIDER_LOG_LEVEL_ERROR,array());
		}
		// フラグ説明
		if( strlen(trim($this->description)) == 0 ) {
		} else if( strlen(trim($this->description)) > 3000 ) {
			$request->addLocaledError('shopping.error.dao.flag.invaliddescription',SPIDER_LOG_LEVEL_ERROR,array());
		}
		return true;
	}
	/**
	 * サムネイル画像があるか確認
	 */
	function getIconUri( & $request ) {
		$fileUri	= '/upload/shopping/flag/'.$this->flag_id.'.jpg';
		if( system_DataFileWriter::isExists( $request, $fileUri, 'public' ) ) {
			return $fileUri;
		} else {
			$fileUri	= '/upload/shopping/flag/'.$this->flag_id.'.gif';
			if( system_DataFileWriter::isExists( $request, $fileUri, 'public' ) ) {
				return $fileUri;
			} else {
				$fileUri	= '/upload/shopping/flag/'.$this->flag_id.'.png';
				if( system_DataFileWriter::isExists( $request, $fileUri, 'public' ) ) {
					return $fileUri;
				}
			}
		}
		return false;
	}
}
?>