<?php
/*
 * member/member/delete/Execute.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once(dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php');
/**
 * spider : 会員削除実行用アクションモジュールクラス
 * 
 * @package member 会員管理パッケージ
 * @subpackage delete 削除パッケージ
 * @version 1.0.0
 * @author  <m_nakashima@users.sourceforge.jp>
 * @since PHP 4.0
 */
class member_member_delete_Execute extends system_login_ModuleBase {
	function member_member_delete_Execute(){
		array_push($this->require_module_array,'database2.Connect');
	}
	function execute( & $request ) {
		$dbo					= $request->getAttribute( 'dbo' );
		$memberId				= $request->getParam('member_id','post');
		$loginUserObject		= $this->getLoginUserObject( $request );
		$memberIdArray		= array();
		$memberObject_array	= array();
		if( !is_array( $memberId ) && strlen(trim($memberId)) > 0 ) {
			array_push( $memberIdArray, $memberId );
		} else if( is_array( $memberId ) ) {
			$memberIdArray	= $memberId;
		}
		if( count( $memberIdArray ) == 0 ) {
			$request->addLocaledError('member.error.common.selectmember',SPIDER_LOG_LEVEL_FATAL,array(''));
		} else {
			foreach( $memberIdArray as $memberId ) {
				$memberObject			= spider_Controller::createObject('member_DaoMember');
				if( strlen(trim($memberId)) > 0 ) {
					// IDが指定されているなら編集のため読み込み
					if( $dbo->loadById($memberObject,$memberId) ){
						array_push( $memberObject_array, $memberObject );
					} else {
						$request->addLocaledError('member.error.common.membernotfound',SPIDER_LOG_LEVEL_FATAL,array(''));
					}
				}
			}
		}

		$newMemberObjectArray	= array();
		if( !$request->isError() ) {
			// エラーがないなら削除する
			foreach( $memberObject_array as $memberObject ) {
				$memberObject->modifier_id	= $loginUserObject->getUniqueId();
				// ログインIDは同一メールアドレスのユーザーが登録できないことを避けるため会員IDを入れておく
				$memberObject->login_id	= $memberObject->member_id;
				if( $memberObject->member_id == $loginUserObject->getUniqueId() ) {
					$memberObject->status_flag	= '251';
				} else {
					$memberObject->status_flag		= '255';
				}
				$memberObject->updated_date	= date('Y-m-d H:i:s');
				if( $dbo->update($memberObject,true) ) {
					array_push( $newMemberObjectArray, $memberObject );
				} else {
					$request->addLocaledError('database2.error.update',SPIDER_LOG_LEVEL_FATAL,array(''));
				}
			}
			$request->removeSession(MEMBER_SESSION_NAME_SELECTED_LIST, SPIDER_SESSION_SCOPE_GLOBAL);
		}

		$request->setAttribute('member.member.delete.member_object_array',$newMemberObjectArray);

	}
}
?>