<?php
/*
 * member/member/correspond/comment/Form.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once(dirname(dirname(dirname(dirname(__FILE__))))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php');
require_once(dirname(dirname(dirname(dirname(__FILE__))))
	.DIRECTORY_SEPARATOR.'DaoMember.class.php' );
require_once(dirname(dirname(dirname(dirname(__FILE__))))
	.DIRECTORY_SEPARATOR.'DaoMemberCorrespond.class.php' );
require_once(dirname(dirname(dirname(dirname(__FILE__))))
	.DIRECTORY_SEPARATOR.'DaoMemberCorrespondComment.class.php' );
/**
 * spider : 会員テーブル操作 ポイント編集フォーム表示用アクションモジュールクラス
 * 
 * @package member 会員管理パッケージ
 * @subpackage member 会員テーブル操作パッケージ
 * @version 1.0.0
 * @author  <m_nakashima@users.sourceforge.jp>
 * @since PHP 4.0
 */
class member_member_correspond_comment_Form extends system_login_ModuleBase {
	function member_member_correspond_comment_Form() {
		array_push($this->require_module_array,'database2.Connect');
	}
	function execute( & $request ) {
		
		$dbo						= $request->getAttribute( 'dbo' );
		$correspondId				= trim(stripslashes( $_GET['mci'] ));
		$commentNumber				= trim(stripslashes( $_GET['mcmn'] ));
		$sessionObjectName			= 'member.member.correspond.comment.modify.object.'.$commentNumber.'.'.$correspondId;
		$sessionConfirmName			= 'member.member.correspond.comment.modify.confirm.'.$commentNumber.'.'.$correspondId;
		$memberObject				= spider_Controller::createObject('member_DaoMember');
		$correspondObject			= spider_Controller::createObject('member_DaoMemberCorrespond');
		$correspondCommentObject	= $request->getSession($sessionObjectName);
		$compareCommentObject		= spider_Controller::createObject('member_DaoMemberCorrespondComment');
		$loginUserObject			= $this->getLoginUserObject( $request );
		$request->removeSession($sessionConfirmName);
		if( get_class($compareCommentObject) == get_class($correspondCommentObject) ){
			// セッションに登録済みならそのまま利用する
			if( $dbo->loadById( $correspondObject, $correspondCommentObject->correspond_id, true ) ){
				// 対応履歴が読み込めたら会員情報を読み込み
				if( !$dbo->loadById($memberObject,$correspondObject->member_id) ) {
					$request->addLocaledError('member.error.common.membernotfound',SPIDER_LOG_LEVEL_FATAL,array(''));
				}
			}
		} else {
			// セッションにないなら作成する
			if( strlen(trim($commentNumber)) > 0 ) {
				// 番号が指定されているなら編集の為読み込み
				if( $dbo->loadByNumber( $correspondCommentObject, $commentNumber ) ){
					// コメントが読み込めたら対応履歴を読み込み
					if( $dbo->loadById( $correspondObject, $correspondCommentObject->correspond_id, true ) ){
						// 対応履歴が読み込めたら会員情報を読み込み
						if( !$dbo->loadById($memberObject,$correspondObject->member_id) ) {
							$request->addLocaledError('member.error.common.membernotfound',SPIDER_LOG_LEVEL_FATAL,array(''));
						}
					}
				} else {
					$request->addLocaledError('member.error.correspond.commentnotfound',SPIDER_LOG_LEVEL_FATAL,array(''));
				}
			} else {
				// 番号が指定されていないなら新規作成
				$correspondCommentObject		= spider_Controller::createObject('member_DaoMemberCorrespondComment');
				if( strlen(trim($correspondId)) > 0 ) {
					// 対応履歴が指定されているなら読み込み
					if( $dbo->loadById( $correspondObject, $correspondId, true ) ){
						// 対応履歴が読み込めたら会員情報を読み込み
						if( !$dbo->loadById($memberObject,$correspondObject->member_id) ) {
							$request->addLocaledError('member.error.common.membernotfound',SPIDER_LOG_LEVEL_FATAL,array(''));
						} else {
							// 対応IDを設定
							$correspondCommentObject->correspond_id		= $correspondId;
							$correspondCommentObject->correspond_date	= date('Y-m-d H:i');
						}
					} else {
						$request->addLocaledError('member.error.correspond.notfound',SPIDER_LOG_LEVEL_FATAL,array(''));
					}
				} else {
					$request->addLocaledError('member.error.correspond.notfound',SPIDER_LOG_LEVEL_FATAL,array(''));
				}
			}
		}
		$correspondCommentObject->status_flag		= $correspondObject->status_flag;
		
		$request->setAttribute('member.member.correspond.comment.memberObject',$memberObject);
		$request->setAttribute('member.member.correspond.comment.correspondObject',$correspondObject);
		$request->setAttribute('member.member.correspond.comment.correspondCommentObject',$correspondCommentObject);
	}
}
?>