<?php
/*
 * member/member/correspond/comment/Confirm.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once(dirname(dirname(dirname(dirname(__FILE__))))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php');
/**
 * spider : 会員テーブル操作 ポイント入力確認用アクションモジュールクラス
 * 
 * @package member 会員管理パッケージ
 * @subpackage member 会員テーブル操作パッケージ
 * @version 1.0.0
 * @author  <m_nakashima@users.sourceforge.jp>
 * @since PHP 4.0
 */
class member_member_correspond_comment_Confirm extends system_login_ModuleBase {
	function member_member_correspond_comment_Confirm() {
		array_push($this->require_module_array,'database2.Connect');
	}
	function execute( & $request ) {
		
		$dbo						= $request->getAttribute( 'dbo' );
		$correspondId				= trim(stripslashes( $_GET['mci'] ));
		$commentNumber				= trim(stripslashes( $_GET['mcmn'] ));
		$sessionObjectName			= 'member.member.correspond.comment.modify.object.'.$commentNumber.'.'.$correspondId;
		$sessionConfirmName			= 'member.member.correspond.comment.modify.confirm.'.$commentNumber.'.'.$correspondId;
		$memberObject				= spider_Controller::createObject('member_DaoMember');
		$correspondObject			= spider_Controller::createObject('member_DaoMemberCorrespond');
		$correspondCommentObject	= spider_Controller::createObject('member_DaoMemberCorrespondComment');
		$compareCommentObject		= spider_Controller::createObject('member_DaoMemberCorrespondComment');
		$loginUserObject			= $this->getLoginUserObject( $request );
		$request->removeSession($sessionConfirmName);
		
		if( strlen(trim($commentNumber)) > 0 ) {
			// 番号が指定されているなら編集の為読み込み
			if( $dbo->loadByNumber( $correspondCommentObject, $commentNumber ) ){
				// コメントが読み込めたら対応履歴を読み込み
				if( $dbo->loadById( $correspondObject, $correspondCommentObject->correspond_id ) ){
					// 対応履歴が読み込めたら会員情報を読み込み
					if( !$dbo->loadById($memberObject,$correspondObject->member_id) ) {
						$request->addLocaledError('member.error.common.membernotfound',SPIDER_LOG_LEVEL_FATAL,array(''));
						return;
					}
				}
			} else {
				$request->addLocaledError('member.error.correspond.commentnotfound',SPIDER_LOG_LEVEL_FATAL,array(''));
				return;
			}
		} else {
			// 番号が指定されていないなら新規作成
			$correspondCommentObject		= spider_Controller::createObject('member_DaoMemberCorrespondComment');
			if( strlen(trim($correspondId)) > 0 ) {
				// 対応履歴が指定されているなら読み込み
				if( $dbo->loadById( $correspondObject, $correspondId ) ){
					// 対応履歴が読み込めたら会員情報を読み込み
					if( !$dbo->loadById($memberObject,$correspondObject->member_id) ) {
						$request->addLocaledError('member.error.common.membernotfound',SPIDER_LOG_LEVEL_FATAL,array(''));
						return;
					} else {
						// 対応IDを設定
						$correspondCommentObject->correspond_id		= $correspondId;
						$correspondCommentObject->correspond_date	= date('Y-m-d H:i');
					}
				} else {
					$request->addLocaledError('member.error.correspond.notfound',SPIDER_LOG_LEVEL_FATAL,array(''));
					return;
				}
			} else {
				$request->addLocaledError('member.error.correspond.notfound',SPIDER_LOG_LEVEL_FATAL,array(''));
				return;
			}
		}

		// 入力値のセットとチェック
		$correspondCommentObject->status_flag		= trim(stripslashes($_POST['status_flag']));
		$correspondCommentObject->comment_note		= trim(stripslashes($_POST['comment_note']));
		$correspondCommentObject->correspond_date	= trim(stripslashes($_POST['correspond_date']));
		if ( preg_match( '/^(|\\-|\\+)[0-9]{1,5}$/', $correspondCommentObject->status_flag ) == 0 ) {
			$request->addLocaledError('member.error.common.invalidstatus',SPIDER_LOG_LEVEL_FATAL,array(''));
		}
		if( strlen(trim($correspondCommentObject->comment_note)) > 30000 ) {
			$request->addLocaledError('member.error.correspond.invalidbody',SPIDER_LOG_LEVEL_FATAL,array(''));
		}
		if ( preg_match( '/^[0-9]{4}\\-[0-9]{2}\\-[0-9]{2}\\s[0-9]{2}:[0-9]{2}(|:[0-9]{2})$/', $correspondCommentObject->correspond_date ) == 0) {
			$request->addLocaledError('member.error.correspond.invaliddate',SPIDER_LOG_LEVEL_FATAL,array(''));
		}
		
		if( $request->isError() ) {
			$request->removeSession($sessionConfirmName);
		} else {
			$request->setSession($sessionConfirmName,'OK');
		}
		$request->setSession($sessionObjectName,$correspondCommentObject);
		$request->setAttribute('member.member.correspond.comment.memberObject',$memberObject);
		$request->setAttribute('member.member.correspond.comment.correspondObject',$correspondObject);
		$request->setAttribute('member.member.correspond.comment.correspondCommentObject',$correspondCommentObject);
	}
}
?>